/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import sbgc.object.CANDeviceScanInfo;
import sbgc.object.Sprav;
import sbgc.service.SerialCommand;
import sbgc.utils.HexUtil;

public class CANModule {
    static final int HW_ASSIGNED_FRW_VER = 2732;
    public final int id;
    public final int type;
    public final String name;
    public static final int TYPE_DRV = 1;
    public static final int TYPE_IMU = 2;
    private static final String[] TYPE_NAMES = new String[]{"CAN_Drv", "CAN_IMU"};
    public static final CANModule[] modules = new CANModule[]{new CANModule(5, 2, "CAN_IMU (main)"), new CANModule(6, 2, "CAN_IMU (frame)"), new CANModule(7, 2, "GPS_IMU (main)"), new CANModule(17, 1, "CAN_Drv#1"), new CANModule(18, 1, "CAN_Drv#2"), new CANModule(19, 1, "CAN_Drv#3"), new CANModule(20, 1, "CAN_Drv#4"), new CANModule(21, 1, "CAN_Drv#5"), new CANModule(22, 1, "CAN_Drv#6"), new CANModule(23, 1, "CAN_Drv#7"), new CANModule(25, 1, "CAN_HUB_GNSS"), new CANModule(26, 1, "CAN_HUB1"), new CANModule(27, 1, "CAN_HUB2"), new CANModule(28, 2, "CAN_IMU (main) (old)"), new CANModule(29, 2, "CAN_IMU (frame) (old)")};

    public CANModule(int id, int type, String name) {
        this.id = id;
        this.type = type;
        this.name = name;
    }

    public static String getTypeName(int type) {
        if (type > 0 && type < TYPE_NAMES.length + 1) {
            return TYPE_NAMES[type - 1];
        }
        return "unknow type " + type;
    }

    public static CANModule getById(int id) {
        for (CANModule m : modules) {
            if (m.id != id) continue;
            return m;
        }
        return null;
    }

    public static String getNameById(int id) {
        CANModule m = CANModule.getById(id);
        if (m != null) {
            return m.name;
        }
        return "unknown id " + id;
    }

    public static String getTypeNameById(int id) {
        CANModule m = CANModule.getById(id);
        if (m != null) {
            return CANModule.getTypeName(m.type);
        }
        return "unknown type";
    }

    public static List<Sprav> getOptionsForType(int type) {
        ArrayList<Sprav> list = new ArrayList<Sprav>();
        list.add(new Sprav(0, "not assigned"));
        for (CANModule m : modules) {
            if (type != 0 && type != m.type) continue;
            list.add(new Sprav(m.id, m.name));
        }
        return list;
    }

    public static LinkedHashMap<String, CANDeviceScanInfo> deviceIdMapFromByteArray(byte[] data) throws Exception {
        LinkedHashMap<String, CANDeviceScanInfo> map = new LinkedHashMap<String, CANDeviceScanInfo>();
        SerialCommand tmp = new SerialCommand(0, data);
        int num = tmp.getBytesAvailable() / 13;
        for (int i = 0; i < num; ++i) {
            byte[] uid = tmp.readBytes(12);
            int id = tmp.readByte();
            map.put(HexUtil.toHex(uid), new CANDeviceScanInfo(id));
        }
        if (tmp.getBytesAvailable() >= 4) {
            long hw_assign_flags = tmp.readDWordUnsigned();
            for (CANDeviceScanInfo device : map.values()) {
                if (device.id <= 0 || device.id > 32) continue;
                device.hard_assign = (hw_assign_flags & 1L << device.id - 1) != 0L;
            }
        }
        return map;
    }

    public static byte[] deviceIdMapToByteArray(LinkedHashMap<String, CANDeviceScanInfo> map) throws Exception {
        SerialCommand tmp = new SerialCommand(0, map.size() * 13 + 4);
        ArrayList<Map.Entry<String, CANDeviceScanInfo>> list = new ArrayList<Map.Entry<String, CANDeviceScanInfo>>(map.entrySet());
        list.sort(Map.Entry.comparingByValue());
        long hw_assigned_flags = 0L;
        for (Map.Entry entry : list) {
            CANDeviceScanInfo deviceInfo = (CANDeviceScanInfo)entry.getValue();
            tmp.write(HexUtil.fromHex((String)entry.getKey()));
            tmp.writeByte(deviceInfo.id);
            if (!deviceInfo.hard_assign || deviceInfo.id <= 0 || deviceInfo.id > 32) continue;
            hw_assigned_flags |= 1L << deviceInfo.id - 1;
        }
        tmp.writeDWord(hw_assigned_flags);
        return tmp.data;
    }
}

