/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import java.util.ArrayList;
import java.util.HashMap;
import sbgc.object.BoardInfo;
import sbgc.object.DebugVar;
import sbgc.object.DebugVars;
import sbgc.service.SerialCommand;
import simplebgc_gui.SimpleBGC_GUIApp;

public class CanDrvRealtimeData {
    private static HashMap<Integer, DebugVar[]> versions = new HashMap();

    public static DebugVar[] getVariables(int firmwareVer) {
        Integer ver = firmwareVer >= 2695 ? new Integer(2) : new Integer(1);
        DebugVar[] vars = versions.get(ver);
        if (vars == null) {
            ArrayList<DebugVar> list = new ArrayList<DebugVar>();
            list.add(new DebugVar("D_Iab.1", 4));
            list.add(new DebugVar("D_Iqd.1", 4));
            list.add(new DebugVar("D_RPM", 4));
            list.add(new DebugVar("D_POS_ERR", 4));
            list.add(new DebugVar("D_VEL_ERR", 4));
            list.add(new DebugVar("D_ANGLE", 4, 64));
            if (ver >= 2) {
                list.add(new DebugVar("D_TRQ_REF", 4));
                list.add(new DebugVar("D_C_PID_ERR", 4));
            }
            vars = list.toArray(new DebugVar[0]);
            versions.put(ver, vars);
        }
        return vars;
    }

    public static void parse(SerialCommand cmd) {
        try {
            DebugVar[] vars = CanDrvRealtimeData.getVariables(BoardInfo.getBoardInfo().getFrwVer());
            DebugVars.parseVars(cmd, vars, null);
        }
        catch (Exception e) {
            SimpleBGC_GUIApp.getLogger().warn("CAN_DRV telemetry parse error: " + e.toString());
        }
    }
}

