/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import sbgc.service.SerialCommand;
import sbgc.utils.FileUtil;
import sbgc.utils.HexUtil;
import simplebgc_gui.SimpleBGC_GUIApp;

@XStreamAlias(value="can-drv-params")
public class CanDrvSoftParams
implements Cloneable {
    public static final int CAN_DRV_PARAMS_SIZE = 128;
    public static final int FORMAT_VER_CUR = 4;
    public static final int FORMAT_VER_MAJOR_MASK = 240;
    public static final int EXTRA_CFG_TYPE_REACTION = 1;
    public static final int EXTRA_CFG_TYPE_EXT_MOTOR = 2;
    public static final String[] EXTRA_CFG_TYPE_NAMES = new String[]{"Reaction wheel", "Extra Motors"};
    public static final int FLAG_USE_VIRT_TEMP_FOR_STATOR_R_COMP = 1;
    public static final int FLAG_DO_R_STATOR_COMPENSATION = 2;
    public static final int FLAG_ENVIRONMENT_TEMP_UNKNOWN = 4;
    public static final int FLAG_OVERTEMP_GRADUALLY_LIMIT_POWER = 8;
    public static final int FLAG_OVERTEMP_STOP_MOTORS = 16;
    public static final int FLAG_CLIPPING_CURRENT_LIMIT_ENABLE = 32;
    public static final int FLAG_PEAK_CURRENT_SOFT_ENABLE = 64;
    public static final int FLAG_OVER_SPEED_PROTECTION_ENABLE = 128;
    public static final int FLAG_LEAVE_PHASES_FLOATING_ENABLE = 256;
    public static final int FLAG_MOVE_HOME_STARTUP = 512;
    public static final int FLAG_SEARCH_HOME = 1024;
    public static final int FLAG_SEARCH_HOME_INDEX = 2048;
    public static final int FLAG_IGNORE_MOTORS_ON_OFF = 4096;
    public static final int FLAG_SERVO1_DUTY_MODE = 8192;
    public static final int FLAG_SERVO2_DUTY_MODE = 16384;
    public static final int FLAG_USE_1WIRE_TEMP_SENS = 32768;
    public static final int FLAG2_SETPOINT_LPF_ENABLED = 1;
    public static final float ACC_LIMIT_RANGE_MAX = 100000.0f;
    public static final float ACC_LIMIT_RANGE_OFFSET = 1000.0f;
    public static final float SPEED_RANGE_MAX = 10000.0f;
    public static final float SPEED_RANGE_OFFSET = 99.0f;
    public static final int ENC_TIMEOUT_DEFAULT_VAL = 104;
    @XStreamOmitField
    private String functionName = null;
    @XStreamOmitField
    private final int drvId;
    public int format_ver;
    public int R_stator = 0;
    public float Ld_stator = 1.0f;
    public int LqLd_ratio = 127;
    public int current_PI_ratio = 127;
    public int current_PI_Wc = 50;
    public int peak_current_soft = 50;
    public int over_heat_temp_mcu = 90;
    public int over_heat_temp_ext = 80;
    public int PWM_freq = 22;
    public int encoder_type;
    public int encoder_cfg;
    public float encoder_gear_ratio = 1.0f;
    public int el_field_offset;
    public int zero_angle_offset;
    public int max_power = 255;
    public int max_speed = 0;
    public int motor_mag_link;
    public int num_poles = 14;
    public int speed_P;
    public int speed_I;
    public int speed_LPF_freq;
    public int[] notch_freq = new int[3];
    public int[] notch_width = new int[3];
    public int[] notch_gain = new int[3];
    public int angle_P;
    public int heat_model_heating_factor;
    public int heat_model_cooling_factor;
    public float torque_constant = 0.0f;
    public float moment_inertia = 0.0f;
    public int clipping_current_limit = 100;
    public int over_speed_rpm_lvl = 120;
    public int R_calib_temp = 25;
    public int flags = 0;
    public int scale_speed = 0;
    public int scale_angle = 0;
    public int limit_angle_min = 0;
    public int limit_angle_max = 0;
    public int acc_limit = 137;
    public int jerk_slope_ms = 0;
    public int default_speed = 137;
    public int search_home_acc = 137;
    public int search_home_speed = 137;
    public int servoRate = 50;
    public int[] servoOut = new int[2];
    public int setpointLPF = 2000;
    public int flags2 = 0;
    public int encTimeout = 104;
    public static final int RESERVED_BYTES = 44;
    public byte[] reserved = new byte[44];

    public CanDrvSoftParams(int drvId) {
        this.drvId = drvId;
    }

    public void formatSerialCommand(SerialCommand cmd) throws Exception {
        int start_len = cmd.len;
        cmd.writeByte(4);
        cmd.writeWord(this.R_stator);
        cmd.writeFloat(this.Ld_stator);
        cmd.writeByte(this.LqLd_ratio);
        cmd.writeByte(this.current_PI_ratio);
        cmd.writeWord(this.current_PI_Wc);
        cmd.writeWord(this.peak_current_soft);
        cmd.writeByte(this.over_heat_temp_mcu);
        cmd.writeByte(this.over_heat_temp_ext);
        cmd.writeByte(this.PWM_freq);
        cmd.writeByte(this.encoder_type);
        cmd.writeByte(this.encoder_cfg);
        cmd.writeFloat(this.encoder_gear_ratio);
        cmd.writeWord(this.el_field_offset);
        cmd.writeWord(this.zero_angle_offset);
        cmd.writeByte(this.max_power);
        cmd.writeWord(this.motor_mag_link);
        cmd.writeByte(this.num_poles);
        cmd.writeWord(this.speed_P);
        cmd.writeByte(this.speed_LPF_freq);
        cmd.writeByteArr(this.notch_freq);
        cmd.writeByteArr(this.notch_width);
        cmd.writeByteSignedArr(this.notch_gain);
        cmd.writeWord(this.angle_P);
        cmd.writeWord(0);
        cmd.writeByte(0);
        cmd.writeWord(this.speed_I);
        cmd.writeWord(this.max_speed);
        cmd.writeByte(this.heat_model_heating_factor);
        cmd.writeByte(this.heat_model_cooling_factor);
        cmd.writeWord(Math.round(this.torque_constant * 1000.0f));
        cmd.writeWord(Math.round(this.moment_inertia * 5.0f));
        cmd.writeWord(this.clipping_current_limit);
        cmd.writeWord(this.over_speed_rpm_lvl);
        cmd.writeByte(this.R_calib_temp);
        cmd.writeWord(this.flags);
        cmd.writeByteSigned(this.scale_speed);
        cmd.writeByteSigned(this.scale_angle);
        cmd.writeWord(this.limit_angle_min);
        cmd.writeWord(this.limit_angle_max);
        cmd.writeByte(this.acc_limit);
        cmd.writeByte(this.jerk_slope_ms);
        cmd.writeByte(this.default_speed);
        cmd.writeByte(this.search_home_acc);
        cmd.writeByte(this.search_home_speed);
        cmd.writeByte(this.servoRate / 10);
        cmd.writeByteArr(this.servoOut);
        cmd.writeByte(this.setpointLPF / 20);
        cmd.writeWord(this.flags2);
        cmd.writeByte(this.encTimeout / 8);
        cmd.write(this.reserved);
        cmd.writeWord(FileUtil.crc16_sbgc32(cmd.data, start_len, cmd.len - start_len));
    }

    public void parseSerialCommand(SerialCommand cmd) throws Exception {
        int start_pos = cmd.pos;
        this.format_ver = cmd.readByte();
        this.R_stator = cmd.readWordUnsigned();
        this.Ld_stator = cmd.readFloat();
        this.LqLd_ratio = cmd.readByte();
        this.current_PI_ratio = cmd.readByte();
        this.current_PI_Wc = cmd.readWordUnsigned();
        this.peak_current_soft = cmd.readWordUnsigned();
        this.over_heat_temp_mcu = cmd.readByte();
        this.over_heat_temp_ext = cmd.readByte();
        this.PWM_freq = cmd.readByte();
        this.encoder_type = cmd.readByte();
        this.encoder_cfg = cmd.readByte();
        this.encoder_gear_ratio = cmd.readFloat();
        this.el_field_offset = cmd.readWord();
        this.zero_angle_offset = cmd.readWord();
        this.max_power = cmd.readByte();
        this.motor_mag_link = cmd.readWordUnsigned();
        this.num_poles = cmd.readByte();
        this.speed_P = cmd.readWordUnsigned();
        this.speed_LPF_freq = cmd.readByte();
        this.notch_freq = cmd.readByteArr(3);
        this.notch_width = cmd.readByteArr(3);
        this.notch_gain = cmd.readByteSignedArr(3);
        this.angle_P = cmd.readWordUnsigned();
        cmd.skipBytes(3);
        this.speed_I = cmd.readWordUnsigned();
        this.max_speed = cmd.readWordUnsigned();
        this.heat_model_heating_factor = cmd.readByte();
        this.heat_model_cooling_factor = cmd.readByte();
        this.torque_constant = (float)cmd.readWordUnsigned() / 1000.0f;
        this.moment_inertia = (float)cmd.readWordUnsigned() / 5.0f;
        this.clipping_current_limit = cmd.readWordUnsigned();
        this.over_speed_rpm_lvl = cmd.readWordUnsigned();
        this.R_calib_temp = cmd.readByteSigned();
        this.flags = cmd.readWordUnsigned();
        if (this.format_ver >= 3) {
            this.scale_speed = cmd.readByteSigned();
            this.scale_angle = cmd.readByteSigned();
            this.limit_angle_min = cmd.readWord();
            this.limit_angle_max = cmd.readWord();
            this.acc_limit = cmd.readByte();
            this.jerk_slope_ms = cmd.readByte();
            this.default_speed = cmd.readByte();
            this.search_home_acc = cmd.readByte();
            this.search_home_speed = cmd.readByte();
            this.servoRate = cmd.readByte() * 10;
            cmd.readByteArr(this.servoOut);
            if (this.format_ver >= 4) {
                this.setpointLPF = cmd.readByte() * 20;
                this.flags2 = cmd.readWordUnsigned();
            } else {
                cmd.skipBytes(3);
            }
            this.encTimeout = cmd.readByte() * 8;
            if (this.encTimeout == 0) {
                this.encTimeout = 104;
            }
        } else {
            cmd.skipBytes(18);
        }
        cmd.read(this.reserved);
        int crc16 = FileUtil.crc16_sbgc32(cmd.data, start_pos, cmd.pos - start_pos);
        int crc16_file = cmd.readWordUnsigned();
        if (crc16 != crc16_file) {
            throw new Exception("Bad CRC (calculated " + crc16 + " != stored " + crc16_file + ")");
        }
    }

    public static CanDrvSoftParams[] getDefaultValues() {
        CanDrvSoftParams[] list = new CanDrvSoftParams[7];
        for (int i = 0; i < 7; ++i) {
            list[i] = new CanDrvSoftParams(i + 1);
        }
        return list;
    }

    public void onAppVersionChange(int old_ver) {
        if (this.setpointLPF == 0) {
            this.setpointLPF = 2000;
        }
        if (this.encTimeout == 0) {
            this.encTimeout = 104;
        }
    }

    public static void parseFromByteArray(byte[] data, CanDrvSoftParams[] list) throws Exception {
        int failed_cnt = 0;
        String lastErr = null;
        for (int i = 0; i < 7; ++i) {
            int drvId = i + 1;
            SerialCommand cmd = new SerialCommand(0, Arrays.copyOfRange(data, i * 128, (i + 1) * 128));
            try {
                list[i] = new CanDrvSoftParams(drvId);
                if (HexUtil.isAllZero(cmd.data, 0, 128)) continue;
                list[i].parseSerialCommand(cmd);
                cmd.checkFinished();
                continue;
            }
            catch (Exception e) {
                lastErr = "Error parsing CAN_Drv#" + drvId + ": " + e.getMessage();
                SimpleBGC_GUIApp.getLogger().info(lastErr);
                list[i] = new CanDrvSoftParams(drvId);
                ++failed_cnt;
            }
        }
        if (failed_cnt != 0) {
            throw new Exception(lastErr + (failed_cnt > 1 ? " (+" + (failed_cnt - 1) + " more errors)" : ""));
        }
    }

    public static byte[] packToByteArray(CanDrvSoftParams[] list) throws Exception {
        if (list == null) {
            throw new Exception("List of CAN_Drv soft params is null!");
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream(896);
        for (int i = 0; i < 7; ++i) {
            if (list[i] == null) {
                throw new Exception("CAN_Drv#" + (i + 1) + " soft params is null!");
            }
            SerialCommand cmd = new SerialCommand(0, 128);
            list[i].formatSerialCommand(cmd);
            if (cmd.getBytesFree() != 0) {
                throw new Exception("Missed " + cmd.getBytesFree() + " bytes!");
            }
            os.write(cmd.data);
        }
        return os.toByteArray();
    }

    public byte[] getExtraCfgBytes(int type, int length) throws Exception {
        byte[] data = HexUtil.reverseCopy(this.reserved, this.reserved.length - length, length);
        int type_ver = data[0] & 0xFF;
        int read_type = type_ver >> 4;
        if (read_type != type) {
            SimpleBGC_GUIApp.getLogger().warn("Configuration has incorrect type/version: " + read_type + ", expected: " + type);
            Arrays.fill(data, (byte)0);
        }
        data[0] = (byte)(data[0] & 0xF);
        return data;
    }

    public void setExtraCfgBytes(int type, byte[] data, boolean overwrite) throws Exception {
        byte[] oldData;
        int oldType;
        if (data.length > this.reserved.length) {
            throw new IndexOutOfBoundsException("Extra configuration section overlaps the reserved space for CAN_Drv#" + this.drvId);
        }
        if (!overwrite && (oldType = ((oldData = HexUtil.reverseCopy(this.reserved, this.reserved.length - 1, 1))[0] & 0xF0) >> 4) > 0 && oldType != type) {
            String name = oldType <= EXTRA_CFG_TYPE_NAMES.length ? EXTRA_CFG_TYPE_NAMES[oldType - 1] : "type" + Integer.toString(oldType);
            throw new IOException("CAN_Drv#" + this.drvId + " sharable memory stores configuration for '" + name + "'. Do you want to overwrite it with the new values?");
        }
        data[0] = (byte)(data[0] & 0xF | type << 4 & 0xF0);
        HexUtil.reverseCopy(data, 0, this.reserved, this.reserved.length - data.length, data.length);
        Arrays.fill(this.reserved, 0, this.reserved.length - data.length, (byte)0);
    }

    public void assignToFunction(String functionName) throws Exception {
        if (this.functionName != null && functionName != null && !this.functionName.equals(functionName)) {
            throw new Exception("CAN_Drv#" + this.drvId + " is already assigned to '" + this.functionName + "', failed to assign to '" + functionName + "'");
        }
        this.functionName = functionName;
    }

    public void clearAssignment() {
        this.functionName = null;
    }

    public CanDrvSoftParams clone() throws CloneNotSupportedException {
        CanDrvSoftParams copy = (CanDrvSoftParams)super.clone();
        copy.notch_freq = Arrays.copyOf(this.notch_freq, this.notch_freq.length);
        copy.notch_width = Arrays.copyOf(this.notch_width, this.notch_width.length);
        copy.notch_gain = Arrays.copyOf(this.notch_gain, this.notch_gain.length);
        copy.reserved = this.reserved != null ? Arrays.copyOf(this.reserved, this.reserved.length) : new byte[44];
        return copy;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof CanDrvSoftParams) {
            CanDrvSoftParams p = (CanDrvSoftParams)o;
            boolean res = this.format_ver == p.format_ver;
            res &= this.R_stator == p.R_stator;
            res &= this.Ld_stator == p.Ld_stator;
            res &= this.LqLd_ratio == p.LqLd_ratio;
            res &= this.current_PI_ratio == p.current_PI_ratio;
            res &= this.current_PI_Wc == p.current_PI_Wc;
            res &= this.peak_current_soft == p.peak_current_soft;
            res &= this.over_heat_temp_mcu == p.over_heat_temp_mcu;
            res &= this.over_heat_temp_ext == p.over_heat_temp_ext;
            res &= this.PWM_freq == p.PWM_freq;
            res &= this.encoder_type == p.encoder_type;
            res &= this.encoder_cfg == p.encoder_cfg;
            res &= this.encoder_gear_ratio == p.encoder_gear_ratio;
            res &= this.el_field_offset == p.el_field_offset;
            res &= this.zero_angle_offset == p.zero_angle_offset;
            res &= this.max_power == p.max_power;
            res &= this.max_speed == p.max_speed;
            res &= this.motor_mag_link == p.motor_mag_link;
            res &= this.num_poles == p.num_poles;
            res &= this.speed_P == p.speed_P;
            res &= this.speed_I == p.speed_I;
            res &= this.speed_LPF_freq == p.speed_LPF_freq;
            res &= this.angle_P == p.angle_P;
            res &= Arrays.equals(this.notch_freq, p.notch_freq);
            res &= Arrays.equals(this.notch_width, p.notch_width);
            res &= Arrays.equals(this.notch_gain, p.notch_gain);
            res &= this.heat_model_heating_factor == p.heat_model_heating_factor;
            res &= this.heat_model_cooling_factor == p.heat_model_cooling_factor;
            res &= this.torque_constant == p.torque_constant;
            res &= this.moment_inertia == p.moment_inertia;
            res &= this.clipping_current_limit == p.clipping_current_limit;
            res &= this.over_speed_rpm_lvl == p.over_speed_rpm_lvl;
            res &= this.R_calib_temp == p.R_calib_temp;
            res &= this.flags == p.flags;
            res &= this.scale_speed == p.scale_speed;
            res &= this.scale_angle == p.scale_angle;
            res &= this.limit_angle_min == p.limit_angle_min;
            res &= this.limit_angle_max == p.limit_angle_max;
            res &= this.acc_limit == p.acc_limit;
            res &= this.jerk_slope_ms == p.jerk_slope_ms;
            res &= this.default_speed == p.default_speed;
            res &= this.search_home_acc == p.search_home_acc;
            res &= this.search_home_speed == p.search_home_speed;
            res &= this.servoRate == p.servoRate;
            res &= Arrays.equals(this.servoOut, p.servoOut);
            res &= this.setpointLPF == p.setpointLPF;
            res &= this.flags2 == p.flags2;
            res &= this.encTimeout == p.encTimeout;
            return res &= Arrays.equals(this.reserved, p.reserved);
        }
        return false;
    }
}

