/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import javax.swing.SwingUtilities;
import sbgc.service.SerialCommand;
import simplebgc_gui.SimpleBGC_GUIApp;

public class ErrorInfo {
    public static final int ERR_NO_SENSOR = 1;
    public static final int ERR_CALIB_ACC = 2;
    public static final int ERR_SET_POWER = 4;
    public static final int ERR_CALIB_POLES = 8;
    public static final int ERR_PROTECTION = 16;
    public static final int ERR_SERIAL_DATA_CORRUPTED = 32;
    public static final int ERR_LOW_BAT1 = 64;
    public static final int ERR_LOW_BAT2 = 128;
    public static final int ERR_GUI_VERSION = 256;
    public static final int ERR_MISS_STEPS = 512;
    public static final int ERR_SYTEM_ERROR = 1024;
    public static final int ERR_EMERGENCY_STOP = 2048;
    public static final int ERR_MOTOR_OVERTEMPERATURE_WARN = 4096;
    public static final int ERR_MISSED_DATA = 65536;
    public static final int GUI_ERRORS_MASK = 65536;
    private static int curError = 0;
    private static int curSubError = 0;
    private static String curErrorText = null;
    private static int curExtSensError = 0;

    public static String getCurErrors() {
        if (curError != 0 || curErrorText != null || curExtSensError != 0) {
            StringBuffer res = new StringBuffer();
            for (int i = 0; i < 15; ++i) {
                int code = 1 << i;
                if ((code & curError) == 0) continue;
                String title = SimpleBGC_GUIApp.getResourceMap(ErrorInfo.class).getString("error" + code + ".title", new Object[0]);
                if (title == null) {
                    title = "UNKNOWN ERROR: " + code;
                }
                if (res.length() > 0) {
                    res.append("; ");
                }
                res.append(title);
            }
            if (curErrorText != null) {
                if (res.length() > 0) {
                    res.append("; ");
                }
                res.append(curErrorText);
            }
            if (curSubError != 0) {
                String title = ErrorInfo.getSubErrorTitle(curSubError);
                if (res.length() > 0) {
                    res.append(": ");
                }
                res.append(title);
            }
            if (curExtSensError != 0) {
                String title = SimpleBGC_GUIApp.getResourceMap(ErrorInfo.class).getString("ext_sens_error" + curExtSensError + ".name", new Object[0]);
                if (title == null) {
                    title = "EXT_SENS_ERR_" + curExtSensError;
                }
                if (res.length() > 0) {
                    res.append("; ");
                }
                res.append(title);
            }
            return res.toString();
        }
        return "";
    }

    public static String getSubErrorTitle(int subCode) {
        String title = SimpleBGC_GUIApp.getResourceMap(ErrorInfo.class).getString("sub_error" + subCode + ".title", new Object[0]);
        title = title != null ? subCode + " " + title : "SUB-CODE " + subCode;
        return title;
    }

    public static String getSubErrorDescr(int subError) {
        String descr = SimpleBGC_GUIApp.getResourceMap(ErrorInfo.class).getString("sub_error" + subError + ".descr", new Object[0]);
        if (descr == null) {
            descr = "";
        }
        return descr;
    }

    public static String getCurErrorsDescr() {
        StringBuffer res = new StringBuffer();
        if (curError != 0) {
            if (curSubError != 0) {
                res.append(ErrorInfo.getSubErrorDescr(curSubError));
            }
            for (int i = 0; i < 15; ++i) {
                String descr;
                int code = 1 << i;
                if ((code & curError) == 0 || (descr = SimpleBGC_GUIApp.getResourceMap(ErrorInfo.class).getString("error" + code + ".descr", new Object[0])) == null) continue;
                if (res.length() > 0) {
                    res.append("; ");
                }
                res.append(descr);
            }
        }
        return res.toString();
    }

    public static void setBoardError(int error) {
        ErrorInfo.setBoardError(error, curSubError);
    }

    public static void setBoardError(int error, int subError) {
        int newCodes = curError & 0x10000 | error;
        if ((curError ^ newCodes) != 0 || subError != curSubError) {
            curError = newCodes;
            curSubError = subError;
            ErrorInfo.updateError();
        }
    }

    public static void setExtSensError(int error) {
        if (curExtSensError != error) {
            curExtSensError = error;
            ErrorInfo.updateError();
        }
    }

    public static void addError(int error) {
        if ((curError & error) == 0) {
            curError |= error;
            ErrorInfo.updateError();
        }
    }

    public static void clearError(int error) {
        if ((curError & error) != 0) {
            curError &= ~error;
            ErrorInfo.updateError();
        }
    }

    public static void clearAllErrors() {
        ErrorInfo.clearError(65535);
        curSubError = 0;
        curExtSensError = 0;
    }

    public static boolean checkError(int error) {
        return (error & curError) != 0;
    }

    public static void updateStatus(final String text) {
        if (SimpleBGC_GUIApp.mainView != null) {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SimpleBGC_GUIApp.mainView.updateStatus(text);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void updateError() {
        if (SimpleBGC_GUIApp.mainView != null) {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SimpleBGC_GUIApp.mainView.updateError();
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean isError() {
        return curError != 0;
    }

    public static void setErrorText(String text) {
        curErrorText = text;
        ErrorInfo.updateError();
    }

    public static int getCurError() {
        return curError;
    }

    public static int getCurSubError() {
        return curSubError;
    }

    public static String formatCmdErrorInfo(SerialCommand cmd) throws Exception {
        cmd.startReading();
        int forCmdId = cmd.readByte();
        int errCode = cmd.readByte();
        int p1 = cmd.getBytesAvailable() >= 2 ? cmd.readWordUnsigned() : 0;
        int p2 = cmd.getBytesAvailable() >= 2 ? cmd.readWordUnsigned() : 0;
        cmd.startReading();
        String str = SimpleBGC_GUIApp.getResourceMap(ErrorInfo.class).getString("cmd_error" + errCode + ".title", forCmdId, p1, p2);
        if (str == null) {
            str = "Unknown error code (" + errCode + ")";
        }
        return str;
    }
}

