/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import sbgc.object.BoardParams;
import sbgc.object.CanDrvSoftParams;
import sbgc.object.IExtMotorParams;
import sbgc.service.SerialCommand;
import simplebgc_gui.SimpleBGC_GUIApp;

@XStreamAlias(value="ext-motor-params")
public class ExtMotorParams
implements Cloneable,
IExtMotorParams {
    public static final int FORMAT_VER_CUR = 0;
    public static final float RC_SCALE_MAX = 100.0f;
    public static final int FLAG_INVERTED = 1;
    public static final int CTRL_TYPE_POSITION = 0;
    public static final int CTRL_TYPE_SPEED = 1;
    public static final int CTRL_TYPE_TORQUE = 2;
    public int id;
    public int drvId;
    public int flags;
    public int rc_src;
    public int rc_scale;
    public int ctrl_type;

    public ExtMotorParams(int id) {
        this.id = id;
    }

    @Override
    public int getDrvId() {
        return this.drvId;
    }

    @Override
    public String getFunctionName() {
        return "Auxirialy motor #" + this.id;
    }

    @Override
    public void write(CanDrvSoftParams sp, boolean overwrite) throws Exception {
        if (sp == null) {
            throw new Exception("Can't write configuration: CanDrvSoftParams is null");
        }
        SerialCommand cmd = new SerialCommand(0, 44);
        cmd.writeByte(0);
        cmd.writeWord(this.flags);
        cmd.writeByte(this.ctrl_type);
        cmd.writeByte(this.rc_src);
        cmd.writeByteSigned(this.rc_scale);
        sp.setExtraCfgBytes(2, cmd.getPayload(), overwrite);
    }

    public static ExtMotorParams readFromParams(int id, int drv_id, BoardParams params) {
        ExtMotorParams p = new ExtMotorParams(id);
        if (drv_id > 0 && drv_id <= 7) {
            try {
                p.read(params.CAN_Drv_soft_params[drv_id - 1]);
                p.drvId = drv_id;
            }
            catch (Exception e) {
                SimpleBGC_GUIApp.getLogger().warn(e.toString());
            }
        }
        return p;
    }

    public void read(CanDrvSoftParams sp) throws Exception {
        if (sp == null) {
            throw new Exception("Can't read configuration: CanDrvSoftParams is null");
        }
        SerialCommand cmd = new SerialCommand(0, sp.getExtraCfgBytes(2, 44));
        int format_ver = cmd.readByte();
        this.flags = cmd.readWordUnsigned();
        this.ctrl_type = cmd.readByte();
        this.rc_src = cmd.readByte();
        this.rc_scale = cmd.readByteSigned();
    }

    public ExtMotorParams clone() throws CloneNotSupportedException {
        ExtMotorParams copy = (ExtMotorParams)super.clone();
        return copy;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof ExtMotorParams) {
            ExtMotorParams p = (ExtMotorParams)o;
            boolean res = true;
            res &= this.flags == p.flags;
            res &= this.rc_src == p.rc_src;
            res &= this.rc_scale == p.rc_scale;
            return res &= this.ctrl_type == p.ctrl_type;
        }
        return false;
    }
}

