/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import sbgc.object.BoardInfo;
import sbgc.service.SerialCommand;

public class IMUDebugInfo {
    public static final int FLAG_TRIPOD_MODE = 1;
    public static final int CORR_SRC_NO = 0;
    public static final String[] CORR_SRC_NAMES = new String[]{"no", "internal", "external", "translate"};
    public static final int EXT_IMU_STATUS_MASK = 7;
    public static final int EXT_IMU_STATUS_NOT_CONNECTED = 1;
    public static final int EXT_IMU_STATUS_QUALITY_BAD = 4;
    public static final String[] EXT_IMU_STATUS_NAMES = new String[]{"DISABLED", "NOT CONNECTED", "UNKNOWN", "ERROR", "BAD", "COARSE", "GOOD", "FINE"};
    public static final int EXT_IMU_STATUS_FLAG_BAD_MAG = 64;
    public static final int EXT_IMU_STATUS_FLAG_BAD_GPS = 128;
    int IMUcorrSrc;
    int frameIMUcorrSrc;
    int Z1_err;
    int H1_err;
    int frameZ1_err;
    int frameH1_err;
    int flags;
    float[][] DCM = new float[3][3];
    float[] ACC = new float[3];
    float[][] imuDCM = new float[3][3];
    boolean imuDCM_valid;
    String extIMUStateStr;

    public void parseIMUDebugInfo(SerialCommand cmd) throws Exception {
        this.IMUcorrSrc = cmd.readByte();
        this.frameIMUcorrSrc = cmd.readByte();
        this.Z1_err = cmd.readByte();
        this.H1_err = cmd.readByte();
        this.frameZ1_err = cmd.readByte();
        this.frameH1_err = cmd.readByte();
        this.extIMUStateStr = IMUDebugInfo.parseExtIMUStateInfo(cmd);
        this.flags = cmd.readWordUnsigned();
        cmd.skipBytes(6);
    }

    public void formatIMUDebugInfo(StringBuilder s) {
        IMUDebugInfo.formatCorrInfo(s, "Main IMU", this.IMUcorrSrc, this.Z1_err, this.H1_err);
        s.append("\n");
        IMUDebugInfo.formatCorrInfo(s, "Frame IMU", this.frameIMUcorrSrc, this.frameZ1_err, this.frameH1_err);
        s.append("\n");
        s.append(this.extIMUStateStr);
        s.append("\n");
        s.append(BoardInfo.formatStatusBits(this.flags, new String[]{"Tripod mode"}, "off", "on"));
    }

    public void parseExtIMUDebugInfo(SerialCommand cmd) throws Exception {
        int i;
        this.parseIMUDebugInfo(cmd);
        for (i = 0; i < 3; ++i) {
            cmd.readFloatArr(this.DCM[i]);
        }
        cmd.readFloatArr(this.ACC);
        if (BoardInfo.isDebugMode() && cmd.getBytesAvailable() >= 36) {
            for (i = 0; i < 3; ++i) {
                cmd.readFloatArr(this.imuDCM[i]);
            }
            this.imuDCM_valid = true;
        } else {
            this.imuDCM_valid = false;
        }
    }

    public static String getStatusName(int status) {
        int s = status & 7;
        StringBuilder name = s >= 0 && s <= EXT_IMU_STATUS_NAMES.length ? new StringBuilder(EXT_IMU_STATUS_NAMES[s]) : new StringBuilder("Unknown (" + status + ")");
        if ((status & 0x80) > 0) {
            name.append(", GPS NOT USED");
        }
        if ((status & 0x40) > 0) {
            name.append(", BAD MAG");
        }
        return name.toString();
    }

    public static String parseExtIMUStateInfo(SerialCommand cmd) throws Exception {
        StringBuilder s = new StringBuilder();
        int status = cmd.readByte();
        int conn_status = status & 7;
        s.append("External IMU: " + (conn_status <= 1 ? IMUDebugInfo.getStatusName(status) : "CONNECTED"));
        if (conn_status > 1) {
            s.append(", quality: " + BoardInfo.wrapBold(IMUDebugInfo.getStatusName(status)));
            s.append(", packets received: " + BoardInfo.wrapBold(String.valueOf(cmd.readWordUnsigned())));
            int parse_errors = cmd.readWordUnsigned();
            s.append("\n");
            int H1_err = cmd.readByte();
            int Z1_err = cmd.readByte();
            s.append("\tattitude error: " + BoardInfo.wrapBold(Z1_err < 255 ? String.format("% 3.1f\u00b0", Float.valueOf((float)Z1_err / 10.0f)) : ">25\u00b0"));
            s.append("\theading error: " + BoardInfo.wrapBold(H1_err < 255 ? String.format("% 3.1f\u00b0", Float.valueOf((float)H1_err / 10.0f)) : ">25\u00b0"));
            cmd.skipBytes(5);
            s.append("\tparse errors: " + BoardInfo.wrapBold(String.valueOf(parse_errors)));
        } else {
            cmd.skipBytes(11);
        }
        return s.toString();
    }

    public String formatExtIMUDebugInfo(SerialCommand cmd) throws Exception {
        int i;
        StringBuilder s = new StringBuilder("<html><pre>");
        this.formatIMUDebugInfo(s);
        s.append("\nExt.DCM: ");
        for (i = 0; i < 3; ++i) {
            s.append(BoardInfo.formatVector(this.DCM[i]));
        }
        s.append("\nExt.ACC: ");
        s.append(BoardInfo.formatVector(this.ACC));
        if (this.imuDCM_valid) {
            s.append("\nIMU DCM: ");
            for (i = 0; i < 3; ++i) {
                s.append(BoardInfo.formatVector(this.imuDCM[i]));
            }
        }
        s.append("</pre></html>");
        return s.toString();
    }

    public static String getCorrSrcName(int corrSrc) {
        return corrSrc >= 0 && corrSrc < CORR_SRC_NAMES.length ? CORR_SRC_NAMES[corrSrc] : "unknown (" + corrSrc + ")";
    }

    public static void formatCorrInfo(StringBuilder s, String imuName, int corrSrcInfo, int Z1_err, int H1_err) {
        boolean imu_enabled;
        int Z1_corr_src = corrSrcInfo & 7;
        int H1_corr_src = corrSrcInfo >> 3 & 7;
        boolean sensor_enabled = (corrSrcInfo & 0x40) != 0;
        boolean bl = imu_enabled = (corrSrcInfo & 0x80) != 0;
        if (imu_enabled) {
            s.append(imuName + ": enabled (" + (sensor_enabled ? "internal sensor" : "external sensor") + ")");
            if (sensor_enabled) {
                s.append(", attitude ref.: " + IMUDebugInfo.getCorrSrcName(Z1_corr_src));
                s.append(", heading ref.: " + IMUDebugInfo.getCorrSrcName(H1_corr_src));
                s.append("\n");
                if (Z1_corr_src != 0) {
                    s.append("\tattitude ref. error: " + BoardInfo.wrapBold(Z1_err < 255 ? String.format("% 3.1f\u00b0", Float.valueOf((float)Z1_err / 10.0f)) : "too big! (>25\u00b0)"));
                }
                if (H1_corr_src != 0) {
                    s.append("\theading ref. error: " + BoardInfo.wrapBold(H1_err < 255 ? String.format("% 3.1f\u00b0", Float.valueOf((float)H1_err / 10.0f)) : "too big! (>25\u00b0)"));
                }
            }
        } else {
            s.append(imuName + ": disabled");
        }
    }

    public boolean isTripodMode() {
        return (this.flags & 1) != 0;
    }
}

