/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.IOException;
import sbgc.service.SerialCommand;

@XStreamAlias(value="rc-input-calib")
public class RCInputCalib
implements Cloneable,
Comparable {
    public int src_ch;
    public int offset;
    public int pos_scale;
    public int neg_scale;

    public RCInputCalib() {
        this.reset();
    }

    public void readConfig(SerialCommand cmd) throws IOException {
        this.src_ch = cmd.readByte();
        this.offset = cmd.readByteSigned();
        this.neg_scale = cmd.readByte();
        this.pos_scale = cmd.readByte();
    }

    public void writeConfig(SerialCommand cmd) throws IOException {
        cmd.writeByte(this.src_ch);
        cmd.writeByteSigned(this.offset);
        cmd.writeByte(this.neg_scale);
        cmd.writeByte(this.pos_scale);
    }

    public RCInputCalib clone() throws CloneNotSupportedException {
        RCInputCalib copy = (RCInputCalib)super.clone();
        return copy;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RCInputCalib)) {
            return false;
        }
        RCInputCalib other = (RCInputCalib)o;
        return this.src_ch == other.src_ch && this.offset == other.offset && this.pos_scale == other.pos_scale && this.neg_scale == other.neg_scale;
    }

    public final void reset() {
        this.offset = 0;
        this.pos_scale = 20;
        this.neg_scale = 20;
    }

    public int compareTo(Object t) {
        if (this.src_ch != 0 && ((RCInputCalib)t).src_ch == 0) {
            return -1;
        }
        if (this.src_ch == 0 && ((RCInputCalib)t).src_ch != 0) {
            return 1;
        }
        return 0;
    }
}

