/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import java.io.IOException;
import java.util.Date;
import javax.swing.SwingUtilities;
import sbgc.object.BoardInfo;
import sbgc.object.ErrorInfo;
import sbgc.service.RealtimeDataThread;
import sbgc.service.SerialCommand;
import sbgc.ui.TabbedPanelMonitoring;
import sbgc.utils.AvgFilter;
import simplebgc_gui.SimpleBGC_GUIApp;

public class RealtimeData {
    private static RealtimeData curRealtimeData = new RealtimeData();
    public static final int RC_CHANNEL_ROLL = 0;
    public static final int RC_CHANNEL_PITCH = 1;
    public static final int RC_CHANNEL_YAW = 2;
    public static final int RC_CHANNEL_CMD = 3;
    public static final int RC_CHANNEL_FC_ROLL = 4;
    public static final int RC_CHANNEL_FC_PITCH = 5;
    public static final String[] RC_DATA_NAMES = new String[]{"RC_ROLL", "RC_PITCH", "RC_YAW", "RC_CMD", "EXT_FC_ROLL", "EXT_FC_PITCH"};
    public static final int RC_UNDEF = -10000;
    public static final int RC_UNDEF16 = Short.MIN_VALUE;
    public static final int RC_MIN_VAL = -500;
    public static final int RC_MAX_VAL = 500;
    public static final int RC_RANGE = 1000;
    public static final int RC_MIN_VAL16 = -16384;
    public static final int RC_MAX_VAL16 = 16384;
    public static final int RC_RANGE16 = 32768;
    public static final float ANGLE14_DEGREE_SCALE = 0.021972656f;
    public static final float DEGREE_ANGLE14_SCALE = 45.511112f;
    public static final float ANGLE14_RAD_SCALE = 3.834952E-4f;
    public static final float GYRO_DEG_S_SCALE = 0.06103702f;
    public static final float GYRO_RAD_S_SCALE = 0.0010652969f;
    public static final int BALANCE_ERROR_MAX = 512;
    public static final int CALIB_MODE_BODE_TEST = 9;
    public static final long STATE_FLAG_SHAKE_GENERATOR_ENABLED = 256L;
    public Date regDate = null;
    public long fast_t1;
    public long fast_t2;
    public long slow_t;
    public float fast_dt_avg;
    static long device_timestamp;
    static long device_timestamp_offset;
    public int[] acc = new int[3];
    public int[] gyro = new int[3];
    public int[] frame_acc = null;
    public int[] frame_gyro = null;
    public int[] debug = new int[4];
    public int[] rcData = new int[]{-10000, -10000, -10000, -10000, -10000, -10000};
    public float[] angle = new float[3];
    public float[] frameIMUAngle = new float[3];
    public float[] stab_angle = new float[3];
    public float[] target_angle = new float[3];
    public int cycleTime;
    public int i2cErrorCount;
    public int errorCode;
    public int subError;
    public int comErrCnt;
    public int CANErrCnt;
    public int CANErrFlags;
    public int bat_val;
    public boolean isPowered;
    public boolean isDebugPort;
    public int curProfile;
    public int curIMU = 1;
    public int[] power = new int[3];
    public int current;
    public int[] magData = new int[3];
    public int[] balanceError = new int[3];
    public float[] frameCamAngle = new float[3];
    public int IMU_G_err;
    public int IMU_H_err;
    public int IMU_temp_cels;
    public int frame_IMU_temp_cels;
    public int[] motor_effective_out = new int[3];
    public int[] motor_current = new int[3];
    public int[] motor_temp = new int[3];
    public int progress;
    public int calibMode;
    public int ext_sens_err;
    public long system_state_flags;
    public float[] angle_err_max_avg = new float[3];
    public int[] mot_flags = new int[3];
    public static final int MOT_FLAG_IS_LIMITED = 1;
    public static final int MOT_FLAG_IS_CURRENT_CLIPPED = 2;
    public static final int MOT_FLAG_IS_POWERED = 4;
    public static final int MOT_FLAG_IS_LOCAL = 8;
    public static final long RTDC_FLAG_INCLUDE_FLAGS = 0x80000000L;
    public static final long RTDC_FLAG_IMU_ANGLE = 1L;
    public static final long RTDC_FLAG_TARGET_ANGLE = 2L;
    public static final long RTDC_FLAG_FRAME_CAM_ANGLE = 8L;
    public static final long RTDC_FLAG_GYRO = 16L;
    public static final long RTDC_FLAG_RC_DATA = 32L;
    public static final long RTDC_FLAG_ACC = 256L;
    public static final long RTDC_FLAG_MOT_STATE = 32768L;
    public static final long RTDC_FLAG_COMM_ERR = 524288L;
    public static final long RTDC_FLAG_SYSTEM_STATE = 0x100000L;
    public static final long RTDC_FLAG_IMU_STATE = 0x20000000L;
    public static final long RTDC2_FLAG_FRAME_IMU_ANGLE = 1L;
    public static final long RTDC2_FLAG_FRAME_GYRO = 2L;
    public static final long RTDC2_FLAG_FRAME_ACC = 4L;
    public static final long RTDC2_FLAG_DEBUG = 8L;
    public static final long RTDC2_FLAG_MAG = 16L;
    public static final long RTDC_FLAGS_FAST = 10L;
    public static final long RTDC2_FLAGS_FAST = 0L;
    public static final long RTDC_FLAGS_SLOW = 538476576L;

    public void set_timestamp(long timestamp) {
        this.fast_t1 = timestamp;
        this.fast_t2 = timestamp;
        this.slow_t = timestamp;
    }

    public boolean is_stab_local_axis(int axis) {
        return (this.mot_flags[axis] & 8) != 0;
    }

    public static RealtimeData getRealtimeData() {
        return curRealtimeData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parse(SerialCommand cmd) throws IOException {
        RealtimeData tmp;
        RealtimeData realtimeData = tmp = curRealtimeData;
        synchronized (realtimeData) {
            tmp.set_timestamp(cmd.timestamp);
            tmp.regDate = new Date(cmd.timestamp);
            int id = cmd.id == 68 ? 0 : cmd.id;
            for (int i = 0; i < 3; ++i) {
                tmp.acc[i] = cmd.readWord();
                tmp.gyro[i] = cmd.readWord();
            }
            tmp.frame_acc = null;
            tmp.frame_gyro = null;
            TabbedPanelMonitoring.UPD_GROUP_GYRO.onDataUpdated();
            TabbedPanelMonitoring.UPD_GROUP_ACC.onDataUpdated();
            tmp.comErrCnt = cmd.readWordUnsigned();
            tmp.errorCode = cmd.readWordUnsigned();
            tmp.subError = cmd.readByte();
            cmd.skipBytes(3);
            cmd.readWordArr(tmp.rcData);
            tmp.angle = cmd.readWordArrAsFloatScaled(3, 0.021972656f);
            if (id >= 23) {
                tmp.frameCamAngle = cmd.readWordArrAsFloatScaled(3, 0.021972656f);
            }
            tmp.target_angle = cmd.readWordArrAsFloatScaled(3, 0.021972656f);
            tmp.cycleTime = cmd.readWord();
            tmp.i2cErrorCount = cmd.readWordUnsigned();
            cmd.skipBytes(1);
            tmp.bat_val = cmd.readWord();
            int flags = cmd.readByte();
            tmp.isPowered = (flags & 1) != 0;
            boolean bl = tmp.isDebugPort = (flags & 2) != 0;
            if (id >= 23) {
                tmp.curIMU = cmd.readByte();
            }
            tmp.curProfile = cmd.readByte();
            for (int i = 0; i < 3; ++i) {
                tmp.power[i] = cmd.readByte();
            }
            if (id >= 25) {
                tmp.frameCamAngle = cmd.readWordArrAsFloatScaled(3, 0.021972656f);
                tmp.progress = cmd.readByte();
                cmd.readWordArr(tmp.balanceError);
                tmp.current = cmd.readWordUnsigned();
                cmd.readWordArr(tmp.magData);
                TabbedPanelMonitoring.UPD_GROUP_MAG.onDataUpdated();
                tmp.IMU_temp_cels = cmd.readByte();
                tmp.frame_IMU_temp_cels = cmd.readByte();
                tmp.IMU_G_err = cmd.readByte();
                tmp.IMU_H_err = cmd.readByte();
                for (int axis = 0; axis < 3; ++axis) {
                    tmp.motor_effective_out[axis] = cmd.readWord();
                }
                tmp.calibMode = cmd.readByte();
                tmp.ext_sens_err = cmd.readByte();
                if (BoardInfo.checkMinBaseFirmwareVer(2720)) {
                    tmp.stab_angle = cmd.readWordArrAsFloatScaled(3, 0.021972656f);
                } else {
                    cmd.skipBytes(6);
                    tmp.stab_angle = tmp.angle;
                }
                tmp.system_state_flags = cmd.readDWordUnsigned();
                tmp.angle_err_max_avg = cmd.readUWordArrAsFloatScaled(3, 0.001f);
                if (BoardInfo.isDebugMode()) {
                    cmd.skipBytes(4);
                    cmd.readWordArr(tmp.debug);
                    TabbedPanelMonitoring.UPD_GROUP_DEBUG.onDataUpdated();
                } else {
                    cmd.skipBytes(12);
                }
            }
        }
        cmd.checkFinished();
        ErrorInfo.setBoardError(tmp.errorCode, tmp.subError);
        ErrorInfo.setExtSensError(tmp.ext_sens_err);
        curRealtimeData = tmp;
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleBGC_GUIApp.mainView.updateRealtimeData();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void parseCmdAdjVarsState(SerialCommand cmd) throws IOException {
        if (cmd.getBytesAvailable() >= 15) {
            final int triggerSignal = cmd.readWord();
            final int triggerAction = cmd.readByte();
            final int analogSignal = cmd.readWord();
            final float analogVal = cmd.readFloat();
            final int LUTsignalVal = cmd.readWord();
            final float LUTvarVal = cmd.readFloat();
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SimpleBGC_GUIApp.mainView.panelAdjVars.updateRealtimeState(triggerSignal, triggerAction, analogSignal, analogVal, LUTsignalVal, LUTvarVal);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void parseCmdMavlinkDebug(SerialCommand cmd) throws IOException {
        int ch = cmd.readByte();
        int flags = cmd.readByte();
        cmd.skipBytes(4);
        boolean isV2 = (flags & 2) != 0;
        cmd.skipBytes(1);
        if (isV2) {
            cmd.skipBytes(2);
        }
        int seq_cnt = cmd.readByte();
        int sys_id = cmd.readByte();
        int comp_id = cmd.readByte();
        int msg_id = cmd.readByte();
        if (isV2) {
            msg_id |= (cmd.readByte() | cmd.readByte() << 8) << 8;
        }
        byte[] body = cmd.readBytes(cmd.getBytesAvailable());
        final String debug_msg = ch + 1 + ".MAV.v" + (isV2 ? 2 : 1) + ((flags & 1) > 0 ? ".out" : ".in") + "." + seq_cnt + " #" + msg_id + " (" + sys_id + "," + comp_id + ") [" + SerialCommand.dumpBytes(body, body.length) + "]";
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleBGC_GUIApp.mainView.debugMessage(debug_msg);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void parseCmdMavlinkInfo(SerialCommand cmd) throws IOException {
        int data_state = cmd.readByte();
        int ahrs_period = cmd.readByte();
        int pos_period = cmd.readByte();
        cmd.skipBytes(4);
        final String common_info = "AHRS: " + ((data_state & 1) > 0 ? "OK" : ((data_state & 2) > 0 ? "low rate" : "no")) + " (" + (ahrs_period == 255 ? ">255" : Integer.valueOf(ahrs_period)) + " ms), GPS: " + ((data_state & 4) > 0 ? "OK" : ((data_state & 8) > 0 ? "low rate" : "no")) + " (" + (pos_period == 255 ? ">255" : Integer.valueOf(pos_period)) + " ms), RC: " + ((data_state & 0x10) > 0 ? "OK" : ((data_state & 0x20) > 0 ? "low rate" : "no")) + ", Control: " + ((data_state & 0x40) > 0 ? "OK" : ((data_state & 0x80) > 0 ? "low rate" : "no"));
        final String[] info = new String[2];
        for (int i = 0; i < 2; ++i) {
            long packets_received_cnt = cmd.readDWordUnsigned();
            int packets_dropped_cnt = cmd.readWordUnsigned();
            int parse_errors = cmd.readWordUnsigned();
            int rx_overflow = cmd.readWordUnsigned();
            int tx_overflow = cmd.readWordUnsigned();
            info[i] = String.format("Packets received: %d, lost: %d, parse errors: %d, buf.overflow: %d RX, %d TX", packets_received_cnt, packets_dropped_cnt, parse_errors, rx_overflow, tx_overflow);
        }
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleBGC_GUIApp.mainView.panelMavlink.MavlinkShowState(common_info, info);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Integer rcData16_to_API_range(int data, int neutral_point) {
        return data != Short.MIN_VALUE ? new Integer(neutral_point + data * 500 / 16384) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseCmdRealtimeDataCustom(SerialCommand cmd) throws IOException {
        RealtimeData tmp;
        RealtimeData realtimeData = tmp = curRealtimeData;
        synchronized (realtimeData) {
            int timestamp16 = cmd.readWordUnsigned();
            long flags = cmd.readDWordUnsigned();
            long delta = (long)timestamp16 - device_timestamp & 0xFFFFL;
            long timestamp = (device_timestamp += delta) + device_timestamp_offset;
            delta = cmd.timestamp - timestamp;
            if (Math.abs(delta) >= 1000L) {
                device_timestamp_offset = cmd.timestamp - device_timestamp;
                timestamp = cmd.timestamp;
            }
            tmp.regDate = new Date(timestamp);
            if (flags == RealtimeDataThread.RTDC_flags_slow) {
                tmp.slow_t = timestamp;
            } else if (flags == RealtimeDataThread.RTDC_flags_fast) {
                int dt = (int)(timestamp - tmp.fast_t1);
                tmp.fast_t1 = timestamp;
                tmp.fast_dt_avg = AvgFilter.average(tmp.fast_dt_avg, dt, 0.3f, RealtimeDataThread.getSamplingTimeS());
            } else if (flags == RealtimeDataThread.RTDC2_flags_fast) {
                tmp.fast_t2 = timestamp;
            } else {
                RealtimeDataThread.getLogger().warn((Object)("Unknown data set: " + Long.toHexString(flags)));
                return;
            }
            if (cmd.id == 88) {
                int axis;
                if ((flags & 1L) != 0L) {
                    tmp.angle = cmd.readWordArrAsFloatScaled(3, 0.021972656f);
                }
                if ((flags & 2L) != 0L) {
                    tmp.target_angle = cmd.readWordArrAsFloatScaled(3, 0.021972656f);
                }
                if ((flags & 8L) != 0L) {
                    tmp.frameCamAngle = cmd.readWordArrAsFloatScaled(3, 0.021972656f);
                }
                for (axis = 0; axis < 3; ++axis) {
                    tmp.stab_angle[axis] = tmp.is_stab_local_axis(axis) ? tmp.frameCamAngle[axis] : tmp.angle[axis];
                }
                if ((flags & 0x10L) != 0L) {
                    cmd.readWordArr(tmp.gyro);
                    TabbedPanelMonitoring.UPD_GROUP_GYRO.onDataUpdated();
                }
                if ((flags & 0x20L) != 0L) {
                    for (int i = 0; i < tmp.rcData.length; ++i) {
                        int val = cmd.readWord();
                        tmp.rcData[i] = val == Short.MIN_VALUE ? -10000 : 1500 + Math.round((float)val * 1000.0f / 32768.0f);
                    }
                }
                if ((flags & 0x100L) != 0L) {
                    cmd.readWordArr(tmp.acc);
                    TabbedPanelMonitoring.UPD_GROUP_ACC.onDataUpdated();
                }
                if ((flags & 0x8000L) != 0L) {
                    for (axis = 0; axis < 3; ++axis) {
                        tmp.motor_effective_out[axis] = cmd.readWord();
                        tmp.motor_current[axis] = cmd.readWordUnsigned();
                        tmp.motor_temp[axis] = cmd.readByteSigned();
                        tmp.mot_flags[axis] = cmd.readWordUnsigned();
                        tmp.balanceError[axis] = cmd.readByteSigned() * 512 / 127;
                        tmp.angle_err_max_avg[axis] = (float)cmd.readWordUnsigned() * 0.001f;
                        cmd.skipBytes(3);
                        tmp.power[axis] = Math.abs(tmp.motor_effective_out[axis]) * 255 / 10000;
                    }
                    cmd.readByte();
                    tmp.bat_val = cmd.readWord();
                    tmp.current = cmd.readWordUnsigned();
                    cmd.readWordUnsigned();
                }
                if ((flags & 0x80000L) != 0L) {
                    tmp.i2cErrorCount = cmd.readWordUnsigned();
                    tmp.comErrCnt = cmd.readWordUnsigned();
                    tmp.CANErrCnt = cmd.readWordUnsigned();
                    tmp.CANErrFlags = cmd.readByte();
                }
                if ((flags & 0x100000L) != 0L) {
                    long state_flags = cmd.readDWordUnsigned();
                    tmp.isDebugPort = (state_flags & 0x80L) != 0L;
                    tmp.isPowered = (state_flags & 0x40L) != 0L;
                    tmp.curIMU = (state_flags & 0x8000L) != 0L ? 2 : 1;
                    tmp.calibMode = cmd.readByte();
                    tmp.curProfile = cmd.readByte();
                    tmp.progress = cmd.readByte();
                    tmp.errorCode = cmd.readWordUnsigned();
                    tmp.subError = cmd.readByte();
                    tmp.cycleTime = cmd.readWordUnsigned();
                    cmd.skipBytes(1);
                    ErrorInfo.setBoardError(tmp.errorCode, tmp.subError);
                }
                if ((flags & 0x20000000L) != 0L) {
                    tmp.IMU_G_err = cmd.readByte();
                    tmp.IMU_H_err = cmd.readByte();
                    cmd.readByte();
                    tmp.ext_sens_err = cmd.readByte();
                    cmd.skipBytes(7);
                    ErrorInfo.setExtSensError(tmp.ext_sens_err);
                }
            } else if (cmd.id == 139) {
                if ((flags & 1L) != 0L) {
                    tmp.frameIMUAngle = cmd.readWordArrAsFloatScaled(3, 0.021972656f);
                }
                if ((flags & 2L) != 0L) {
                    if (tmp.frame_gyro == null) {
                        tmp.frame_gyro = new int[3];
                    }
                    cmd.readWordArr(tmp.frame_gyro);
                    TabbedPanelMonitoring.UPD_GROUP_GYRO.onDataUpdated();
                }
                if ((flags & 4L) != 0L) {
                    if (tmp.frame_acc == null) {
                        tmp.frame_acc = new int[3];
                    }
                    cmd.readWordArr(tmp.frame_acc);
                    TabbedPanelMonitoring.UPD_GROUP_ACC.onDataUpdated();
                }
                if ((flags & 8L) != 0L) {
                    cmd.readWordArr(tmp.debug);
                    TabbedPanelMonitoring.UPD_GROUP_DEBUG.onDataUpdated();
                }
                if ((flags & 0x10L) != 0L) {
                    cmd.readWordArr(tmp.magData);
                    TabbedPanelMonitoring.UPD_GROUP_MAG.onDataUpdated();
                }
            } else {
                throw new IOException("Unsupported command: " + cmd.id);
            }
        }
        cmd.checkFinished();
        curRealtimeData = tmp;
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleBGC_GUIApp.mainView.updateRealtimeData();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

