/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import java.io.IOException;
import java.util.Arrays;
import sbgc.service.SerialCommand;

public class ShakeGeneratorCfg
implements Cloneable {
    public static final int PAUSE_PERIOD_OFFSET = 500;
    public static final int PAUSE_PERIOD_SCALE = 20;
    public static final float FREQ_OFFSET = 0.3f;
    public static final float FREQ_SCALE = 0.05f;
    public static final float FREQ_RANGE_OFFSET = 1.5f;
    public static final float FREQ_RANGE_SCALE = 0.1f;
    public static final float RESONANCE_FREQ_OFFSET = 0.1f;
    public static final float RESONANCE_FREQ_SCALE = 0.1f;
    public static final float RESONANCE_GAIN_SCALE = 0.2f;
    public static final float FREQ_SHIFT_MAX = 300.0f;
    public static final float FREQ_SHIFT_MIN = 33.333332f;
    public static final float MASTER_GAIN_MIN = 0.1023f;
    public static final float MASTER_GAIN_MAX = 10.0f;
    public int[] amp = new int[3];
    public int freq;
    public int freq_range;
    public int pause_period;
    public int pause_balance;
    public int pause_affection;
    public int pause_randomness;
    public int pause_phase_variance;
    public int[] resonance_gain = new int[3];
    public int resonance_freq;
    public int[] freq_shift = new int[3];
    public int master_gain;
    public byte[] reserved = new byte[4];

    public void writeCmd(SerialCommand cmd) throws IOException {
        cmd.writeByteArr(this.amp);
        cmd.writeByte(this.freq);
        cmd.writeByte(this.freq_range);
        cmd.writeByte(this.pause_period);
        cmd.writeByte(this.pause_balance);
        cmd.writeByte(this.pause_affection);
        cmd.writeByte(this.pause_randomness);
        cmd.writeByte(this.pause_phase_variance);
        cmd.writeByteArr(this.resonance_gain);
        cmd.writeByte(this.resonance_freq);
        cmd.writeByteSignedArr(this.freq_shift);
        cmd.writeByte(this.master_gain);
        cmd.write(this.reserved);
    }

    public void readCmd(SerialCommand cmd) throws IOException {
        cmd.readByteArr(this.amp);
        this.freq = cmd.readByte();
        this.freq_range = cmd.readByte();
        this.pause_period = cmd.readByte();
        this.pause_balance = cmd.readByte();
        this.pause_affection = cmd.readByte();
        this.pause_randomness = cmd.readByte();
        this.pause_phase_variance = cmd.readByte();
        cmd.readByteArr(this.resonance_gain);
        this.resonance_freq = cmd.readByte();
        cmd.readByteSignedArr(this.freq_shift);
        this.master_gain = cmd.readByte();
        cmd.read(this.reserved);
    }

    public ShakeGeneratorCfg clone() throws CloneNotSupportedException {
        ShakeGeneratorCfg copy = (ShakeGeneratorCfg)super.clone();
        copy.amp = Arrays.copyOf(this.amp, this.amp.length);
        copy.resonance_gain = Arrays.copyOf(this.resonance_gain, this.resonance_gain.length);
        copy.freq_shift = Arrays.copyOf(this.freq_shift, this.freq_shift.length);
        return copy;
    }

    public boolean equals(Object other) {
        if (super.equals(other)) {
            return true;
        }
        if (other == null || !(other instanceof ShakeGeneratorCfg)) {
            return false;
        }
        ShakeGeneratorCfg p = (ShakeGeneratorCfg)other;
        return Arrays.equals(this.amp, p.amp) && this.freq == p.freq && this.freq_range == p.freq_range && this.pause_period == p.pause_period && this.pause_balance == p.pause_balance && this.pause_affection == p.pause_affection && this.pause_randomness == p.pause_randomness && this.pause_phase_variance == p.pause_phase_variance && Arrays.equals(this.resonance_gain, p.resonance_gain) && this.resonance_freq == p.resonance_freq && Arrays.equals(this.freq_shift, p.freq_shift) && this.master_gain == p.master_gain && Arrays.equals(this.reserved, p.reserved);
    }
}

