/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import sbgc.service.CommandResponseListener;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandProcessor;
import sbgc.utils.Log;

public class StateVars {
    static final Log logger = Log.getLogger(SerialCommandProcessor.class.getName());
    private static final int EEPROM_STATE_VARS_SIZE = 192;
    public int[] step_signal_val;
    public int sub_error;
    public int max_acc_val;
    public long work_time_s;
    public long work_time_temp_corr_s;
    public int startup_cnt;
    public int imu_temp_min;
    public int imu_temp_max;
    public int mcu_temp_min;
    public int mcu_temp_max;
    public int[] shock_cnt;
    public long energy_time_s;
    public float energy;
    public long avg_current_time_s;
    public float avg_current;
    public int max_current;
    private int reserved1;
    private byte[] reserved;

    public static StateVars readEEPROM() throws Exception {
        logger.debug("Reading state vars from EEPROM..");
        SerialCommand cmd = new SerialCommand(111);
        SerialCommand resp = CommandResponseListener.sendCommandAndWaitAnswer(cmd, 3000L);
        if (resp != null && resp.id == 111) {
            StateVars s = new StateVars();
            s.parse(resp);
            return s;
        }
        throw new Exception("No valid response on CMD_READ_STATE_VARS");
    }

    public void parse(SerialCommand cmd) throws Exception {
        logger.debug("Parsing CMD_READ_STATE_VARS..");
        if (cmd.len != 192) {
            throw new Exception("Wrong format of CMD_READ_STATE_VARS!");
        }
        this.step_signal_val = cmd.readByteArr(6);
        this.sub_error = cmd.readByte();
        this.max_acc_val = cmd.readByte();
        this.work_time_s = cmd.readDWordUnsigned();
        this.startup_cnt = cmd.readWordUnsigned();
        this.max_current = cmd.readWordUnsigned();
        this.imu_temp_min = cmd.readByteSigned();
        this.imu_temp_max = cmd.readByteSigned();
        this.mcu_temp_min = cmd.readByteSigned();
        this.mcu_temp_max = cmd.readByteSigned();
        this.shock_cnt = cmd.readByteArr(4);
        this.energy_time_s = cmd.readDWordUnsigned();
        this.energy = cmd.readFloat();
        this.avg_current_time_s = cmd.readDWordUnsigned();
        this.avg_current = cmd.readFloat();
        this.work_time_temp_corr_s = cmd.readDWordUnsigned();
        this.reserved = cmd.readBytes(192 - cmd.pos);
    }

    public void writeEEPROM() throws Exception {
        if (this.reserved == null) {
            throw new Exception("Data is empty. Read it from EEPROM first!");
        }
        logger.debug("Writing state vars to EEPROM..");
        SerialCommand cmd = new SerialCommand(112, 192);
        cmd.writeByteArr(this.step_signal_val);
        cmd.writeByte(this.sub_error);
        cmd.writeByte(this.max_acc_val);
        cmd.writeDWord(this.work_time_s);
        cmd.writeWord(this.startup_cnt);
        cmd.writeWord(this.max_current);
        cmd.writeByteSigned(this.imu_temp_min);
        cmd.writeByteSigned(this.imu_temp_max);
        cmd.writeByteSigned(this.mcu_temp_min);
        cmd.writeByteSigned(this.mcu_temp_max);
        cmd.writeByteArr(this.shock_cnt);
        cmd.writeDWord(this.energy_time_s);
        cmd.writeFloat(this.energy);
        cmd.writeDWord(this.avg_current_time_s);
        cmd.writeFloat(this.avg_current);
        cmd.writeDWord(this.work_time_temp_corr_s);
        cmd.write(this.reserved);
        SerialCommand resp = CommandResponseListener.sendCommandAndWaitAnswer(cmd, 3000L);
        if (resp == null || resp.id != 67) {
            throw new Exception("No confirmation on writing state variables!");
        }
    }
}

