/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import sbgc.service.SerialCommand;
import sbgc.utils.FileUtil;

public class ThermostatCfg {
    public static final int FLAG_ENABLED = 1;
    public static final int FILE_ID_THERMOSTAT_CFG = 3329;
    public static final int EEPROM_CFG_SIZE = 32;
    public static final int FORMAT_VER_CUR = 3;
    public static final float THERMO_GAIN_MIN = 0.1f;
    public static final float THERMO_GAIN_MAX = 10.0f;
    public static final float THERMO_KI_KP_MIN = 0.02f;
    public static final float THERMO_KI_KP_MAX = 50.0f;
    public int format_ver;
    public int temp;
    public int pid_gain;
    public int ki_kp;
    public int kd_kp;
    public int power;
    public int flags;
    public int ext_sens_type;
    public byte[] reserved = new byte[21];

    public ThermostatCfg(byte[] data) throws Exception {
        this.parse(data);
    }

    public byte[] pack() throws Exception {
        SerialCommand cmd = new SerialCommand(0, 32);
        cmd.writeByte(3);
        cmd.writeWord(this.flags);
        cmd.writeByte(this.power);
        cmd.writeByte(this.temp);
        cmd.writeByte(this.pid_gain);
        cmd.writeByte(this.ki_kp);
        cmd.writeByte(this.kd_kp);
        cmd.writeByte(this.ext_sens_type);
        cmd.write(this.reserved);
        cmd.writeWord(FileUtil.crc16_sbgc32(cmd.data, 0, cmd.len));
        cmd.checkFull();
        return cmd.data;
    }

    public void parse(byte[] data) throws Exception {
        SerialCommand cmd = new SerialCommand(0, data);
        this.format_ver = cmd.readByte();
        this.flags = cmd.readWordUnsigned();
        this.power = cmd.readByte();
        this.temp = cmd.readByte();
        this.pid_gain = cmd.readByte();
        if (this.format_ver >= 3) {
            this.ki_kp = cmd.readByte();
            this.kd_kp = cmd.readByte();
        } else {
            cmd.skipBytes(2);
            this.ki_kp = 127;
            this.kd_kp = 127;
        }
        this.ext_sens_type = cmd.readByte();
        cmd.read(this.reserved);
        int crc16 = FileUtil.crc16_sbgc32(cmd.data, 0, cmd.pos);
        int crc16_file = cmd.readWordUnsigned();
        if (crc16 != crc16_file) {
            throw new Exception("Bad CRC (calculated " + crc16 + " != stored " + crc16_file + ")");
        }
        cmd.checkFinished();
    }
}

