/*
 * Decompiled with CFR 0.152.
 */
package sbgc.optimizer;

import org.apache.log4j.Logger;
import sbgc.optimizer.IOptimizable;
import sbgc.optimizer.IOptimizedParams;
import sbgc.service.upgrade.IProgressListener;
import sbgc.utils.Log;
import sbgc.utils.MathUtils;

public abstract class Optimizer {
    protected static final Log logger = new Log(Logger.getLogger((String)Optimizer.class.getName()));
    public static final float STABILIZE_STEP = 0.1f;
    public static final float RANDOMIZE_STEP = 0.02f;
    protected boolean isActive;
    protected IProgressListener progressListener;
    protected IOptimizable system;
    protected final boolean isStartFromCurrent;
    protected final int iterNumMax;

    protected Optimizer(IOptimizable system, IProgressListener progressListener, boolean isStartFromCurrent, int iterNumMax) throws Exception {
        this.progressListener = progressListener;
        this.system = system;
        this.isStartFromCurrent = isStartFromCurrent;
        this.iterNumMax = iterNumMax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float optimize(IOptimizedParams p) throws Exception {
        this.isActive = true;
        try {
            float cost_best = this.system.cost_function(p, 0.0f);
            logger.debug(String.format("Initial cost=%.4f (%s)", Float.valueOf(cost_best), p.toString()));
            p.applyConstraints();
            cost_best = this._optimize(p);
            if (cost_best == 1000000.0f) {
                throw new IllegalStateException("Stable solution was not found!" + (this.isStartFromCurrent ? "\nTry to change initial conditions or start from zero values." : ""));
            }
            logger.debug(String.format("Best values: cost=%.4f (%s)", Float.valueOf(cost_best), p.toString()));
            float f = cost_best;
            return f;
        }
        finally {
            this.isActive = false;
        }
    }

    protected abstract float _optimize(IOptimizedParams var1) throws Exception;

    protected abstract float getProgress();

    protected float computeCost(IOptimizedParams p, float[] n_params) throws Exception {
        p.setNormalizedParams(n_params, -1);
        return this.system.cost_function(p, this.getProgress());
    }

    void updateProgress(int progress) {
        if (this.progressListener != null && !this.progressListener.onProgressChange(progress)) {
            this.isActive = false;
        }
    }

    protected void makeStabilizeStep(IOptimizedParams p, float[] n_params) throws Exception {
        Optimizer.makeRandomStep(n_params, 0.02f);
        p.setNormalizedParams(n_params, -1);
        p.increaseStability(0.1f);
        p.getNormalizedParams(n_params);
    }

    public static void makeRandomStep(float[] n_params, float stepLength) {
        for (int j = 0; j < n_params.length; ++j) {
            n_params[j] = Optimizer.make_rnd_step(n_params[j], stepLength);
        }
    }

    public static float make_rnd_step(float val, float rnd_step_size) {
        float rnd1 = (float)Math.random() * 2.0f - 1.0f;
        return MathUtils.constrain(val += rnd1 < 0.0f ? rnd1 * Math.min(rnd_step_size, val) : rnd1 * Math.min(rnd_step_size, 1.0f - val), 0.0f, 1.0f);
    }
}

