/*
 * Decompiled with CFR 0.152.
 */
package sbgc.script_parser.script;

public enum ParamId {
    NUMERIC,
    RA,
    PA,
    YA,
    RESERVED2,
    TIMEOUT,
    RS,
    PS,
    YS,
    ACC_LIMIT_R,
    ACC_LIMIT_P,
    ACC_LIMIT_Y,
    SPEED_R,
    SPEED_P,
    SPEED_Y,
    TIME,
    INIT_SYSTEM_ON_FINISH,
    CMD_ID,
    NAME,
    VALUE,
    JERK_SLOPE_R,
    JERK_SLOPE_P,
    JERK_SLOPE_Y,
    OPERATOR,
    COND,
    GOTO,
    RMOD,
    PMOD,
    YMOD;

    public static final int STORAGE_TYPE_BYTE = 1;
    public static final int STORAGE_TYPE_UNSIGNED_SHORT = 2;
    public static final int STORAGE_TYPE_FLOAT = 4;
    public static final String[] OPERATOR_VALUES;
    public static final String[] COND_VALUES;

    public static ParamId fromString(String name) {
        for (ParamId paramId : ParamId.values()) {
            if (!paramId.name().equals(name)) continue;
            return paramId;
        }
        return null;
    }

    public int toInteger() {
        return this.ordinal() + 65;
    }

    public static ParamId fromId(int id) {
        if ((id -= 65) >= 0 && id < ParamId.values().length) {
            return ParamId.values()[id];
        }
        return null;
    }

    public final int getStorageType() {
        switch (this) {
            case INIT_SYSTEM_ON_FINISH: 
            case OPERATOR: 
            case COND: 
            case RMOD: 
            case PMOD: 
            case YMOD: {
                return 1;
            }
            case CMD_ID: 
            case NAME: 
            case JERK_SLOPE_R: 
            case JERK_SLOPE_P: 
            case JERK_SLOPE_Y: 
            case GOTO: {
                return 2;
            }
        }
        return 4;
    }

    static {
        OPERATOR_VALUES = new String[]{"=", "+", "-", "*", "/", "%"};
        COND_VALUES = new String[]{"=", "!=", ">", ">=", ">>", "<", "<=", "<<"};
    }
}

