/*
 * Decompiled with CFR 0.152.
 */
package sbgc.script_parser.script;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sbgc.object.BoardParams;
import sbgc.object.Sprav;
import sbgc.script_parser.manager.BinaryReadException;
import sbgc.script_parser.manager.ScriptParser;
import sbgc.script_parser.script.BadProgramException;
import sbgc.script_parser.script.CommandId;
import sbgc.script_parser.script.ParamId;
import sbgc.script_parser.script.ScriptProgram;
import sbgc.script_parser.utils.Utils;
import sbgc.service.DataInputStreamLE;
import sbgc.service.DataOutputStreamLE;
import sbgc.ui.ParamsUIFactory;
import simplebgc_gui.SimpleBGC_GUIApp;

public class ScriptCmdParam
implements Serializable {
    public static final float ANGLE_SCALE = 45.511112f;
    public static final Map<String, Integer> RC_SRC_NAMES;
    public static final int SRC_TYPE_RC = 1;
    public static final int SRC_TYPE_VAR = 2;
    public static final int SRC_TYPE_ADJ_VAR = 3;
    public static final int TMP_VARS_MAX_NUM = 10;
    public static final int API_VIRT_NUM_CHANNELS = 32;
    public static final int VAR_IDX_TMP_VAR = 246;
    public static final int VAR_IDX_RC_API_VIRT_CH = 214;
    private int id;
    private CommandId cmdId;
    private float value;
    private int srcId = 0;
    private int srcType = 0;
    private float srcMin = 0.0f;
    private float srcMax = 0.0f;
    ScriptParser scriptParser = null;

    public ScriptCmdParam(CommandId cmdId) {
        this.cmdId = cmdId;
    }

    public ScriptCmdParam(int id, float value) {
        this.id = id;
        this.value = value;
    }

    public void setScriptParser(ScriptParser scriptParser) {
        this.scriptParser = scriptParser;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public void setSrc(int srcType, int srcId) {
        this.srcId = srcId;
        this.srcType = srcType;
    }

    public void setSrcMin(float rcMin) {
        this.srcMin = rcMin;
    }

    public void setSrcMax(float rcMax) {
        this.srcMax = rcMax;
    }

    public boolean equals(ScriptCmdParam scriptCmdParam) {
        return scriptCmdParam.getId() == this.id && scriptCmdParam.getValue() == this.value;
    }

    public boolean isNamed() {
        return this.id >= 66;
    }

    public ParamId getNamedId() {
        assert (this.isNamed());
        return ParamId.fromId(this.id);
    }

    public boolean isNumeric() {
        return !this.isNamed();
    }

    public boolean isAngleParam() {
        ParamId p = ParamId.fromId(this.id);
        return p != null && (p == ParamId.PA || p == ParamId.RA || p == ParamId.YA);
    }

    public boolean isNoValueParam() {
        ParamId p = ParamId.fromId(this.id);
        return false;
    }

    public static String getArrayParamName(int valueInt, String[] arr) {
        if (valueInt >= 0 && valueInt < arr.length) {
            return arr[valueInt];
        }
        return "UNKNOWN_ID_" + valueInt;
    }

    public String toScriptString(ScriptProgram scriptProgram) {
        StringBuilder res = new StringBuilder();
        if (this.isNamed()) {
            ParamId p = this.getNamedId();
            res.append(p != null ? p.toString() : "<unknown param>");
        } else {
            res.append(Integer.toString(this.id));
        }
        res.append("(");
        Integer valueInt = Math.round(this.value);
        int type = ParamId.fromId(this.id).getStorageType();
        if (this.srcType > 0) {
            String srcName = null;
            switch (this.srcType) {
                case 1: {
                    srcName = ScriptCmdParam.rcSrcIntegerToName(this.srcId);
                    break;
                }
                case 2: {
                    srcName = "TMP_VAR_" + (this.srcId + 1);
                    break;
                }
                case 3: {
                    srcName = ScriptCmdParam.adjVarIntegerToName(this.srcId);
                }
            }
            if (srcName == null) {
                srcName = "UNKNOWN_SRC_" + this.srcType + "_" + this.srcId;
            }
            res.append(srcName);
            res.append("[" + Float.toString(this.srcMin) + "," + Float.toString(this.srcMax) + "]");
        } else if (this.id == ParamId.NAME.toInteger()) {
            String name = null;
            if (this.cmdId == CommandId.SET_ADJ_VAR || this.cmdId == CommandId.IF) {
                name = valueInt >= 246 ? "TMP_VAR_" + (valueInt - 246 + 1) : (valueInt >= 214 ? "API_VIRT_CH_" + (valueInt - 214 + 1) : ScriptCmdParam.adjVarIntegerToName(valueInt));
            }
            if (name == null) {
                name = "UNKNOWN_ID_" + valueInt;
            }
            res.append(name);
        } else if (this.id == ParamId.OPERATOR.toInteger()) {
            res.append(ScriptCmdParam.getArrayParamName(valueInt, ParamId.OPERATOR_VALUES));
        } else if (this.id == ParamId.COND.toInteger()) {
            res.append(ScriptCmdParam.getArrayParamName(valueInt, ParamId.COND_VALUES));
        } else if (this.id == ParamId.GOTO.toInteger()) {
            String label = null;
            if (scriptProgram != null) {
                label = scriptProgram.addAutoLabel(valueInt);
            }
            if (label != null) {
                res.append(label);
            } else {
                res.append(valueInt);
            }
        } else if (this.cmdId == CommandId.TRIGGER && this.id <= ParamId.NUMERIC.toInteger() || this.id == ParamId.CMD_ID.toInteger() || this.id == ParamId.INIT_SYSTEM_ON_FINISH.toInteger()) {
            res.append(Integer.toString(valueInt));
        } else if (type == 1 || type == 2) {
            res.append(valueInt);
        } else {
            res.append(Float.toString(this.value));
        }
        res.append(")");
        return res.toString();
    }

    public String toStringDump() {
        return this.toString();
    }

    public void verify() throws BadProgramException {
        if (this.id < 66) {
            return;
        }
        if (this.id <= 0 || this.id - 66 >= ParamId.values().length) {
            throw new BadProgramException(SimpleBGC_GUIApp.getResourceMap().getString("error.ScriptParser.invalidParameterId", new Object[0]));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScriptCmdParam read(DataInputStreamLE ds, CommandId commandId) throws IOException, BinaryReadException {
        ScriptCmdParam scriptCmdParam = new ScriptCmdParam(commandId);
        int id = ds.readByte();
        if ((id & 0x80) > 0) {
            scriptCmdParam.setId(id &= 0xFFFFFF7F);
            int srcType = ds.readByte();
            int srcId = ds.readByte();
            scriptCmdParam.setSrc(srcType, srcId);
            scriptCmdParam.setSrcMin(ds.readFloat());
            scriptCmdParam.setSrcMax(ds.readFloat());
            return scriptCmdParam;
        } else {
            float paramValue;
            scriptCmdParam.setId(id);
            if (scriptCmdParam.isNumeric()) {
                if (commandId == CommandId.TRIGGER) {
                    paramValue = ds.readByte();
                } else {
                    if (commandId != CommandId.SERVO) throw new BinaryReadException("Command ID=" + (Object)((Object)commandId) + " has wrong parameter " + scriptCmdParam.toStringDump());
                    paramValue = ds.readShort();
                }
            } else if (scriptCmdParam.isNoValueParam()) {
                paramValue = 0.0f;
            } else {
                int type = ParamId.fromId(id).getStorageType();
                if (type == 1) {
                    paramValue = ds.readByte();
                } else if (type == 2) {
                    paramValue = ds.readShortUnsigned();
                } else {
                    if (type != 4) throw new BinaryReadException("Command ID=" + (Object)((Object)commandId) + " parameter '" + scriptCmdParam.toStringDump() + "' is unknow type " + type);
                    paramValue = ds.readFloat();
                }
            }
            scriptCmdParam.setValue(paramValue);
        }
        return scriptCmdParam;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(DataOutputStreamLE out, CommandId commandId) throws IOException {
        if (this.srcType > 0) {
            out.writeByte(this.id | 0x80);
            out.writeByte(this.srcType);
            out.writeByte(this.srcId);
            out.writeFloat(this.srcMin);
            out.writeFloat(this.srcMax);
            return;
        } else {
            out.writeByte(this.id);
            if (this.isNumeric()) {
                if (commandId == CommandId.TRIGGER) {
                    out.writeByte((int)this.value);
                    return;
                } else {
                    if (commandId != CommandId.SERVO) throw new IOException("Command " + (Object)((Object)commandId) + " has wrong parameter " + this.toStringDump());
                    out.writeShort((int)this.value);
                }
                return;
            } else {
                if (this.isNoValueParam()) return;
                int int_value = Math.round(this.value);
                int type = ParamId.fromId(this.id).getStorageType();
                if (type == 1) {
                    out.writeByte(int_value);
                    return;
                } else if (type == 2) {
                    out.writeShort(int_value);
                    return;
                } else {
                    if (type != 4) throw new IOException("Command ID=" + (Object)((Object)commandId) + " parameter '" + this.toStringDump() + "' is unknow type " + type);
                    out.writeFloat(this.value);
                }
            }
        }
    }

    public static Integer rcSrcNameToInteger(String name) {
        return RC_SRC_NAMES.get(name);
    }

    public static String rcSrcIntegerToName(Integer id) {
        for (Map.Entry<String, Integer> entry : RC_SRC_NAMES.entrySet()) {
            if (id == null || !id.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public static Integer adjVarNameToInteger(String name) {
        for (Sprav var : ParamsUIFactory.getAdjVarsList()) {
            if (!var.getName().equalsIgnoreCase(name)) continue;
            return var.getId();
        }
        return null;
    }

    public static String adjVarIntegerToName(Integer id) {
        for (Sprav var : ParamsUIFactory.getAdjVarsList()) {
            if (!var.getId().equals(id)) continue;
            return var.getName();
        }
        return null;
    }

    public static int indexOfArray(String valStr, String[] arr) throws Exception {
        int idx = Arrays.asList(arr).indexOf(valStr);
        if (idx >= 0) {
            return idx;
        }
        throw new Exception(SimpleBGC_GUIApp.getResourceMap().getString("error.ScriptParser.invalidSetValue", valStr, String.join((CharSequence)",", arr)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(String valueStr) throws Exception {
        if (this.scriptParser == null) {
            throw new IllegalStateException("ScriptParser is not available, required.");
        }
        Exception invalidParamValException = new Exception(SimpleBGC_GUIApp.getResourceMap().getString("error.ScriptParser.invalidParameterValue", new Object[0]) + " " + valueStr);
        if (valueStr.startsWith("UNKNOWN_ID_")) {
            this.setValue(Integer.parseInt(valueStr.substring(11)));
            return;
        } else if (this.getId() == ParamId.NAME.toInteger()) {
            Integer name_id = null;
            if (this.cmdId == CommandId.SET_ADJ_VAR || this.cmdId == CommandId.IF) {
                if (valueStr.startsWith("TMP_VAR_")) {
                    int var_id = Integer.parseInt(valueStr.substring(8));
                    if (var_id < 1 || var_id > 10) throw new Exception("In TMP_VAR_<N> N should be in range 1..10");
                    name_id = var_id - 1 + 246;
                } else if (valueStr.startsWith("API_VIRT_CH_")) {
                    int id = Integer.parseInt(valueStr.substring(12));
                    if (id < 1 || id > 32) throw new Exception("In API_VIRT_CH_<N> N should be in range 1..32");
                    name_id = id - 1 + 214;
                } else {
                    name_id = ScriptCmdParam.adjVarNameToInteger(valueStr);
                }
            }
            if (name_id == null) throw new Exception(SimpleBGC_GUIApp.getResourceMap().getString("error.ScriptParser.invalidParameterValueForName", new Object[0]) + " " + valueStr);
            this.setValue(name_id.intValue());
            return;
        } else if (this.getId() == ParamId.OPERATOR.toInteger()) {
            this.setValue(ScriptCmdParam.indexOfArray(valueStr, ParamId.OPERATOR_VALUES));
            return;
        } else if (this.getId() == ParamId.COND.toInteger()) {
            this.setValue(ScriptCmdParam.indexOfArray(valueStr, ParamId.COND_VALUES));
            return;
        } else if (this.getId() == ParamId.GOTO.toInteger()) {
            Integer lineNum = null;
            if (Utils.isInteger(valueStr)) {
                lineNum = Utils.toInteger(valueStr);
                if (!this.scriptParser.isLineNumValid(lineNum)) {
                    throw new Exception(SimpleBGC_GUIApp.getResourceMap().getString("error.ScriptParser.invalidLineNumber", lineNum));
                }
            } else {
                lineNum = this.scriptParser.getLineNumForLabel(valueStr);
                if (lineNum == null) {
                    throw new Exception(SimpleBGC_GUIApp.getResourceMap().getString("error.ScriptParser.invalidLabel", valueStr));
                }
            }
            this.setValue(lineNum.floatValue());
            return;
        } else {
            if (!Utils.isFloat(valueStr)) {
                throw invalidParamValException;
            }
            this.setValue(Utils.toFloat(valueStr));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSrc(String srcName, String rcMin, String rcMax) throws Exception {
        if (!this.parseForUnknownSrc(srcName)) {
            if (srcName.startsWith("TMP_VAR_")) {
                int idx = Integer.parseInt(srcName.substring(8)) - 1;
                if (idx < 0 || idx >= 10) throw new Exception("In TMP_VAR_<N> N should be in range 1..10");
                this.setSrc(2, idx);
            } else {
                Integer srcId = ScriptCmdParam.rcSrcNameToInteger(srcName);
                if (srcId != null) {
                    this.setSrc(1, srcId);
                } else {
                    srcId = ScriptCmdParam.adjVarNameToInteger(srcName);
                    if (srcId == null) throw new Exception(SimpleBGC_GUIApp.getResourceMap().getString("error.ScriptParser.invalidSrc", new Object[0]) + " " + srcName);
                    this.setSrc(3, srcId);
                }
            }
        }
        if (!Utils.isFloat(rcMin) || !Utils.isFloat(rcMax)) {
            throw new Exception(SimpleBGC_GUIApp.getResourceMap().getString("error.ScriptParser.invalidParameterValue", new Object[0]) + ": '" + rcMin + "," + rcMax + "'");
        }
        this.setSrcMin(Utils.toFloat(rcMin));
        this.setSrcMax(Utils.toFloat(rcMax));
    }

    public boolean parseForUnknownSrc(String str) throws Exception {
        Matcher matcher = Pattern.compile("^UNKNOWN_SRC_(\\d+)_(\\d+)$").matcher(str);
        if (matcher.matches()) {
            this.setSrc(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(1)));
            return true;
        }
        return false;
    }

    static {
        int i;
        RC_SRC_NAMES = new LinkedHashMap<String, Integer>();
        RC_SRC_NAMES.put("RC_ROLL_PWM", 1);
        RC_SRC_NAMES.put("RC_PITCH_PWM", 2);
        RC_SRC_NAMES.put("RC_YAW_PWM", 5);
        RC_SRC_NAMES.put("FC_ROLL_PWM", 3);
        RC_SRC_NAMES.put("FC_PITCH_PWM", 4);
        RC_SRC_NAMES.put("ADC1", 33);
        RC_SRC_NAMES.put("ADC2", 34);
        RC_SRC_NAMES.put("ADC3", 35);
        for (i = 1; i < 20; ++i) {
            RC_SRC_NAMES.put("RC_VIRT_CH_" + i, 64 + i);
        }
        for (i = 1; i <= 31; ++i) {
            RC_SRC_NAMES.put("API_VIRT_CH_" + i, 128 + i);
        }
        for (i = 0; i < BoardParams.RC_VIRT_CH_MOTOR_ANGLE_NAMES.length; ++i) {
            RC_SRC_NAMES.put(BoardParams.RC_VIRT_CH_MOTOR_ANGLE_NAMES[i], 64 + i + 20);
        }
        for (i = 0; i < BoardParams.RC_VIRT2_CH_NAMES.length; ++i) {
            RC_SRC_NAMES.put(BoardParams.RC_VIRT2_CH_NAMES[i], 96 + i);
        }
    }
}

