/*
 * Decompiled with CFR 0.152.
 */
package sbgc.script_parser.utils;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import sbgc.script_parser.script.ScriptProgram;
import sbgc.service.SerialCommandProcessor;
import sbgc.service.upgrade.IProgressListener;

public class FileHelper {
    public static final String outputFilePath = "binaryFile.bin";

    public String readFile(String filename) throws IOException {
        File file = new File(filename);
        FileReader reader = new FileReader(file);
        char[] chars = new char[(int)file.length()];
        reader.read(chars);
        String content = new String(chars);
        reader.close();
        return content;
    }

    public byte[] readBinFile(String file) throws IOException {
        return this.readBinFile(new File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBinFile(File file) throws IOException {
        try (RandomAccessFile f = new RandomAccessFile(file, "r");){
            long longlength = f.length();
            int length = (int)longlength;
            if ((long)length != longlength) {
                throw new IOException("File size >= 2 GB");
            }
            byte[] data = new byte[length];
            f.readFully(data);
            byte[] byArray = data;
            return byArray;
        }
    }

    public void writeByteArray(byte[] byteArray, String filePath) throws FileNotFoundException, IOException {
        FileOutputStream fos = new FileOutputStream(filePath);
        fos.write(byteArray);
        fos.close();
    }

    public void writeString(String filePath, String content) throws IOException {
        File newTextFile = new File(filePath);
        FileWriter fw = new FileWriter(newTextFile);
        fw.write(content);
        fw.close();
    }

    public DataInputStream readStream(String filePath) throws FileNotFoundException {
        return this.readStream(new File(filePath));
    }

    public DataInputStream readStream(File file) throws FileNotFoundException {
        return new DataInputStream(new FileInputStream(file));
    }

    public static String removeExtention(String filePath) {
        int ext_idx;
        int slash_idx = filePath.lastIndexOf("\\");
        if (slash_idx == -1) {
            slash_idx = filePath.lastIndexOf("/");
        }
        if ((ext_idx = filePath.lastIndexOf(46)) == -1) {
            ext_idx = filePath.length() - 1;
        }
        return filePath.substring(slash_idx + 1, ext_idx);
    }

    public static byte[] writeBoard(ScriptProgram scriptProgram, int slotNum, IProgressListener progressListener) throws Exception {
        byte[] data = null;
        if (scriptProgram.getCmdNum() > 0) {
            data = scriptProgram.getBytes();
        }
        int fileId = ScriptProgram.getScriptFileId(slotNum);
        SerialCommandProcessor.writeFile(fileId, data, progressListener);
        return data;
    }

    public static byte[] readBoard(int slotNum, IProgressListener progressListener) throws Exception {
        int fileId = ScriptProgram.getScriptFileId(slotNum);
        byte[] data = SerialCommandProcessor.readFile(fileId, progressListener);
        return data;
    }
}

