/*
 * Decompiled with CFR 0.152.
 */
package sbgc.script_parser.utils;

import javax.xml.bind.DatatypeConverter;

public class Utils {
    public static String getHexDump(byte[] bytes) {
        return DatatypeConverter.printHexBinary((byte[])bytes);
    }

    public static boolean isParam(String str) {
        return str.matches("^\\w+\\(([-]?\\d*\\.?\\d+|\\w+\\[[-]?\\d*\\.?\\d+\\,\\s*[-]?\\d*\\.?\\d+\\])\\)$");
    }

    public static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static int toInteger(String str) {
        assert (Utils.isInteger(str));
        return Integer.parseInt(str);
    }

    public static boolean isFloat(String str) {
        try {
            Float.parseFloat(str);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static float toFloat(String str) {
        assert (Utils.isFloat(str));
        return Float.parseFloat(str);
    }
}

