/*
 * Decompiled with CFR 0.152.
 */
package sbgc.serial.command;

import sbgc.service.SerialCommand;
import sbgc.utils.MathUtils;

public class CmdControlHelper {
    public static float SPEED_DEG_S_TO_UNITS_SCALE = 8.19175f;
    public static final int MODE_DISABLED = 0;
    public static final int MODE_IGNORE = 7;
    public static final int MODE_SPEED = 1;
    public static final int MODE_ANGLE = 2;
    public static final int MODE_ANGLE_SHORTEST = 8;
    public static final int MODE_SPEED_ANGLE = 3;
    public static final int MODE_RC = 4;
    public static final int MODE_RC_HIGH_RES = 6;
    public static final int MODE_ANGLE_REL_FRAME = 5;
    public static final int FLAG_AUTO_TASK = 64;
    public static final int FLAG_FORCE_RC_SPEED = 64;
    public static final int FLAG_HIGH_RES_SPEED = 64;
    public static final int FLAG_TARGET_PRECISE = 32;
    public static final int FLAG_MIX_FOLLOW = 16;
    public int[] mode = new int[3];
    public float[] speed = new float[3];
    public float[] angle = new float[3];
    public int[] rc_values = new int[3];

    public void updateRCValues(int[] values) {
        System.arraycopy(values, 0, this.rc_values, 0, this.rc_values.length);
    }

    public void setAngles(float[] angles) {
        System.arraycopy(angles, 0, this.angle, 0, angles.length);
    }

    public SerialCommand getCmd() {
        SerialCommand cmd_control = new SerialCommand(67);
        try {
            cmd_control.writeByteArr(this.mode);
            for (int axis = 0; axis < 3; ++axis) {
                cmd_control.writeWord(Math.round(this.speed[axis] * SPEED_DEG_S_TO_UNITS_SCALE));
                cmd_control.writeWord(this.mode[axis] == 4 ? this.rc_values[axis] * -500 / -16384 : (this.mode[axis] == 6 ? this.rc_values[axis] : MathUtils.deg_to_angle14(this.angle[axis])));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cmd_control;
    }
}

