/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.util.zip.CRC32;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;
import sbgc.object.ErrorInfo;
import sbgc.object.IMUCalib;
import sbgc.service.SerialCommandProcessor;
import sbgc.service.upgrade.IProgressListener;
import sbgc.utils.FileUtil;
import simplebgc_gui.SimpleBGC_GUIApp;

public class BackupIMUCalibThread
extends Thread {
    static final Logger logger = Logger.getLogger((String)BackupIMUCalibThread.class.getName());
    static BackupIMUCalibThread backupIMUCalibThread = null;
    static ResourceMap resourceMap = null;
    final boolean isFrameIMU;
    final File file;
    final IProgressListener progressListener;

    public static void backupIMUCalib(boolean isFrameIMU, IProgressListener progressListener) {
        File f;
        resourceMap = SimpleBGC_GUIApp.getResourceMap();
        if (!(backupIMUCalibThread != null && backupIMUCalibThread.isAlive() || (f = SimpleBGC_GUIApp.mainView.showProfileSaveDialog(resourceMap.getString("title.dialog_IMU_calib_file", new Object[0]), "data", "sbgc_IMU_calib.data")) == null)) {
            backupIMUCalibThread = new BackupIMUCalibThread(isFrameIMU, f, progressListener);
            backupIMUCalibThread.start();
        }
    }

    public BackupIMUCalibThread(boolean isFrameIMU, File file, IProgressListener progressListener) {
        this.isFrameIMU = isFrameIMU;
        this.file = file;
        this.progressListener = progressListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.progressListener.onProgressStart(resourceMap.getString("progress.backup_IMU_calib", new Object[0]), false);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            for (int type = 1; type <= 3; ++type) {
                int fileId = IMUCalib.getCalibFileId(type, this.isFrameIMU);
                byte[] data = SerialCommandProcessor.readFile(fileId, this.progressListener);
                dos.writeByte(type);
                dos.writeShort(data.length);
                CRC32 crc = new CRC32();
                crc.update(data);
                dos.writeLong(crc.getValue());
                dos.write(data);
                this.progressListener.onProgressChange(type * 30);
            }
            dos.close();
            FileUtil.saveBackupData(2, this.file, bos.toByteArray());
            ErrorInfo.updateStatus(resourceMap.getString("status.backup_IMU_calib.done", new Object[0]));
        }
        catch (InterruptedException bos) {
        }
        catch (Exception e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleBGC_GUIApp.mainView.showErrorMessage(e.getMessage(), resourceMap.getString("error.backup_IMU_calib", new Object[0]));
                }
            });
        }
        finally {
            this.progressListener.onProgressFinish(true);
        }
    }
}

