/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service;

import java.util.LinkedList;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import sbgc.object.ErrorInfo;
import sbgc.service.ICommandResponseListener;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandDispatcher;
import sbgc.service.SerialCommandProcessor;
import sbgc.service.upgrade.IProgressListener;
import simplebgc_gui.SimpleBGC_GUIApp;

public class CommandResponseListener
implements Runnable,
ICommandResponseListener {
    public static final int CMD_BUF_MAX_SIZE = 100;
    static final Logger logger = Logger.getLogger((String)CommandResponseListener.class.getName());
    private int commandId = -1;
    private LinkedList<SerialCommand> cmdBuf = new LinkedList();
    private long timeout = 0L;
    public boolean supressLogs = false;

    public CommandResponseListener(int commandId) {
        this.commandId = commandId;
    }

    public CommandResponseListener(int commandId, long timeout) {
        this.commandId = commandId;
        this.timeout = timeout;
    }

    protected void finalize() throws Throwable {
        SerialCommandDispatcher.getInstance().removeResponseListener(this);
        super.finalize();
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCommandReceived(SerialCommand cmd) {
        CommandResponseListener commandResponseListener = this;
        synchronized (commandResponseListener) {
            if (!cmd.isHeavyDutyCommand(false) && !this.supressLogs) {
                logger.trace((Object)("onCommandReceived " + cmd.toHeaderString()));
            }
            if (this.cmdBuf.size() < 100) {
                this.cmdBuf.add(cmd);
                this.notifyAll();
            } else {
                logger.warn((Object)("buffer is overflown, command (" + cmd.id + ") is lost!"));
            }
        }
    }

    private boolean isResponseReceived() {
        return this.cmdBuf.size() > 0;
    }

    public synchronized SerialCommand waitShort(long timeout) throws InterruptedException {
        if (!this.isResponseReceived() && timeout > 0L) {
            this.wait(timeout);
        }
        return this.cmdBuf.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerialCommand waitFor(IProgressListener progressListener) throws InterruptedException {
        SerialCommand res = null;
        try {
            for (long i = 0L; i < this.timeout && !Thread.currentThread().isInterrupted(); i += 100L) {
                CommandResponseListener commandResponseListener = this;
                synchronized (commandResponseListener) {
                    if (this.isResponseReceived()) {
                        break;
                    }
                    this.wait(100L);
                    if (progressListener != null && !progressListener.onProgressChange((int)(i * 100L / this.timeout))) {
                        throw new InterruptedException("Interrupted by user!");
                    }
                    continue;
                }
            }
        }
        finally {
            CommandResponseListener commandResponseListener = this;
            synchronized (commandResponseListener) {
                SerialCommandDispatcher.getInstance().removeResponseListener(this);
                res = this.cmdBuf.poll();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerialCommand[] waitForCount(IProgressListener progressListener, int count) throws InterruptedException {
        CommandResponseListener commandResponseListener;
        SerialCommand[] res = null;
        try {
            for (long i = 0L; i < this.timeout && !Thread.currentThread().isInterrupted(); i += 100L) {
                CommandResponseListener commandResponseListener2 = this;
                synchronized (commandResponseListener2) {
                    if (this.cmdBuf.size() >= count) {
                        break;
                    }
                    this.wait(100L);
                    if (progressListener != null && !progressListener.onProgressChange((int)(i * 100L / this.timeout))) {
                        throw new InterruptedException("Interrupted by user!");
                    }
                    continue;
                }
            }
            commandResponseListener = this;
        }
        catch (Throwable throwable) {
            CommandResponseListener commandResponseListener3 = this;
            synchronized (commandResponseListener3) {
                SerialCommandDispatcher.getInstance().removeResponseListener(this);
                if (this.cmdBuf.size() > 0) {
                    res = new SerialCommand[Math.min(this.cmdBuf.size(), count)];
                    for (int i = 0; i < res.length; ++i) {
                        res[i] = this.cmdBuf.poll();
                    }
                }
            }
            throw throwable;
        }
        synchronized (commandResponseListener) {
            SerialCommandDispatcher.getInstance().removeResponseListener(this);
            if (this.cmdBuf.size() > 0) {
                res = new SerialCommand[Math.min(this.cmdBuf.size(), count)];
                for (int i = 0; i < res.length; ++i) {
                    res[i] = this.cmdBuf.poll();
                }
            }
        }
        return res;
    }

    public static SerialCommand waitFor(int commandId, long timeout, IProgressListener progressListener) throws InterruptedException {
        CommandResponseListener cmdResponseListener = CommandResponseListener.registerResponseListener(commandId, timeout);
        return cmdResponseListener.waitFor(progressListener);
    }

    public static SerialCommand waitFor(int commandId, long timeout) throws InterruptedException {
        return CommandResponseListener.waitFor(commandId, timeout, null);
    }

    public static CommandResponseListener registerResponseListener(int commandId, long timeout) {
        CommandResponseListener commandResponseListener = new CommandResponseListener(commandId, timeout);
        SerialCommandDispatcher.getInstance().addResponseListener(commandResponseListener);
        return commandResponseListener;
    }

    public static SerialCommand sendCommandAndWaitAnswer(SerialCommand cmd, long timeout, IProgressListener progressListener) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            logger.debug((Object)"Thread is interrupted, skipping..");
            return null;
        }
        CommandResponseListener listener = CommandResponseListener.registerResponseListener(cmd.id, timeout);
        SerialCommandProcessor.sendCommand(cmd);
        return listener.waitFor(progressListener);
    }

    public static SerialCommand sendCommandAndWaitAnswer(SerialCommand command, long timeout) throws InterruptedException {
        return CommandResponseListener.sendCommandAndWaitAnswer(command, timeout, null);
    }

    public static boolean sendCommandAndWaitConfirm(SerialCommand command, long timeout) throws InterruptedException {
        SerialCommand resp = CommandResponseListener.sendCommandAndWaitAnswer(command, timeout);
        return resp != null && resp.getId() == 67;
    }

    public static SerialCommand[] sendCommandAndWaitAnswers(SerialCommand cmd, long timeout, IProgressListener progressListener, int count) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            logger.debug((Object)"Thread is interrupted, skipping..");
            return null;
        }
        CommandResponseListener listener = CommandResponseListener.registerResponseListener(cmd.id, timeout);
        SerialCommandProcessor.sendCommand(cmd);
        return listener.waitForCount(progressListener, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.trace((Object)"Waiting command result...");
        CommandResponseListener commandResponseListener = this;
        synchronized (commandResponseListener) {
            try {
                this.wait(this.timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            logger.trace((Object)"Out from command waiting.");
        }
    }

    public static ICommandResponseListener getErrorResponseListener(final int cmdId) {
        return new ICommandResponseListener(){

            @Override
            public void onCommandReceived(SerialCommand cmd) {
                if (cmd.id == 255) {
                    try {
                        final String errInfo = ErrorInfo.formatCmdErrorInfo(cmd);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SimpleBGC_GUIApp.mainView.showErrorMessage(errInfo);
                            }
                        });
                    }
                    catch (Exception exception) {}
                } else if (cmd.id == 67) {
                    // empty if block
                }
            }

            @Override
            public int getCommandId() {
                return cmdId;
            }
        };
    }
}

