/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service;

import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import sbgc.object.AdjVarInfo;
import sbgc.object.BoardInfo;
import sbgc.service.ICommandResponseListener;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandDispatcher;
import sbgc.service.SerialCommandProcessor;
import sbgc.service.SerialPortService;
import sbgc.utils.Log;
import sbgc.utils.Settings;
import simplebgc_gui.SimpleBGC_GUIApp;

public class ConnectThread
extends Thread {
    static final Log logger = new Log(Logger.getLogger((String)ConnectThread.class.getName()));
    private static ConnectThread worker = null;
    boolean needExit = false;
    boolean defaultPortSettings = false;
    public static boolean isConnected;
    public static boolean needPassword;
    SerialCommand cmdEmpty;
    SerialCommand cmdBoardInfo;

    private ConnectThread() {
    }

    private void send_connect_command() {
        for (int protocol_ver = 1; protocol_ver <= 2; ++protocol_ver) {
            if (SerialCommandProcessor.protocolVerCfg == SerialCommandProcessor.ProtocolVersion.AUTO) {
                SerialCommandProcessor.setProtocolVerOut(SerialCommandProcessor.protocolVerFromInt(protocol_ver));
            }
            SerialCommandProcessor.sendCommand(this.cmdEmpty);
            SerialCommandProcessor.sendCommand(this.cmdBoardInfo);
            try {
                Thread.sleep(300L);
                continue;
            }
            catch (InterruptedException ignore) {
                return;
            }
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setName("ConnectThread");
        logger.info("Starting board connection..");
        BoardInfo.setBoardInfo(null);
        int lastBaudIndex = Integer.parseInt(Settings.get("latest.serial.baud", "0"));
        int lastParity = Integer.parseInt(Settings.get("latest.serial.parity", Integer.toString(0)));
        if (this.defaultPortSettings) {
            lastBaudIndex = 0;
            lastParity = 0;
        }
        SerialPortService.setBaudIndex(lastBaudIndex);
        SerialPortService.setParity(lastParity);
        String defaultPassword = Settings.get("board_password.default");
        needPassword = false;
        this.cmdEmpty = new SerialCommand(1);
        this.cmdBoardInfo = SerialCommandProcessor.getCmdBoardInfo(defaultPassword);
        ICommandResponseListener errorListener = new ICommandResponseListener(){

            @Override
            public int getCommandId() {
                return 86;
            }

            @Override
            public void onCommandReceived(SerialCommand cmd) {
                try {
                    if (cmd.id == 255) {
                        int for_cmd_id = cmd.readByte();
                        int code = cmd.readByte();
                        if (code == 12 || code == 13) {
                            logger.debug("Password required!");
                            needPassword = true;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        SerialCommandDispatcher.getInstance().addResponseListener(errorListener);
        while (BoardInfo.getBoardInfo() == null && !this.needExit && SerialPortService.isConnected()) {
            if (!this.defaultPortSettings && SerialPortService.isBaudRateSupported() && Settings.is("serial.baud.auto", true)) {
                for (int baudIndex = lastBaudIndex; baudIndex < SerialPortService.SERIAL_BAUD_RATES.length && BoardInfo.getBoardInfo() == null && !this.needExit; ++baudIndex) {
                    SerialPortService.setBaudIndex(baudIndex);
                    for (int j = 0; j < 2 && BoardInfo.getBoardInfo() == null && !this.needExit; ++j) {
                        SerialPortService.setParity(j == 0 ? 0 : 2);
                        this.send_connect_command();
                    }
                }
                lastBaudIndex = 0;
            } else {
                this.send_connect_command();
            }
            if (!needPassword) continue;
            if (SimpleBGC_GUIApp.mainView != null) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            JCheckBox asDefault = new JCheckBox("Save as default");
                            String password = SimpleBGC_GUIApp.mainView.showPasswordRequiredDialog("The connection is password-protected.", new Object[]{asDefault});
                            if (password != null) {
                                ConnectThread.this.cmdBoardInfo = SerialCommandProcessor.getCmdBoardInfo(password);
                                if (asDefault.isSelected()) {
                                    Settings.set("board_password.default", password);
                                    Settings.save();
                                }
                            } else {
                                logger.info("Password is not provided, finishing the connection...");
                                SimpleBGC_GUIApp.mainView.disconnect();
                            }
                        }
                    });
                }
                catch (Exception baudIndex) {
                    // empty catch block
                }
                needPassword = false;
                continue;
            }
            logger.error("Password is required, finishing the connection...");
            return;
        }
        SerialCommandDispatcher.getInstance().removeResponseListener(errorListener);
        BoardInfo info = BoardInfo.getBoardInfo();
        if (info != null) {
            SerialCommandProcessor.applyProtocolVerSettings();
            Settings.set("latest.serial.baud", Integer.toString(SerialPortService.getBaudIndex()));
            Settings.set("latest.serial.parity", Integer.toString(SerialPortService.getParity()));
            Settings.save();
            SerialCommandProcessor.sendCommand(new SerialCommand(28));
            for (int i = 0; i < 30 && info.deviceId == null; ++i) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException ignore) {
                    return;
                }
            }
            if (BoardInfo.checkMinBaseFirmwareVer(2730)) {
                try {
                    info.adjVarsInfo = AdjVarInfo.getFromBoard(null);
                }
                catch (Exception e) {
                    logger.error("Failed to load the list of adjustable variables: " + e.getMessage());
                }
            }
            isConnected = true;
            if (SimpleBGC_GUIApp.mainView != null) {
                SimpleBGC_GUIApp.mainView.setConnected(true);
            }
        }
    }

    public static void initConnection() {
        ConnectThread.initConnection(false);
    }

    public static void initConnection(boolean defaultPortSettings) {
        ConnectThread.stopConnection();
        isConnected = false;
        worker = new ConnectThread();
        ConnectThread.worker.defaultPortSettings = defaultPortSettings;
        worker.start();
    }

    public static void reconnect(int delay) {
        logger.info("Reconnecting to the board..");
        boolean needReconnect = SimpleBGC_GUIApp.mainView.isSerialCommunicationActive();
        SimpleBGC_GUIApp.mainView.stopSerialCommunication();
        try {
            SerialPortService.disconnect();
            SimpleBGC_GUIApp.mainView.disconnect();
            if (needReconnect) {
                Thread.sleep(delay);
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SimpleBGC_GUIApp.mainView.connect(null, true);
                    }
                });
            }
        }
        catch (Exception e) {
            logger.stackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopConnection() {
        if (worker != null) {
            ConnectThread connectThread = worker;
            synchronized (connectThread) {
                ConnectThread.worker.needExit = true;
                worker.interrupt();
            }
        }
    }

    public static Thread getThread() {
        return worker;
    }
}

