/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service;

import java.util.Arrays;
import sbgc.object.BoardParams;
import sbgc.object.BoardProfile;
import sbgc.serial.command.CmdControlConfigHelper;
import sbgc.serial.command.CmdControlHelper;
import sbgc.service.QuatControl;
import sbgc.service.SerialCommandProcessor;
import sbgc.utils.Log;
import simplebgc_gui.SimpleBGC_GUIApp;

public class ControlThread
implements Runnable {
    public static final int CONTROL_MODE_API_VIRT_CH = 0;
    public static final int CONTROL_MODE_RC = 1;
    public static final int CONTROL_MODE_ANGLE = 2;
    public static final int CONTROL_MODE_ANGLE_SHORTEST = 3;
    public static final int CONTROL_MODE_QUAT = 4;
    public static final int INTERVAL_MIN_MS = 8;
    protected Log logger = null;
    boolean isActive = false;
    Thread thread = null;
    int interval_ms = 20;
    boolean constant_interval = false;
    int control_mode = 0;
    int axesBits;
    int[] mode_flags = new int[3];
    boolean freshValues;
    int[] values = new int[3];
    float[] target_angles = new float[3];
    CmdControlHelper cmd_control = new CmdControlHelper();
    QuatControl quatControl = new QuatControl();

    public ControlThread() {
        this.logger = Log.getLogger(ControlThread.class.getName());
    }

    public void setInterval(int interval_ms, boolean constant_interval) {
        this.interval_ms = Math.max(8, interval_ms);
        this.constant_interval = constant_interval;
    }

    public void setControlMode(int mode) {
        if (mode != this.control_mode) {
            if (this.isActive) {
                this.finishCurControlMode();
            }
            this.quatControl.resetState();
            this.control_mode = mode;
            this.applyControlModeChanges();
        }
    }

    public int getControlMode() {
        return this.control_mode;
    }

    public void setModeFlags(int[] flags) {
        this.mode_flags = flags;
        this.applyControlModeChanges();
    }

    public void setQuatControlMode(int quatControlMode) {
        this.quatControl.setMode(quatControlMode);
    }

    public void setAxesBits(int axesBits) {
        this.axesBits = axesBits;
        this.applyControlModeChanges();
    }

    public void applyControlModeChanges() {
        int mode = this.control_mode == 1 ? 6 : (this.control_mode == 2 ? 2 : (this.control_mode == 3 ? 8 : 0));
        for (int axis = 0; axis < 3; ++axis) {
            this.cmd_control.mode[axis] = (this.axesBits & 1 << axis) != 0 ? mode | this.mode_flags[axis] : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update(int[] newValues) {
        for (int i = 0; i < this.values.length && i < newValues.length; ++i) {
            this.values[i] = newValues[i];
        }
        this.freshValues = true;
        if (!this.constant_interval && this.thread != null) {
            Thread thread = this.thread;
            synchronized (thread) {
                this.thread.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.logger.debug("Control thread is started.");
        CmdControlConfigHelper controlHelper = new CmdControlConfigHelper();
        controlHelper.flags = 1;
        SerialCommandProcessor.sendCommand(controlHelper.getCmd());
        long lastSendTime = 0L;
        while (this.isActive) {
            try {
                if (SimpleBGC_GUIApp.mainView.isSerialCommunicationActiveAndNotPaused()) {
                    long wait_ms = (long)this.interval_ms - (System.currentTimeMillis() - lastSendTime);
                    if (this.constant_interval) {
                        this.sendControlCmd();
                        long exceed = Math.min(-wait_ms, (long)(this.interval_ms / 2));
                        lastSendTime = System.currentTimeMillis() - exceed;
                        Thread.sleep((long)this.interval_ms - exceed);
                        continue;
                    }
                    if (wait_ms <= 0L) {
                        if (this.freshValues) {
                            this.sendControlCmd();
                            this.freshValues = false;
                            lastSendTime = System.currentTimeMillis();
                        }
                        wait_ms = 1000L;
                    }
                    Thread thread = this.thread;
                    synchronized (thread) {
                        this.thread.wait(wait_ms);
                        continue;
                    }
                }
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.finishCurControlMode();
        this.logger.debug("Control thread is finished.");
    }

    private void sendControlCmd() {
        int[] rc_euler = new int[]{this.values[2], this.values[1], this.values[0]};
        if (this.control_mode == 0) {
            SerialCommandProcessor.send_CMD_API_VIRT_CH_HIGH_RES(this.values);
        } else if (this.control_mode == 1) {
            this.cmd_control.updateRCValues(rc_euler);
            SerialCommandProcessor.sendCommand(this.cmd_control.getCmd());
        } else if (this.control_mode == 2 || this.control_mode == 3) {
            BoardProfile p = BoardParams.getCurProfile();
            if (p != null) {
                for (int axis = 0; axis < 3; ++axis) {
                    this.target_angles[axis] = p.rcMinAngle[axis] + (p.rcMaxAngle[axis] - p.rcMinAngle[axis]) * ((p.rcInverse[axis] ? -rc_euler[axis] : rc_euler[axis]) - -16384) / 32768;
                }
                this.cmd_control.setAngles(this.target_angles);
                SerialCommandProcessor.sendCommand(this.cmd_control.getCmd());
            }
        } else if (this.control_mode == 4) {
            this.quatControl.process();
            this.quatControl.updateRCValues(rc_euler);
            SerialCommandProcessor.sendCommand(this.quatControl.getControlCmd());
        }
    }

    public synchronized void start() {
        if (!this.isActive) {
            this.logger.debug("Starting gimbal control thread..");
            this.isActive = true;
            this.quatControl.resetState();
            this.thread = new Thread(this);
            this.thread.start();
        } else {
            this.logger.warn("Control thread is alive");
        }
    }

    public synchronized void stop() {
        if (this.thread != null) {
            this.logger.debug("Finishing gimbal control thread..");
            this.isActive = false;
            this.thread.interrupt();
        }
    }

    public synchronized void finishCurControlMode() {
        this.logger.debug("Finishing current control mode..");
        if (this.control_mode == 1 || this.control_mode == 2 || this.control_mode == 3) {
            SerialCommandProcessor.sendCommand(new CmdControlHelper().getCmd());
        } else if (this.control_mode == 0) {
            int[] values_undef = new int[this.values.length];
            Arrays.fill(values_undef, Short.MIN_VALUE);
            SerialCommandProcessor.send_CMD_API_VIRT_CH_HIGH_RES(values_undef);
        } else if (this.control_mode == 4) {
            this.quatControl.setMode(0);
            SerialCommandProcessor.sendCommand(this.quatControl.getControlCmd());
        }
    }

    public int[] getValues() {
        return this.values;
    }
}

