/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class DataInputStreamLE {
    private InputStream inputStream = null;

    public DataInputStreamLE(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public int readByte() throws IOException {
        return this.inputStream.read();
    }

    public float readFloat() throws IOException {
        byte[] buf = new byte[4];
        this.inputStream.read(buf);
        return ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN).getFloat();
    }

    public int readShort() throws IOException {
        byte[] buf = new byte[2];
        this.inputStream.read(buf);
        return (buf[0] & 0xFF) + (buf[1] << 8);
    }

    public int readShortUnsigned() throws IOException {
        byte[] buf = new byte[2];
        this.inputStream.read(buf);
        return (buf[0] & 0xFF) + ((buf[1] & 0xFF) << 8);
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }
}

