/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service;

import java.net.Socket;
import sbgc.service.DataPortNetworkBase;
import sbgc.service.IDataPort;

public class DataPortTCPImpl
extends DataPortNetworkBase
implements Runnable,
IDataPort {
    Thread serverThread = null;
    Socket clientSocket = null;
    String remoteHost = null;
    int remotePort;
    byte[] in_buf = new byte[512];

    public DataPortTCPImpl(String remoteHost, int remotePort) throws Exception {
        this.remoteHost = remoteHost;
        this.remotePort = remotePort;
    }

    public void reconnectSocket() throws Exception {
        if (this.clientSocket != null) {
            try {
                this.clientSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.clientSocket = new Socket(this.remoteHost, this.remotePort);
        this.clientSocket.setKeepAlive(true);
        this.clientSocket.setTrafficClass(16);
        this.clientSocket.setSoTimeout(0);
    }

    @Override
    public synchronized void connect() throws Exception {
        if (this.isConnected) {
            throw new Exception("TCP port is already connected.");
        }
        logger.info("Connecting TCPSerial " + this.remoteHost + ":" + this.remotePort);
        this.reconnectSocket();
        this.baseConnect();
        this.serverThread = new Thread(this);
        this.serverThread.start();
    }

    @Override
    public synchronized void disconnect() {
        logger.debug("Disconnecting TCPSerial..");
        try {
            this.clientSocket.close();
            this.baseDisconnect();
            this.serverThread.join(1000L);
        }
        catch (Exception e) {
            logger.error("Error closing TCPSerial: " + e.toString());
        }
    }

    @Override
    public void configure(int baudRate, int parity) throws Exception {
    }

    @Override
    public void run() {
        while (this.isConnected) {
            try {
                int length = this.clientSocket.getInputStream().read(this.in_buf);
                if (length > 0) {
                    super.onDataReceived(this.in_buf, 0, length);
                    continue;
                }
                if (length != -1) continue;
                throw new Exception("EOF in socket!");
            }
            catch (Exception e) {
                if (!this.isConnected) continue;
                logger.error(e.toString());
                try {
                    Thread.sleep(1000L);
                    this.reconnectSocket();
                    logger.debug("Socket connection restored");
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception connectException) {
                    logger.error("Failed to restore socket connection: " + e.toString());
                }
            }
        }
        logger.debug("TCPSerial thread is finished.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendData(byte[] data, int pos, int len) throws Exception {
        if (this.isConnected) {
            Socket socket = this.clientSocket;
            synchronized (socket) {
                this.clientSocket.getOutputStream().write(data, pos, len);
                this.clientSocket.getOutputStream().flush();
            }
            this.lastSendTime = System.currentTimeMillis();
        }
    }
}

