/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.swing.SwingUtilities;
import sbgc.adj_var_parser.AdjVarData;
import sbgc.adj_var_parser.AdjVarParser;
import sbgc.object.AutoPIDCfg2;
import sbgc.object.BoardInfo;
import sbgc.object.BoardParams;
import sbgc.object.CANModule;
import sbgc.object.CanDrvSoftParams;
import sbgc.object.CustomTune;
import sbgc.object.ErrorInfo;
import sbgc.object.GeometryCfg;
import sbgc.object.SerialLinkCfg;
import sbgc.object.ThermostatCfg;
import sbgc.service.CommandResponseListener;
import sbgc.service.RealtimeDataThread;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandProcessor;
import sbgc.utils.Log;
import simplebgc_gui.SimpleBGC_GUIApp;

class ParamsReaderThread
extends Thread {
    private final Log logger;
    private int profileId;
    private float progress;
    private float progress_step;

    public ParamsReaderThread(int profileId, Log logger) {
        this.profileId = profileId;
        this.logger = logger;
    }

    private void progressStep() {
        this.progress += this.progress_step;
        SimpleBGC_GUIApp.mainView.onProgressChange((int)this.progress);
    }

    @Override
    public void run() {
        ArrayList<String> errors = new ArrayList<String>();
        boolean rt_pause_state = RealtimeDataThread.pause(true);
        BoardInfo boardInfo = BoardInfo.getBoardInfo();
        ArrayList<Integer> cmd_ids = new ArrayList<Integer>(3);
        cmd_ids.add(new Integer(21));
        if (BoardInfo.hasExtendedParams()) {
            cmd_ids.add(new Integer(33));
        }
        if (BoardInfo.hasExtendedParams2()) {
            cmd_ids.add(new Integer(62));
        }
        if (BoardInfo.hasExtendedParams3()) {
            cmd_ids.add(new Integer(104));
        }
        BoardParams params = null;
        String actionName = "unknown action";
        try {
            SerialCommand cmd;
            params = BoardParams.getCurParams().clone();
            SimpleBGC_GUIApp.mainView.onProgressStart("Reading system configuration..", false);
            this.progress = 0.0f;
            this.progress_step = 100.0f / (float)((this.profileId == -1 ? BoardInfo.getNumProfiles() : 1) * cmd_ids.size() + 10);
            for (int id = 0; id < BoardInfo.getNumProfiles(); ++id) {
                if (this.profileId != -1 && id != this.profileId && (this.profileId != 50 || id != params.curProfile)) continue;
                int profile_err = 0;
                String err_str = "-Error reading profile " + (id + 1) + ": ";
                actionName = "Reading profile " + (id + 1);
                for (Integer cmd_id : cmd_ids) {
                    this.logger.info("Requesting profile " + id + ", cmd " + cmd_id + "..");
                    cmd = new SerialCommand((int)cmd_id, 1);
                    cmd.writeByte(id);
                    SerialCommand resp = CommandResponseListener.sendCommandAndWaitAnswer(cmd, 3000L);
                    if (resp != null && resp.getId() == cmd.getId()) {
                        int profile_id = resp.readByte();
                        if (profile_id == id) {
                            if (resp.getBytesAvailable() == 1) {
                                profile_err = resp.readByte();
                                this.logger.error(err_str + "error code " + profile_err);
                            } else {
                                params.parse(resp, profile_id, boardInfo);
                                this.logger.info("Profile " + profile_id + " successfuly parsed");
                            }
                        } else {
                            errors.add("-Received profile (" + profile_id + ") does not match the requested one (" + id + ")");
                        }
                    } else {
                        errors.add(err_str + "no response");
                    }
                    this.progressStep();
                }
                if (profile_err == 0) continue;
                errors.add(err_str + ErrorInfo.getSubErrorTitle(profile_err));
            }
            if (BoardInfo.hasAdjVars() && (this.profileId < 50 || this.profileId == 51)) {
                actionName = "Reading adjustable variables";
                this.logger.info(actionName);
                cmd = new SerialCommand(43);
                SerialCommand resp = CommandResponseListener.sendCommandAndWaitAnswer(cmd, 3000L);
                if (resp != null && resp.getId() == cmd.getId()) {
                    params.parseAdjVarsReadCmd(resp);
                    this.logger.info("Adj.vars parsed");
                } else if (!SimpleBGC_GUIApp.debugMode) {
                    errors.add("-Error reading adj. variables");
                }
            }
            this.progressStep();
            if (BoardInfo.hasAdjVarsLUT() && (this.profileId < 50 || this.profileId == 51)) {
                params.adj_vars_LUT = null;
                actionName = "Reading adjustable variables LUT";
                this.logger.info(actionName);
                try {
                    byte[] bytes = this.readFile(1280, "Adj.vars LUT");
                    params.adj_vars_LUT = AdjVarParser.dataToText(AdjVarData.fromByteArray(bytes));
                }
                catch (FileNotFoundException e) {
                    this.logger.error("adj.vars LUT does not exists");
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.logger.error(actionName + " error: " + e.toString());
                    errors.add("-" + actionName + " error: " + e.getMessage());
                }
            }
            this.progressStep();
            if (BoardInfo.hasCANIdMap() && (this.profileId < 50 || this.profileId == 52)) {
                params.CAN_device_id_map = null;
                actionName = "Reading CAN device Id mapping";
                this.logger.info(actionName);
                try {
                    byte[] bytes = this.readFile(1793, "CAN device ID mapping");
                    params.CAN_device_id_map = CANModule.deviceIdMapFromByteArray(bytes);
                }
                catch (FileNotFoundException e) {
                    this.logger.info("CAN device map does not exists, skipped");
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.logger.error(actionName + " error: " + e.toString());
                    errors.add("-" + actionName + " error: " + e.getMessage());
                }
                if (params.CAN_device_id_map == null) {
                    params.CAN_device_id_map = new LinkedHashMap();
                }
            }
            this.progressStep();
            if (BoardInfo.hasCANDrvParams() && (this.profileId < 50 || this.profileId == 53)) {
                params.CAN_Drv_soft_params = null;
                actionName = "Reading CAN_drv soft params";
                this.logger.info(actionName);
                try {
                    byte[] data = SerialCommandProcessor.readEEPROM(3200, 896, SimpleBGC_GUIApp.mainView);
                    params.CAN_Drv_soft_params = CanDrvSoftParams.getDefaultValues();
                    CanDrvSoftParams.parseFromByteArray(data, params.CAN_Drv_soft_params);
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.logger.error(actionName + " error: " + e.toString());
                    errors.add("-" + actionName + " error: " + e.getMessage());
                }
            }
            this.progressStep();
            if (BoardInfo.hasCustomTune() && this.profileId < 50) {
                actionName = "Reading custom melodies";
                this.logger.info(actionName);
                for (int idx = 0; idx < params.custom_tunes.length; ++idx) {
                    try {
                        byte[] bytes = this.readFile(2048 + idx, "Custom melody " + idx);
                        params.custom_tunes[idx] = CustomTune.bytesToString(bytes);
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        params.custom_tunes[idx] = "";
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        this.logger.error(actionName + " error: " + e.toString());
                        errors.add("-" + actionName + " error: " + e.getMessage());
                    }
                }
            }
            this.progressStep();
            if (BoardInfo.hasAutoPID2() && this.profileId < 50) {
                actionName = "Reading auto PID v2 tuning configuration";
                this.logger.info(actionName);
                params.auto_pid_cfg2 = new AutoPIDCfg2(false);
                cmd = new SerialCommand(108);
                cmd.writeByte(6);
                cmd.writeEmptyArr(10);
                SerialCommand resp = CommandResponseListener.sendCommandAndWaitAnswer(cmd, 3000L);
                if (resp != null && resp.getId() == 108) {
                    try {
                        params.auto_pid_cfg2.read(resp);
                    }
                    catch (InterruptedException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        this.logger.error(actionName + " error: " + e.toString());
                        errors.add("-" + actionName + " error: " + e.getMessage());
                        params.auto_pid_cfg2.setDefaultValues(false);
                    }
                }
            }
            this.progressStep();
            params.serial_link_cfg = null;
            if (BoardInfo.hasSerialLinkParams() && this.profileId < 50) {
                actionName = "Reading SerialLink configuration";
                this.logger.info(actionName);
                try {
                    byte[] data = SerialCommandProcessor.readEEPROM(4352, 64, SimpleBGC_GUIApp.mainView);
                    params.serial_link_cfg = SerialLinkCfg.parseFromByteArray(data);
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.logger.error(actionName + " error: " + e.toString());
                    errors.add("-" + actionName + " error: " + e.getMessage());
                    params.serial_link_cfg = new SerialLinkCfg();
                }
            }
            this.progressStep();
            if (BoardInfo.hasCanImuCfg() && this.profileId < 50) {
                params.thermo_cfg = null;
                this.logger.info("Reading CAN_IMU thermostat config..");
                try {
                    byte[] data = SerialCommandProcessor.readFile(3329, null);
                    params.thermo_cfg = new ThermostatCfg(data);
                }
                catch (FileNotFoundException e) {
                    this.logger.info("Not supported by the connected sensor or firmware");
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.logger.warn(e.toString());
                }
            }
            this.progressStep();
            if (BoardInfo.hasBoardFeature(0x80000000L) && this.profileId < 50) {
                actionName = "Reading gimbal geometry";
                this.logger.info(actionName);
                try {
                    byte[] data = SerialCommandProcessor.readEEPROM(4544, 64, SimpleBGC_GUIApp.mainView);
                    params.geometry_cfg = new GeometryCfg(data);
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.logger.error(actionName + " error: " + e.toString());
                    errors.add("-" + actionName + " error: " + e.getMessage());
                }
            }
            this.progressStep();
            params.loadedFrom = errors.isEmpty() ? BoardParams.LoadedFrom.BOARD : BoardParams.LoadedFrom.BOARD_INCOMPLETE;
            SimpleBGC_GUIApp.mainView.onProgressChange(100);
        }
        catch (InterruptedException ignore) {
            this.logger.error(this.getClass().getName() + " is interrupted");
        }
        catch (Exception e) {
            errors.add("-Unexpected error: " + e.toString());
            this.logger.error("Unexpected error: " + e.toString());
            this.logger.stackTrace(e);
        }
        if (params != null) {
            BoardParams.setCurParams(params);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleBGC_GUIApp.mainView.updateBoardParams();
                    SimpleBGC_GUIApp.mainView.updateStatus(SimpleBGC_GUIApp.getResourceMap().getString("status.params_loaded", new Object[0]));
                }
            });
        }
        if (!errors.isEmpty()) {
            final String err = Log.join(errors, "\n");
            this.logger.error(err);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleBGC_GUIApp.mainView.showErrorMessage("Something goes wrong when reading parameters: \n" + err, "Error reading parameters");
                }
            });
        }
        SimpleBGC_GUIApp.mainView.onProgressFinish(true);
        RealtimeDataThread.pause(rt_pause_state);
    }

    byte[] readFile(int fileId, String descr) throws Exception {
        this.logger.info("Requesting file " + descr + " from the board..");
        return SerialCommandProcessor.readFile(fileId, null);
    }
}

