/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import sbgc.adj_var_parser.AdjVarData;
import sbgc.adj_var_parser.AdjVarParser;
import sbgc.object.BoardInfo;
import sbgc.object.BoardParams;
import sbgc.object.CANModule;
import sbgc.object.CanDrvSoftParams;
import sbgc.object.CustomTune;
import sbgc.object.ErrorInfo;
import sbgc.object.ThermostatCfg;
import sbgc.service.CommandResponseListener;
import sbgc.service.RealtimeDataThread;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandProcessor;
import sbgc.service.upgrade.IProgressListener;
import sbgc.utils.HexUtil;
import sbgc.utils.Log;
import simplebgc_gui.SimpleBGC_GUIApp;

public class ParamsWriterThread
extends Thread {
    private int confirmedCmdId;
    private final BoardParams params;
    private final Log logger;
    private int profileId;
    private float progress;
    private float progress_step;
    IProgressListener progressListener;

    public ParamsWriterThread(BoardParams params, int profileId, Log logger, IProgressListener progressListener) {
        this.params = params;
        this.profileId = profileId;
        this.logger = logger;
        this.progressListener = progressListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWriteCmdConfirmation(int cmd_id, SerialCommand cmd) {
        ParamsWriterThread paramsWriterThread = this;
        synchronized (paramsWriterThread) {
            this.confirmedCmdId = cmd_id;
            this.notifyAll();
        }
    }

    private void progressStep() {
        this.progress += this.progress_step;
        if (this.progressListener != null) {
            this.progressListener.onProgressChange((int)this.progress);
        }
    }

    @Override
    public void run() {
        String tmpErr;
        ArrayList<String> errors;
        block59: {
            errors = new ArrayList<String>();
            this.confirmedCmdId = 0;
            try {
                if (this.params.thermo_cfg == null && this.params.ext_sens_type == 66) {
                    throw new Exception(SimpleBGC_GUIApp.getResourceMap().getString("error.ext_sens_config_order", new Object[0]));
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
                if (SimpleBGC_GUIApp.mainView == null) break block59;
                SimpleBGC_GUIApp.mainView.showErrorMessageThreadSafe(e.getMessage());
            }
        }
        boolean rt_pause_state = RealtimeDataThread.pause(true);
        BoardInfo boardInfo = BoardInfo.getBoardInfo();
        if (this.progressListener != null) {
            this.progressListener.onProgressStart("Writing system configuration..", false);
        }
        ArrayList<Integer> cmd_ids = new ArrayList<Integer>(3);
        cmd_ids.add(new Integer(22));
        if (BoardInfo.hasExtendedParams()) {
            cmd_ids.add(new Integer(34));
        }
        if (BoardInfo.hasExtendedParams2()) {
            cmd_ids.add(new Integer(63));
        }
        if (BoardInfo.hasExtendedParams3()) {
            cmd_ids.add(new Integer(105));
        }
        if ((tmpErr = SerialCommandProcessor.sendCmdWriteParamsSet(true)) != null) {
            errors.add(tmpErr + "\nParameters are not written.");
        } else {
            try {
                byte[] bytes;
                SerialCommand cmd;
                boolean needReset = false;
                this.progress = 0.0f;
                this.progress_step = 100.0f / (float)((this.profileId == -1 ? BoardInfo.getNumProfiles() : 1) * cmd_ids.size() + 10);
                if (BoardInfo.hasAdjVars() && (this.profileId < 50 || this.profileId == 51)) {
                    this.logger.debug("Writing Adj.Vars..");
                    cmd = this.params.formatAdjVarsWriteCmd();
                    if (!CommandResponseListener.sendCommandAndWaitConfirm(cmd, 3000L) && !SimpleBGC_GUIApp.debugMode) {
                        errors.add("-No confirmation on writing configuration of adjustable variables");
                    }
                }
                this.progressStep();
                if (BoardInfo.hasAdjVarsLUT() && (this.profileId < 50 || this.profileId == 51)) {
                    this.logger.debug("Writing Adj.Vars LUT..");
                    try {
                        bytes = null;
                        if (this.params.adj_vars_LUT != null) {
                            AdjVarData data = AdjVarParser.parseFromString(this.params.adj_vars_LUT);
                            if (data.sources.size() > 0) {
                                bytes = data.toByteArray();
                            }
                        }
                        try {
                            SerialCommandProcessor.writeFile(1280, bytes, null);
                        }
                        catch (Exception e) {
                            errors.add("-Failed to write adjustable variables LUT: " + e.toString());
                        }
                    }
                    catch (Exception e) {
                        errors.add("-Syntax error in adjustable variables LUT");
                    }
                }
                this.progressStep();
                if (BoardInfo.hasCANIdMap() && this.params.CAN_device_id_map != null && (this.profileId < 50 || this.profileId == 52)) {
                    this.logger.debug("Writing CAN device ID mapping..");
                    bytes = CANModule.deviceIdMapToByteArray(this.params.CAN_device_id_map);
                    try {
                        SerialCommandProcessor.writeFile(1793, bytes, null);
                    }
                    catch (Exception e) {
                        errors.add("-Failed to write CAN device Id mapping: " + e.toString());
                    }
                }
                this.progressStep();
                if (BoardInfo.hasCANDrvParams() && this.params.CAN_Drv_soft_params != null && (this.profileId < 50 || this.profileId == 53)) {
                    this.logger.debug("Writing CAN_Drv soft params..");
                    try {
                        byte[] data = CanDrvSoftParams.packToByteArray(this.params.CAN_Drv_soft_params);
                        SerialCommandProcessor.writeEEPROM(3200, data, SimpleBGC_GUIApp.mainView);
                    }
                    catch (Exception e) {
                        errors.add("-Failed to write CAN_drv soft params: " + e.toString());
                    }
                }
                this.progressStep();
                if (BoardInfo.hasCustomTune() && this.profileId < 50) {
                    this.logger.info("Writing custom melodies..");
                    for (int idx = 0; idx < this.params.custom_tunes.length; ++idx) {
                        try {
                            byte[] bytes2 = CustomTune.stringToBytes(this.params.custom_tunes[idx]);
                            if (bytes2 != null) {
                                this.logger.debug("Melody" + idx + " dump: " + HexUtil.toHex(bytes2));
                            }
                            SerialCommandProcessor.writeFile(2048 + idx, bytes2, null);
                            continue;
                        }
                        catch (Exception e) {
                            this.logger.error("error writing custom melody " + idx, e);
                            errors.add(e.getMessage());
                            this.logger.stackTrace(e);
                        }
                    }
                }
                this.progressStep();
                if (BoardInfo.hasAutoPID2() && this.profileId < 50 && this.params.auto_pid_cfg2 != null) {
                    this.logger.info("Writing automatic PID tuning algorithms configuration..");
                    cmd = new SerialCommand(108);
                    cmd.writeByte(3);
                    cmd.writeEmptyArr(10);
                    this.params.auto_pid_cfg2.write(cmd);
                    if (!CommandResponseListener.sendCommandAndWaitConfirm(cmd, 3000L)) {
                        errors.add("-Failed to save auto-PID configuration");
                    }
                }
                this.progressStep();
                if (BoardInfo.hasSerialLinkParams() && this.params.serial_link_cfg != null && this.profileId < 50) {
                    this.logger.debug("Writing SerialLink params..");
                    try {
                        byte[] data = this.params.serial_link_cfg.pack();
                        if (data.length > 64) {
                            throw new Exception("Data size (" + data.length + ") exceeds available space!");
                        }
                        SerialCommandProcessor.writeEEPROM(4352, data, SimpleBGC_GUIApp.mainView);
                    }
                    catch (Exception e) {
                        errors.add("-Failed to write Serial Link parameters: " + e.toString());
                    }
                }
                this.progressStep();
                if (this.params.thermo_cfg != null && this.profileId < 50) {
                    this.logger.info("Writing CAN_IMU thermostat config..");
                    try {
                        byte[] data = this.params.thermo_cfg.pack();
                        SerialCommandProcessor.writeFile(3329, data, null);
                        this.params.thermo_cfg = new ThermostatCfg(data);
                    }
                    catch (Exception e) {
                        errors.add("-Failed to write CAN_IMU thermostat config: " + e.toString());
                    }
                }
                this.progressStep();
                if (BoardInfo.hasBoardFeature(0x80000000L) && this.profileId < 50) {
                    this.logger.debug("Writing gimbal geometry..");
                    try {
                        SerialCommandProcessor.writeEEPROM(4544, this.params.geometry_cfg.pack(), SimpleBGC_GUIApp.mainView);
                    }
                    catch (Exception e) {
                        errors.add("-Failed to write geometry config: " + e.toString());
                    }
                }
                this.progressStep();
                int[] ids = new int[BoardInfo.getNumProfiles()];
                for (int id = 0; id < ids.length; ++id) {
                    ids[id] = id == this.params.curProfile ? ids.length - 1 : id;
                }
                int last_id = BoardInfo.getNumProfiles() - 1;
                for (int i = 0; i <= last_id; ++i) {
                    int id;
                    int n = i == this.params.curProfile ? last_id : (id = i == last_id ? this.params.curProfile : i);
                    if (this.profileId != -1 && id != this.profileId && (this.profileId != 50 || id != this.params.curProfile)) continue;
                    Iterator iterator = cmd_ids.iterator();
                    while (iterator.hasNext()) {
                        int cmd_id = (Integer)iterator.next();
                        cmd = this.params.formatWriteCommand(id, cmd_id, boardInfo);
                        if (CommandResponseListener.sendCommandAndWaitConfirm(cmd, 3000L)) {
                            this.logger.debug("Parameters writing command " + cmd.id + " is confirmed");
                        } else {
                            errors.add("-No confirmation on writing parameters for command " + cmd.id);
                        }
                        this.progressStep();
                    }
                }
                if ((this.params.general_flags2 & 0x100) != 0) {
                    try {
                        SerialCommandProcessor.sendCmdProfileSet(6, 1, this.progressListener);
                    }
                    catch (Exception e) {
                        this.logger.error("Failed to make auto-backup: " + e.toString());
                    }
                }
                this.params.curProfileBoard = this.params.curProfile;
                if (this.progressListener != null) {
                    this.progressListener.onProgressChange(100);
                }
                if ((tmpErr = SerialCommandProcessor.sendCmdWriteParamsSet(false)) != null) {
                    errors.add(tmpErr);
                }
                if (needReset) {
                    SerialCommandProcessor.sendCommand(new SerialCommand(114));
                    SerialCommandProcessor.waitForReset(this.progressListener);
                }
            }
            catch (InterruptedException ignore) {
                this.logger.error(this.getClass().getName() + " is interrupted");
            }
            catch (Exception e) {
                this.logger.error("unexpected exception!", e);
                errors.add("-Unexpected error: " + e.toString());
            }
        }
        if (errors.isEmpty()) {
            ErrorInfo.updateStatus(SimpleBGC_GUIApp.getResourceMap().getString("status.profile_written", new Object[0]));
        } else {
            final String err = Log.join(errors, "\n");
            this.logger.error(err);
            if (SimpleBGC_GUIApp.mainView != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SimpleBGC_GUIApp.mainView.showErrorMessage("Something goes wrong when writing parameters: \n" + err, "Error writing parameters");
                    }
                });
            }
        }
        if (this.progressListener != null) {
            this.progressListener.onProgressFinish(true);
        }
        RealtimeDataThread.pause(rt_pause_state);
    }
}

