/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service;

import java.util.LinkedHashMap;
import sbgc.object.BoardParams;
import sbgc.object.BoardProfile;
import sbgc.service.SerialCommand;
import sbgc.utils.Log;
import sbgc.utils.MathUtils;
import sbgc.utils.Quaternion;
import simplebgc_gui.SimpleBGC_GUIApp;

public class QuatControl {
    static Log logger;
    public static final int MODE_DISABLED = 0;
    public static final int MODE_SPEED = 1;
    public static final int MODE_ATTITUDE = 2;
    public static final int MODE_SPEED_ATTITUDE = 5;
    public static final int MODE_SPEED_LIMITED = 9;
    public static final int FLAG_MOTION_PROFILE_SPLIT_XYZ = 1;
    public static final int CTRL_FLAG_CONFIRM = 1;
    public static final int CTRL_FLAG_ATTITUDE_PACKED = 2;
    public static final int CTRL_FLAG_ATTITUDE_LIMITED_180 = 4;
    public static final int CTRL_FLAG_ATT_REMOVE_ABSENT_AXES = 8;
    public static final int CTRL_FLAG_AUTO_TASK = 64;
    public static final LinkedHashMap<Integer, String> MODE_NAMES;
    int mode = 0;
    int flags = 8;
    float[] target_angles = new float[3];
    float[] target_speed = new float[3];
    Quaternion cur_attitude = new Quaternion();
    long prev_time_ms;

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void resetState() {
        this.cur_attitude.init();
    }

    public void updateRCValues(int[] values) {
        block2: {
            BoardProfile p;
            block3: {
                p = BoardParams.getCurProfile();
                if (p == null) break block2;
                if (this.mode != 2) break block3;
                for (int axis = 0; axis < 3; ++axis) {
                    this.target_angles[axis] = (float)(p.rcMinAngle[axis] + (p.rcMaxAngle[axis] - p.rcMinAngle[axis]) * ((p.rcInverse[axis] ? -values[axis] : values[axis]) - -16384) / 32768) * ((float)Math.PI / 180);
                }
                break block2;
            }
            if (this.mode != 1 && this.mode != 9 && this.mode != 5) break block2;
            for (int axis = 0; axis < 3; ++axis) {
                int xyz = axis == 0 ? 1 : (axis == 1 ? 0 : 2);
                this.target_speed[xyz] = (float)(p.rcSpeed[axis] * 32) * 0.0010652969f * (float)(p.rcInverse[axis] ? -values[axis] : values[axis]) / -16384.0f;
            }
        }
    }

    public void process() {
        if (this.mode == 5) {
            long cur_time = System.currentTimeMillis();
            long dt = cur_time - this.prev_time_ms;
            this.prev_time_ms = cur_time;
            if (dt < 1000L) {
                float[] delta_rot_v = new float[3];
                MathUtils.vector_mult(this.target_speed, (float)(-dt) * 0.001f, delta_rot_v);
                Quaternion delta_q = new Quaternion();
                delta_q.from_rot_vect_small(delta_rot_v);
                this.cur_attitude.mult(delta_q);
                this.cur_attitude.normalize();
                this._debugCurAttitude(cur_time);
            }
        }
    }

    public SerialCommand getControlCmd() {
        SerialCommand cmd = new SerialCommand(140);
        try {
            cmd.writeByte(this.mode);
            cmd.writeByte(this.flags);
            if (this.mode == 2) {
                Quaternion q = new Quaternion();
                q.from_euler_rpy(this.target_angles);
                cmd.writeFloatArr(q.toFltArr());
            } else if (this.mode == 5) {
                cmd.writeFloatArr(this.cur_attitude.toFltArr());
            }
            if (this.mode == 1 || this.mode == 9 || this.mode == 5) {
                cmd.writeFloatArr(this.target_speed);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cmd;
    }

    public SerialCommand getConfigCmd(int[] max_speed, int[] acc_limit, int[] jerk_slope, Integer flags, Integer attitude_lpf_freq, Integer speed_lpf_freq) {
        SerialCommand cmd = new SerialCommand(142);
        try {
            int data_set = 0;
            SerialCommand tmp = new SerialCommand(0);
            if (max_speed != null) {
                data_set |= 1;
                tmp.writeWordArr(max_speed);
            }
            if (acc_limit != null) {
                data_set |= 2;
                tmp.writeWordArr(acc_limit);
            }
            if (jerk_slope != null) {
                data_set |= 4;
                tmp.writeWordArr(jerk_slope);
            }
            if (flags != null) {
                data_set |= 8;
                tmp.writeWord(flags);
            }
            if (attitude_lpf_freq != null) {
                data_set |= 0x10;
                tmp.writeByte(attitude_lpf_freq);
            }
            if (speed_lpf_freq != null) {
                data_set |= 0x20;
                tmp.writeByte(speed_lpf_freq);
            }
            cmd.writeWord(data_set);
            cmd.write(tmp.getPayload());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cmd;
    }

    void _debugCurAttitude(long time_ms) {
        float[] euler = new float[3];
        this.cur_attitude.to_euler_rpy(euler);
        for (int axis = 0; axis < 3; ++axis) {
            SimpleBGC_GUIApp.mainView.panelMonitoring.setChartData("QUAT_" + BoardParams.getAxisAbbr(axis), euler[axis] * 57.29578f, time_ms);
        }
    }

    static {
        MODE_NAMES = new LinkedHashMap();
        logger = Log.getLogger(QuatControl.class.getName());
        MODE_NAMES.put(1, "SPEED");
        MODE_NAMES.put(2, "ATTITUDE");
        MODE_NAMES.put(5, "SPEED_ATTITUDE");
        MODE_NAMES.put(9, "SPEED_LIMITED");
    }
}

