/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service;

import java.io.IOException;
import org.apache.log4j.Logger;
import sbgc.object.BoardInfo;
import sbgc.object.DebugVars;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandProcessor;
import sbgc.ui.TabbedPanelMonitoring;
import sbgc.utils.MathUtils;
import sbgc.utils.Settings;
import simplebgc_gui.SimpleBGC_GUIApp;
import simplebgc_gui.SimpleBGC_GUIView;

public class RealtimeDataThread {
    static final Logger logger = Logger.getLogger((String)RealtimeDataThread.class.getName());
    public static final int SUSPENDED_FRAME_RATE = 5;
    private static int frameRate = 1;
    private static float samplingTimeS = 1.0f;
    private static Thread thread = null;
    private static volatile boolean paused = false;
    private static boolean suspended = false;
    static SerialCommand cmd_RTDC_slow;
    static SerialCommand cmd_RTDC_fast;
    static SerialCommand cmd_RTDC2_fast;
    public static long RTDC_flags_slow;
    public static long RTDC_flags_fast;
    public static long RTDC2_flags_fast;

    public static final Logger getLogger() {
        return logger;
    }

    public static void start() {
        if (thread != null) {
            thread.interrupt();
        }
        logger.info((Object)"Starting realtime data thread..");
        final TabbedPanelMonitoring panelMonitoring = SimpleBGC_GUIApp.mainView.panelMonitoring;
        RealtimeDataThread.RTDC_configure();
        thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Thread.currentThread().setName("RTData");
                if (Settings.is("realtime.debug_vars")) {
                    DebugVars.requestDebugVarsInfo(0);
                }
                if (Settings.is("realtime.log_to_file")) {
                    panelMonitoring.startLogging(Settings.get("realtime.log_rewrite", "true").equals("true"));
                }
                SerialCommand cmd_realtime_data_4 = new SerialCommand(BoardInfo.checkMinPartnerFirmwareVer(2410) ? 25 : 23);
                SerialCommand cmd_debug_vars_3 = new SerialCommand(254);
                boolean requestDebugVars = false;
                int slowUpdSlot = 0;
                int slowUpdCnt = 0;
                long slowUpdLastTime = 0L;
                float delayCorr = 0.0f;
                while (!this.isInterrupted()) {
                    int _frameRate = RealtimeDataThread.getFrameRate();
                    float delay = 1000.0f / (float)_frameRate;
                    long curTime = System.currentTimeMillis();
                    if (curTime - slowUpdLastTime > 100L) {
                        slowUpdSlot = slowUpdCnt + 1;
                        slowUpdLastTime = curTime;
                        slowUpdCnt = (slowUpdCnt + 1) % 3;
                    }
                    try {
                        Thread thread = thread;
                        synchronized (thread) {
                            while (paused) {
                                this.wait();
                            }
                        }
                        if (SimpleBGC_GUIApp.mainView.panelMonitoring.isRequestBasicDataEnabled()) {
                            if (BoardInfo.hasRealtimeDataCustom2()) {
                                if (slowUpdSlot != 0) {
                                    RealtimeDataThread.RTDC_configure();
                                    SerialCommandProcessor.sendCommand(cmd_RTDC_slow);
                                }
                                SerialCommandProcessor.sendCommand(cmd_RTDC_fast);
                                if (cmd_RTDC2_fast != null) {
                                    SerialCommandProcessor.sendCommand(cmd_RTDC2_fast);
                                }
                            } else {
                                SerialCommandProcessor.sendCommand(cmd_realtime_data_4);
                            }
                        }
                        if (SimpleBGC_GUIApp.mainView.isPanelVisible(panelMonitoring) || panelMonitoring.isDataLogEnabled()) {
                            int canDrvIdx;
                            if (DebugVars.hasInfo()) {
                                if (slowUpdSlot != 0) {
                                    requestDebugVars = DebugVars.fillRequestCommand(cmd_debug_vars_3);
                                }
                                if (requestDebugVars) {
                                    SerialCommandProcessor.sendCommand(cmd_debug_vars_3);
                                }
                            }
                            if (!suspended && (canDrvIdx = SimpleBGC_GUIApp.mainView.panelMonitoring.getCurCanDrvIdx()) >= 0) {
                                SerialCommand cmd = new SerialCommand(101);
                                cmd.writeByte(1 << canDrvIdx);
                                SerialCommandProcessor.sendCommand(cmd);
                            }
                        }
                        if (!suspended) {
                            if (slowUpdSlot != 0 && SimpleBGC_GUIApp.mainView.isPanelVisible(SimpleBGC_GUIApp.mainView.panelAdjVars)) {
                                SerialCommand cmd = new SerialCommand(46);
                                cmd.writeByte(SimpleBGC_GUIApp.mainView.panelAdjVars.trigger_cur_slot);
                                if (SimpleBGC_GUIApp.mainView.panelAdjVars.selectedVar != null) {
                                    cmd.writeWord(SimpleBGC_GUIApp.mainView.panelAdjVars.selectedVar.src_ch);
                                    cmd.writeByte(SimpleBGC_GUIApp.mainView.panelAdjVars.selectedVar.var_id);
                                } else {
                                    cmd.writeEmptyArr(3);
                                }
                                cmd.writeWord(SimpleBGC_GUIApp.mainView.panelAdjVars.showLUTSignalId);
                                cmd.writeByte(SimpleBGC_GUIApp.mainView.panelAdjVars.showLUTVarId);
                                cmd.writeEmptyArr(10);
                                SerialCommandProcessor.sendCommand(cmd);
                            }
                            if (SimpleBGC_GUIApp.mainView.isPanelVisible(SimpleBGC_GUIApp.mainView.panelMavlink)) {
                                if (slowUpdSlot == 2) {
                                    SerialCommand cmd = new SerialCommand(250);
                                    SerialCommandProcessor.sendCommand(cmd);
                                } else if (slowUpdSlot == 3 && BoardInfo.hasBoardFeature(65536L)) {
                                    SerialCommandProcessor.sendCommand(new SerialCommand(106));
                                }
                            } else if (SimpleBGC_GUIApp.mainView.isPanelVisible(SimpleBGC_GUIApp.mainView.panelHardwareSettings) && slowUpdSlot == 2) {
                                SerialCommandProcessor.sendCommand(new SerialCommand(106));
                            }
                        }
                        Thread.sleep(Math.max(0, Math.round(delay + delayCorr)));
                    }
                    catch (InterruptedException ignore) {
                        break;
                    }
                    catch (IOException e) {
                        logger.error((Object)e.toString());
                    }
                    SimpleBGC_GUIApp.mainView.panelMonitoring.chart.update();
                    if (slowUpdSlot != 0) {
                        SimpleBGC_GUIApp.mainView.panelMonitoring.doPeriodicUpdate();
                    }
                    slowUpdSlot = 0;
                    long deltaTime = System.currentTimeMillis() - curTime;
                    delayCorr += (delay - (float)deltaTime) * 0.05f;
                    delayCorr = MathUtils.constrain(delayCorr, -10.0f, 10.0f);
                }
                panelMonitoring.stopLogging();
                logger.info((Object)"RealtimeDataThread is finished.");
            }
        };
        thread.start();
    }

    public static void stop() {
        logger.info((Object)"Finishing realtime data thread..");
        if (thread != null) {
            thread.interrupt();
        }
    }

    public static void setFrameRate(int rate) {
        frameRate = rate;
    }

    public static int getFrameRate() {
        return suspended ? Math.min(frameRate, 5) : frameRate;
    }

    public static float getSamplingTimeS() {
        return frameRate > 0 ? 1.0f / (float)RealtimeDataThread.getFrameRate() : 1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean pause(final boolean state) {
        boolean old_state = paused;
        paused = state;
        if (old_state != state) {
            if (thread != null && !paused) {
                logger.debug((Object)"Resuming realtime data thread..");
                Thread thread = RealtimeDataThread.thread;
                synchronized (thread) {
                    RealtimeDataThread.thread.notify();
                }
            }
            if (SimpleBGC_GUIApp.mainView != null) {
                SimpleBGC_GUIView.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (!state) {
                            SimpleBGC_GUIApp.mainView.panelMonitoring.chart.start();
                        }
                        SimpleBGC_GUIApp.mainView.updateRealtimeData();
                    }
                });
            }
        }
        return old_state;
    }

    public static boolean isPaused() {
        return paused;
    }

    public static void suspend(boolean state) {
        suspended = state;
    }

    public static boolean isSuspended() {
        return suspended;
    }

    public static void RTDC_configure() {
        try {
            boolean frameIMU = SimpleBGC_GUIApp.mainView.panelMonitoring.curIMUset == 2;
            cmd_RTDC_slow = new SerialCommand(88);
            RTDC_flags_slow = 2685960224L;
            cmd_RTDC_slow.writeDWord(RTDC_flags_slow);
            cmd_RTDC_slow.writeEmptyArr(6);
            RTDC_flags_fast = 0x8000000AL;
            RTDC2_flags_fast = 0x80000000L;
            if (frameIMU) {
                RTDC2_flags_fast |= 1L;
            } else {
                RTDC_flags_fast |= 1L;
            }
            if (TabbedPanelMonitoring.UPD_GROUP_GYRO.isEnabled()) {
                if (frameIMU) {
                    RTDC2_flags_fast |= 2L;
                } else {
                    RTDC_flags_fast |= 0x10L;
                }
            }
            if (TabbedPanelMonitoring.UPD_GROUP_ACC.isEnabled()) {
                if (frameIMU) {
                    RTDC2_flags_fast |= 4L;
                } else {
                    RTDC_flags_fast |= 0x100L;
                }
            }
            if (TabbedPanelMonitoring.UPD_GROUP_MAG.isEnabled()) {
                RTDC2_flags_fast |= 0x10L;
            }
            if (TabbedPanelMonitoring.UPD_GROUP_DEBUG.isEnabled()) {
                RTDC2_flags_fast |= 8L;
            }
            cmd_RTDC_fast = new SerialCommand(88);
            cmd_RTDC_fast.writeDWord(RTDC_flags_fast);
            cmd_RTDC_fast.writeEmptyArr(6);
            if (RTDC2_flags_fast != 0L) {
                cmd_RTDC2_fast = new SerialCommand(139);
                cmd_RTDC2_fast.writeDWord(RTDC2_flags_fast);
                cmd_RTDC2_fast.writeEmptyArr(6);
            } else {
                cmd_RTDC2_fast = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

