/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.util.zip.CRC32;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;
import sbgc.object.BackupData;
import sbgc.object.ErrorInfo;
import sbgc.object.IMUCalib;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandProcessor;
import sbgc.service.upgrade.IProgressListener;
import sbgc.utils.FileUtil;
import simplebgc_gui.SimpleBGC_GUIApp;

public class RestoreIMUCalibThread
extends Thread {
    static final Logger logger = Logger.getLogger((String)RestoreIMUCalibThread.class.getName());
    static RestoreIMUCalibThread restoreIMUCalibThread = null;
    static ResourceMap resourceMap = null;
    final boolean isFrameIMU;
    final File file;
    final IProgressListener progressListener;

    public static void restoreIMUCalib(boolean isFrameIMU, IProgressListener progressListener) {
        File f;
        if (!(restoreIMUCalibThread != null && restoreIMUCalibThread.isAlive() || (f = SimpleBGC_GUIApp.mainView.showProfileLoadDialog((resourceMap = SimpleBGC_GUIApp.getResourceMap()).getString("title.dialog_IMU_calib_file", new Object[0]), "data")) == null)) {
            restoreIMUCalibThread = new RestoreIMUCalibThread(isFrameIMU, f, progressListener);
            restoreIMUCalibThread.start();
        }
    }

    public RestoreIMUCalibThread(boolean isFrameIMU, File file, IProgressListener progressListener) {
        this.isFrameIMU = isFrameIMU;
        this.file = file;
        this.progressListener = progressListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.progressListener.onProgressStart(resourceMap.getString("progress.restore_IMU_calib", new Object[0]), false);
        try {
            BackupData d = FileUtil.readBackupData(2, this.file);
            ByteArrayInputStream bis = new ByteArrayInputStream(d.data);
            DataInputStream dis = new DataInputStream(bis);
            while (dis.available() > 0) {
                byte type = dis.readByte();
                short size = dis.readShort();
                long crc32 = dis.readLong();
                byte[] data = new byte[size];
                if (dis.read(data) != data.length) {
                    throw new Exception("File is corrupted: EOF reached for calibration " + type);
                }
                CRC32 crc = new CRC32();
                crc.update(data);
                if (crc.getValue() != crc32) {
                    throw new Exception("File is corrupted: bad CRC for calibration " + type);
                }
                int fileId = IMUCalib.getCalibFileId(type, this.isFrameIMU);
                SerialCommandProcessor.writeFile(fileId, data, this.progressListener);
                this.progressListener.onProgressChange(type * 30);
            }
            SerialCommandProcessor.sendCommand(new SerialCommand(114));
            SerialCommandProcessor.waitForReset(this.progressListener);
            ErrorInfo.updateStatus(resourceMap.getString("status.restore_IMU_calib.done", new Object[0]));
        }
        catch (InterruptedException d) {
        }
        catch (Exception e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleBGC_GUIApp.mainView.showErrorMessage(e.getMessage(), resourceMap.getString("error.restore_IMU_calib", new Object[0]));
                }
            });
        }
        finally {
            this.progressListener.onProgressFinish(true);
        }
    }
}

