/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import sbgc.object.Sprav;
import sbgc.service.Checksum;
import sbgc.service.SerialCommandProcessor;
import sbgc.utils.FileUtil;
import sbgc.utils.HexUtil;

public class SerialCommand {
    public static final int SIGN_TYPE_FULL = 1;
    public static final int SIGN_TYPE_FIRMWARE_UPDATE = 2;
    public static final int SIGN_TYPE_AUTH_GUI = 3;
    public static final int SIGN_TYPE_CHECK_FIRMWARE = 4;
    public static final int SIGN_TYPE_ACTIVATE = 5;
    public static final int MAX_SIZE = 255;
    public static final byte START_BYTE1 = 62;
    public static final byte START_BYTE2 = 36;
    public static final int CMD_EMPTY = 1;
    public static final int CMD_READ_PARAMS = 82;
    public static final int CMD_WRITE_PARAMS = 87;
    public static final int CMD_REALTIME_DATA = 68;
    public static final int CMD_BOARD_INFO = 86;
    public static final int CMD_CALIB_ACC = 65;
    public static final int CMD_CALIB_GYRO = 103;
    public static final int CMD_CALIB_EXT_GAIN = 71;
    public static final int CMD_USE_DEFAULTS = 70;
    public static final int CMD_CALIB_POLES = 80;
    public static final int CMD_RESET = 114;
    public static final int CMD_HELPER_DATA = 72;
    public static final int CMD_CALIB_OFFSET = 79;
    public static final int CMD_CALIB_BAT = 66;
    public static final int CMD_MOTORS_ON = 77;
    public static final int CMD_MOTORS_OFF = 109;
    public static final int CMD_EXECUTE_MENU = 69;
    public static final int CMD_CONFIRM = 67;
    public static final int CMD_CONTROL = 67;
    public static final int CMD_CONTROL_CONFIG = 90;
    public static final int CMD_BOARD_INFO_3 = 20;
    public static final int CMD_READ_PARAMS_3 = 21;
    public static final int CMD_WRITE_PARAMS_3 = 22;
    public static final int CMD_REALTIME_DATA_3 = 23;
    public static final int CMD_SELECT_IMU_3 = 24;
    public static final int CMD_REALTIME_DATA_4 = 25;
    public static final int CMD_ENCODERS_CALIB_OFFSET_4 = 26;
    public static final int CMD_ENCODERS_CALIB_FLD_OFFSET_4 = 27;
    public static final int CMD_READ_PROFILE_NAMES = 28;
    public static final int CMD_WRITE_PROFILE_NAMES = 29;
    public static final int CMD_QUEUE_PARAMS_INFO_3 = 30;
    public static final int CMD_SET_ADJ_VARS_VAL = 31;
    public static final int CMD_SAVE_PARAMS_3 = 32;
    public static final int CMD_READ_PARAMS_EXT = 33;
    public static final int CMD_WRITE_PARAMS_EXT = 34;
    public static final int CMD_AUTO_PID = 35;
    public static final int CMD_BODE_TEST_START_STOP = 37;
    public static final int CMD_BODE_TEST_DATA = 38;
    public static final int CMD_I2C_WRITE_REG_BUF = 39;
    public static final int CMD_I2C_READ_REG_BUF = 40;
    public static final int CMD_WRITE_EXTERNAL_DATA = 41;
    public static final int CMD_READ_EXTERNAL_DATA = 42;
    public static final int CMD_READ_ADJ_VARS_CFG = 43;
    public static final int CMD_WRITE_ADJ_VARS_CFG = 44;
    public static final int CMD_API_VIRT_CH_CONTROL = 45;
    public static final int CMD_ADJ_VARS_STATE = 46;
    public static final int CMD_EEPROM_WRITE = 47;
    public static final int CMD_EEPROM_READ = 48;
    public static final int CMD_CALIB_INFO = 49;
    public static final int CMD_SIGN_MESSAGE = 50;
    public static final int CMD_BOOT_MODE = 51;
    public static final int CMD_SYSTEM_STATE = 52;
    public static final int CMD_READ_FILE = 53;
    public static final int CMD_WRITE_FILE = 54;
    public static final int CMD_FS_CLEAR_ALL = 55;
    public static final int CMD_AHRS_HELPER = 56;
    public static final int CMD_RUN_SCRIPT = 57;
    public static final int CMD_SCRIPT_DEBUG = 58;
    public static final int CMD_CALIB_MAG = 59;
    public static final int CMD_UART_BYPASS = 60;
    public static final int CMD_GET_ANGLES_EXT = 61;
    public static final int CMD_READ_PARAMS_EXT2 = 62;
    public static final int CMD_WRITE_PARAMS_EXT2 = 63;
    public static final int CMD_GET_ANGLES = 73;
    public static final int CMD_CALIB_MOTOR_MAG_LINK = 74;
    public static final int CMD_GYRO_CORRECTION = 75;
    public static final int CMD_MODULE_LIST = 76;
    public static final int CMD_MODULE_FLASH_START = 78;
    public static final int CMD_MODULE_FLASH_WRITE = 81;
    public static final int CMD_MODULE_FLASH_FINISH = 83;
    public static final int CMD_REALTIME_DATA_CUSTOM = 88;
    public static final int CMD_BEEP_SOUND = 89;
    public static final int CMD_CALIB_ORIENT_CORR = 91;
    public static final int CMD_COGGING_CALIB_INFO = 92;
    public static final int CMD_CALIB_COGGING = 93;
    public static final int CMD_CALIB_ACC_EXT_REF = 94;
    public static final int CMD_PROFILE_SET = 95;
    public static final int CMD_CAN_DEVICE_SCAN = 96;
    public static final int CMD_CAN_DRV_HARD_PARAMS = 97;
    public static final int CMD_CAN_DRV_STATE = 98;
    public static final int CMD_CAN_DRV_CALIBRATE = 99;
    public static final int CMD_READ_RC_INPUTS = 100;
    public static final int CMD_REALTIME_DATA_CAN_DRV = 101;
    public static final int CMD_EVENT = 102;
    public static final int CMD_READ_PARAMS_EXT3 = 104;
    public static final int CMD_WRITE_PARAMS_EXT3 = 105;
    public static final int CMD_EXT_IMU_DEBUG_INFO = 106;
    public static final int CMD_SET_DEVICE_ADDR = 107;
    public static final int CMD_AUTO_PID2 = 108;
    public static final int CMD_EXT_IMU_CMD = 110;
    public static final int CMD_READ_STATE_VARS = 111;
    public static final int CMD_WRITE_STATE_VARS = 112;
    public static final int CMD_SERIAL_PROXY = 113;
    public static final int CMD_IMU_ADVANCED_CALIB = 115;
    public static final int CMD_API_VIRT_CH_HIGH_RES = 116;
    public static final int CMD_CALIB_ENCODER_LUT = 117;
    public static final int CMD_CALIB_ENCODER_LUT_RES = 118;
    public static final int CMD_WRITE_PARAMS_SET = 119;
    public static final int CMD_CALIB_CUR_SENS = 120;
    public static final int CMD_CONTROL_EXT = 121;
    public static final int CMD_ENC_INT_CALIB = 122;
    public static final int CMD_SYNC_MOTORS = 123;
    public static final int CMD_EXT_LICENSE_INFO = 124;
    public static final int CMD_VIBRATION_TEST_START_STOP = 125;
    public static final int CMD_VIBRATION_TEST_DATA = 126;
    public static final int CMD_CAN_DRV_TELEMETRY = 127;
    public static final int CMD_ADJ_VARS_INFO = 132;
    public static final int CMD_PASS_PROTECT_READ = 136;
    public static final int CMD_PASS_PROTECT_WRITE = 137;
    public static final int CMD_CAN_DRV_SET_PARAMS = 138;
    public static final int CMD_REALTIME_DATA_CUSTOM2 = 139;
    public static final int CMD_CONTROL_QUAT = 140;
    public static final int CMD_CONTROL_QUAT_STATUS = 141;
    public static final int CMD_CONTROL_QUAT_CONFIG = 142;
    public static final int CMD_EXT_SENS_CMD = 150;
    public static final int CMD_TRANSPARENT_SAPI = 151;
    public static final int CMD_DEBUG_STR = 248;
    public static final int CMD_SET_DEBUG_PORT = 249;
    public static final int CMD_MAVLINK_INFO = 250;
    public static final int CMD_MAVLINK_DEBUG = 251;
    public static final int CMD_DEBUG_VARS_INFO_3 = 253;
    public static final int CMD_DEBUG_VARS_3 = 254;
    public static final int CMD_ERROR = 255;
    public static final int CALIB_ACTION_CALIBRATE = 1;
    public static final int CALIB_ACTION_RESET = 2;
    public static final int CALIB_ACTION_TEMP_CALIBRATE = 3;
    public static final int CALIB_ACTION_TEMP_ENABLE = 4;
    public static final int CALIB_ACTION_TEMP_DISABLE = 5;
    public static final int CALIB_ACTION_RESTORE_FACTORY = 6;
    public static final int CALIB_ACTION_SAVE_FACTORY = 7;
    public static final int CALIB_ACTION_STOP = 8;
    public static final int CALIB_ACTION_MULTIPOINT = 9;
    public static final int CALIB_ACTION_ERROR = 254;
    public static final int CALIB_ACTION_FINISHED = 255;
    public static final int FILE_TYPE_SCRIPT = 1;
    public static final int FILE_TYPE_IMU_CALIB = 3;
    public static final int FILE_TYPE_COGGING_CORRECTION = 4;
    public static final int FILE_TYPE_ADJ_VAR_LUT = 5;
    public static final int FILE_TYPE_PROFILE_SET = 6;
    public static final int FILE_TYPE_PARAMS = 7;
    public static final int FILE_TYPE_TUNE = 8;
    public static final int FILE_TYPE_ENCODER_LUT = 11;
    public static final int FILE_TYPE_EXT_LICENSES = 12;
    public static final int FILE_TYPE_CAN_IMU_CFG = 13;
    public static final int FILE_TYPE_AUTO_PID_DEBUG = 14;
    public static final int FILE_TYPE_BODE_TEST_RESP = 15;
    public static final int FILE_TYPE_BODE_TEST_CAPTURE = 16;
    public static final int FILE_ID_ADJ_VAR_LUT = 1280;
    public static final int FILE_ID_CAN_ID_MAP = 1793;
    public static final int CMD_PROFILE_SET_ACTION_SAVE = 1;
    public static final int CMD_PROFILE_SET_ACTION_CLEAR = 2;
    public static final int CMD_PROFILE_SET_ACTION_LOAD = 3;
    public static final int CAN_DRV_CALIB_STOP = 0;
    public static final int CAN_DRV_CALIB_RL = 1;
    public static final int CAN_DRV_CALIB_EL_FIELD = 2;
    public static final int CAN_DRV_CALIB_ZERO_OFFSET = 3;
    public static final int CAN_DRV_CALIB_AUTO_PID = 4;
    public static final int CAN_DRV_CALIB_CONTINUE = 5;
    public static final int CAN_DRV_CALIB_INTERNAL_ENCODER = 30;
    public static final int CMD_CAN_DRV_HARD_PARAMS_ACTION_READ = 0;
    public static final int CMD_CAN_DRV_HARD_PARAMS_ACTION_WRITE = 15;
    public static final int CMD_CAN_DRV_HARD_PARAMS_ACTION_RESET = 255;
    public static final int DEVICE_TYPE_AM4096 = 1;
    public static final int DEVICE_TYPE_AS5600L = 2;
    public static final int RC_UNDEF_API = -10000;
    public static final int RC_UNDEF = Short.MIN_VALUE;
    public static final Sprav[] DEBUG_PORT_CMD_FILTER = new Sprav[]{new Sprav(23, "CMD_REALTIME_DATA_3"), new Sprav(25, "CMD_REALTIME_DATA_4"), new Sprav(88, "CMD_REALTIME_DATA_CUSTOM"), new Sprav(127, "CMD_CAN_DRV_TELEMETRY"), new Sprav(254, "CMD_DEBUG_VARS_3"), new Sprav(251, "CMD_MAVLINK_DEBUG"), new Sprav(73, "CMD_GET_ANGLES"), new Sprav(61, "CMD_GET_ANGLES_EXT"), new Sprav(38, "CMD_BODE_TEST_DATA"), new Sprav(72, "CMD_HELPER_DATA"), new Sprav(56, "CMD_AHRS_HELPER"), new Sprav(75, "CMD_GYRO_CORRECTION"), new Sprav(67, "CMD_CONTROL"), new Sprav(121, "CMD_CONTROL_EXT"), new Sprav(140, "CMD_CONTROL_QUAT"), new Sprav(141, "CMD_CONTROL_QUAT_STATUS"), new Sprav(31, "CMD_SET_ADJ_VARS_VAL"), new Sprav(45, "CMD_API_VIRT_CH_CONTROL"), new Sprav(116, "CMD_API_VIRT_CH_HIGH_RES"), new Sprav(126, "CMD_VIBRATION_TEST_DATA"), new Sprav(151, "CMD_TRANSPARENT_SAPI"), new Sprav(150, "CMD_EXT_SENS_CMD")};
    public final int id;
    public byte[] data = null;
    public int pos = 0;
    public int len;
    public final long timestamp;

    public SerialCommand(int id) {
        this(id, 255);
    }

    public int getId() {
        return this.id;
    }

    public SerialCommand(int id, int size) {
        this(id, size, System.currentTimeMillis());
    }

    public SerialCommand(int id, int size, long timestamp) {
        this.id = id;
        this.data = new byte[size];
        this.len = 0;
        this.timestamp = timestamp;
    }

    public SerialCommand(int id, byte[] data) {
        this(id, data.length);
        System.arraycopy(data, 0, this.data, 0, data.length);
        this.len = data.length;
    }

    public SerialCommand(int id, int[] data) {
        this(id, data.length);
        this.len = data.length;
        for (int i = 0; i < data.length; ++i) {
            this.data[i] = (byte)(data[i] & 0xFF);
        }
    }

    public SerialCommand(SerialCommand src) throws Exception {
        this(src.id, 255, src.timestamp);
        this.write(src.data);
    }

    public void reset() {
        this.len = 0;
        this.pos = 0;
    }

    public void startReading() {
        this.pos = 0;
    }

    public byte[] getBytes(SerialCommandProcessor.ProtocolVersion protocolVer) {
        int total_len = this.len + 5;
        if (protocolVer == SerialCommandProcessor.ProtocolVersion.V2) {
            ++total_len;
        }
        byte[] buf = new byte[total_len];
        buf[1] = (byte)this.id;
        buf[2] = (byte)this.len;
        Checksum cs = new Checksum();
        cs.update(this.id);
        cs.update(this.len);
        buf[3] = (byte)cs.get();
        System.arraycopy(this.data, 0, buf, 4, this.len);
        int cs_pos = this.len + 4;
        if (protocolVer == SerialCommandProcessor.ProtocolVersion.V2) {
            buf[0] = 36;
            int crc16 = FileUtil.crc16_sbgc32(buf, 1, this.len + 3);
            buf[cs_pos++] = (byte)(crc16 & 0xFF);
            buf[cs_pos] = (byte)(crc16 >> 8 & 0xFF);
        } else {
            buf[0] = 62;
            buf[cs_pos] = (byte)new Checksum(this.data, this.len).get();
        }
        return buf;
    }

    public static String dumpBytes(byte[] data, int size) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            str.append(String.format("%02x ", data[i] & 0xFF));
        }
        return str.toString();
    }

    public String toString() {
        StringBuffer str = new StringBuffer("[" + this.id + "," + this.len + "] [");
        str.append(SerialCommand.dumpBytes(this.data, this.len));
        str.append("] ");
        if (SerialCommandProcessor.getCurProtocolVer() == SerialCommandProcessor.ProtocolVersion.V1) {
            str.append(Integer.toHexString(new Checksum(this.data, this.len).get()));
        } else {
            byte[] res = this.getBytes(SerialCommandProcessor.ProtocolVersion.V2);
            str.append(HexUtil.toHex(res, res.length - 2, res.length, " "));
        }
        return str.toString();
    }

    public String toHeaderString() {
        return "[" + this.id + "," + this.len + "]";
    }

    public int readByte() throws IOException {
        if (this.pos < this.len) {
            return this.data[this.pos++] & 0xFF;
        }
        throw new IOException("Limit reached!");
    }

    public int peakByte(int pos) {
        if (pos < this.len) {
            return this.data[pos] & 0xFF;
        }
        return 0;
    }

    public int[] readByteArr(int size) throws IOException {
        int[] arr = new int[size];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.readByte();
        }
        return arr;
    }

    public int[] readByte3() throws IOException {
        return this.readByteArr(3);
    }

    public void readByteArr(int[] arr) throws IOException {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.readByte();
        }
    }

    public byte readByteSigned() throws IOException {
        if (this.pos < this.len) {
            return this.data[this.pos++];
        }
        throw new IOException("Limit reached!");
    }

    public int[] readByteSignedArr(int size) throws IOException {
        int[] arr = new int[size];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.readByteSigned();
        }
        return arr;
    }

    public void readByteSignedArr(int[] arr) throws IOException {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.readByteSigned();
        }
    }

    public int readWord() throws IOException {
        if (this.pos + 2 <= this.len) {
            return (this.data[this.pos++] & 0xFF) + (this.data[this.pos++] << 8);
        }
        throw new IOException("Limit reached!");
    }

    public int[] readWordArr(int size) throws IOException {
        int[] arr = new int[size];
        this.readWordArr(arr);
        return arr;
    }

    public int[] readWord3() throws IOException {
        return this.readWordArr(3);
    }

    public void readWordArr(int[] arr) throws IOException {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.readWord();
        }
    }

    public void readWordArr(int[] arr, int startIdx, int num) throws IOException {
        for (int i = startIdx; i < startIdx + num; ++i) {
            arr[i] = this.readWord();
        }
    }

    public void readWordArrScaled(int[] arr, float scale) throws IOException {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = Math.round((float)this.readWord() * scale);
        }
    }

    public float[] readWordArrAsFloatScaled(int length, float scale) throws IOException {
        float[] arr = new float[length];
        for (int i = 0; i < length; ++i) {
            arr[i] = (float)this.readWord() * scale;
        }
        return arr;
    }

    public float[] readUWordArrAsFloatScaled(int length, float scale) throws IOException {
        float[] arr = new float[length];
        for (int i = 0; i < length; ++i) {
            arr[i] = (float)this.readWordUnsigned() * scale;
        }
        return arr;
    }

    public int readWordUnsigned() throws IOException {
        if (this.pos + 2 <= this.len) {
            return (this.data[this.pos++] & 0xFF) + ((this.data[this.pos++] & 0xFF) << 8);
        }
        throw new IOException("Limit reached!");
    }

    public int[] readWordUnsigned3() throws IOException {
        int[] arr = new int[3];
        for (int i = 0; i < 3; ++i) {
            arr[i] = this.readWordUnsigned();
        }
        return arr;
    }

    public int[] readWordArrUnsigned(int size) throws IOException {
        int[] arr = new int[size];
        this.readWordArrUnsigned(arr);
        return arr;
    }

    public void readWordArrUnsigned(int[] arr) throws IOException {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.readWordUnsigned();
        }
    }

    public long readDWord() throws IOException {
        return ((long)this.readWord() & 0xFFFFL) + ((long)this.readWord() << 16);
    }

    public long readDWordUnsigned() throws IOException {
        return (long)this.readWordUnsigned() + ((long)this.readWordUnsigned() << 16);
    }

    public float readFloat() throws IOException {
        if (this.pos + 4 <= this.len) {
            Float f = Float.valueOf(ByteBuffer.wrap(this.data, this.pos, 4).order(ByteOrder.LITTLE_ENDIAN).getFloat());
            this.pos += 4;
            return f.floatValue();
        }
        throw new IOException("Limit reached!");
    }

    public void readFloatArr(float[] arr) throws IOException {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.readFloat();
        }
    }

    public float[] readFloatArr(int length) throws IOException {
        float[] arr = new float[length];
        this.readFloatArr(arr);
        return arr;
    }

    public float[] readFloat3() throws IOException {
        return this.readFloatArr(3);
    }

    public double readDouble() throws IOException {
        if (this.pos + 8 <= this.len) {
            Double d = ByteBuffer.wrap(this.data, this.pos, 8).order(ByteOrder.LITTLE_ENDIAN).getDouble();
            this.pos += 8;
            return d;
        }
        throw new IOException("Limit reached!");
    }

    public boolean readBoolean() throws IOException {
        return this.readByte() == 1;
    }

    public String readString() throws IOException {
        int size = this.readByte();
        if (this.pos + size <= this.len) {
            String s = new String(this.data, this.pos, size, Charset.forName("ISO-8859-1"));
            this.pos += size;
            return s;
        }
        throw new IOException("Limit reached in readString()!");
    }

    public void read(byte[] buf) throws IOException {
        this.read(buf, 0, buf.length);
    }

    public void read(byte[] buf, int to_pos, int size) throws IOException {
        if (this.pos + size <= this.len) {
            System.arraycopy(this.data, this.pos, buf, to_pos, size);
            this.pos += size;
        } else {
            throw new IOException("Limit reached!");
        }
    }

    public byte[] readBytes(int size) throws IOException {
        if (this.pos + size <= this.len) {
            byte[] buf = new byte[size];
            System.arraycopy(this.data, this.pos, buf, 0, size);
            this.pos += size;
            return buf;
        }
        throw new IOException("Limit reached!");
    }

    public void skipBytes(int size) throws IOException {
        if (this.pos + size <= this.len) {
            this.pos += size;
        } else {
            throw new IOException("Limit reached!");
        }
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(byte[] buf, int from_pos, int size) throws IOException {
        if (this.len + size <= this.data.length) {
            System.arraycopy(buf, from_pos, this.data, this.len, size);
            this.len += size;
        } else {
            throw new IOException("Buffer oferflow!");
        }
    }

    public void writeByte(int val) throws IOException {
        if (this.len >= this.data.length) {
            throw new IOException("Buffer oferflow!");
        }
        this.data[this.len++] = (byte)(val & 0xFF);
    }

    public void writeByteArr(int[] arr) throws IOException {
        for (int i = 0; i < arr.length; ++i) {
            this.writeByte(arr[i]);
        }
    }

    public void writeByteSignedArr(int[] arr) throws IOException {
        for (int i = 0; i < arr.length; ++i) {
            this.writeByteSigned(arr[i]);
        }
    }

    public void writeByteSigned(int val) throws IOException {
        if (this.len >= this.data.length) {
            throw new IOException("Buffer oferflow!");
        }
        this.data[this.len++] = (byte)val;
    }

    public void writeWord(int val) throws IOException {
        if (this.len + 2 > this.data.length) {
            throw new IOException("Buffer oferflow!");
        }
        this.data[this.len++] = (byte)(val & 0xFF);
        this.data[this.len++] = (byte)(val >> 8 & 0xFF);
    }

    public void writeWordArr(int[] arr) throws IOException {
        for (int i = 0; i < arr.length; ++i) {
            this.writeWord(arr[i]);
        }
    }

    public void writeDWord(long val) throws IOException {
        this.writeWord((int)val);
        this.writeWord((int)(val >> 16));
    }

    public void writeFloat(float val) throws IOException {
        if (this.len + 4 <= this.data.length) {
            ByteBuffer.wrap(this.data, this.len, 4).order(ByteOrder.LITTLE_ENDIAN).putFloat(val);
            this.len += 4;
        } else {
            throw new IOException("Buffer oferflow!");
        }
    }

    public void writeFloatArr(float[] arr) throws IOException {
        for (float v : arr) {
            this.writeFloat(v);
        }
    }

    public void writeBoolean(boolean val) throws IOException {
        this.writeByte(val ? 1 : 0);
    }

    public void writeEmptyArr(int size) throws IOException {
        for (int i = 0; i < size; ++i) {
            this.writeByte(0);
        }
    }

    public void writeString(String str) throws IOException {
        byte[] bytes = str.getBytes(Charset.forName("ISO-8859-1"));
        if (bytes.length != str.length()) {
            throw new IOException("Invalid characters. Only Latin1 codepage is supported for strings.");
        }
        this.writeByte(bytes.length);
        this.write(bytes);
    }

    public final int getBytesFree() {
        return this.data.length - this.len;
    }

    public final int getBytesAvailable() {
        return this.len - this.pos;
    }

    public final int getBytesWritten() {
        return this.len;
    }

    public final int getBytesRead() {
        return this.pos;
    }

    public final int getChecksum() {
        return new Checksum(this.data, this.len).get();
    }

    public final void checkFinished() throws IOException {
        if (this.getBytesAvailable() != 0) {
            throw new IOException("Wrong command format: left " + this.getBytesAvailable() + " bytes");
        }
    }

    public final void checkFull() throws IOException {
        if (this.getBytesFree() != 0) {
            throw new IOException("Wrong command format: left " + this.getBytesFree() + " bytes");
        }
    }

    public final boolean isHeavyDutyCommand(boolean isOut) {
        if (this.id == 67 && !isOut) {
            return SerialCommand.isHeavyDutyCommand(this.peakByte(0), true);
        }
        return SerialCommand.isHeavyDutyCommand(this.id, isOut);
    }

    public static final boolean isHeavyDutyCommand(int id, boolean isOut) {
        return id == 38 || id == 68 || id == 254 || id == 23 || id == 25 || id == 46 || id == 251 || id == 88 || id == 139 || id == 116 || id == 106 || id == 49 || id == 115 || id == 141 || !isOut && id == 249 || isOut && (id == 67 || id == 121 || id == 140) || id == 248;
    }

    public byte[] getPayload() {
        byte[] payload = new byte[this.len];
        System.arraycopy(this.data, 0, payload, 0, payload.length);
        return payload;
    }
}

