/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service;

import gnu.io.CommPortIdentifier;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.log4j.Logger;
import sbgc.object.Sprav;
import sbgc.service.DataPortMavLinkImpl;
import sbgc.service.DataPortSerialImpl;
import sbgc.service.DataPortTCPImpl;
import sbgc.service.IDataPort;
import sbgc.service.SerialCommandProcessor;
import sbgc.service.UDPSerial;
import sbgc.utils.Log;
import sbgc.utils.Settings;

public class SerialPortService {
    public static final String PORT_NAME_UDP = "UDP";
    public static final String PORT_NAME_TCP = "WiFi (TCP/IP)";
    public static final String TCP_REMOTE_HOST_DEFAULT = "192.168.4.1";
    public static final String TCP_REMOTE_PORT_DEFAULT = "23";
    public static final int TUNNEL_MAVLINK_V2_EXTENSION = 1;
    public static final int TUNNEL_MAVLINK_TUNNEL = 10;
    static final Log logger = new Log(Logger.getLogger((String)SerialPortService.class.getName()));
    static IDataPort dataPort = null;
    static boolean loaded = false;
    public static int[] SERIAL_BAUD_RATES = new int[]{115200, 57600, 38400, 19200, 9600, 256000};
    public static final int[] SERIAL_BAUD_RATES_EXTENDED = new int[]{115200, 57600, 38400, 19200, 9600, 256000, 1200, 2400, 4800, 230400, 921600};
    private static int baudIndex = 0;
    private static int parity = 0;

    public static void initSerialPortService() throws Exception {
        if (loaded) {
            return;
        }
    }

    public static void connect_port(String portName, int tunnelType) throws Exception {
        String remoteHost;
        if (portName.equals(PORT_NAME_UDP)) {
            int localPort;
            int remotePort;
            try {
                remoteHost = Settings.get("udp.remote_host");
                remotePort = Integer.parseInt(Settings.get("udp.remote_port"));
                localPort = Integer.parseInt(Settings.get("udp.local_port"));
                if (localPort == 0) {
                    throw new Exception("Local port is not set");
                }
            }
            catch (Exception e) {
                throw new Exception("Wrong UDP port settings: " + e.getMessage() + ". Go to \"File -> Settings..\" to configure.");
            }
            dataPort = new UDPSerial(remoteHost, remotePort, localPort);
        } else if (portName.equals(PORT_NAME_TCP)) {
            int remotePort;
            try {
                remoteHost = Settings.get("tcp.remote_host", TCP_REMOTE_HOST_DEFAULT);
                remotePort = Integer.parseInt(Settings.get("tcp.remote_port", TCP_REMOTE_PORT_DEFAULT));
            }
            catch (Exception e) {
                throw new Exception("Wrong TCP port settings: " + e.getMessage() + ". Go to \"File -> Settings..\" to configure.");
            }
            dataPort = new DataPortTCPImpl(remoteHost, remotePort);
        } else {
            dataPort = new DataPortSerialImpl(portName);
        }
        if (tunnelType > 0 && tunnelType <= 10) {
            int compId = Integer.parseInt(Settings.get("tunnel.mavlink.comp_id"));
            dataPort = new DataPortMavLinkImpl(dataPort, compId, tunnelType);
        }
        dataPort.connect();
        logger.debug("dataPort " + dataPort.getClass().getName() + " connected");
    }

    public static void connect(String portName, boolean isBLE, int tunnelType) throws Exception {
        SerialPortService.connect_port(portName, tunnelType);
        SerialPortService.updateSerialPortParams();
        if (!dataPort.isBLESupported()) {
            isBLE = false;
        }
        SerialCommandProcessor.setDataPort(dataPort);
        SerialPortService.setBaudIndex(Integer.parseInt(Settings.get("latest.serial.baud", "0")));
        if (isBLE) {
            Settings.set("connect.BLE", "1");
            dataPort.setMode(1);
        } else {
            Settings.set("connect.BLE", "0");
            dataPort.setMode(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSerialPortParams() {
        if (dataPort != null) {
            IDataPort iDataPort = dataPort;
            synchronized (iDataPort) {
                try {
                    dataPort.configure(SERIAL_BAUD_RATES_EXTENDED[baudIndex], parity);
                }
                catch (Exception e) {
                    logger.error("Error configuring serial port: " + e.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disconnect_port() throws Exception {
        if (dataPort != null) {
            IDataPort iDataPort = dataPort;
            synchronized (iDataPort) {
                logger.info("Disconecting data port " + dataPort.getClass().getName() + "..");
                dataPort.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disconnect() throws Exception {
        if (dataPort != null) {
            IDataPort iDataPort = dataPort;
            synchronized (iDataPort) {
                logger.debug("Removing event listener..");
                dataPort.removeEventListener();
                SerialPortService.disconnect_port();
                dataPort = null;
                logger.info("Data port disconnected.");
            }
        }
        SerialCommandProcessor.setDataPort(null);
    }

    public static boolean isBaudRateSupported() {
        if (dataPort != null) {
            return dataPort.isBaudRateSupported();
        }
        return false;
    }

    public static void setBaudIndex(int _baudIndex) {
        if (_baudIndex < 0 || _baudIndex >= SERIAL_BAUD_RATES_EXTENDED.length) {
            _baudIndex = 0;
        }
        if (baudIndex != _baudIndex) {
            baudIndex = _baudIndex;
            logger.debug("Setting baudrate: " + SERIAL_BAUD_RATES_EXTENDED[baudIndex]);
            SerialPortService.updateSerialPortParams();
        }
    }

    public static void setParity(int _parity) {
        if (parity != _parity) {
            parity = _parity;
            logger.debug("Setting parity: " + parity);
            SerialPortService.updateSerialPortParams();
        }
    }

    public static int getParity() {
        return parity;
    }

    public static int getBaudIndex() {
        return baudIndex;
    }

    public static int getBaudIndexByValue(int baud) {
        for (int i = 0; i < SERIAL_BAUD_RATES_EXTENDED.length; ++i) {
            if (SERIAL_BAUD_RATES_EXTENDED[i] != baud) continue;
            return i;
        }
        return -1;
    }

    public static int getBaudRate() {
        return SERIAL_BAUD_RATES_EXTENDED[baudIndex];
    }

    public static final IDataPort getDataPort() {
        return dataPort;
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static boolean isPortOpened() {
        return dataPort != null;
    }

    public static boolean isConnected() {
        return dataPort != null && dataPort.isConnected();
    }

    public static ArrayList<Sprav> getPortList(String proxy) {
        proxy = proxy != null ? " (" + proxy + ")" : "";
        try {
            int index = 0;
            ArrayList<Sprav> portList = new ArrayList<Sprav>();
            System.currentTimeMillis();
            Enumeration portListIdentifiers = CommPortIdentifier.getPortIdentifiers();
            while (portListIdentifiers.hasMoreElements()) {
                CommPortIdentifier portId = (CommPortIdentifier)portListIdentifiers.nextElement();
                if (portId.getPortType() != 1) continue;
                Sprav sp = new Sprav(index, portId.getName());
                portList.add(sp);
                ++index;
            }
            portList.add(new Sprav(1000, PORT_NAME_UDP));
            portList.add(new Sprav(1001, PORT_NAME_TCP));
            for (Sprav sp : portList) {
                sp.setProp("port", sp.getName());
                sp.setName(sp.getName() + proxy);
            }
            return portList;
        }
        catch (Exception e) {
            logger.trace("Failed to get available ports: " + e.toString());
            return null;
        }
    }

    public static String getTunnelNames(int tunnelType) {
        if (tunnelType > 0 && tunnelType <= 10) {
            return "MavLink";
        }
        return null;
    }
}

