/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import sbgc.service.DataPortNetworkBase;
import sbgc.service.IDataPort;

public class UDPSerial
extends DataPortNetworkBase
implements Runnable,
IDataPort {
    Thread serverThread = null;
    DatagramSocket serverSocket = null;
    DatagramSocket clientSocket = null;
    InetAddress remoteAddress = null;
    int remotePort;
    int localPort;
    InetAddress senderAddress = null;
    int senderPort = 0;

    public UDPSerial(String remoteHost, int remotePort, int localPort) throws Exception {
        this.localPort = localPort;
        if (remoteHost != null && remoteHost.length() > 0) {
            this.remoteAddress = InetAddress.getByName(remoteHost);
        }
        this.remotePort = remotePort;
    }

    @Override
    public synchronized void connect() throws Exception {
        if (this.isConnected) {
            throw new Exception("UDPSerial is already connected.");
        }
        logger.info("Starting UDPSerial on localhost:" + this.localPort);
        this.serverSocket = new DatagramSocket(this.localPort);
        this.clientSocket = new DatagramSocket();
        this.baseConnect();
        this.serverThread = new Thread(this);
        this.serverThread.start();
    }

    @Override
    public synchronized void disconnect() {
        logger.debug("Disconnecting UDPSerial..");
        try {
            this.serverSocket.close();
            this.clientSocket.close();
            this.baseDisconnect();
            this.serverThread.join(1000L);
        }
        catch (Exception e) {
            logger.error("Error closing UDPSerial: " + e.toString());
        }
    }

    @Override
    public void configure(int baudRate, int parity) throws Exception {
    }

    @Override
    public void run() {
        byte[] buf = new byte[512];
        while (this.isConnected) {
            DatagramPacket receivePacket = new DatagramPacket(buf, buf.length);
            try {
                this.serverSocket.receive(receivePacket);
                this.senderAddress = receivePacket.getAddress();
                this.senderPort = receivePacket.getPort();
                logger.debug("UDP datagram from " + this.senderAddress.toString() + ":" + this.senderPort + " received: " + receivePacket.getLength() + " bytes, offset=" + receivePacket.getOffset());
                try {
                    super.onDataReceived(receivePacket.getData(), receivePacket.getOffset(), receivePacket.getLength());
                }
                catch (Exception e) {
                    logger.error("Failed to append new data to buffer: " + e.toString());
                }
                this.eventDispatcher.fireEvent();
            }
            catch (Exception e) {
                if (!this.isConnected) continue;
                logger.error(e.toString());
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        logger.debug("UDP server thread is finished.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendData(byte[] data, int pos, int len) throws Exception {
        if (this.isConnected) {
            if (this.remoteAddress == null) {
                this.remoteAddress = this.senderAddress;
            }
            if (this.remotePort == 0) {
                this.remotePort = this.senderPort;
            }
            if (this.remoteAddress != null && this.remotePort != 0) {
                logger.debug("Sending UDP datagram " + len + " bytes..");
                DatagramPacket sendPacket = new DatagramPacket(data, pos, len, this.remoteAddress, this.remotePort);
                DatagramSocket datagramSocket = this.clientSocket;
                synchronized (datagramSocket) {
                    this.clientSocket.send(sendPacket);
                }
                this.lastSendTime = System.currentTimeMillis();
            } else {
                logger.error("UDP target host:port is not configured!");
            }
        }
    }
}

