/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service.upgrade;

import java.io.File;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;
import sbgc.object.ExtDeviceInfo;
import sbgc.service.DataPortProxyImpl;
import sbgc.service.RealtimeDataThread;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandProcessor;
import sbgc.service.upgrade.FirmwareWriterSTM32BootImpl;
import sbgc.service.upgrade.IFirmwareUpgradeListener;
import sbgc.service.upgrade.IStatusListener;
import sbgc.service.upgrade.ProgressListenerImpl;
import sbgc.utils.FileUtil;
import sbgc.utils.ILogListener;
import sbgc.utils.Log;
import simplebgc_gui.DialogExtIMUInfo;
import simplebgc_gui.DialogFirmwareUpgrade;
import simplebgc_gui.SimpleBGC_GUIApp;

public class ExtDeviceFirmwareUpgrader
implements Runnable {
    static final Log logger = new Log(Logger.getLogger((String)ExtDeviceFirmwareUpgrader.class.getName()));
    static ResourceMap resourceMap = null;
    IFirmwareUpgradeListener listener = null;
    ILogListener logListener = null;
    IStatusListener statusListener = null;
    File firmwareHexFile = null;
    DialogExtIMUInfo dialogExtIMU = null;
    ExtDeviceInfo deviceInfo = null;

    public ExtDeviceFirmwareUpgrader(DialogExtIMUInfo dialogExtIMU, ExtDeviceInfo deviceInfo, File firmwareHexFile, IFirmwareUpgradeListener listener, ILogListener logListener, IStatusListener statusListener) throws IllegalArgumentException {
        this.dialogExtIMU = dialogExtIMU;
        this.deviceInfo = deviceInfo;
        this.listener = listener;
        this.logListener = logListener;
        this.statusListener = statusListener;
        this.firmwareHexFile = firmwareHexFile;
        resourceMap = SimpleBGC_GUIApp.getResourceMap(DialogFirmwareUpgrade.class);
        if (this.listener == null) {
            throw new IllegalArgumentException("IFirmwareUpgradeListener should be not null!");
        }
        if (this.logListener == null) {
            throw new IllegalArgumentException("ILogListener should be not null!");
        }
        if (this.dialogExtIMU == null) {
            throw new IllegalArgumentException("DialogExtIMUInfo should be not null!");
        }
        if (this.deviceInfo == null) {
            throw new IllegalArgumentException("External device information is not received!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean oldRtDataState = RealtimeDataThread.pause(true);
        try {
            if (!this.dialogExtIMU.isConnected()) {
                throw new Exception("External device is not connected!");
            }
            this.logListener.append("Reading firmware from file..");
            byte[] firmwareData = FileUtil.readFirmwareFromFile(this.firmwareHexFile, this.deviceInfo.getFirmwareAddress());
            this.logListener.append("OK, " + firmwareData.length + " bytes\n");
            ExtDeviceInfo frwInfo = ExtDeviceInfo.readFromFirmware(firmwareData, this.deviceInfo.type);
            this.logListener.info(String.format("Firmware information: frw.ver.: %d.%d, build: %d, key: %h", frwInfo.sw_ver.getMajorVer(), frwInfo.sw_ver.getMinorVer(), frwInfo.sw_ver.getBuildNum(), frwInfo.key));
            this.deviceInfo.checkFirmware(frwInfo);
            frwInfo.checkCRC(firmwareData);
            if (this.listener.isAlive()) {
                this.logListener.info("Setting external device into boot mode...");
                SerialCommand cmd = new SerialCommand(110);
                cmd.writeByte(10);
                cmd.writeByte(1);
                cmd.writeWord(100);
                if (this.dialogExtIMU.sendCommandAndWaitConfirm(cmd, 10, 3000L) == null) {
                    throw new Exception("No confirmation on CMD_BOOT_MODE");
                }
                this.logListener.info("Waiting for bootloader to start...");
                Thread.sleep(1000L);
            }
            if (this.listener.isAlive()) {
                if (this.statusListener != null) {
                    this.statusListener.onStatusChange("Writing firmware...");
                }
                this.listener.onFlashStart();
                ProgressListenerImpl progressListener = new ProgressListenerImpl(50, 50, this.listener);
                DataPortProxyImpl proxy = new DataPortProxyImpl();
                try {
                    proxy.connect();
                    FirmwareWriterSTM32BootImpl writer = new FirmwareWriterSTM32BootImpl(proxy, this.logListener, progressListener, this.deviceInfo.getFirmwarePages());
                    writer.write(this.firmwareHexFile, firmwareData, this.deviceInfo.getFirmwareAddress(), this.deviceInfo.getRunAddress());
                }
                finally {
                    proxy.disconnect();
                }
            }
            SerialCommandProcessor.sendCmdReset();
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ExtDeviceFirmwareUpgrader.this.listener.onFirmwareUpgradeEnd(null, null);
                }
            });
        }
        catch (InterruptedException e) {
            this.listener.onFirmwareUpgradeEnd(new Exception("Upgrade process is interrupted!"), null);
        }
        catch (Throwable e) {
            this.listener.onFirmwareUpgradeEnd(e, null);
        }
        finally {
            RealtimeDataThread.pause(oldRtDataState);
        }
    }
}

