/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service.upgrade;

import java.io.File;
import org.apache.log4j.Logger;
import sbgc.common.IFirmwareInfo;
import sbgc.object.BoardInfo;
import sbgc.service.upgrade.IFirmwareDownloader;
import sbgc.service.upgrade.IProgressListener;
import sbgc.service.upgrade.VersionImpl;
import sbgc.utils.FileUtil;
import sbgc.utils.ILogListener;
import sbgc.utils.Log;
import sbgc.utils.OSUtil;
import sbgc.utils.Settings;
import sbgc.utils.http.HttpTransportFactory;
import sbgc.utils.http.IHttpTransport;
import sbgc.utils.http.IRequest;
import sbgc.utils.http.IResponse;
import sbgc.utils.http.RequestFactory;

public class FirmwareDownloaderImpl
implements IFirmwareDownloader {
    public static final String TMP_DIRECTORY = "firmware";
    public static final String FIRMWARE_TEMPLATE = "yyyyMMddHHmmss";
    private static final Log logger = new Log(Logger.getLogger((String)FirmwareDownloaderImpl.class.getName()));
    private BoardInfo boardInfo = null;
    private IFirmwareInfo firmwareInfo = null;
    private ILogListener logListener = null;
    private IProgressListener progressListener = null;
    private boolean binFormat = false;

    public FirmwareDownloaderImpl(BoardInfo boardInfo, IFirmwareInfo firmwareInfo, ILogListener logListener, IProgressListener progressListener, boolean binFormat) {
        this.boardInfo = boardInfo;
        this.firmwareInfo = firmwareInfo;
        this.logListener = logListener;
        this.progressListener = progressListener;
        this.binFormat = binFormat;
    }

    @Override
    public File download(File saveFile) throws Exception {
        logger.trace("Downloading firmware...", this.logListener);
        try {
            int version = 0;
            int versionId = 0;
            if (this.firmwareInfo != null) {
                version = this.firmwareInfo.getVersion();
                versionId = this.firmwareInfo.getVersionId();
            }
            if (saveFile == null) {
                String workingDirectory = Settings.getUserDir();
                File tmp = new File(workingDirectory + File.separatorChar + TMP_DIRECTORY);
                if (!tmp.exists()) {
                    logger.warn("Creating temporary directory...", this.logListener);
                    tmp.mkdirs();
                }
                saveFile = new File(tmp.getAbsolutePath() + File.separatorChar + "simplebgc" + this.boardInfo.boardVer + "_v" + new VersionImpl(version).toString().replaceAll("[\\W]", "_") + "_" + this.boardInfo.getDeviceId() + (this.binFormat ? ".bin" : ".hex"));
            }
            logger.trace("Prepearing request...");
            IRequest request = RequestFactory.getRequest();
            request.addParameter("act", "sbgc.get_firmware");
            request.addParameter("device_id", this.boardInfo.getDeviceId());
            request.addParameter("mcu_id", this.boardInfo.getMcuId());
            request.addParameter("version", Integer.toString(version));
            request.addParameter("versionId", Integer.toString(versionId));
            request.addParameter("sign", Settings.get("temporary_signature"));
            request.addParameter("os", OSUtil.getOsName());
            request.addParameter("bin_format", this.binFormat ? "1" : "0");
            if ("1".equals(Settings.get("registration.data.sent"))) {
                if (Settings.get("registration.data.email") != null) {
                    request.addParameter("email", Settings.get("registration.data.email"));
                }
                if (Settings.get("registration.data.country") != null) {
                    request.addParameter("country", Settings.get("registration.data.country"));
                }
            }
            IHttpTransport transport = HttpTransportFactory.getTransport();
            IResponse response = transport.send(request);
            byte[] data = null;
            if (response.getErrorCode() == null || response.getErrorCode() != 0) {
                throw new Exception(response.getErrorMessage() != null ? response.getErrorMessage() : "Invalid response" + (response.getErrorCode() != null ? " code: " + response.getErrorCode() + "!" : "!"));
            }
            data = response.getFirmware();
            this.progressListener.onProgressChange(90);
            this.progressListener.onProgressChange(95);
            logger.trace("Writing data into file \"" + saveFile.getAbsolutePath() + "\"...", this.logListener);
            FileUtil.save(saveFile.getAbsolutePath(), data);
            this.progressListener.onProgressChange(100);
            logger.debug("Firmware is downloaded: " + data.length + " bytes", this.logListener);
            return saveFile;
        }
        catch (Exception e) {
            throw new Exception("Error downloading firmware: " + e.toString());
        }
    }
}

