/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service.upgrade;

import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;
import sbgc.common.IFirmwareInfo;
import sbgc.object.BoardInfo;
import sbgc.serial.command.SerialCommandSignMessageImpl;
import sbgc.service.ConnectThread;
import sbgc.service.RealtimeDataThread;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandProcessor;
import sbgc.service.SerialPortService;
import sbgc.service.upgrade.FirmwareDownloaderImpl;
import sbgc.service.upgrade.FirmwareWriterDFUUtilImpl;
import sbgc.service.upgrade.FirmwareWriterSTM32BootImpl;
import sbgc.service.upgrade.IFirmwareUpgradeListener;
import sbgc.service.upgrade.IStatusListener;
import sbgc.service.upgrade.ProgressListenerImpl;
import sbgc.utils.ILogListener;
import sbgc.utils.Log;
import sbgc.utils.Settings;
import sbgc.utils.http.HttpTransportFactory;
import sbgc.utils.http.IHttpTransport;
import sbgc.utils.http.IRequest;
import sbgc.utils.http.IResponse;
import sbgc.utils.http.RequestFactory;
import simplebgc_gui.DialogFirmwareUpgrade;
import simplebgc_gui.SimpleBGC_GUIApp;
import simplebgc_gui.SimpleBGC_GUIView;

public class FirmwareUpgraderImpl
implements Runnable {
    private static final Log logger = new Log(Logger.getLogger((String)FirmwareUpgraderImpl.class.getName()));
    private static ResourceMap resourceMap = null;
    private IFirmwareInfo firmwareInfo = null;
    private IFirmwareUpgradeListener listener = null;
    private ILogListener logListener = null;
    private IStatusListener statusListener = null;
    private final String portName;
    private File firmwareHexFile = null;
    private BoardInfo boardInfo = null;
    private SimpleBGC_GUIView mainView = null;
    private File saveFile = null;

    public FirmwareUpgraderImpl(SimpleBGC_GUIView mainView, BoardInfo boardInfo, IFirmwareInfo firmwareInfo, String portName, File firmwareHexFile, IFirmwareUpgradeListener listener, ILogListener logListener, IStatusListener statusListener, File saveFile) throws IllegalArgumentException {
        this.firmwareInfo = firmwareInfo;
        this.boardInfo = boardInfo;
        this.portName = portName;
        this.listener = listener;
        this.logListener = logListener;
        this.statusListener = statusListener;
        this.firmwareHexFile = firmwareHexFile;
        this.mainView = mainView;
        this.saveFile = saveFile;
        resourceMap = SimpleBGC_GUIApp.getResourceMap(DialogFirmwareUpgrade.class);
        if (this.listener == null) {
            throw new IllegalArgumentException("IFirmwareUpgradeListener should be not null!");
        }
        if (this.logListener == null) {
            throw new IllegalArgumentException("ILogListener should be not null!");
        }
    }

    private File downloadFirmware() throws Exception {
        boolean binFormat = this.saveFile == null || !this.saveFile.getName().toLowerCase().endsWith(".hex");
        return new FirmwareDownloaderImpl(this.boardInfo, this.firmwareInfo, this.logListener, new ProgressListenerImpl(0, 50, this.listener), binFormat).download(this.saveFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeFirmware(File firmware) throws Exception {
        if (this.statusListener != null) {
            this.statusListener.onStatusChange("Writing firmware...");
        }
        this.listener.onFlashStart();
        ProgressListenerImpl progressListener = new ProgressListenerImpl(50, 50, this.listener);
        if ((this.boardInfo.connectionFlags & 1) != 0) {
            if (!firmware.getName().toLowerCase().endsWith(".bin")) throw new Exception("Unsupported file format: " + firmware.getName());
            FirmwareWriterDFUUtilImpl writer = new FirmwareWriterDFUUtilImpl(this.logListener, progressListener);
            writer.write(firmware, null, 0x8000000, 0x8000000);
            return;
        }
        if (this.portName == null || this.portName.isEmpty()) {
            throw new Exception(resourceMap.getString("error.port_is_not_selected", new Object[0]));
        }
        this.logListener.append("Opening serial port " + this.portName + "..");
        SerialPortService.connect_port(this.portName, 0);
        this.logListener.append("OK\n");
        try {
            FirmwareWriterSTM32BootImpl writer = new FirmwareWriterSTM32BootImpl(SerialPortService.getDataPort(), this.logListener, progressListener, null);
            writer.write(firmware, null, 0x8000000, 0x8000000);
            return;
        }
        finally {
            this.logListener.append("Disconnecting serial port " + this.portName + "..");
            SerialPortService.disconnect_port();
            this.logListener.append("OK\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean oldRtDataState = RealtimeDataThread.pause(true);
        try {
            Thread.sleep(1000L);
            if (this.listener.isAlive() && this.firmwareHexFile == null) {
                if (this.mainView.isConnected()) {
                    if (!oldRtDataState) {
                        this.logListener.info("Pausing monitoring..");
                        Thread.sleep(2000L);
                    }
                } else {
                    if (this.statusListener != null) {
                        this.statusListener.onStatusChange("Connecting to board..");
                    }
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            FirmwareUpgraderImpl.this.mainView.connect(FirmwareUpgraderImpl.this.portName, true);
                        }
                    });
                    if (ConnectThread.getThread() != null) {
                        ConnectThread.getThread().join(5000L);
                    }
                    if (!this.mainView.isConnected()) {
                        this.mainView.disconnect();
                        throw new Exception(resourceMap.getString("error.reconnect_usb", new Object[0]));
                    }
                }
                if (this.boardInfo == null) {
                    this.boardInfo = BoardInfo.getBoardInfo();
                }
                this.logListener.info("Signing request..");
                String sign = SerialCommandSignMessageImpl.signMessage(Settings.get("temporary_session"), 2);
                Settings.set("temporary_signature", sign);
                logger.trace(" OK");
                if (this.statusListener != null) {
                    this.statusListener.onStatusChange("Downloading firmware...");
                }
                this.firmwareHexFile = this.downloadFirmware();
            }
            if (this.saveFile != null) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        FirmwareUpgraderImpl.this.listener.onFirmwareSaved(FirmwareUpgraderImpl.this.saveFile);
                    }
                });
            } else {
                if (this.listener.isAlive() && this.mainView.isConnected()) {
                    int cmd_id;
                    this.mainView.stopSerialCommunication();
                    Thread.sleep(500L);
                    this.logListener.info("Entering boot mode...");
                    int boot_wait = 2000;
                    if ((this.boardInfo.connectionFlags & 1) != 0) {
                        JOptionPane.showMessageDialog(null, resourceMap.getString("info.close_flash_jumper", new Object[0]), resourceMap.getString("messageDialog.info.title", new Object[0]), 1);
                        cmd_id = 114;
                        boot_wait += 2000;
                    } else {
                        cmd_id = 51;
                    }
                    SerialCommand cmd = new SerialCommand(cmd_id, 3);
                    if (BoardInfo.checkMinPartnerFirmwareVer(2434)) {
                        cmd.writeByte(1);
                        cmd.writeWord(0);
                    }
                    SerialCommandProcessor.sendCommand(cmd);
                    for (int time = 0; time < 3000 && this.mainView.isConnected(); time += 100) {
                        Thread.sleep(100L);
                    }
                    if (this.mainView.isConnected()) {
                        this.mainView.disconnect();
                    }
                    this.logListener.info("Waiting for bootloader to start...");
                    Thread.sleep(boot_wait);
                }
                if (this.listener.isAlive()) {
                    if (this.boardInfo == null) {
                        throw new Exception("BoardInfo is null!");
                    }
                    this.writeFirmware(this.firmwareHexFile);
                    this.setFirmware();
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            FirmwareUpgraderImpl.this.listener.onFirmwareUpgradeEnd(null, FirmwareUpgraderImpl.this.firmwareInfo);
                        }
                    });
                }
            }
        }
        catch (InterruptedException e) {
            this.listener.onFirmwareUpgradeEnd(new Exception("Upgrade process is interrupted!"), this.firmwareInfo);
        }
        catch (Throwable e) {
            this.listener.onFirmwareUpgradeEnd(e, this.firmwareInfo);
        }
        finally {
            RealtimeDataThread.pause(oldRtDataState);
        }
    }

    private void setFirmware() throws Exception {
        if (this.firmwareInfo != null) {
            try {
                logger.trace("Prepearing request...");
                IRequest request = RequestFactory.getRequest();
                request.addParameter("act", "sbgc.set_firmware");
                request.addParameter("device_id", this.boardInfo.getDeviceId());
                request.addParameter("mcu_id", this.boardInfo.getMcuId());
                request.addParameter("version", Integer.toString(this.firmwareInfo.getVersion()));
                request.addParameter("versionId", Integer.toString(this.firmwareInfo.getVersionId()));
                request.addParameter("sign", Settings.get("temporary_signature"));
                IHttpTransport transport = HttpTransportFactory.getTransport();
                IResponse response = transport.send(request);
                if (response.getErrorCode() == null || response.getErrorCode() != 0) {
                    throw new Exception(response.getErrorMessage() != null ? response.getErrorMessage() : "Invalid response" + (response.getErrorCode() != null ? " code: " + response.getErrorCode() + "!" : "!"));
                }
            }
            catch (Exception e) {
                throw new Exception("Can't confirm firmware upgrade: " + e.toString());
            }
        }
    }
}

