/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service.upgrade;

import java.io.File;
import java.util.Arrays;
import org.apache.log4j.Logger;
import sbgc.STM32.STM32Boot;
import sbgc.service.IDataPort;
import sbgc.service.upgrade.IFirmwareWriter;
import sbgc.service.upgrade.IProgressListener;
import sbgc.utils.FileUtil;
import sbgc.utils.ILogListener;
import sbgc.utils.Log;
import sbgc.utils.Settings;

public class FirmwareWriterSTM32BootImpl
implements IFirmwareWriter {
    private static final Log logger = new Log(Logger.getLogger((String)FirmwareWriterSTM32BootImpl.class.getName()));
    private final ILogListener logListener;
    private final IProgressListener progressListener;
    IDataPort dataPort;
    int[] erasePages;

    public FirmwareWriterSTM32BootImpl(IDataPort dataPort, ILogListener logListener, IProgressListener progressListener, int[] erasePages) {
        this.dataPort = dataPort;
        this.logListener = logListener;
        this.progressListener = progressListener;
        this.erasePages = erasePages;
    }

    @Override
    public void write(File firmwareFile, byte[] firmwareData, int writeAddress, int runAddress) throws Exception {
        logger.trace("Writing firmware to STM32 bootloader...", this.logListener);
        if (firmwareData == null) {
            this.logListener.append("Reading firmware from file..");
            firmwareData = FileUtil.readFirmwareFromFile(firmwareFile, writeAddress);
            this.logListener.append("OK, " + firmwareData.length + " bytes\n");
        }
        this.logListener.append("Connecting bootloader..");
        STM32Boot stm32 = new STM32Boot(this.dataPort);
        stm32.init(Settings.is("firmware_update.flash_high_speed"));
        this.logListener.append("OK\n");
        int boot_ver = stm32.get_version();
        int chip_id = stm32.get_chip_id();
        this.logListener.append("Bootloader version: " + (boot_ver >> 8) + "." + (boot_ver & 0xFF) + ", MCU_ID: " + chip_id + "\n");
        this.progressListener.onProgressChange(10);
        if (this.erasePages != null) {
            this.logListener.append("Erasing pages " + Arrays.toString(this.erasePages) + "..");
            if (boot_ver >> 8 >= 3) {
                stm32.extended_erase_pages(this.erasePages);
            } else {
                stm32.erase_pages(this.erasePages);
            }
        } else {
            this.logListener.append("Mass-erasing FLASH..");
            if (stm32.is_command_supported(68)) {
                stm32.extended_erase_flash();
            } else if (stm32.is_command_supported(67)) {
                stm32.erase_flash();
            } else {
                throw new Exception("ERASE_FLASH or EXTENDED_ERASE_FLASH command is not supported");
            }
        }
        this.logListener.append("OK\n");
        this.logListener.append("Writing firmware..");
        stm32.write_flash(firmwareData, writeAddress, this.progressListener);
        this.logListener.append("OK\n");
        this.logListener.append("Starting main program..");
        stm32.go_cmd(runAddress);
        this.logListener.append("OK\n");
        if (this.progressListener != null) {
            this.progressListener.onProgressFinish(true);
        }
    }
}

