/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service.upgrade;

import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import org.apache.log4j.Logger;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import sbgc.service.upgrade.IFirmwareWriter;
import sbgc.service.upgrade.IProgressListener;
import sbgc.service.upgrade.OutReaderSTMFlashLoader;
import sbgc.service.upgrade.ProgressListenerImpl;
import sbgc.utils.ILogListener;
import sbgc.utils.Log;
import sbgc.utils.Settings;
import simplebgc_gui.DialogFirmwareUpgrade;
import simplebgc_gui.SimpleBGC_GUIApp;

public class FirmwareWriterSTMFlashLoaderImpl
implements IFirmwareWriter {
    private static final Log logger = new Log(Logger.getLogger((String)FirmwareWriterSTMFlashLoaderImpl.class.getName()));
    public static final String FLASH_TOOL_COMMAND_UNLOCK = null;
    public static final String FLASH_TOOL_COMMAND_FLASH = "{0}/bin/STMFlashLoader.exe -c --pn {1} --br 115200 -i STM32F303_256K -e --all -d --fn {2} -r --a {3}";
    public static final String FLASH_TOOL_COMMAND_LOCK = null;
    public static final int WAIT_TIMEOUT = 20;
    private final ILogListener logListener;
    private final IProgressListener progressListener;
    private String lastErrorText = null;
    private int waitCnt = 0;
    ResourceMap resourceMap = null;
    String port;

    public FirmwareWriterSTMFlashLoaderImpl(String port, ILogListener logListener, IProgressListener progressListener) {
        this.port = port;
        this.logListener = logListener;
        this.progressListener = progressListener;
        this.resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(DialogFirmwareUpgrade.class);
    }

    public void onOutWrite(char c) {
        System.out.println(c);
        this.waitCnt = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOutWrite(String message) {
        FirmwareWriterSTMFlashLoaderImpl firmwareWriterSTMFlashLoaderImpl = this;
        synchronized (firmwareWriterSTMFlashLoaderImpl) {
            if (message != null && message.toLowerCase().indexOf("avrdude:") > -1) {
                this.lastErrorText = message;
            }
            logger.trace(message, this.logListener);
        }
        this.waitCnt = 0;
    }

    @Override
    public void write(File firmware, byte[] firmwareData, int writeAddress, int runAddress) throws Exception {
        logger.trace("Writing firmware to address 0x" + Integer.toHexString(writeAddress) + "...", this.logListener);
        try {
            if (FLASH_TOOL_COMMAND_UNLOCK != null) {
                this.exec_cmd(FLASH_TOOL_COMMAND_UNLOCK, this.port, firmware, writeAddress);
            }
            this.exec_cmd(FLASH_TOOL_COMMAND_FLASH, this.port, firmware, writeAddress);
            if (FLASH_TOOL_COMMAND_LOCK != null) {
                this.exec_cmd(FLASH_TOOL_COMMAND_LOCK, this.port, firmware, writeAddress);
            }
        }
        catch (Exception e) {
            throw new Exception("Error writing firmware: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exec_cmd(String template, String serialPort, File firmware, int writeAddress) throws Exception {
        if (!firmware.exists()) {
            throw new Exception(MessageFormat.format("Firmware file \"{0}\" isn't found!", firmware.getAbsolutePath()));
        }
        Runtime runtime = Runtime.getRuntime();
        String port = serialPort;
        if (port.toLowerCase().indexOf("com") > -1) {
            port = port.substring(3);
        }
        String[] args = new String[]{Settings.getWorkingDirectory(), port, firmware.getAbsolutePath(), Integer.toHexString(writeAddress)};
        String[] command = template.split("\\s");
        for (int i = 0; i < command.length; ++i) {
            command[i] = MessageFormat.format(command[i], args);
        }
        Process process = runtime.exec(command);
        this.progressListener.onProgressChange(10);
        InputStream stdout = process.getInputStream();
        InputStream stderr = process.getErrorStream();
        try {
            double progressChange = 100L / (firmware.length() / 5600L);
            OutReaderSTMFlashLoader stdoutReader = new OutReaderSTMFlashLoader("stdout", stdout, this, new ProgressListenerImpl(10, 80, this.progressListener), progressChange);
            stdoutReader.start();
            OutReaderSTMFlashLoader stderrReader = new OutReaderSTMFlashLoader("stderr", stderr, this, null, progressChange);
            stderrReader.start();
            int result = -1;
            this.waitCnt = 0;
            while (true) {
                try {
                    result = process.exitValue();
                }
                catch (Exception exception) {
                    FirmwareWriterSTMFlashLoaderImpl firmwareWriterSTMFlashLoaderImpl = this;
                    synchronized (firmwareWriterSTMFlashLoaderImpl) {
                        ++this.waitCnt;
                        if (this.waitCnt > 20) {
                            break;
                        }
                    }
                    Thread.sleep(1000L);
                    continue;
                }
                break;
            }
            process.destroy();
            logger.trace("Process finished.", this.logListener);
            stdoutReader.join();
            stderrReader.join();
            this.progressListener.onProgressChange(100);
            if (result != 0) {
                if (this.lastErrorText != null) {
                    throw new Exception("[" + result + "] " + this.lastErrorText);
                }
                if (result == -1) {
                    throw new Exception("Timeout!");
                }
                throw new Exception("Flash tool execution failed (" + result + ")!");
            }
        }
        finally {
            stdout.close();
            stderr.close();
        }
    }
}

