/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service.upgrade;

import java.io.InputStream;
import org.apache.log4j.Logger;
import sbgc.service.upgrade.FirmwareWriterDFUUtilImpl;
import sbgc.service.upgrade.IProgressListener;
import sbgc.service.upgrade.OutReaderSTMFlashLoader;
import sbgc.utils.Log;

class OutReaderDFUUtil
implements Runnable {
    public static final String ENCODING_FROM = "Cp1252";
    private InputStream in = null;
    private FirmwareWriterDFUUtilImpl firmwareWriter = null;
    private static final Log logger = new Log(Logger.getLogger((String)OutReaderSTMFlashLoader.class.getName()));
    private Thread thread = null;
    private IProgressListener progressListener = null;
    private boolean isErrorStream = false;
    private static final double progressChange = 10.0;

    public OutReaderDFUUtil(boolean isErrorStream, InputStream in, FirmwareWriterDFUUtilImpl firmwareWriter, IProgressListener progressListener) {
        this.in = in;
        this.firmwareWriter = firmwareWriter;
        this.progressListener = progressListener;
        this.isErrorStream = isErrorStream;
    }

    public void start() {
        this.thread = new Thread((Runnable)this, "Firmware Upgrade (" + (this.isErrorStream ? "stdout" : "stderr") + ")");
        this.thread.start();
    }

    public void join() {
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException ie) {
                logger.error("Waiting is interrupted!");
            }
        }
    }

    @Override
    public void run() {
        int b = -1;
        try {
            byte[] line = new byte[1024];
            int size = 0;
            double progress = 0.0;
            while ((b = this.in.read()) > -1) {
                if (b == 13) {
                    b = this.in.read();
                    if (b == -1) break;
                    if (b != 10) {
                        size = 0;
                    }
                }
                if (b == 10) {
                    if (size <= 0) continue;
                    this.firmwareWriter.onOutWrite(new String(line, 0, size, ENCODING_FROM), this.isErrorStream);
                    size = 0;
                    continue;
                }
                if (b == 37) {
                    try {
                        int length = 0;
                        while (line[size - length - 1] >= 48 && line[size - length - 1] <= 57) {
                            ++length;
                        }
                        progress = Integer.parseInt(new String(line, size - length, length, ENCODING_FROM));
                    }
                    catch (Exception e) {
                        logger.debug(e.toString());
                        progress += 10.0;
                    }
                    if (this.progressListener != null && progress > 0.0 && progress <= 100.0) {
                        this.progressListener.onProgressChange((int)progress);
                    }
                }
                if (size >= line.length) continue;
                line[size++] = (byte)b;
            }
            if (size > 0) {
                this.firmwareWriter.onOutWrite(new String(line, 0, size, ENCODING_FROM), this.isErrorStream);
            }
            if (this.progressListener != null) {
                this.progressListener.onProgressChange(100);
            }
        }
        catch (Exception e) {
            logger.error("Error reading output: " + e.toString());
        }
    }
}

