/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service.upgrade;

import sbgc.service.upgrade.IProgressListener;

public class ProgressListenerImpl
implements IProgressListener {
    private int parentRange = 100;
    private int parentStart = 0;
    private IProgressListener parent = null;

    public ProgressListenerImpl(int parentStart, int parentRange, IProgressListener parent) {
        this.parentStart = parentStart;
        this.parentRange = parentRange;
        this.parent = parent;
    }

    @Override
    public void onProgressStart(String action, boolean modal) {
        if (this.parent != null) {
            this.parent.onProgressStart(action, modal);
        }
    }

    @Override
    public synchronized boolean onProgressChange(int percent) {
        int value = percent;
        if (value > 100) {
            value = 100;
        }
        if (this.parent != null) {
            this.parent.onProgressChange(this.parentStart + value * this.parentRange / 100);
        }
        return true;
    }

    @Override
    public synchronized void onProgressFinish(boolean isSuccess) {
        if (this.parent != null) {
            this.parent.onProgressFinish(isSuccess);
        }
    }
}

