/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service.upgrade;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.Logger;
import sbgc.common.IFirmwareInfo;
import sbgc.object.BoardInfo;
import sbgc.service.upgrade.FirmwareInfoComparator;
import sbgc.service.upgrade.IVersionChecker;
import sbgc.service.upgrade.IVersionCheckerListener;
import sbgc.service.upgrade.VersionFactory;
import sbgc.service.upgrade.VersionImpl;
import sbgc.utils.DateUtil;
import sbgc.utils.Log;
import sbgc.utils.Settings;
import sbgc.utils.http.HttpTransportFactory;
import sbgc.utils.http.IHttpTransport;
import sbgc.utils.http.IRequest;
import sbgc.utils.http.IResponse;
import sbgc.utils.http.RequestFactory;

public class VersionCheckerImpl
implements IVersionChecker,
Runnable {
    public static final String FIRMWARE = "firmware";
    public static final String GUI = "gui";
    private static final Log logger = new Log(Logger.getLogger((String)VersionCheckerImpl.class.getName()));
    private ArrayList<IVersionCheckerListener> listeners = new ArrayList();
    private static final Object blocker = new Object();
    private static boolean checking = false;
    private String error = null;
    private Thread checkingThread = null;
    boolean wait;

    @Override
    public boolean hasError() {
        return this.error != null;
    }

    @Override
    public String getError() {
        return this.error;
    }

    @Override
    public void addListener(IVersionCheckerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean check(boolean wait) {
        this.wait = wait;
        logger.trace("Version checking...");
        Object object = blocker;
        synchronized (object) {
            if (checking) {
                logger.trace("Version checking is already started.");
                return false;
            }
            logger.trace("Starting thread...");
            try {
                this.checkingThread = new Thread((Runnable)this, "VersionChecker");
                this.checkingThread.start();
            }
            catch (Exception e) {
                checking = false;
            }
            return true;
        }
    }

    @Override
    public void await() {
        logger.trace("Waiting for thread execution...");
        if (this.checkingThread != null) {
            try {
                this.checkingThread.join();
                logger.trace("Out of waiting.");
            }
            catch (InterruptedException e) {
                logger.warn("Awaiting interrupted: " + e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Iterator<IVersionCheckerListener> request;
        Object object = blocker;
        synchronized (object) {
            checking = true;
        }
        IResponse response = null;
        try {
            for (IVersionCheckerListener listener : this.listeners) {
                listener.onStartCheck();
            }
            logger.debug("Starting version checking...");
            request = RequestFactory.getRequest();
            request.addParameter("act", "sbgc.firmware_info");
            BoardInfo boardInfo = BoardInfo.getBoardInfo();
            if (boardInfo == null) {
                throw new Exception("BoardInfo is null. May be card is disconnected?");
            }
            request.addParameter("board_ver", Integer.toString(boardInfo.getBoardVersion()));
            request.addParameter("firmware_ver", Integer.toString(boardInfo.getFrwVerShow()));
            request.addParameter("device_id", boardInfo.getDeviceId());
            request.addParameter("mcu_id", boardInfo.getMcuId());
            request.addParameter("lang", Settings.getLocale().getLanguage());
            if (Settings.is("firmware_update.check_beta")) {
                request.addParameter("check_beta", "1");
            }
            if (Settings.is("firmware_update.experimental")) {
                request.addParameter("experimental", "1");
            }
            if (boardInfo.getFrwVerShow() > 0 && Settings.is("firmware_update.compatible_only")) {
                request.addParameter("check_board_features", Long.toString(boardInfo.boardFeatures));
            }
            request.addParameter("flash_size", Integer.toString(boardInfo.flash_size));
            request.addParameter("usb_vcp", (boardInfo.connectionFlags & 1) != 0 ? "1" : "0");
            IHttpTransport transport = HttpTransportFactory.getTransport();
            response = transport.send((IRequest)((Object)request));
            ArrayList<IFirmwareInfo> firmwares = null;
            String temporarySession = null;
            if (response.getErrorCode() != null && response.getErrorCode() == 0) {
                temporarySession = response.getResultData().get("session");
                firmwares = response.getFirmwareInfo();
                Collections.sort(firmwares, new FirmwareInfoComparator());
                Settings.set("last.version.check.date", DateUtil.format(new Date(), "yyyy.MM.dd"));
                Settings.set("temporary_session", temporarySession);
                if (response.isAllowReg()) {
                    Settings.set("registration.data.sent", "1");
                } else {
                    Settings.set("registration.data.sent", "0");
                }
                if (response.getEmail() != null && Settings.get("registration.data.email") == null) {
                    logger.trace("Email: " + response.getEmail());
                    Settings.set("registration.data.email", response.getEmail());
                }
                if (response.getCountry() != null && Settings.get("registration.data.country") == null) {
                    logger.trace("Country: " + response.getCountry());
                    Settings.set("registration.data.country", response.getCountry());
                }
            } else {
                throw new Exception(response.getErrorMessage() != null ? response.getErrorMessage() : "Invalid response" + (response.getErrorCode() != null ? " code: " + response.getErrorCode() + "!" : "!"));
            }
            Settings.save();
            logger.debug("Versions (version; id; date): ");
            for (IFirmwareInfo finfo : firmwares) {
                logger.debug("\t" + finfo.getVersion() + "; " + finfo.getVersionId() + (finfo.getRegDate() != null ? "; " + DateUtil.format(finfo.getRegDate(), "dd.MM.yyyy") : ""));
            }
            VersionImpl latestFirmware = firmwares.size() > 0 ? VersionFactory.getVersion(firmwares.get(0).getVersion()) : null;
            for (IVersionCheckerListener listener : this.listeners) {
                if (latestFirmware != null) {
                    listener.onLatestFirmwareVersion(latestFirmware);
                }
                listener.onVersionsLoaded(firmwares);
            }
            request = blocker;
        }
        catch (Exception e) {
            logger.error("Error checking version: " + e.toString());
            if (e.getMessage() != null) {
                this.error = e.getMessage();
            }
            this.error = e.toString();
        }
        finally {
            Iterator<IVersionCheckerListener> iterator = blocker;
            synchronized (iterator) {
                checking = false;
            }
            for (IVersionCheckerListener listener : this.listeners) {
                listener.onEndCheck(response);
            }
        }
        synchronized (request) {
            checking = false;
        }
        for (IVersionCheckerListener listener : this.listeners) {
            listener.onEndCheck(response);
        }
    }
}

