/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service.upgrade;

public class VersionImpl {
    private Integer version = null;
    private int major = 0;
    private int minor = 0;
    private int issue = 0;
    private int buildNumber = 0;

    public VersionImpl(int ver) {
        this.version = ver;
        this.major = ver / 1000;
        this.minor = ver % 1000 / 10;
        this.issue = ver % 10;
    }

    public VersionImpl(int ver, int buildNumber) {
        this(ver);
        this.buildNumber = buildNumber;
    }

    public static VersionImpl getVerBase100(int ver, int buildNumber) {
        VersionImpl v = new VersionImpl(ver, buildNumber);
        v.major = ver / 100;
        v.minor = ver % 100;
        return v;
    }

    public int getMajorVer() {
        return this.major;
    }

    public int getMinorVer() {
        return this.minor;
    }

    public int getBuildNum() {
        return this.buildNumber;
    }

    public Integer getFullVer() {
        return this.version;
    }

    public int getComparableVersion() {
        return this.version != null ? this.version : 0;
    }

    public int compareTo(VersionImpl version) {
        return Integer.compare(this.getComparableVersion(), version.getComparableVersion());
    }

    public int compareToIgnoringIssue(VersionImpl version) {
        return Integer.compare(this.getComparableVersion() / 10, version.getComparableVersion() / 10);
    }

    public String toString() {
        if (this.version != null) {
            String res = this.major + "." + String.format("%02d", this.minor) + "." + this.issue;
            if (this.buildNumber > 0) {
                res = res + "_" + this.buildNumber;
            }
            return res;
        }
        return "--";
    }

    public String toStringOmitIssueNum() {
        if (this.version != null) {
            return this.major + "." + String.format("%02d", this.minor) + ".x";
        }
        return "--";
    }
}

