/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTitleAnnotation;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.panel.CrosshairOverlay;
import org.jfree.chart.panel.Overlay;
import org.jfree.chart.plot.Crosshair;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import sbgc.bode_plot.BodeCalculation;
import sbgc.bode_plot.BodeConfig;
import sbgc.bode_plot.BodeRenderer;
import sbgc.bode_plot.BodeResult;
import sbgc.bode_plot.Complex;
import sbgc.bode_plot.ControllerOptimizer;
import sbgc.bode_plot.ControllerParams;
import sbgc.bode_plot.Extremum;
import sbgc.bode_plot.MultiAxisCrosshairOverlay;
import sbgc.bode_plot.TestDataReaderCSVImpl;
import sbgc.object.AutoPIDCfg2;
import sbgc.object.BoardParams;
import sbgc.object.BoardProfile;
import sbgc.script_parser.utils.FileHelper;
import sbgc.ui.TabbedPanelAnalyze;
import sbgc.utils.Log;
import simplebgc_gui.DialogAutoPID2;
import simplebgc_gui.SimpleBGC_GUIApp;
import simplebgc_gui.SimpleBGC_GUIView;

public class BodePlotJPanel
extends JPanel
implements ChartMouseListener {
    private static final Log logger = new Log(Logger.getLogger((String)BodePlotJPanel.class.getName()));
    private List<BodeResult> bodeResultList = new ArrayList<BodeResult>();
    private boolean isGainShown = false;
    private boolean isPhaseShown = false;
    private boolean isSensShown = false;
    private boolean isSmoothSelected = true;
    private boolean isAutoScaleSelected = true;
    private MultiAxisCrosshairOverlay crosshairOverlay = null;
    private ChartPanel chartPanel = null;
    private Crosshair xCrosshair = null;
    private Crosshair yCrosshair = null;
    private Crosshair phaseCrosshair = null;
    ControllerOptimizer controllerOptimizer = null;
    ControllerParams cp_cur = null;
    private TabbedPanelAnalyze panelAnalyze;
    DialogAutoPID2 dialogAutoPID2 = null;

    public void setParent(TabbedPanelAnalyze parent) {
        this.panelAnalyze = parent;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public void addBodeResult(BodeResult bodeResult) {
        boolean exists;
        if (bodeResult == null) {
            return;
        }
        String origName = bodeResult.getName();
        int i = 0;
        do {
            exists = false;
            for (BodeResult b : this.bodeResultList) {
                if (b.equals(bodeResult)) {
                    return;
                }
                if (!b.getName().equalsIgnoreCase(bodeResult.getName())) continue;
                exists = true;
                bodeResult.setName(origName + "(" + ++i + ")");
            }
        } while (exists);
        this.bodeResultList.add(bodeResult);
        if (this.panelAnalyze != null) {
            this.panelAnalyze.onBodeResultAdd(bodeResult);
        }
    }

    public List<BodeResult> getBodeDataList() {
        return this.bodeResultList;
    }

    public void drawPlot() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add((Component)this.getChartPanel(), "Center");
        this.validate();
    }

    public void clearPlot() {
        this.bodeResultList.clear();
        if (this.panelAnalyze != null) {
            this.panelAnalyze.onBodeResultClear();
        }
        this.drawPlot();
    }

    public void setIsAmpShown(boolean isGainShown) {
        this.isGainShown = isGainShown;
    }

    public void setIsSensitivityShown(boolean state) {
        this.isSensShown = state;
    }

    public void setIsPhaseShown(boolean isPhaseShown) {
        this.isPhaseShown = isPhaseShown;
    }

    public void setIsSmoothSelected(boolean isSmoothSelected) {
        this.isSmoothSelected = isSmoothSelected;
    }

    public void setIsAutoScaleSelected(boolean isAutoScaleSelected) {
        this.isAutoScaleSelected = isAutoScaleSelected;
    }

    public boolean isGainShown() {
        return this.isGainShown;
    }

    public boolean isPhaseShown() {
        return this.isPhaseShown;
    }

    public boolean isSensShown() {
        return this.isSensShown;
    }

    private ChartPanel getChartPanel() {
        JFreeChart chart = ChartFactory.createScatterPlot((String)"", (String)"dB", (String)"Hz", null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        chart.setBackgroundPaint((Paint)Color.white);
        chart.removeLegend();
        BodeRenderer phaseRenderer = new BodeRenderer();
        NumberAxis phaseAxis = new NumberAxis("");
        phaseAxis.setRange(-185.0, 185.0);
        phaseAxis.setTickUnit(new NumberTickUnit(30.0));
        BodeRenderer gainRenderer = new BodeRenderer();
        NumberAxis gainAxis = new NumberAxis("dB");
        LogarithmicAxis logarithmicAxis = new LogarithmicAxis("");
        logarithmicAxis.setStrictValuesFlag(false);
        logarithmicAxis.setRange(2.0, 500.0);
        XYPlot plot = chart.getXYPlot();
        plot.setRenderer(0, (XYItemRenderer)gainRenderer);
        plot.setRangeAxis(0, (ValueAxis)gainAxis);
        plot.setRenderer(1, (XYItemRenderer)phaseRenderer);
        plot.setRangeAxis(1, (ValueAxis)phaseAxis);
        plot.setDomainAxis((ValueAxis)logarithmicAxis);
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        LegendItemCollection markerItemCollection = new LegendItemCollection();
        this.crosshairOverlay = new MultiAxisCrosshairOverlay();
        if (this.isGainShown || this.isSensShown) {
            plot.setDataset(0, (XYDataset)this.getGainXYSeriesCollection(gainAxis, legendItemCollection, markerItemCollection, this.crosshairOverlay, gainRenderer));
            plot.mapDatasetToRangeAxis(0, 0);
        }
        if (this.isPhaseShown) {
            plot.setDataset(1, (XYDataset)this.getPhaseXYSeriesCollection(legendItemCollection, markerItemCollection, this.crosshairOverlay, phaseRenderer));
            plot.mapDatasetToRangeAxis(1, 1);
        }
        chart.addLegend(this.createCustomLegend(legendItemCollection));
        XYTitleAnnotation xyTitleAnnotation = new XYTitleAnnotation(0.0, 1.0, (Title)this.createCustomLegend(markerItemCollection), RectangleAnchor.TOP_LEFT);
        xyTitleAnnotation.setMaxWidth(0.48);
        plot.addAnnotation((XYAnnotation)xyTitleAnnotation);
        this.xCrosshair = new Crosshair(Double.NaN, (Paint)Color.GRAY, (Stroke)BodeConfig.CROSSCHAIR_DASHED_STROKE);
        this.xCrosshair.setLabelVisible(true);
        this.yCrosshair = new Crosshair(Double.NaN, (Paint)Color.GRAY, (Stroke)BodeConfig.CROSSCHAIR_DASHED_STROKE);
        this.yCrosshair.setLabelVisible(true);
        this.phaseCrosshair = new Crosshair(Double.NaN, (Paint)Color.RED, (Stroke)BodeConfig.CROSSCHAIR_DASHED_STROKE);
        this.phaseCrosshair.setLabelVisible(true);
        this.phaseCrosshair.setLabelAnchor(RectangleAnchor.BOTTOM_RIGHT);
        this.crosshairOverlay.addDomainCrosshair(this.xCrosshair);
        this.crosshairOverlay.addRangeCrosshair(1, this.phaseCrosshair);
        this.crosshairOverlay.addRangeCrosshair(0, this.yCrosshair);
        this.chartPanel = new ChartPanel(chart, true, true, true, false, true);
        this.chartPanel.addOverlay((Overlay)this.crosshairOverlay);
        this.chartPanel.addChartMouseListener((ChartMouseListener)this);
        return this.chartPanel;
    }

    private XYSeriesCollection getGainXYSeriesCollection(NumberAxis gainAxis, LegendItemCollection legendItemCollection, LegendItemCollection markerItemCollection, CrosshairOverlay crosshairOverlay, BodeRenderer gainRenderer) {
        XYSeriesCollection gainCollection = new XYSeriesCollection();
        int gainSeriesNum = 0;
        boolean maxMinSet = false;
        float gainMaxRange = 20.0f;
        float gainMinRange = -70.0f;
        for (BodeResult bodeResult : this.bodeResultList) {
            if (!bodeResult.isVisible()) continue;
            int num = this.bodeResultList.indexOf(bodeResult);
            if (this.isGainShown) {
                String gainName = "gain " + bodeResult.getName();
                legendItemCollection.add(new LegendItem(gainName, (Paint)BodeConfig.colorGainList[num % 5]));
                Crosshair gainCrosshair = new Crosshair(Double.NaN, (Paint)BodeConfig.colorPhaseList[num % 5], (Stroke)BodeConfig.CROSSCHAIR_DOTTED_STROKE);
                gainCrosshair.setLabelVisible(false);
                float[] gainPoints = bodeResult.getGain();
                if (this.isSmoothSelected) {
                    gainPoints = BodeResult.calcGaussSmooth(gainPoints);
                }
                if (bodeResult.canGetPhaseGainMargin()) {
                    Float marginGainFreq = BodeResult.getCrossing(gainPoints, 0.0f);
                    if (marginGainFreq != null) {
                        gainCrosshair.setValue((double)marginGainFreq.floatValue());
                        crosshairOverlay.addDomainCrosshair(gainCrosshair);
                        LegendItem phaseAnnotation = new LegendItem("Phase margin at freq. " + String.format("%.2f", marginGainFreq) + "Hz : " + String.format("%.2f", Float.valueOf(bodeResult.getGluePhaseAtFreq(marginGainFreq.floatValue()) + 180.0f)) + " degree", (Paint)BodeConfig.colorPhaseList[num % 5]);
                        phaseAnnotation.setLabelPaint((Paint)BodeConfig.colorPhaseList[num % 5]);
                        markerItemCollection.add(phaseAnnotation);
                    }
                }
                if (this.isAutoScaleSelected) {
                    Extremum extremum = BodeResult.calcExtremum(gainPoints);
                    if (!maxMinSet) {
                        gainMinRange = extremum.getMin() - 1.0f;
                        gainMaxRange = extremum.getMax() + 1.0f;
                        maxMinSet = true;
                    } else {
                        if (extremum.getMin() - 1.0f < gainMinRange) {
                            gainMinRange = extremum.getMin() - 1.0f;
                        }
                        if (extremum.getMax() + 1.0f > gainMaxRange) {
                            gainMaxRange = extremum.getMax() + 1.0f;
                        }
                    }
                }
                gainCollection.addSeries(this.getXYSeries(gainPoints, gainName));
                gainRenderer.setSeriesPaint(gainSeriesNum, BodeConfig.colorGainList[num % 5]);
                ++gainSeriesNum;
            }
            if (!this.isSensShown || !bodeResult.canGetPhaseGainMargin()) continue;
            String sensName = "sens. " + bodeResult.getName();
            legendItemCollection.add(new LegendItem(sensName, (Paint)BodeConfig.colorSensList[num % 5]));
            float[] sensPoints = BodeCalculation.calcSensitivity(bodeResult.getResponse());
            if (this.isSmoothSelected) {
                sensPoints = BodeResult.calcGaussSmooth(sensPoints);
            }
            gainCollection.addSeries(this.getXYSeries(sensPoints, sensName));
            gainRenderer.setSeriesPaint(gainSeriesNum, BodeConfig.colorSensList[num % 5]);
            ++gainSeriesNum;
        }
        gainAxis.setRange((double)gainMinRange, (double)gainMaxRange);
        return gainCollection;
    }

    private XYSeriesCollection getPhaseXYSeriesCollection(LegendItemCollection legendItemCollection, LegendItemCollection markerItemCollection, CrosshairOverlay crosshairOverlay, BodeRenderer phaseRenderer) {
        XYSeriesCollection phaseCollection = new XYSeriesCollection();
        int phaseSeriesNum = 0;
        for (BodeResult bodeResult : this.bodeResultList) {
            if (!bodeResult.isVisible() || !bodeResult.hasPhase()) continue;
            int num = this.bodeResultList.indexOf(bodeResult);
            String phaseName = "phase " + bodeResult.getName();
            legendItemCollection.add(new LegendItem(phaseName, (Paint)BodeConfig.colorPhaseList[num % 5]));
            Crosshair phaseCrosshair = new Crosshair(Double.NaN, (Paint)BodeConfig.colorGainList[num % 5], (Stroke)BodeConfig.CROSSCHAIR_DOTTED_STROKE);
            phaseCrosshair.setLabelVisible(false);
            float[] phasePoints = this.isSmoothSelected ? bodeResult.smoothPhase() : bodeResult.getPhase();
            if (bodeResult.canGetPhaseGainMargin()) {
                Float marginPhaseFreq = BodeResult.getCrossing(bodeResult.getGluePhase(), -180.0f);
                if (marginPhaseFreq != null) {
                    phaseCrosshair.setValue((double)marginPhaseFreq.floatValue());
                    crosshairOverlay.addDomainCrosshair(phaseCrosshair);
                    Object[] objectArray = new Object[1];
                    objectArray[0] = Float.valueOf(BodeResult.getValAtFreq(marginPhaseFreq.floatValue(), bodeResult.getGain()));
                    LegendItem gainAnnotation = new LegendItem("Gain margin at freq. " + String.format("%.2f", marginPhaseFreq) + "Hz : " + String.format("%.2f", objectArray) + " db", (Paint)BodeConfig.colorGainList[num % 5]);
                    gainAnnotation.setLabelPaint((Paint)BodeConfig.colorGainList[num % 5]);
                    markerItemCollection.add(gainAnnotation);
                }
            }
            List<Point2D.Float> pointsList = BodeResult.calcPhaseCycling(phasePoints);
            List<XYSeries> xySeriesList = this.getXYSeriesList(pointsList, phaseName);
            for (XYSeries xySeries : xySeriesList) {
                xySeries.setKey((Comparable)((Object)(phaseName + "#" + phaseSeriesNum)));
                phaseCollection.addSeries(xySeries);
                phaseRenderer.setSeriesPaint(phaseSeriesNum, BodeConfig.colorPhaseList[num % 5]);
                ++phaseSeriesNum;
            }
        }
        return phaseCollection;
    }

    private XYSeries getXYSeries(float[] pointArray, String label) {
        XYSeries xySeries = new XYSeries((Comparable)((Object)label));
        int listSize = pointArray.length;
        for (int i = 1; i < listSize; ++i) {
            xySeries.add((double)BodeResult.getFreqAtIndex(i), (double)pointArray[i]);
        }
        return xySeries;
    }

    private List<XYSeries> getXYSeriesList(List<Point2D.Float> pointsList, String label) {
        ArrayList<XYSeries> xySeriesList = new ArrayList<XYSeries>();
        int listSize = pointsList.size();
        XYSeries xySeries = new XYSeries((Comparable)((Object)label));
        for (int i = 1; i < listSize; ++i) {
            float y2 = pointsList.get((int)i).y;
            float y1 = pointsList.get((int)(i - 1)).y;
            float x = pointsList.get((int)i).x;
            float diff = Math.abs(y2 - y1);
            if ((double)diff > 180.0) {
                if (xySeries.getItemCount() != 0) {
                    xySeriesList.add(xySeries);
                }
                xySeries = new XYSeries((Comparable)((Object)""));
            }
            xySeries.add((double)BodeResult.getFreqAtIndex(x), (double)y2);
        }
        xySeriesList.add(xySeries);
        return xySeriesList;
    }

    private LegendTitle createCustomLegend(LegendItemCollection legendItemCollection) {
        LineLegendItemSource lineLegendItemSource = new LineLegendItemSource(legendItemCollection);
        LegendTitle legendTitle = new LegendTitle((LegendItemSource)lineLegendItemSource);
        legendTitle.setPosition(RectangleEdge.BOTTOM);
        return legendTitle;
    }

    public void plotDataFromFile(String filePath) throws Exception {
        TestDataReaderCSVImpl reader = new TestDataReaderCSVImpl(new FileReader(filePath));
        BodeResult bodeResult = new BodeResult();
        reader.readHeader(bodeResult);
        bodeResult.setName(FileHelper.removeExtention(filePath));
        BodeCalculation bodeCalculation = new BodeCalculation();
        bodeCalculation.calcBode(reader, bodeResult);
        this.addBodeResult(bodeResult);
        if (bodeResult.getSubResultList() != null) {
            for (BodeResult res : bodeResult.getSubResultList()) {
                this.addBodeResult(res);
            }
        }
        this.drawPlot();
    }

    private double snapRangeValue(Rectangle2D dataArea, XYPlot plot, double x, int y_screen, int rangeIndex) {
        double y = plot.getRangeAxis(rangeIndex).java2DToValue((double)y_screen, dataArea, RectangleEdge.LEFT);
        double diff_min = 10.0 / plot.getRangeAxis(rangeIndex).lengthToJava2D(1.0, dataArea, RectangleEdge.LEFT);
        double y_min = y;
        this.crosshairOverlay.selectedSeriesName[rangeIndex] = null;
        XYDataset dataset = plot.getDataset(rangeIndex);
        if (dataset != null) {
            for (int series = 0; series < dataset.getSeriesCount(); ++series) {
                double diff;
                double y2 = DatasetUtilities.findYValue((XYDataset)dataset, (int)series, (double)x);
                if (y2 == Double.NaN || !((diff = Math.abs(y - y2)) < diff_min)) continue;
                y_min = y2;
                diff_min = diff;
                this.crosshairOverlay.selectedSeriesName[rangeIndex] = dataset.getSeriesKey(series).toString();
            }
        }
        return y_min;
    }

    public void chartMouseMoved(ChartMouseEvent event) {
        if (this.chartPanel != null) {
            Rectangle2D dataArea = this.chartPanel.getScreenDataArea();
            JFreeChart chart = event.getChart();
            XYPlot plot = (XYPlot)chart.getPlot();
            double x = plot.getDomainAxis().java2DToValue((double)event.getTrigger().getX(), dataArea, RectangleEdge.BOTTOM);
            double y = this.snapRangeValue(dataArea, plot, x, event.getTrigger().getY(), 0);
            this.xCrosshair.setValue(x);
            this.yCrosshair.setValue(y);
            if (this.isPhaseShown) {
                y = this.snapRangeValue(dataArea, plot, x, event.getTrigger().getY(), 1);
                this.phaseCrosshair.setValue(y);
            }
        }
    }

    public void chartMouseClicked(ChartMouseEvent event) {
    }

    public void optimize() throws Exception {
        int n;
        ArrayList<BodeResult> G_list = new ArrayList<BodeResult>(10);
        int axis = -1;
        Boolean isDataNotchIncluded = null;
        for (BodeResult bodeResult : this.bodeResultList) {
            if (!bodeResult.isPlant()) continue;
            if (axis != -1 && bodeResult.axis != axis) {
                throw new Exception("Please load the plant responses for a single axis only!");
            }
            if ((bodeResult.system & 0x40) == 0) {
                isDataNotchIncluded = true;
            } else {
                if (isDataNotchIncluded != null && isDataNotchIncluded.booleanValue()) {
                    throw new Exception("Can't mix data captured with- and without filters!");
                }
                isDataNotchIncluded = false;
            }
            G_list.add(bodeResult);
            axis = bodeResult.axis;
        }
        if (G_list.isEmpty()) {
            throw new Exception("Please capture the plant response(s) first or load from file(s).");
        }
        if (this.dialogAutoPID2 == null) {
            this.dialogAutoPID2 = new DialogAutoPID2((Frame)SimpleBGC_GUIApp.mainView.getFrame(), true);
        }
        this.dialogAutoPID2.setActiveAxis(axis);
        this.dialogAutoPID2.setTestData(G_list);
        if (this.dialogAutoPID2.showDialog() != 1) {
            return;
        }
        AutoPIDCfg2 cfg = this.dialogAutoPID2.getCurrentConfig();
        for (BodeResult b : G_list) {
            if (!isDataNotchIncluded.booleanValue() || cfg.getNotchTunedNum(axis) <= 0) continue;
            throw new Exception("To be able to tune notch filters, please load test data captured without filters!");
        }
        int n2 = 3;
        BoardProfile p = null;
        if (BoardParams.isLoaded()) {
            n = BoardParams.getCurParams().getPIDControllerVer();
            p = BoardParams.getCurProfile();
        }
        ControllerParams cp_zero = new ControllerParams(n, axis, cfg.freqTo);
        cp_zero.setParamsToTune(this.getParamsToTune(cfg, axis, n));
        if (p != null) {
            this.cp_cur = new ControllerParams(n, axis, cfg.freqTo);
            this.cp_cur.setParamsToTune(this.getParamsToTune(cfg, axis, n));
            this.cp_cur.fillFromProfile(p, isDataNotchIncluded == false);
            if (n != 4) {
                this.cp_cur.setKi(0.0f);
            }
            if (!cp_zero.isParamTuned(5)) {
                cp_zero.setLpfFreq(this.cp_cur.getLpfFreq());
                cp_zero.setLpfQInv(this.cp_cur.getLpfQInv());
            }
            if (!cp_zero.isParamTuned(4)) {
                cp_zero.setDLpfFreq(this.cp_cur.getDLpfFreq());
            }
            for (int idx = 0; idx < 3; ++idx) {
                if (!p.isNotchEnabled(axis, idx) || isDataNotchIncluded.booleanValue() || cfg.getNotchTunedNum(axis) != 0) continue;
                cp_zero.configureNotchFromProfile(p, axis, idx);
            }
        } else {
            this.cp_cur = null;
        }
        BodeResult[] G_arr = !cfg.multiple_systems ? new BodeResult[]{G_list.get(G_list.size() - 1)} : G_list.toArray(new BodeResult[G_list.size()]);
        if (this.controllerOptimizer != null) {
            return;
        }
        this.controllerOptimizer = new ControllerOptimizer(n, G_arr, cfg, axis);
        this.startOptimizeThread(cfg.isStartFromCurrent() && this.cp_cur != null ? this.cp_cur : cp_zero);
    }

    private boolean[] getParamsToTune(AutoPIDCfg2 cfg, int axis, int ctrlVer) {
        boolean[] is_tuned = new boolean[16];
        for (int i = 0; i < 16; ++i) {
            is_tuned[i] = false;
            if (cfg.isGainOnly()) {
                if (i != 3) continue;
                is_tuned[i] = true;
                continue;
            }
            if (i <= 2) {
                is_tuned[i] = ctrlVer == 4 || i != 1;
                continue;
            }
            if (i >= 4 && i <= 6) {
                is_tuned[i] = cfg.isTuneLPF(axis);
                if (i != 6 || ctrlVer != 1) continue;
                is_tuned[i] = false;
                continue;
            }
            if (i < 7 || i > 15) continue;
            int idx = ControllerParams.getNotchIdx(i);
            is_tuned[i] = cfg.isTuneNotch(axis, idx);
        }
        return is_tuned;
    }

    public void startOptimizeThread(final ControllerParams optimizedParams) throws Exception {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SimpleBGC_GUIView progressListener = SimpleBGC_GUIApp.mainView;
                progressListener.onProgressStart("Processing optimization..", true);
                try {
                    float cost_best = BodePlotJPanel.this.controllerOptimizer.optimize(optimizedParams, progressListener);
                    for (int idx = 0; idx < 3; ++idx) {
                        if (!optimizedParams.isNotchTuned(idx)) continue;
                        float gain = optimizedParams.getNotchGain(idx);
                        optimizedParams.setNotchGain(idx, 0.0f);
                        float cost2 = BodePlotJPanel.this.controllerOptimizer.cost_function(optimizedParams, 0.0f);
                        if (cost2 - cost_best > 0.02f * (Math.abs(cost_best) + Math.abs(cost2))) {
                            optimizedParams.setNotchGain(idx, gain);
                            continue;
                        }
                        logger.debug(String.format("Disable notch#%d as not effective: on %.4f / off %.4f", idx + 1, Float.valueOf(cost_best), Float.valueOf(cost2)));
                        cost_best = cost2;
                    }
                    optimizedParams.sortNotchByFreq();
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            if (BodePlotJPanel.this.controllerOptimizer.cfg.show_response != 0) {
                                Complex[] C_cur = null;
                                if (BodePlotJPanel.this.cp_cur != null) {
                                    C_cur = BodePlotJPanel.this.controllerOptimizer.getControllerResp(BodePlotJPanel.this.cp_cur);
                                }
                                Complex[] C = BodePlotJPanel.this.controllerOptimizer.getControllerResp(optimizedParams);
                                for (int i = 0; i < BodePlotJPanel.this.controllerOptimizer.getBodeResultArr().length; ++i) {
                                    BodeResult b = BodePlotJPanel.this.controllerOptimizer.getBodeResultArr()[i].clone();
                                    Complex[] GC = BodePlotJPanel.this.controllerOptimizer.applyController(i, C, optimizedParams.getExtraGain());
                                    b.startFreq = BodePlotJPanel.this.controllerOptimizer.startFreq;
                                    if (i == 0 && (BodePlotJPanel.this.controllerOptimizer.cfg.show_response & 4) > 0) {
                                        b.setResponseAtFreq(C, BodePlotJPanel.this.controllerOptimizer.freqLUT);
                                        b.setName("C_new");
                                        b.system = 3;
                                        BodePlotJPanel.this.addBodeResult(b);
                                        b = b.clone();
                                    }
                                    if ((BodePlotJPanel.this.controllerOptimizer.cfg.show_response & 1) > 0) {
                                        b.setResponseAtFreq(GC, BodePlotJPanel.this.controllerOptimizer.freqLUT);
                                        b.setName("GC" + (i + 1) + "_new");
                                        b.system = 7;
                                        BodePlotJPanel.this.addBodeResult(b);
                                        b = b.clone();
                                    }
                                    if (i == 0 && (BodePlotJPanel.this.controllerOptimizer.cfg.show_response & 8) > 0 && C_cur != null) {
                                        b.setResponseAtFreq(C_cur, BodePlotJPanel.this.controllerOptimizer.freqLUT);
                                        b.setName("C_old");
                                        b.system = 3;
                                        BodePlotJPanel.this.addBodeResult(b);
                                        b = b.clone();
                                    }
                                    if ((BodePlotJPanel.this.controllerOptimizer.cfg.show_response & 2) <= 0 || C_cur == null || BodePlotJPanel.this.cp_cur == null) continue;
                                    Complex[] GC_cur = BodePlotJPanel.this.controllerOptimizer.applyController(i, C_cur, BodePlotJPanel.this.cp_cur.getExtraGain());
                                    b.setResponseAtFreq(GC_cur, BodePlotJPanel.this.controllerOptimizer.freqLUT);
                                    b.setName("GC" + (i + 1) + "_old");
                                    b.system = 7;
                                    BodePlotJPanel.this.addBodeResult(b);
                                    b = b.clone();
                                }
                                BodePlotJPanel.this.drawPlot();
                            }
                            logger.info("Optimized parameters (v" + optimizedParams.version + "): " + optimizedParams.toParamsString());
                            if (BodePlotJPanel.this.panelAnalyze != null) {
                                BodePlotJPanel.this.panelAnalyze.setOptimizedParams(optimizedParams);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    logger.stackTrace(e);
                    SimpleBGC_GUIApp.mainView.showErrorMessage("Optimization failed: " + e.getMessage());
                }
                finally {
                    progressListener.onProgressFinish(true);
                    BodePlotJPanel.this.controllerOptimizer = null;
                    logger.debug("Optimization finished");
                }
            }
        }).start();
    }

    private class LineLegendItemSource
    implements LegendItemSource {
        private LegendItemCollection legendItemCollection;

        public LineLegendItemSource(LegendItemCollection legendItemCollection) {
            this.legendItemCollection = legendItemCollection;
        }

        public LegendItemCollection getLegendItems() {
            return this.legendItemCollection;
        }
    }
}

