/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui;

class Expo {
    public final int max_in;
    public final int max_out;
    public float rate;
    public int deadband;
    public float k1;
    public float k3;

    public Expo(int max_in, int max_out) {
        this.max_in = max_in;
        this.max_out = max_out;
    }

    public void setRate(int rate) {
        this.rate = Expo.constrain(rate, 0, 100);
        this.update();
    }

    public void setDeadband(int deadband) {
        this.deadband = deadband;
        this.update();
    }

    public void update() {
        this.k3 = this.rate / (100.0f * (float)this.max_in * (float)this.max_in * (float)this.max_in) * (float)this.max_out;
        this.k1 = (100.0f - this.rate) / 100.0f * (float)this.max_out / (float)this.max_in;
    }

    public float calculate(float x) {
        if (this.k3 == 0.0f || x == 0.0f) {
            return x;
        }
        return x * x * x * this.k3 + x * this.k1;
    }

    static int constrain(int val, int min, int max) {
        return val < min ? min : (val > max ? max : val);
    }
}

