/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui;

import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import sbgc.object.BoardInfo;
import sbgc.ui.IGroupView;
import sbgc.ui.ITabbedPanel;
import sbgc.utils.Log;
import sbgc.utils.OrderedProperties;
import sbgc.utils.Settings;

public class GroupView
implements IGroupView {
    public static String MENU_NAME_PREFIX = "menu";
    public final VIEW minViewLevel;
    public final int minFrwVer;
    public final long hasBoardFeature;
    public final long noBoardFeature;
    private static VIEW curView = VIEW.DEVELOPER;
    private static final HashMap<String, GroupView> groups = new HashMap();
    private static final Log logger;
    public static final String COMPONENT_VIEW_LEVELS_FILE_NAME = "view_level.properties";
    public static String componentViewLevelsFilePath;
    public static final OrderedProperties componentViewLevels;
    private static final Class[] restrictedClasses;

    private GroupView(VIEW minViewLevel) {
        this(minViewLevel, 0, 0L, 0L);
    }

    private GroupView(VIEW minViewLevel, int minFrwVer, long hasBoardFeature, long noBoardFeature) {
        this.minViewLevel = minViewLevel;
        this.minFrwVer = minFrwVer;
        this.hasBoardFeature = hasBoardFeature;
        this.noBoardFeature = noBoardFeature;
    }

    @Override
    public boolean checkBoard() {
        return !(this.minFrwVer != 0 && (BoardInfo.getBoardInfo() == null || !BoardInfo.checkMinBaseFirmwareVer(this.minFrwVer)) || this.hasBoardFeature != 0L && !BoardInfo.hasBoardFeature(this.hasBoardFeature) || this.noBoardFeature != 0L && BoardInfo.hasBoardFeature(this.noBoardFeature));
    }

    private static boolean isComponentRestrictChecked(Component component) {
        boolean restricted = false;
        for (Class c : restrictedClasses) {
            if (!c.isInstance(component)) continue;
            restricted = component.getName() != null;
            return restricted;
        }
        return restricted;
    }

    private static String getComponentAlias(Component c, ITabbedPanel tabbedPanel) {
        Container parent = null;
        String result = "";
        if (tabbedPanel != null) {
            result = tabbedPanel.getName() + "." + c.getName();
        } else if (c instanceof ITabbedPanel) {
            result = c.getName();
        } else if (c instanceof JMenuItem) {
            result = c.getName();
        } else {
            parent = c.getParent();
            if (parent != null) {
                result = c.getName() != null && c.getName().startsWith("group") ? GroupView.getComponentAlias(parent, null) + "." + c.getName() : (GroupView.isComponentRestrictChecked(c) ? GroupView.getComponentAlias(parent, null) + "." + c.getName() : GroupView.getComponentAlias(parent, null));
            }
        }
        return result;
    }

    private static String getComponentAlias(Component c) {
        return GroupView.getComponentAlias(c, null);
    }

    public static boolean canShowGroup(Component component, ITabbedPanel tabbedPanel, boolean checkBoard) {
        String componentAliasViewLevel = GroupView.getComponentAlias(component, tabbedPanel) + ".viewLevel";
        boolean res = true;
        Integer groupMinViewLevel = null;
        GroupView gStatic = groups.get(component.getName());
        if (gStatic != null) {
            groupMinViewLevel = gStatic.minViewLevel.ordinal();
        }
        if (componentViewLevels.containsKey(componentAliasViewLevel)) {
            String viewLevelAsString = (String)componentViewLevels.get(componentAliasViewLevel);
            try {
                groupMinViewLevel = VIEW.valueOf(viewLevelAsString).ordinal();
            }
            catch (IllegalArgumentException e) {
                logger.error("Invalid view level ({0}) for \"{1}\"", new Object[]{viewLevelAsString, componentAliasViewLevel});
            }
        } else if (componentAliasViewLevel.toLowerCase().indexOf(MENU_NAME_PREFIX) == -1) {
            logger.warn("No view level property for \"{0}\"!", new Object[]{componentAliasViewLevel});
        }
        if (groupMinViewLevel != null) {
            res = false;
            if (curView.ordinal() >= groupMinViewLevel) {
                res = true;
                if (checkBoard && gStatic != null) {
                    res = gStatic.checkBoard();
                }
            }
        }
        return res;
    }

    public static boolean canShowGroup(Component component) {
        return GroupView.canShowGroup(component, null, true);
    }

    public static VIEW getCurViewLevel() {
        return curView;
    }

    public static void setCurViewLevel(VIEW curView) {
        GroupView.curView = curView;
    }

    public static GroupView getGroupView(String groupName) {
        GroupView groupView = null;
        groupView = groups.get(groupName);
        return groupView;
    }

    public static void updateComponentViewLevelsPropertiesFile(ITabbedPanel[] tabbedPanels) {
        GroupView.loadComponentViewLevels();
        HashSet<String> loadedComponentAliases = new HashSet<String>();
        for (Object componentAlias : componentViewLevels.keySet()) {
            loadedComponentAliases.add((String)componentAlias);
        }
        HashSet<String> currentComponentAliases = new HashSet<String>();
        int appended = 0;
        for (ITabbedPanel tabbedPanel : tabbedPanels) {
            for (Component group : tabbedPanel.getGroups()) {
                String componentViewLevelAlias;
                String groupAlias = tabbedPanel.getName() + "." + group.getName();
                String groupViewLevel = VIEW.DEVELOPER.name();
                GroupView groupView = null;
                groupView = GroupView.getGroupView(group.getName());
                if (groupView != null) {
                    groupViewLevel = groupView.minViewLevel.name();
                }
                if (!componentViewLevels.containsKey(componentViewLevelAlias = groupAlias + ".viewLevel")) {
                    ++appended;
                    componentViewLevels.put(componentViewLevelAlias, groupViewLevel);
                }
                currentComponentAliases.add(componentViewLevelAlias);
                appended += GroupView.updateViewLevelOfChildComponents(group, groupAlias, currentComponentAliases);
            }
        }
        logger.trace("Updated component view levels: {0}", new Object[]{new Integer(appended)});
        logger.trace("Removing unused component aliases...");
        int removed = 0;
        for (String componentAlias : loadedComponentAliases) {
            if (currentComponentAliases.contains(componentAlias)) continue;
            ++removed;
            componentViewLevels.remove(componentAlias);
        }
        logger.trace("Removed: {0}", new Object[]{new Integer(removed)});
        GroupView.saveComponentViewLevels();
    }

    private static int updateViewLevelOfChildComponents(Component parent, String prefix, HashSet<String> currentComponentAliases) {
        int appended = 0;
        if (GroupView.isComponentRestrictChecked(parent)) {
            String componentViewLevelAlias = prefix + "." + parent.getName() + ".viewLevel";
            if (!componentViewLevels.containsKey(componentViewLevelAlias)) {
                componentViewLevels.put(componentViewLevelAlias, "GROUP");
                ++appended;
            }
            currentComponentAliases.add(componentViewLevelAlias);
        } else if (parent instanceof Container) {
            for (Component child : ((Container)parent).getComponents()) {
                appended += GroupView.updateViewLevelOfChildComponents(child, prefix, currentComponentAliases);
            }
        }
        return appended;
    }

    private static void loadComponentViewLevels() {
        logger.trace("Loading component view levels of \"{0}\"...", new Object[]{GroupView.getComponentViewLevelsFilePath()});
        try {
            componentViewLevels.load(new FileInputStream(GroupView.getComponentViewLevelsFilePath()));
            logger.trace("Component view levels loaded: {0}", new Object[]{new Integer(componentViewLevels.keySet().size())});
        }
        catch (FileNotFoundException fnfe) {
            logger.warn("File doesn't exist.");
        }
        catch (IOException e) {
            logger.error("Error loading properties file \"{0}\": {1}", new Object[]{GroupView.getComponentViewLevelsFilePath(), e.toString()});
        }
    }

    private static void saveComponentViewLevels() {
        logger.trace("Resaving component view levels at \"{0}\"...", new Object[]{GroupView.getComponentViewLevelsFilePath()});
        try {
            componentViewLevels.store(new FileOutputStream(GroupView.getComponentViewLevelsFilePath()), "component alias = it's view level");
            logger.trace("Component view levels resaved: {0}", new Object[]{new Integer(componentViewLevels.keySet().size())});
        }
        catch (IOException e) {
            logger.error("Error saving component view levels at file \"{0}\": {1}", new Object[]{GroupView.getComponentViewLevelsFilePath(), e.toString()});
        }
    }

    private static String getComponentViewLevelsFilePath() {
        if (componentViewLevelsFilePath == null) {
            try {
                componentViewLevelsFilePath = Settings.getPropertiesFileName(COMPONENT_VIEW_LEVELS_FILE_NAME, true);
            }
            catch (Exception e) {
                logger.error("Error constructing component view levels file path: " + e.toString());
            }
        }
        return componentViewLevelsFilePath;
    }

    private static void removeComponentEnabledPropertyChangeListeners(Component component) {
        PropertyChangeListener[] listeners;
        for (PropertyChangeListener listener : listeners = component.getPropertyChangeListeners()) {
            component.removePropertyChangeListener(listener);
        }
    }

    public static boolean isComponentEnabled(Component component) {
        String componentViewLevelString;
        String componentViewLevelAlias;
        if (GroupView.isComponentRestrictChecked(component) && componentViewLevels.containsKey(componentViewLevelAlias = GroupView.getComponentAlias(component) + ".viewLevel") && !"GROUP".equals(componentViewLevelString = (String)componentViewLevels.get(componentViewLevelAlias))) {
            try {
                return curView.ordinal() >= VIEW.valueOf(componentViewLevelString).ordinal();
            }
            catch (IllegalArgumentException e) {
                logger.error("Invalid view level ({0}) of \"{1}\"!", new Object[]{componentViewLevelString, componentViewLevelAlias});
            }
        }
        return true;
    }

    public static void processComponentChildsViewLevel(Component component) {
        block13: {
            if (GroupView.isComponentRestrictChecked(component)) {
                String componentViewLevelAlias = GroupView.getComponentAlias(component) + ".viewLevel";
                if (componentViewLevels.containsKey(componentViewLevelAlias)) {
                    try {
                        String componentViewLevelString = (String)componentViewLevels.get(componentViewLevelAlias);
                        if ("GROUP".equals(componentViewLevelString)) break block13;
                        boolean enabled = true;
                        try {
                            enabled = curView.ordinal() >= VIEW.valueOf(componentViewLevelString).ordinal();
                        }
                        catch (IllegalArgumentException e) {
                            logger.error("Invalid view level ({0}) of \"{1}\"!", new Object[]{componentViewLevelString, componentViewLevelAlias});
                        }
                        if (!enabled) {
                            if (component.isEnabled()) {
                                component.setEnabled(false);
                            }
                            component.addPropertyChangeListener("enabled", new PropertyChangeListener(){

                                @Override
                                public void propertyChange(PropertyChangeEvent evt) {
                                    if (evt.getSource() instanceof Component) {
                                        Component source = (Component)evt.getSource();
                                        if (evt.getNewValue() instanceof Boolean && ((Boolean)evt.getNewValue()).booleanValue()) {
                                            ((Component)evt.getSource()).setEnabled(false);
                                        }
                                    }
                                }
                            });
                        } else {
                            GroupView.removeComponentEnabledPropertyChangeListeners(component);
                            if (!component.isEnabled()) {
                                component.setEnabled(true);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error checking view level for \"{0}\": {1}", new Object[]{componentViewLevelAlias, e.toString()});
                    }
                }
            } else if (component instanceof Container) {
                for (Component child : ((Container)component).getComponents()) {
                    GroupView.processComponentChildsViewLevel(child);
                }
            }
        }
    }

    static {
        groups.put("groupPIDController", new GroupView(VIEW.ADVANCED));
        groups.put("groupAdvancedGains", new GroupView(VIEW.EXPERT, 2673, 0L, 0L));
        groups.put("groupServoMode", new GroupView(VIEW.EXPERT, 2736, 0x20000000L, 0L));
        groups.put("groupPIDAdaptive", new GroupView(VIEW.EXPERT));
        groups.put("groupFiltersNotch", new GroupView(VIEW.EXPERT, 2420, 0L, 0L));
        groups.put("groupFiltersLPF", new GroupView(VIEW.EXPERT, 2420, 0L, 0L));
        groups.put("groupMomentumSettings", new GroupView(VIEW.EXPERT, 0, 2048L, 0L));
        groups.put("groupMomentumCalibrate", new GroupView(VIEW.BASIC, 0, 2048L, 0L));
        groups.put("groupCoggingCorrection", new GroupView(VIEW.EXPERT, 0, 4096L, 0L));
        groups.put("groupStabAxes", new GroupView(VIEW.EXPERT, 2627, 0L, 0L));
        groups.put("groupFrameIMUFF", new GroupView(VIEW.ADVANCED, 9999, 0L, 0L));
        groups.put("groupMotorConfig", new GroupView(VIEW.DEVELOPER));
        groups.put("groupHardwareMiscDev", new GroupView(VIEW.DEVELOPER));
        groups.put("groupMotorPower", new GroupView(VIEW.EXPERT));
        groups.put("groupSensorCfgMain", new GroupView(VIEW.DEVELOPER));
        groups.put("groupCAN_IMU", new GroupView(VIEW.DEVELOPER, 0, 1024L, 0L));
        groups.put("groupSensorCfgFrame", new GroupView(VIEW.DEVELOPER));
        groups.put("groupSensorCalibrate", new GroupView(VIEW.ADVANCED));
        groups.put("groupSensorSettings", new GroupView(VIEW.EXPERT));
        groups.put("groupTripodMode", new GroupView(VIEW.ADVANCED));
        groups.put("groupIMUState", new GroupView(VIEW.EXPERT));
        groups.put("groupMagnetometerCfg", new GroupView(VIEW.DEVELOPER, 0, 64L, 0L));
        groups.put("groupMagnetometerSettings", new GroupView(VIEW.EXPERT, 0, 64L, 0L));
        groups.put("groupSerialConnection", new GroupView(VIEW.EXPERT));
        groups.put("groupPowerManagement", new GroupView(VIEW.ADVANCED){

            @Override
            public boolean checkBoard() {
                return BoardInfo.hasBoardFeature(524288L) || BoardInfo.hasBoardFeature(0x4000000000L);
            }
        });
        groups.put("groupSyncMotors", new GroupView(VIEW.ADVANCED, 2709, 0L, 0L));
        groups.put("groupGeometry", new GroupView(VIEW.DEVELOPER, 0, 0x80000000L, 0L));
        groups.put("groupRCSignalState", new GroupView(VIEW.BASIC));
        groups.put("groupRCInputConfig", new GroupView(VIEW.ADVANCED));
        groups.put("groupRCCommandAssignment", new GroupView(VIEW.BASIC));
        groups.put("groupRCMode", new GroupView(VIEW.BASIC));
        groups.put("groupRCSettings", new GroupView(VIEW.BASIC));
        groups.put("groupRCTrim", new GroupView(VIEW.BASIC));
        groups.put("groupPWMBypass", new GroupView(VIEW.ADVANCED));
        groups.put("groupStepSignal", new GroupView(VIEW.ADVANCED, 2653, 0L, 0L));
        groups.put("groupCanImuServo", new GroupView(VIEW.ADVANCED, 2735, 1024L, 0L));
        groups.put("groupServiceStartup", new GroupView(VIEW.BASIC));
        groups.put("groupWorkingPositions", new GroupView(VIEW.ADVANCED));
        groups.put("groupMenuButton", new GroupView(VIEW.BASIC));
        groups.put("groupBatteryMonitoring", new GroupView(VIEW.EXPERT));
        groups.put("groupCurrentSensor", new GroupView(VIEW.EXPERT, 2697, 32L, 0L));
        groups.put("groupBuzzer", new GroupView(VIEW.ADVANCED));
        groups.put("groupCustomMelodies", new GroupView(VIEW.ADVANCED, 2668, 0L, 0L));
        groups.put("groupAutoMotion", new GroupView(VIEW.ADVANCED));
        groups.put("groupRetractedPosition", new GroupView(VIEW.ADVANCED, 0, 0x40000000L, 0L));
        groups.put("groupProfileSets", new GroupView(VIEW.ADVANCED, 2650, 0L, 0L));
        groups.put("groupTimelapse", new GroupView(VIEW.ADVANCED));
        groups.put("groupServiceMisc", new GroupView(VIEW.ADVANCED));
        groups.put("groupStartupAction", new GroupView(VIEW.EXPERT, 2650, 0L, 0L));
        groups.put("groupForce", new GroupView(VIEW.ADVANCED, 0, 0L, 0L));
        groups.put("groupExtraButtons", new GroupView(VIEW.EXPERT, 2684, 0L, 0L));
        groups.put("groupSystemStat", new GroupView(VIEW.ADVANCED, 2687, 262144L, 0L));
        groups.put("groupFiles", new GroupView(VIEW.DEVELOPER, 2701, -1L, 0L));
        groups.put("groupSerialLink", new GroupView(VIEW.DEVELOPER, 0, 0x4000000L, 0L));
        groups.put("groupShakeGenerator", new GroupView(VIEW.BASIC, 0, 0x200000000L, 0L));
        groups.put("groupPasswordProtection", new GroupView(VIEW.ADVANCED, 2735, 0L, 0L));
        groups.put("groupFollowActivation", new GroupView(VIEW.BASIC));
        groups.put("groupFollowConfigBasic", new GroupView(VIEW.BASIC));
        groups.put("groupFollowConfigAdvanced", new GroupView(VIEW.ADVANCED));
        groups.put("groupAdjVarsTrigger", new GroupView(VIEW.ADVANCED, 2430, 0L, 0L));
        groups.put("groupAdjVarsAnalog", new GroupView(VIEW.ADVANCED, 2430, 0L, 0L));
        groups.put("groupAdjVarsLUT", new GroupView(VIEW.EXPERT, 2625, 0L, 0L));
        groups.put("groupEncodersHardware", new GroupView(VIEW.DEVELOPER, 0, 4L, 0L));
        groups.put("groupEncodersCalibration", new GroupView(VIEW.EXPERT, 0, 4L, 0L));
        groups.put("groupEncodersAdvancedCalib", new GroupView(VIEW.EXPERT, 0, 0x800000L, 0L));
        groups.put("groupEncodersSettings", new GroupView(VIEW.EXPERT, 0, 4L, 0L));
        groups.put("groupEncodersHeatingModel", new GroupView(VIEW.DEVELOPER, 0, 4L, 0L));
        groups.put("groupEncodersYAW", new GroupView(VIEW.DEVELOPER, 2550, 0L, 4L));
        groups.put("groupAssignDeviceId", new GroupView(VIEW.DEVELOPER, 2650, 1024L, 0L));
        groups.put("groupCANDrvHardParams", new GroupView(VIEW.DEVELOPER, 2650, 1024L, 0L));
        groups.put("groupCANDrvSoftParams", new GroupView(VIEW.EXPERT, 2650, 1024L, 0L));
        groups.put("groupExtIMU", new GroupView(VIEW.EXPERT, 2664, 65536L, 0L));
        groups.put("groupExtConnOptions", new GroupView(VIEW.EXPERT, 2593, 0L, 0L));
        groups.put("groupMavLink", new GroupView(VIEW.EXPERT, 2593, 0L, 0L));
        groups.put("groupAnalyze", new GroupView(VIEW.EXPERT, 0, 0L, 0L));
        groups.put("groupOptimizer", new GroupView(VIEW.EXPERT, 0, 0L, 0L));
        groups.put("groupFirmwareUpdate", new GroupView(VIEW.UPGRADE));
        groups.put("groupScripting", new GroupView(VIEW.ADVANCED));
        groups.put("groupDebug", new GroupView(VIEW.EXPERT));
        groups.put("groupMonitoring", new GroupView(VIEW.ADVANCED));
        groups.put("sensorMenu", new GroupView(VIEW.ADVANCED));
        groups.put("menuCalibAcc", new GroupView(VIEW.ADVANCED));
        groups.put("menuCalibGyro", new GroupView(VIEW.ADVANCED));
        groups.put("menuCalibrateHelper", new GroupView(VIEW.ADVANCED));
        groups.put("menuCalibAccTemp", new GroupView(VIEW.EXPERT));
        groups.put("menuCalibGyroTemp", new GroupView(VIEW.EXPERT));
        groups.put("menuEraseEEPROM", new GroupView(VIEW.EXPERT));
        groups.put("menuBackupIMUCalib", new GroupView(VIEW.ADVANCED));
        groups.put("menuRestoreIMUCalib", new GroupView(VIEW.ADVANCED));
        groups.put("menuConfigureBluetooth", new GroupView(VIEW.ADVANCED));
        groups.put("menuExecuteAction", new GroupView(VIEW.ADVANCED));
        groups.put("groupMotor4HW", new GroupView(VIEW.DEVELOPER, 0, 8192L, 0L));
        groups.put("groupMotor4SW", new GroupView(VIEW.ADVANCED, 0, 8192L, 0L));
        groups.put("groupReaction", new GroupView(VIEW.DEVELOPER, 0, 0x400000L, 0L));
        groups.put("groupExtMotors", new GroupView(VIEW.DEVELOPER, 0, 0x400000000L, 0L));
        groups.put("groupScreenJoystick", new GroupView(VIEW.BASIC));
        groups.put("groupGamepadValues", new GroupView(VIEW.BASIC));
        groups.put("groupGamepadConfig", new GroupView(VIEW.BASIC));
        logger = new Log(Logger.getLogger((String)GroupView.class.getName()));
        componentViewLevelsFilePath = null;
        componentViewLevels = new OrderedProperties();
        restrictedClasses = new Class[]{JLabel.class, JSpinner.class, JTextField.class, JComboBox.class, JCheckBox.class, JButton.class, JRadioButton.class};
    }

    public static enum VIEW {
        UPGRADE,
        BASIC,
        ADVANCED,
        EXPERT,
        DEVELOPER,
        HIDE;

    }
}

