/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import sbgc.adj_var_parser.AdjVarData;
import sbgc.adj_var_parser.AdjVarParseException;
import sbgc.adj_var_parser.AdjVarParser;
import sbgc.adj_var_parser.AdjVarSource;
import sbgc.object.AdjVarAnalogCfg;
import sbgc.object.AdjVarTriggerCfg;
import sbgc.object.BoardInfo;
import sbgc.object.BoardParams;
import sbgc.object.RealtimeData;
import sbgc.object.Sprav;
import sbgc.ui.EditorJTextPane;
import sbgc.ui.ITabbedPanel;
import sbgc.ui.ParamsUIFactory;
import sbgc.ui.RCDataPanel;
import sbgc.ui.SpravComboBoxModel;
import sbgc.ui.TabbedPanelBase;
import simplebgc_gui.ScriptHighlighter;
import simplebgc_gui.SimpleBGC_GUIApp;
import simplebgc_gui.SimpleBGC_GUIView;

public class JPanelAdjVars
extends TabbedPanelBase
implements ITabbedPanel {
    private RCDataPanel triggerSignalPanel;
    private RCDataPanel analogSignalPanel;
    private JComboBox[] comboBoxTriggerAction = null;
    private AdjVarTriggerCfg[] adj_vars_trigger = null;
    private AdjVarAnalogCfg[] adj_vars_analog = null;
    public int trigger_cur_slot = 0;
    public int analog_cur_slot = 0;
    public AdjVarAnalogCfg selectedVar = null;
    public int showLUTSignalId = 0;
    public int showLUTVarId = 0;
    private boolean updateControlsMode = false;
    private Color normalBackgroundColor = null;
    private ButtonGroup buttonGroupAnalogType;
    private JPanel groupAdjVarsAnalog;
    private JPanel groupAdjVarsLUT;
    private JPanel groupAdjVarsTrigger;
    private JButton jButtonAdjVarLUTValidate;
    private JComboBox jComboBoxAnalogAdjVar;
    private JComboBox jComboBoxAnalogEditSlot;
    private JComboBox jComboBoxAnalogSrc;
    private JComboBox jComboBoxLUTSignalShow;
    private JComboBox jComboBoxLUTVarShow;
    private JComboBox jComboBoxTriggerAct1;
    private JComboBox jComboBoxTriggerAct2;
    private JComboBox jComboBoxTriggerAct3;
    private JComboBox jComboBoxTriggerAct4;
    private JComboBox jComboBoxTriggerAct5;
    private JComboBox jComboBoxTriggerEditSlot;
    private JComboBox jComboBoxTriggerSrc;
    private JLabel jLabelActiveAction;
    private JLabel jLabelAdjVarMax;
    private JLabel jLabelAdjVarMin;
    private JLabel jLabelAnalogChannelEdit;
    private JLabel jLabelAnalogCurVal;
    private JLabel jLabelAnalogCurValueLabel;
    private JLabel jLabelAnalogSource;
    private JLabel jLabelAnalogVariable;
    private JLabel jLabelLUTShowSignal;
    private JLabel jLabelLUTShowSignalVal;
    private JLabel jLabelLUTShowVarVal;
    private JLabel jLabelLUTStatus;
    private JLabel jLabelLUTVarShow;
    private JLabel jLabelTriggerActions;
    private JLabel jLabelTriggerActiveAction;
    private JLabel jLabelTriggerChannelEdit;
    private JLabel jLabelTriggerSource;
    private JPanel jPanel1;
    private JPanel jPanelAnalogSignal;
    private JPanel jPanelTriggerSignal;
    private JRadioButton jRadioButtonAnalogTypeAbs;
    private JRadioButton jRadioButtonAnalogTypeMult;
    private JScrollPane jScrollPane1;
    private JSlider jSliderAdjVarMax;
    private JSlider jSliderAdjVarMin;
    private JTextPane jTextPaneAdjVarLUT;

    public JPanelAdjVars(SimpleBGC_GUIView mainView) {
        super(mainView);
        this.initComponents();
        this.prepareLayout();
        this.triggerSignalPanel = new RCDataPanel(null);
        this.triggerSignalPanel.setMin(-500.0f);
        this.triggerSignalPanel.setMax(500.0f);
        for (int i = -300; i < 500; i += 200) {
            this.triggerSignalPanel.addMarker(i);
        }
        this.jPanelTriggerSignal.add(this.triggerSignalPanel);
        this.analogSignalPanel = new RCDataPanel(null);
        this.analogSignalPanel.setMin(-500.0f);
        this.analogSignalPanel.setMax(500.0f);
        this.jPanelAnalogSignal.add(this.analogSignalPanel);
        this.comboBoxTriggerAction = new JComboBox[]{this.jComboBoxTriggerAct1, this.jComboBoxTriggerAct2, this.jComboBoxTriggerAct3, this.jComboBoxTriggerAct4, this.jComboBoxTriggerAct5};
        this.normalBackgroundColor = this.jLabelLUTStatus.getBackground();
        this.updateControls();
    }

    private void initComponents() {
        this.buttonGroupAnalogType = new ButtonGroup();
        this.groupAdjVarsTrigger = new JPanel();
        this.jLabelTriggerActions = new JLabel();
        this.jComboBoxTriggerSrc = new JComboBox();
        this.jLabelTriggerSource = new JLabel();
        this.jComboBoxTriggerAct1 = new JComboBox();
        this.jComboBoxTriggerAct2 = new JComboBox();
        this.jComboBoxTriggerAct3 = new JComboBox();
        this.jComboBoxTriggerAct4 = new JComboBox();
        this.jComboBoxTriggerAct5 = new JComboBox();
        this.jLabelTriggerChannelEdit = new JLabel();
        this.jComboBoxTriggerEditSlot = new JComboBox();
        this.jPanelTriggerSignal = new JPanel();
        this.jLabelActiveAction = new JLabel();
        this.jLabelTriggerActiveAction = new JLabel();
        this.groupAdjVarsAnalog = new JPanel();
        this.jComboBoxAnalogSrc = new JComboBox();
        this.jLabelAnalogSource = new JLabel();
        this.jLabelAnalogChannelEdit = new JLabel();
        this.jComboBoxAnalogEditSlot = new JComboBox();
        this.jLabelAnalogVariable = new JLabel();
        this.jComboBoxAnalogAdjVar = new JComboBox();
        this.jLabelAdjVarMin = new JLabel();
        this.jSliderAdjVarMin = new JSlider();
        this.jLabelAdjVarMax = new JLabel();
        this.jSliderAdjVarMax = new JSlider();
        this.jPanelAnalogSignal = new JPanel();
        this.jLabelAnalogCurValueLabel = new JLabel();
        this.jLabelAnalogCurVal = new JLabel();
        this.jRadioButtonAnalogTypeAbs = new JRadioButton();
        this.jRadioButtonAnalogTypeMult = new JRadioButton();
        this.groupAdjVarsLUT = new JPanel();
        this.jButtonAdjVarLUTValidate = new JButton();
        this.jLabelLUTStatus = new JLabel();
        this.jLabelLUTVarShow = new JLabel();
        this.jComboBoxLUTVarShow = new JComboBox();
        this.jLabelLUTShowVarVal = new JLabel();
        this.jLabelLUTShowSignal = new JLabel();
        this.jComboBoxLUTSignalShow = new JComboBox();
        this.jLabelLUTShowSignalVal = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jTextPaneAdjVarLUT = new EditorJTextPane();
        this.setName("AdjVars");
        this.setLayout(null);
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(JPanelAdjVars.class);
        this.groupAdjVarsTrigger.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("groupAdjVarsTrigger.border.title", new Object[0])));
        this.groupAdjVarsTrigger.setName("groupAdjVarsTrigger");
        this.groupAdjVarsTrigger.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabelTriggerActions.setText(resourceMap.getString("jLabelTriggerActions.text", new Object[0]));
        this.jLabelTriggerActions.setName("jLabelTriggerActions");
        this.groupAdjVarsTrigger.add((Component)this.jLabelTriggerActions, new AbsoluteConstraints(400, 20, -1, -1));
        this.jComboBoxTriggerSrc.setName("jComboBoxTriggerSrc");
        this.groupAdjVarsTrigger.add((Component)this.jComboBoxTriggerSrc, new AbsoluteConstraints(180, 40, 200, -1));
        this.jLabelTriggerSource.setText(resourceMap.getString("jLabelTriggerSource.text", new Object[0]));
        this.jLabelTriggerSource.setName("jLabelTriggerSource");
        this.groupAdjVarsTrigger.add((Component)this.jLabelTriggerSource, new AbsoluteConstraints(180, 20, -1, -1));
        this.jComboBoxTriggerAct1.setName("jComboBoxTriggerAct1");
        this.groupAdjVarsTrigger.add((Component)this.jComboBoxTriggerAct1, new AbsoluteConstraints(400, 40, 290, -1));
        this.jComboBoxTriggerAct2.setName("jComboBoxTriggerAct2");
        this.groupAdjVarsTrigger.add((Component)this.jComboBoxTriggerAct2, new AbsoluteConstraints(400, 65, 290, -1));
        this.jComboBoxTriggerAct3.setName("jComboBoxTriggerAct3");
        this.groupAdjVarsTrigger.add((Component)this.jComboBoxTriggerAct3, new AbsoluteConstraints(400, 90, 290, -1));
        this.jComboBoxTriggerAct4.setName("jComboBoxTriggerAct4");
        this.groupAdjVarsTrigger.add((Component)this.jComboBoxTriggerAct4, new AbsoluteConstraints(400, 115, 290, -1));
        this.jComboBoxTriggerAct5.setName("jComboBoxTriggerAct5");
        this.groupAdjVarsTrigger.add((Component)this.jComboBoxTriggerAct5, new AbsoluteConstraints(400, 140, 290, -1));
        this.jLabelTriggerChannelEdit.setText(resourceMap.getString("jLabelTriggerChannelEdit.text", new Object[0]));
        this.jLabelTriggerChannelEdit.setName("jLabelTriggerChannelEdit");
        this.groupAdjVarsTrigger.add((Component)this.jLabelTriggerChannelEdit, new AbsoluteConstraints(20, 20, -1, -1));
        this.jComboBoxTriggerEditSlot.setName("jComboBoxTriggerEditSlot");
        this.jComboBoxTriggerEditSlot.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JPanelAdjVars.this.jComboBoxTriggerEditSlotItemStateChanged(evt);
            }
        });
        this.groupAdjVarsTrigger.add((Component)this.jComboBoxTriggerEditSlot, new AbsoluteConstraints(20, 40, 140, -1));
        this.jPanelTriggerSignal.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanelTriggerSignal.setToolTipText(resourceMap.getString("jPanelTriggerSignal.toolTipText", new Object[0]));
        this.jPanelTriggerSignal.setName("jPanelTriggerSignal");
        this.jPanelTriggerSignal.setLayout(new BoxLayout(this.jPanelTriggerSignal, 2));
        this.groupAdjVarsTrigger.add((Component)this.jPanelTriggerSignal, new AbsoluteConstraints(20, 80, 360, 20));
        this.jLabelActiveAction.setText(resourceMap.getString("jLabelActiveAction.text", new Object[0]));
        this.jLabelActiveAction.setName("jLabelActiveAction");
        this.groupAdjVarsTrigger.add((Component)this.jLabelActiveAction, new AbsoluteConstraints(20, 110, 120, -1));
        this.jLabelTriggerActiveAction.setFont(resourceMap.getFont("jLabelTriggerActiveAction.font"));
        this.jLabelTriggerActiveAction.setText(resourceMap.getString("jLabelTriggerActiveAction.text", new Object[0]));
        this.jLabelTriggerActiveAction.setName("jLabelTriggerActiveAction");
        this.groupAdjVarsTrigger.add((Component)this.jLabelTriggerActiveAction, new AbsoluteConstraints(150, 110, 230, -1));
        this.add(this.groupAdjVarsTrigger);
        this.groupAdjVarsTrigger.setBounds(0, 0, 705, 180);
        this.groupAdjVarsAnalog.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("groupAdjVarsAnalog.border.title", new Object[0])));
        this.groupAdjVarsAnalog.setName("groupAdjVarsAnalog");
        this.groupAdjVarsAnalog.setLayout((LayoutManager)new AbsoluteLayout());
        this.jComboBoxAnalogSrc.setName("jComboBoxAnalogSrc");
        this.groupAdjVarsAnalog.add((Component)this.jComboBoxAnalogSrc, new AbsoluteConstraints(180, 50, 200, -1));
        this.jLabelAnalogSource.setText(resourceMap.getString("jLabelTriggerSource.text", new Object[0]));
        this.jLabelAnalogSource.setName("jLabelAnalogSource");
        this.groupAdjVarsAnalog.add((Component)this.jLabelAnalogSource, new AbsoluteConstraints(180, 30, -1, -1));
        this.jLabelAnalogChannelEdit.setText(resourceMap.getString("jLabelTriggerChannelEdit.text", new Object[0]));
        this.jLabelAnalogChannelEdit.setName("jLabelAnalogChannelEdit");
        this.groupAdjVarsAnalog.add((Component)this.jLabelAnalogChannelEdit, new AbsoluteConstraints(20, 30, -1, -1));
        this.jComboBoxAnalogEditSlot.setName("jComboBoxAnalogEditSlot");
        this.jComboBoxAnalogEditSlot.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JPanelAdjVars.this.jComboBoxAnalogEditSlotItemStateChanged(evt);
            }
        });
        this.groupAdjVarsAnalog.add((Component)this.jComboBoxAnalogEditSlot, new AbsoluteConstraints(20, 50, 140, -1));
        this.jLabelAnalogVariable.setText(resourceMap.getString("jLabelAnalogVariable.text", new Object[0]));
        this.jLabelAnalogVariable.setName("jLabelAnalogVariable");
        this.groupAdjVarsAnalog.add((Component)this.jLabelAnalogVariable, new AbsoluteConstraints(400, 30, -1, -1));
        this.jComboBoxAnalogAdjVar.setName("jComboBoxAnalogAdjVar");
        this.groupAdjVarsAnalog.add((Component)this.jComboBoxAnalogAdjVar, new AbsoluteConstraints(400, 50, 290, -1));
        this.jLabelAdjVarMin.setText(resourceMap.getString("jLabelAdjVarMin.text", new Object[0]));
        this.jLabelAdjVarMin.setName("jLabelAdjVarMin");
        this.groupAdjVarsAnalog.add((Component)this.jLabelAdjVarMin, new AbsoluteConstraints(400, 110, -1, -1));
        this.jSliderAdjVarMin.setForeground(resourceMap.getColor("jSliderAdjVarMin.foreground"));
        this.jSliderAdjVarMin.setMajorTickSpacing(25);
        this.jSliderAdjVarMin.setMaximum(250);
        this.jSliderAdjVarMin.setMinorTickSpacing(5);
        this.jSliderAdjVarMin.setPaintTicks(true);
        this.jSliderAdjVarMin.setValue(0);
        this.jSliderAdjVarMin.setName("jSliderAdjVarMin");
        this.jSliderAdjVarMin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JPanelAdjVars.this.jSliderAdjVarMinStateChanged(evt);
            }
        });
        this.groupAdjVarsAnalog.add((Component)this.jSliderAdjVarMin, new AbsoluteConstraints(430, 110, 260, -1));
        this.jLabelAdjVarMax.setText(resourceMap.getString("jLabelAdjVarMax.text", new Object[0]));
        this.jLabelAdjVarMax.setName("jLabelAdjVarMax");
        this.groupAdjVarsAnalog.add((Component)this.jLabelAdjVarMax, new AbsoluteConstraints(400, 140, -1, -1));
        this.jSliderAdjVarMax.setForeground(resourceMap.getColor("jSliderAdjVarMax.foreground"));
        this.jSliderAdjVarMax.setMaximum(250);
        this.jSliderAdjVarMax.setName("jSliderAdjVarMax");
        this.jSliderAdjVarMax.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JPanelAdjVars.this.jSliderAdjVarMaxStateChanged(evt);
            }
        });
        this.groupAdjVarsAnalog.add((Component)this.jSliderAdjVarMax, new AbsoluteConstraints(430, 140, 260, -1));
        this.jPanelAnalogSignal.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanelAnalogSignal.setToolTipText(resourceMap.getString("jPanelAnalogSignal.toolTipText", new Object[0]));
        this.jPanelAnalogSignal.setName("jPanelAnalogSignal");
        this.jPanelAnalogSignal.setLayout(new BoxLayout(this.jPanelAnalogSignal, 2));
        this.groupAdjVarsAnalog.add((Component)this.jPanelAnalogSignal, new AbsoluteConstraints(20, 90, 360, 20));
        this.jLabelAnalogCurValueLabel.setText(resourceMap.getString("jLabelAnalogCurValueLabel.text", new Object[0]));
        this.jLabelAnalogCurValueLabel.setName("jLabelAnalogCurValueLabel");
        this.groupAdjVarsAnalog.add((Component)this.jLabelAnalogCurValueLabel, new AbsoluteConstraints(20, 130, 120, -1));
        this.jLabelAnalogCurVal.setFont(this.jLabelAnalogCurVal.getFont().deriveFont(this.jLabelAnalogCurVal.getFont().getStyle() | 1, this.jLabelAnalogCurVal.getFont().getSize() + 5));
        this.jLabelAnalogCurVal.setText(resourceMap.getString("jLabelAnalogCurVal.text", new Object[0]));
        this.jLabelAnalogCurVal.setName("jLabelAnalogCurVal");
        this.groupAdjVarsAnalog.add((Component)this.jLabelAnalogCurVal, new AbsoluteConstraints(150, 130, 110, -1));
        this.buttonGroupAnalogType.add(this.jRadioButtonAnalogTypeAbs);
        this.jRadioButtonAnalogTypeAbs.setSelected(true);
        this.jRadioButtonAnalogTypeAbs.setText(resourceMap.getString("jRadioButtonAnalogTypeAbs.text", new Object[0]));
        this.jRadioButtonAnalogTypeAbs.setToolTipText(resourceMap.getString("jRadioButtonAnalogTypeAbs.toolTipText", new Object[0]));
        this.jRadioButtonAnalogTypeAbs.setName("jRadioButtonAnalogTypeAbs");
        this.groupAdjVarsAnalog.add((Component)this.jRadioButtonAnalogTypeAbs, new AbsoluteConstraints(430, 80, 140, -1));
        this.buttonGroupAnalogType.add(this.jRadioButtonAnalogTypeMult);
        this.jRadioButtonAnalogTypeMult.setText(resourceMap.getString("jRadioButtonAnalogTypeMult.text", new Object[0]));
        this.jRadioButtonAnalogTypeMult.setToolTipText(resourceMap.getString("jRadioButtonAnalogTypeMult.toolTipText", new Object[0]));
        this.jRadioButtonAnalogTypeMult.setName("jRadioButtonAnalogTypeMult");
        this.groupAdjVarsAnalog.add((Component)this.jRadioButtonAnalogTypeMult, new AbsoluteConstraints(570, 80, 130, -1));
        this.add(this.groupAdjVarsAnalog);
        this.groupAdjVarsAnalog.setBounds(0, 180, 705, 180);
        this.groupAdjVarsLUT.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("groupAdjVarsLUT.border.title", new Object[0])));
        this.groupAdjVarsLUT.setName("groupAdjVarsLUT");
        this.groupAdjVarsLUT.setLayout((LayoutManager)new AbsoluteLayout());
        ApplicationActionMap actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(JPanelAdjVars.class, this);
        this.jButtonAdjVarLUTValidate.setAction(actionMap.get("buttonAdjVarLUTValidate"));
        this.jButtonAdjVarLUTValidate.setText(resourceMap.getString("jButtonAdjVarLUTValidate.text", new Object[0]));
        this.jButtonAdjVarLUTValidate.setToolTipText(resourceMap.getString("jButtonAdjVarLUTValidate.toolTipText", new Object[0]));
        this.jButtonAdjVarLUTValidate.setName("jButtonAdjVarLUTValidate");
        this.groupAdjVarsLUT.add((Component)this.jButtonAdjVarLUTValidate, new AbsoluteConstraints(550, 170, 140, -1));
        this.jLabelLUTStatus.setText(resourceMap.getString("jLabelLUTStatus.text", new Object[0]));
        this.jLabelLUTStatus.setVerticalAlignment(1);
        this.jLabelLUTStatus.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(0, 4, 0, 4)));
        this.jLabelLUTStatus.setName("jLabelLUTStatus");
        this.jLabelLUTStatus.setOpaque(true);
        this.groupAdjVarsLUT.add((Component)this.jLabelLUTStatus, new AbsoluteConstraints(10, 163, 530, 40));
        this.jLabelLUTVarShow.setText(resourceMap.getString("jLabelLUTVarShow.text", new Object[0]));
        this.jLabelLUTVarShow.setToolTipText(resourceMap.getString("jLabelLUTShowVarVal.toolTipText", new Object[0]));
        this.jLabelLUTVarShow.setName("jLabelLUTVarShow");
        this.groupAdjVarsLUT.add((Component)this.jLabelLUTVarShow, new AbsoluteConstraints(10, 240, 120, -1));
        this.jComboBoxLUTVarShow.setToolTipText(resourceMap.getString("jLabelLUTShowVarVal.toolTipText", new Object[0]));
        this.jComboBoxLUTVarShow.setName("jComboBoxLUTVarShow");
        this.jComboBoxLUTVarShow.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JPanelAdjVars.this.jComboBoxLUTVarShowItemStateChanged(evt);
            }
        });
        this.groupAdjVarsLUT.add((Component)this.jComboBoxLUTVarShow, new AbsoluteConstraints(140, 240, 290, -1));
        this.jLabelLUTShowVarVal.setFont(this.jLabelLUTShowVarVal.getFont().deriveFont(this.jLabelLUTShowVarVal.getFont().getStyle() | 1, this.jLabelLUTShowVarVal.getFont().getSize() + 5));
        this.jLabelLUTShowVarVal.setText(resourceMap.getString("jLabelLUTShowVarVal.text", new Object[0]));
        this.jLabelLUTShowVarVal.setToolTipText(resourceMap.getString("jLabelLUTShowVarVal.toolTipText", new Object[0]));
        this.jLabelLUTShowVarVal.setName("jLabelLUTShowVarVal");
        this.groupAdjVarsLUT.add((Component)this.jLabelLUTShowVarVal, new AbsoluteConstraints(450, 240, 100, -1));
        this.jLabelLUTShowSignal.setText(resourceMap.getString("jLabelLUTShowSignal.text", new Object[0]));
        this.jLabelLUTShowSignal.setToolTipText(resourceMap.getString("jLabelLUTShowSignalVal.toolTipText", new Object[0]));
        this.jLabelLUTShowSignal.setName("jLabelLUTShowSignal");
        this.groupAdjVarsLUT.add((Component)this.jLabelLUTShowSignal, new AbsoluteConstraints(10, 210, 120, -1));
        this.jComboBoxLUTSignalShow.setToolTipText(resourceMap.getString("jLabelLUTShowSignalVal.toolTipText", new Object[0]));
        this.jComboBoxLUTSignalShow.setName("jComboBoxLUTSignalShow");
        this.jComboBoxLUTSignalShow.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JPanelAdjVars.this.jComboBoxLUTSignalShowItemStateChanged(evt);
            }
        });
        this.groupAdjVarsLUT.add((Component)this.jComboBoxLUTSignalShow, new AbsoluteConstraints(140, 210, 290, -1));
        this.jLabelLUTShowSignalVal.setFont(this.jLabelLUTShowSignalVal.getFont().deriveFont(this.jLabelLUTShowSignalVal.getFont().getStyle() | 1, this.jLabelLUTShowSignalVal.getFont().getSize() + 5));
        this.jLabelLUTShowSignalVal.setText(resourceMap.getString("jLabelLUTShowSignalVal.text", new Object[0]));
        this.jLabelLUTShowSignalVal.setToolTipText(resourceMap.getString("jLabelLUTShowSignalVal.toolTipText", new Object[0]));
        this.jLabelLUTShowSignalVal.setName("jLabelLUTShowSignalVal");
        this.groupAdjVarsLUT.add((Component)this.jLabelLUTShowSignalVal, new AbsoluteConstraints(450, 210, 100, -1));
        this.jScrollPane1.setName("jScrollPane1");
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setLayout(new BorderLayout());
        this.jTextPaneAdjVarLUT.setBackground(resourceMap.getColor("jTextPaneAdjVarLUT.background"));
        this.jTextPaneAdjVarLUT.setForeground(resourceMap.getColor("jTextPaneAdjVarLUT.foreground"));
        this.jTextPaneAdjVarLUT.setToolTipText(resourceMap.getString("jTextPaneAdjVarLUT.toolTipText", new Object[0]));
        this.jTextPaneAdjVarLUT.setCaretColor(resourceMap.getColor("jTextPaneAdjVarLUT.caretColor"));
        this.jTextPaneAdjVarLUT.setName("jTextPaneAdjVarLUT");
        this.jPanel1.add((Component)this.jTextPaneAdjVarLUT, "Center");
        this.jScrollPane1.setViewportView(this.jPanel1);
        this.groupAdjVarsLUT.add((Component)this.jScrollPane1, new AbsoluteConstraints(10, 20, 680, 140));
        this.add(this.groupAdjVarsLUT);
        this.groupAdjVarsLUT.setBounds(0, 360, 705, 280);
    }

    private void jSliderAdjVarMinStateChanged(ChangeEvent evt) {
    }

    private void jSliderAdjVarMaxStateChanged(ChangeEvent evt) {
    }

    private void jComboBoxTriggerEditSlotItemStateChanged(ItemEvent evt) {
        if (!this.updateControlsMode) {
            this.applyControls();
            this.trigger_cur_slot = this.jComboBoxTriggerEditSlot.getSelectedIndex();
            this.updateControls();
        }
    }

    private void jComboBoxAnalogEditSlotItemStateChanged(ItemEvent evt) {
        if (!this.updateControlsMode) {
            this.applyControls();
            this.analog_cur_slot = this.jComboBoxAnalogEditSlot.getSelectedIndex();
            this.updateControls();
        }
    }

    private void jComboBoxLUTSignalShowItemStateChanged(ItemEvent evt) {
        this.showLUTSignalId = ((SpravComboBoxModel)this.jComboBoxLUTSignalShow.getModel()).getCurrentId();
    }

    private void jComboBoxLUTVarShowItemStateChanged(ItemEvent evt) {
        this.showLUTVarId = ((SpravComboBoxModel)this.jComboBoxLUTVarShow.getModel()).getCurrentId();
    }

    @Override
    public void updateBoardVerUI() {
        BoardInfo info = BoardInfo.getBoardInfo();
        this.jComboBoxAnalogSrc.setModel(new SpravComboBoxModel(ParamsUIFactory.getRCMapList(info), this.jComboBoxAnalogSrc.getModel()));
        this.jComboBoxTriggerSrc.setModel(new SpravComboBoxModel(ParamsUIFactory.getRCMapList(info), this.jComboBoxTriggerSrc.getModel()));
        ArrayList<Sprav> cmdList = ParamsUIFactory.getCmdList();
        for (int i = 0; i < this.comboBoxTriggerAction.length; ++i) {
            this.comboBoxTriggerAction[i].setModel(new SpravComboBoxModel(cmdList, this.comboBoxTriggerAction[i].getModel()));
        }
        this.jComboBoxAnalogAdjVar.setModel(new SpravComboBoxModel(ParamsUIFactory.getAdjVarsList(), this.jComboBoxAnalogAdjVar.getModel()));
        this.jComboBoxLUTVarShow.setModel(new SpravComboBoxModel(ParamsUIFactory.getAdjVarsList(), this.jComboBoxLUTVarShow.getModel()));
        this.jComboBoxLUTSignalShow.setModel(new SpravComboBoxModel(AdjVarSource.getSignalSourceList(), this.jComboBoxLUTSignalShow.getModel()));
    }

    @Override
    public void updateBoardParams(BoardParams params) throws Exception {
        this.adj_vars_trigger = BoardParams.copyOf(params.adj_vars_trigger);
        this.adj_vars_analog = BoardParams.copyOf(params.adj_vars_analog);
        this.jTextPaneAdjVarLUT.setText(params.adj_vars_LUT != null ? params.adj_vars_LUT : "");
        this.updateControls();
    }

    private void updateControls() {
        DefaultComboBoxModel<String> m;
        int i;
        this.updateControlsMode = true;
        if (this.adj_vars_trigger != null) {
            if (this.trigger_cur_slot >= 0 && this.trigger_cur_slot < this.adj_vars_trigger.length) {
                AdjVarTriggerCfg var = this.adj_vars_trigger[this.trigger_cur_slot];
                ((SpravComboBoxModel)this.jComboBoxTriggerSrc.getModel()).setCurrent(var.src_ch);
                for (i = 0; i < var.action.length && i < this.comboBoxTriggerAction.length; ++i) {
                    ((SpravComboBoxModel)this.comboBoxTriggerAction[i].getModel()).setCurrentOrAdd(var.action[i], "<unknown action>");
                }
            }
            m = new DefaultComboBoxModel<String>();
            for (i = 0; i < this.adj_vars_trigger.length; ++i) {
                m.addElement(this.resourceMap.getString("comboBox.slotToEdit", new Object[0]) + " " + (i + 1) + (this.adj_vars_trigger[i].src_ch != 0 ? " #" : ""));
            }
            this.jComboBoxTriggerEditSlot.setModel(m);
            this.jComboBoxTriggerEditSlot.setSelectedIndex(this.trigger_cur_slot);
        }
        if (this.adj_vars_analog != null) {
            if (this.analog_cur_slot >= 0 && this.analog_cur_slot < this.adj_vars_analog.length) {
                this.selectedVar = this.adj_vars_analog[this.analog_cur_slot];
                ((SpravComboBoxModel)this.jComboBoxAnalogSrc.getModel()).setCurrent(this.selectedVar.src_ch);
                ((SpravComboBoxModel)this.jComboBoxAnalogAdjVar.getModel()).setCurrent(this.selectedVar.var_id);
                this.jRadioButtonAnalogTypeAbs.setSelected(!this.selectedVar.isMultType);
                this.jRadioButtonAnalogTypeMult.setSelected(this.selectedVar.isMultType);
                this.jSliderAdjVarMin.setValue(this.selectedVar.min_val);
                this.jSliderAdjVarMax.setValue(this.selectedVar.max_val);
            }
            m = new DefaultComboBoxModel();
            for (i = 0; i < this.adj_vars_analog.length; ++i) {
                m.addElement(this.resourceMap.getString("comboBox.slotToEdit", new Object[0]) + " " + (i + 1) + (this.adj_vars_analog[i].src_ch != 0 ? " #" : ""));
            }
            this.jComboBoxAnalogEditSlot.setModel(m);
            this.jComboBoxAnalogEditSlot.setSelectedIndex(this.analog_cur_slot);
        }
        this.updateControlsMode = false;
    }

    @Override
    public void applyBoardParams(BoardParams params) throws Exception {
        this.applyControls();
        if (this.adj_vars_trigger != null) {
            params.adj_vars_trigger = BoardParams.copyOf(this.adj_vars_trigger);
        }
        if (this.adj_vars_analog != null) {
            params.adj_vars_analog = BoardParams.copyOf(this.adj_vars_analog);
        }
        if (!this.validateAdjVarLUT()) {
            throw new Exception("Adjustable variables LUT syntax error");
        }
        params.adj_vars_LUT = this.jTextPaneAdjVarLUT.getText();
    }

    public void applyControls() {
        Cloneable var;
        if (this.adj_vars_trigger != null && this.trigger_cur_slot >= 0 && this.trigger_cur_slot < this.adj_vars_trigger.length) {
            var = this.adj_vars_trigger[this.trigger_cur_slot];
            var.src_ch = ((SpravComboBoxModel)this.jComboBoxTriggerSrc.getModel()).getCurrentId();
            for (int i = 0; i < var.action.length && i < this.comboBoxTriggerAction.length; ++i) {
                var.action[i] = ((SpravComboBoxModel)this.comboBoxTriggerAction[i].getModel()).getCurrentId();
            }
        }
        if (this.adj_vars_analog != null && this.analog_cur_slot >= 0 && this.analog_cur_slot < this.adj_vars_analog.length) {
            var = this.adj_vars_analog[this.analog_cur_slot];
            ((AdjVarAnalogCfg)var).src_ch = ((SpravComboBoxModel)this.jComboBoxAnalogSrc.getModel()).getCurrentId();
            ((AdjVarAnalogCfg)var).var_id = ((SpravComboBoxModel)this.jComboBoxAnalogAdjVar.getModel()).getCurrentId();
            ((AdjVarAnalogCfg)var).isMultType = this.jRadioButtonAnalogTypeMult.isSelected();
            ((AdjVarAnalogCfg)var).min_val = this.jSliderAdjVarMin.getValue();
            ((AdjVarAnalogCfg)var).max_val = this.jSliderAdjVarMax.getValue();
        }
    }

    public void updateRealtimeState(int triggerSignal, int triggerAction, int analogSignal, float analogVal, int LUTSignalVal, float LUTVarVal) {
        this.triggerSignalPanel.setData(RealtimeData.rcData16_to_API_range(triggerSignal, 0));
        this.analogSignalPanel.setData(RealtimeData.rcData16_to_API_range(analogSignal, 0));
        this.jLabelAnalogCurVal.setText(String.format("%.2f", Float.valueOf(analogVal)));
        if (triggerAction < this.comboBoxTriggerAction[0].getItemCount()) {
            Sprav item = ((SpravComboBoxModel)this.comboBoxTriggerAction[0].getModel()).findElement(triggerAction);
            this.jLabelTriggerActiveAction.setText(item != null ? item.getName() : "--");
        }
        String srcValStr = "--";
        try {
            Float val = AdjVarSource.srcValFromShort(this.showLUTSignalId, LUTSignalVal);
            if (val != null) {
                srcValStr = String.format("%.2f", Float.valueOf(val.floatValue()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jLabelLUTShowSignalVal.setText(srcValStr);
        this.jLabelLUTShowVarVal.setText(String.format("%.2f", Float.valueOf(LUTVarVal)));
    }

    @Action
    public void buttonAdjVarLUTValidate() {
        this.validateAdjVarLUT();
    }

    public void showLUTStatusMessage(String message, boolean error) {
        this.jLabelLUTStatus.setText("<html>" + message + "</html>");
        if (error) {
            this.jLabelLUTStatus.setBackground(Color.RED);
        } else {
            this.jLabelLUTStatus.setBackground(this.normalBackgroundColor);
        }
    }

    public boolean validateAdjVarLUT() {
        try {
            AdjVarData data = AdjVarParser.parseFromString(this.jTextPaneAdjVarLUT.getText());
            byte[] bytes = data.toByteArray();
            this.showLUTStatusMessage(this.resourceMap.getString("adj_var_LUT.parse.ok", bytes.length), false);
            ScriptHighlighter.highlightProgramLine2(this.jTextPaneAdjVarLUT, 0);
            return true;
        }
        catch (AdjVarParseException e) {
            this.showLUTStatusMessage(this.resourceMap.getString("adj_var_LUT.parse.error", e.lineNum, e.getMessage()), true);
            ScriptHighlighter.highlightProgramLine2(this.jTextPaneAdjVarLUT, e.lineNum);
        }
        catch (Exception e) {
            this.showLUTStatusMessage(this.resourceMap.getString("adj_var_LUT.parse.error", 0, e.getMessage()), true);
        }
        return false;
    }
}

