/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui;

import java.text.DecimalFormat;
import javax.swing.AbstractSpinnerModel;
import javax.swing.JSpinner;
import sbgc.ui.FormattedNumberEditor;
import sbgc.ui.IFormatConfigurer;

public class LogSpinnerModel
extends AbstractSpinnerModel
implements IFormatConfigurer {
    int maxInt;
    double a;
    double b;
    double offset;
    int valueInt = 0;

    public static void setModelAndEditor(JSpinner spinner, double min, double max, int maxInt, double offset) throws IllegalArgumentException {
        LogSpinnerModel m = new LogSpinnerModel(min, max, maxInt, offset);
        Object val = spinner.getValue();
        if (val != null && val instanceof Number) {
            m.setValue(val);
        }
        spinner.setModel(m);
        spinner.setEditor(new FormattedNumberEditor(spinner));
    }

    protected LogSpinnerModel(double min, double max, int maxInt, double offset) throws IllegalArgumentException {
        this.maxInt = maxInt;
        this.offset = offset;
        max += this.offset;
        if (min <= 0.0 || min >= max || maxInt <= 1) {
            throw new IllegalArgumentException();
        }
        this.a = min;
        this.b = Math.log(max / this.a) / (double)maxInt;
    }

    private Double valueFromInt(int valInt) {
        return this.a * Math.exp((double)valInt * this.b) - this.offset;
    }

    public int getValueInt() {
        return this.valueInt;
    }

    public void setValueInt(int valInt) {
        this.valueInt = this.constrain(valInt);
        this.fireStateChanged();
    }

    @Override
    public Object getValue() {
        return this.valueFromInt(this.valueInt);
    }

    @Override
    public void setValue(Object new_value) {
        if (new_value != null && new_value instanceof Number) {
            int prevInt = this.valueInt;
            double val = ((Number)new_value).doubleValue() + this.offset;
            if (val > 0.0) {
                int valInt = (int)Math.round(Math.log(val / this.a) / this.b);
                this.valueInt = this.constrain(valInt);
            } else {
                this.valueInt = 0;
            }
            if (prevInt != this.valueInt) {
                this.fireStateChanged();
            }
        } else {
            throw new UnsupportedOperationException("Not a valid number.");
        }
    }

    @Override
    public Object getNextValue() {
        return new Double(this.valueFromInt(this.valueInt + 1));
    }

    @Override
    public Object getPreviousValue() {
        return new Double(this.valueFromInt(this.valueInt - 1));
    }

    private int constrain(int valInt) {
        return Math.max(0, Math.min(valInt, this.maxInt));
    }

    @Override
    public void configureFormat(DecimalFormat df) {
        double delta = this.valueFromInt(this.valueInt + 1) - this.valueFromInt(this.valueInt);
        int digits = 0;
        while (delta < 5.0) {
            delta *= 10.0;
            ++digits;
        }
        df.setMaximumFractionDigits(digits);
    }
}

