/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;
import sbgc.object.AdjVarInfo;
import sbgc.object.BatInfo;
import sbgc.object.BoardInfo;
import sbgc.object.BoardParams;
import sbgc.object.ListOption;
import sbgc.object.SerialLinkCfg;
import sbgc.object.Sprav;
import sbgc.service.SerialPortService;
import sbgc.utils.Log;
import simplebgc_gui.SimpleBGC_GUIApp;
import simplebgc_gui.SimpleBGC_GUIView;

public class ParamsUIFactory {
    public static final int BOARD_VER_3 = 30;
    protected static final Log logger = new Log(Logger.getLogger((String)ParamsUIFactory.class.getName()));
    public static final String MENU_CMD_ITEM_NAME = "<unknown action>";
    public static final String[] EXT_IMU_MODEL_NAMES = new String[]{"disabled", "MavLink FC channel 1", "MavLink FC channel 2", "Vectornav VN-100, VN-200", "Inertialsense uAHRS, uINS", "Basecam GPS_IMU", "Vectornav VN-300"};

    public static ArrayList<Sprav> getCmdList() {
        int i;
        ResourceMap r = SimpleBGC_GUIApp.getResourceMap();
        ArrayList<Sprav> list = new ArrayList<Sprav>();
        list.add(new Sprav(0, r.getString("cmd.no_action", new Object[0])));
        list.add(new Sprav(1, r.getString("cmd.use_profile", SimpleBGC_GUIView.getProfileName(0))));
        list.add(new Sprav(2, r.getString("cmd.use_profile", SimpleBGC_GUIView.getProfileName(1))));
        list.add(new Sprav(3, r.getString("cmd.use_profile", SimpleBGC_GUIView.getProfileName(2))));
        list.add(new Sprav(14, r.getString("cmd.use_profile", SimpleBGC_GUIView.getProfileName(3))));
        list.add(new Sprav(15, r.getString("cmd.use_profile", SimpleBGC_GUIView.getProfileName(4))));
        list.add(new Sprav(6, r.getString("cmd.calibrate_acc", new Object[0])));
        if (BoardInfo.hasBoardFeature(16384L)) {
            list.add(new Sprav(61, r.getString("cmd.calibrate_acc_auto", new Object[0])));
        }
        list.add(new Sprav(9, r.getString("cmd.calibrate_gyro", new Object[0])));
        list.add(new Sprav(4, r.getString("cmd.swap_roll_pitch", new Object[0])));
        list.add(new Sprav(5, r.getString("cmd.swap_yaw_roll", new Object[0])));
        list.add(new Sprav(8, r.getString("cmd.set_tilt_by_hands", new Object[0])));
        list.add(new Sprav(7, r.getString("cmd.reset", new Object[0])));
        list.add(new Sprav(62, r.getString("cmd.reset_imu", new Object[0])));
        list.add(new Sprav(10, r.getString("cmd.motor_toggle", new Object[0])));
        list.add(new Sprav(11, r.getString("cmd.motor_on", new Object[0])));
        list.add(new Sprav(12, r.getString("cmd.motor_off", new Object[0])));
        if (BoardInfo.checkMinPartnerFirmwareVer(2690)) {
            list.add(new Sprav(66, r.getString("cmd.motors_safe_toggle", new Object[0])));
        }
        list.add(new Sprav(60, r.getString("cmd.motors_safe_stop", new Object[0])));
        list.add(new Sprav(13, r.getString("cmd.frame_upside_down", new Object[0])));
        list.add(new Sprav(16, r.getString("cmd.auto_pid", new Object[0])));
        if (BoardInfo.autoPID2()) {
            list.add(new Sprav(64, r.getString("cmd.auto_pid_gain_only", new Object[0])));
        }
        list.add(new Sprav(17, r.getString("cmd.look_down", new Object[0])));
        list.add(new Sprav(18, r.getString("cmd.home_position", new Object[0])));
        list.add(new Sprav(38, r.getString("cmd.home_position_shortest", new Object[0])));
        list.add(new Sprav(75, r.getString("cmd.home_positin_motors", new Object[0])));
        if (BoardInfo.hasBoardFeature(0x40000000L)) {
            list.add(new Sprav(76, r.getString("cmd.retracted_position", new Object[0])));
        }
        if (BoardInfo.checkMinPartnerFirmwareVer(2696)) {
            list.add(new Sprav(70, r.getString("cmd.set_cur_pos_as_home", new Object[0])));
        }
        if (BoardInfo.checkMinPartnerFirmwareVer(2627)) {
            list.add(new Sprav(46, r.getString("cmd.level_roll", new Object[0])));
        }
        if (BoardInfo.checkMinPartnerFirmwareVer(2687)) {
            list.add(new Sprav(65, r.getString("cmd.level_pitch", new Object[0])));
        }
        list.add(new Sprav(34, r.getString("cmd.level_roll_pitch", new Object[0])));
        list.add(new Sprav(35, r.getString("cmd.center_yaw", new Object[0])));
        list.add(new Sprav(39, r.getString("cmd.center_yaw_shortest", new Object[0])));
        list.add(new Sprav(19, r.getString("cmd.rc_bind", new Object[0])));
        list.add(new Sprav(20, r.getString("cmd.calibrate_gyro_temperature", new Object[0])));
        list.add(new Sprav(21, r.getString("cmd.calibrate_acc_temperature", new Object[0])));
        list.add(new Sprav(22, r.getString("cmd.menu_button_press", new Object[0])));
        for (i = 0; i < BoardInfo.getScriptSlotsNum(); ++i) {
            list.add(new Sprav(23 + i, r.getString("cmd.run_script_slot", i + 1)));
        }
        list.add(new Sprav(71, r.getString("cmd.stop_script", new Object[0])));
        list.add(new Sprav(33, r.getString("cmd.menu_calibrate_mag", new Object[0])));
        list.add(new Sprav(36, r.getString("cmd.untwist_cables", new Object[0])));
        list.add(new Sprav(40, r.getString("cmd.rotate_yaw_180", new Object[0])));
        list.add(new Sprav(41, r.getString("cmd.rotate_yaw_180_frame_rel", new Object[0])));
        list.add(new Sprav(42, r.getString("cmd.switch_yaw_180_frame_rel", new Object[0])));
        list.add(new Sprav(43, r.getString("cmd.switch_pos_roll_90", new Object[0])));
        list.add(new Sprav(44, r.getString("cmd.timelapse_start", new Object[0])));
        list.add(new Sprav(47, r.getString("cmd.timelapse_repeat", new Object[0])));
        list.add(new Sprav(67, r.getString("cmd.timelapse_step1", new Object[0])));
        if (BoardInfo.hasBoardFeature(2048L)) {
            list.add(new Sprav(45, r.getString("cmd.calib_momentum", new Object[0])));
        }
        for (i = 0; i < 5; ++i) {
            list.add(new Sprav(48 + i, r.getString("cmd.load_profile_set_slot", i + 1)));
        }
        list.add(new Sprav(53, r.getString("cmd.load_profile_set_backup", new Object[0])));
        for (i = 0; i < 3; ++i) {
            list.add(new Sprav(54 + i, r.getString("cmd.invert_rc", BoardParams.getAxisName(i))));
        }
        list.add(new Sprav(57, r.getString("cmd.snap_fixed_angle", new Object[0])));
        list.add(new Sprav(58, r.getString("cmd.camera_rec_photo_event", new Object[0])));
        list.add(new Sprav(59, r.getString("cmd.camera_photo_event", new Object[0])));
        list.add(new Sprav(63, r.getString("cmd.forced_follow_toggle", new Object[0])));
        list.add(new Sprav(69, r.getString("cmd.disable_follow_toggle", new Object[0])));
        list.add(new Sprav(72, r.getString("cmd.tripod_mode_off", new Object[0])));
        list.add(new Sprav(73, r.getString("cmd.tripod_mode_on", new Object[0])));
        list.add(new Sprav(74, r.getString("cmd.set_rc_trim", new Object[0])));
        list.add(new Sprav(77, r.getString("cmd.shake_generator_off", new Object[0])));
        list.add(new Sprav(78, r.getString("cmd.shake_generator_on", new Object[0])));
        list.add(new Sprav(79, r.getString("cmd.servo_mode_on", new Object[0])));
        list.add(new Sprav(10, r.getString("cmd.servo_mode_off", new Object[0])));
        list.add(new Sprav(81, r.getString("cmd.servo_mode_toggle", new Object[0])));
        return list;
    }

    public static ArrayList<Sprav> getRCMapList(BoardInfo info) {
        return ParamsUIFactory.getRCMapList(info, RCMapFieldType.COMMON);
    }

    public static ArrayList<Sprav> getRCMapList(BoardInfo info, RCMapFieldType fieldType) {
        int i;
        int firmwareVer = 0;
        if (info != null) {
            firmwareVer = info.getFrwVer();
        }
        ResourceMap r = SimpleBGC_GUIApp.getResourceMap();
        ArrayList<Sprav> list = new ArrayList<Sprav>();
        list.add(new Sprav(0, r.getString("option.noInput", new Object[0])));
        if (fieldType != RCMapFieldType.SERVO_OUT) {
            list.add(new Sprav(1, "RC_ROLL - PWM"));
            list.add(new Sprav(2, "RC_PITCH - PWM"));
            list.add(new Sprav(5, "RC_YAW - PWM"));
            list.add(new Sprav(3, "FC_ROLL - PWM"));
            list.add(new Sprav(4, "FC_PITCH - PWM"));
        }
        list.add(new Sprav(33, "ADC1 - analog"));
        list.add(new Sprav(34, "ADC2 - analog"));
        list.add(new Sprav(35, "ADC3 - analog"));
        if (info != null && info._hasBoardFeature(0x1000000000L)) {
            list.add(new Sprav(36, "ADC4 - analog"));
        }
        for (i = 1; i <= 31; ++i) {
            String name = "RC_VIRT_CH_" + i;
            if (firmwareVer >= 2595 && i >= 20 && i < BoardParams.RC_VIRT_CH_MOTOR_ANGLE_NAMES.length + 20) {
                name = BoardParams.RC_VIRT_CH_MOTOR_ANGLE_NAMES[i - 20];
            }
            list.add(new Sprav(64 + i, name));
        }
        if (firmwareVer >= 2732) {
            for (i = 0; i < BoardParams.RC_VIRT2_CH_NAMES.length; ++i) {
                list.add(new Sprav(96 + i, BoardParams.RC_VIRT2_CH_NAMES[i]));
            }
        }
        if (firmwareVer >= 2430) {
            for (i = 1; i <= 31; ++i) {
                list.add(new Sprav(0x80 | i, "API_VIRT_CH_" + i));
            }
        }
        if (firmwareVer >= 2653 && fieldType != RCMapFieldType.STEP_SIGNAL) {
            for (i = 1; i <= 6; ++i) {
                list.add(new Sprav(0xA0 | i, "STEP_SIGNAL_" + i));
            }
        }
        if (BoardInfo.hasExtraButtons()) {
            for (i = 0; i < 5; ++i) {
                list.add(new Sprav(6 + i, "EXTRA_BUTTON_" + (i + 1)));
            }
        }
        return list;
    }

    public static ArrayList<Sprav> getRCVirtModeList() {
        ResourceMap r = SimpleBGC_GUIApp.getResourceMap();
        ArrayList<Sprav> list = new ArrayList<Sprav>();
        list.add(new Sprav(0, "Normal (PWM)"));
        list.add(new Sprav(1, "Sum-PPM"));
        list.add(new Sprav(2, "Futaba s-bus"));
        list.add(new Sprav(3, "Spektrum DSM2/DSMX"));
        list.add(new Sprav(4, "Jeti EX Bus"));
        list.add(new Sprav(10, "Serial port (Serial API, etc.)"));
        return list;
    }

    public static Object[] getOutputList() {
        ResourceMap r = SimpleBGC_GUIApp.getResourceMap();
        ArrayList<String> list = new ArrayList<String>();
        list.add(r.getString("option.disabled", new Object[0]));
        list.add("ROLL " + r.getString("option.out", new Object[0]));
        list.add("PITCH " + r.getString("option.out", new Object[0]));
        list.add("YAW " + r.getString("option.out", new Object[0]));
        if (BoardInfo.has_i2c_drv()) {
            list.add("SBGC32_I2C_drv#1");
            list.add("SBGC32_I2C_drv#2");
            list.add("SBGC32_I2C_drv#3");
            list.add("SBGC32_I2C_drv#4");
        }
        if (BoardInfo.hasCANDrvParams()) {
            for (int i = 1; i <= 7; ++i) {
                list.add("CAN_drv#" + i);
            }
        }
        return list.toArray();
    }

    public static ArrayList<BatInfo> getBatInfoList() {
        ArrayList<BatInfo> list = new ArrayList<BatInfo>();
        list.add(new BatInfo(1, 1));
        list.add(new BatInfo(1, 2));
        list.add(new BatInfo(1, 3));
        list.add(new BatInfo(1, 4));
        list.add(new BatInfo(1, 5));
        list.add(new BatInfo(1, 6));
        list.add(new BatInfo(2, 2));
        list.add(new BatInfo(2, 3));
        list.add(new BatInfo(2, 4));
        list.add(new BatInfo(2, 5));
        list.add(new BatInfo(2, 6));
        return list;
    }

    public static ArrayList<Sprav> getRCOutList() {
        int i;
        ResourceMap r = SimpleBGC_GUIApp.getResourceMap();
        ArrayList<Sprav> list = new ArrayList<Sprav>();
        list.add(new Sprav(0, r.getString("option.disabled", new Object[0])));
        for (i = 1; i <= 31; ++i) {
            list.add(new Sprav(i, "RC_VIRT_CH_" + i));
        }
        if (BoardInfo.checkMinPartnerFirmwareVer(2602)) {
            for (i = 1; i <= 3; ++i) {
                list.add(new Sprav(0x20 | i, "ADC " + i));
            }
            for (i = 1; i <= 31; ++i) {
                list.add(new Sprav(0x80 | i, "API_VIRT_CH_" + i));
            }
        }
        return list;
    }

    public static ArrayList<Sprav> getAdjVarsList() {
        ArrayList<Sprav> list = new ArrayList<Sprav>();
        list.add(new Sprav(0, "P_ROLL"));
        list.add(new Sprav(1, "P_PITCH"));
        list.add(new Sprav(2, "P_YAW"));
        list.add(new Sprav(3, "I_ROLL"));
        list.add(new Sprav(4, "I_PITCH"));
        list.add(new Sprav(5, "I_YAW"));
        list.add(new Sprav(6, "D_ROLL"));
        list.add(new Sprav(7, "D_PITCH"));
        list.add(new Sprav(8, "D_YAW"));
        list.add(new Sprav(91, "OUTER_P_ROLL"));
        list.add(new Sprav(92, "OUTER_P_PITCH"));
        list.add(new Sprav(93, "OUTER_P_YAW"));
        list.add(new Sprav(9, "POWER_ROLL"));
        list.add(new Sprav(10, "POWER_PITCH"));
        list.add(new Sprav(11, "POWER_YAW"));
        list.add(new Sprav(12, "ACC_LIMITER_ALL"));
        list.add(new Sprav(13, "FOLLOW_SPEED_ROLL"));
        list.add(new Sprav(14, "FOLLOW_SPEED_PITCH"));
        list.add(new Sprav(15, "FOLLOW_SPEED_YAW"));
        list.add(new Sprav(16, "FOLLOW_LPF_ROLL"));
        list.add(new Sprav(17, "FOLLOW_LPF_PITCH"));
        list.add(new Sprav(18, "FOLLOW_LPF_YAW"));
        list.add(new Sprav(19, "RC_SPEED_ROLL"));
        list.add(new Sprav(20, "RC_SPEED_PITCH"));
        list.add(new Sprav(21, "RC_SPEED_YAW"));
        list.add(new Sprav(22, "RC_LPF_ROLL"));
        list.add(new Sprav(23, "RC_LPF_PITCH"));
        list.add(new Sprav(24, "RC_LPF_YAW"));
        list.add(new Sprav(25, "RC_TRIM_ROLL"));
        list.add(new Sprav(26, "RC_TRIM_PITCH"));
        list.add(new Sprav(27, "RC_TRIM_YAW"));
        list.add(new Sprav(28, "RC_DEADBAND"));
        list.add(new Sprav(72, "RC_DEADBAND.PITCH"));
        list.add(new Sprav(73, "RC_DEADBAND.YAW"));
        list.add(new Sprav(29, "RC_EXPO_RATE"));
        list.add(new Sprav(74, "RC_EXPO_RATE.PITCH"));
        list.add(new Sprav(75, "RC_EXPO_RATE.YAW"));
        list.add(new Sprav(30, "FOLLOW_PITCH"));
        list.add(new Sprav(31, "FOLLOW_YAW_PITCH"));
        list.add(new Sprav(32, "FOLLOW_DEADBAND"));
        list.add(new Sprav(33, "FOLLOW_EXPO_RATE"));
        list.add(new Sprav(34, "FOLLOW_ROLL_MIX_START"));
        list.add(new Sprav(35, "FOLLOW_ROLL_MIX_RANGE"));
        list.add(new Sprav(36, "GYRO_TRUST"));
        list.add(new Sprav(37, "FRAME_HEADING_ANGLE"));
        list.add(new Sprav(38, "GYRO_HEADING_CORRECTION"));
        list.add(new Sprav(39, "ACC_LIMITER_ROLL"));
        list.add(new Sprav(40, "ACC_LIMITER_PITCH"));
        list.add(new Sprav(41, "ACC_LIMITER_YAW"));
        list.add(new Sprav(42, "PID_GAIN_ROLL"));
        list.add(new Sprav(43, "PID_GAIN_PITCH"));
        list.add(new Sprav(44, "PID_GAIN_YAW"));
        list.add(new Sprav(45, "LPF_FREQ_ROLL"));
        list.add(new Sprav(46, "LPF_FREQ_PITCH"));
        list.add(new Sprav(47, "LPF_FREQ_YAW"));
        list.add(new Sprav(94, "D-LPF_FREQ_ROLL"));
        list.add(new Sprav(95, "D-LPF_FREQ_PITCH"));
        list.add(new Sprav(96, "D-LPF_FREQ_YAW"));
        list.add(new Sprav(48, "TIMELAPSE_TIME"));
        list.add(new Sprav(49, "MAV_CTRL_MODE"));
        list.add(new Sprav(50, "H_CORR_FACTOR"));
        list.add(new Sprav(51, "SW_LIM_MIN.ROLL"));
        list.add(new Sprav(52, "SW_LIM_MAX.ROLL"));
        list.add(new Sprav(53, "SW_LIM_MIN.PITCH"));
        list.add(new Sprav(54, "SW_LIM_MAX.PITCH"));
        list.add(new Sprav(55, "SW_LIM_MIN.YAW"));
        list.add(new Sprav(56, "SW_LIM_MAX.YAW"));
        list.add(new Sprav(99, "SW_LIM_WIDTH.ROLL"));
        list.add(new Sprav(100, "SW_LIM_WIDTH.PITCH"));
        list.add(new Sprav(101, "SW_LIM_WIDTH.YAW"));
        list.add(new Sprav(57, "FOLLOW_RANGE.ROLL"));
        list.add(new Sprav(58, "FOLLOW_RANGE.PITCH"));
        list.add(new Sprav(59, "FOLLOW_RANGE.YAW"));
        list.add(new Sprav(60, "AUTO_PID_TARGET"));
        list.add(new Sprav(61, "RC_MODE.ROLL"));
        list.add(new Sprav(62, "RC_MODE.PITCH"));
        list.add(new Sprav(63, "RC_MODE.YAW"));
        list.add(new Sprav(64, "EULER_ORDER"));
        list.add(new Sprav(65, "FOLLOW_IN_DBAND"));
        list.add(new Sprav(66, "RC_LIMIT_MIN.ROLL"));
        list.add(new Sprav(67, "RC_LIMIT_MAX.ROLL"));
        list.add(new Sprav(68, "RC_LIMIT_MIN.PITCH"));
        list.add(new Sprav(69, "RC_LIMIT_MAX.PITCH"));
        list.add(new Sprav(70, "RC_LIMIT_MIN.YAW"));
        list.add(new Sprav(71, "RC_LIMIT_MAX.YAW"));
        list.add(new Sprav(76, "SHAKE_AMP.ROLL"));
        list.add(new Sprav(77, "SHAKE_AMP.TILT"));
        list.add(new Sprav(78, "SHAKE_AMP.PAN"));
        list.add(new Sprav(79, "SHAKE_FREQ"));
        list.add(new Sprav(80, "SHAKE_FREQ_RANGE"));
        list.add(new Sprav(81, "SHAKE_PAUSE_PERIOD"));
        list.add(new Sprav(82, "SHAKE_PAUSE_BALANCE"));
        list.add(new Sprav(83, "SHAKE_PAUSE_RANDOMNESS"));
        list.add(new Sprav(84, "SHAKE_RESONANCE_GAIN.ROLL"));
        list.add(new Sprav(85, "SHAKE_RESONANCE_GAIN.TILT"));
        list.add(new Sprav(86, "SHAKE_RESONANCE_GAIN.PAN"));
        list.add(new Sprav(87, "SHAKE_FREQ_SHIFT.ROLL"));
        list.add(new Sprav(88, "SHAKE_FREQ_SHIFT.TILT"));
        list.add(new Sprav(89, "SHAKE_FREQ_SHIFT.PAN"));
        list.add(new Sprav(90, "SHAKE_MASTER_GAIN"));
        list.add(new Sprav(97, "IMU_A_CORR.ROLL"));
        list.add(new Sprav(98, "IMU_A_CORR.PITCH"));
        BoardInfo info = BoardInfo.getBoardInfo();
        if (info != null && info.adjVarsInfo != null) {
            for (Sprav item : list) {
                boolean found = false;
                for (AdjVarInfo var : info.adjVarsInfo) {
                    if (item.getId() != var.id) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                item.setName("x " + item.getName());
            }
            ArrayList<Sprav> append = new ArrayList<Sprav>();
            for (AdjVarInfo var : info.adjVarsInfo) {
                boolean found = false;
                for (Sprav item : list) {
                    if (item.getId() != var.id) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                append.add(new Sprav(var.id, var.name));
            }
            list.addAll(append);
        }
        return list;
    }

    public static ArrayList<Sprav> getEncoderList() {
        ResourceMap r = SimpleBGC_GUIApp.getResourceMap();
        ArrayList<Sprav> list = new ArrayList<Sprav>();
        list.add(new Sprav(0, r.getString("option.disabled", new Object[0])));
        for (Map.Entry<Integer, String> entry : BoardParams.ENC_TYPE_NAMES.entrySet()) {
            int type = entry.getKey();
            if (type <= 0 || !BoardParams.is_encoder_supported_by_main_ctrl(type)) continue;
            list.add(new Sprav(type, entry.getValue()));
        }
        return list;
    }

    public static ArrayList<Sprav> getCANDrvEncoderList() {
        ResourceMap r = SimpleBGC_GUIApp.getResourceMap();
        ArrayList<Sprav> list = new ArrayList<Sprav>();
        list.add(new Sprav(0, r.getString("option.disabled", new Object[0])));
        for (Map.Entry<Integer, String> entry : BoardParams.CAN_DRV_ENC_TYPE_NAMES.entrySet()) {
            int type = entry.getKey();
            if (type <= 0) continue;
            list.add(new Sprav(type, entry.getValue()));
        }
        return list;
    }

    public static ArrayList<Sprav> getEncoderCfgList(int type, boolean isCANDrv) {
        ArrayList<Sprav> spravList = new ArrayList<Sprav>();
        String[] arrList = null;
        if (BoardParams.encoder_has_cfg(type)) {
            int i;
            int j;
            String[] list_spi = new String[]{"1MHz", "2MHz", "4MHz", "500kHz"};
            int SPEED_NUM = 4;
            if (type == 64) {
                arrList = new String[4];
                for (int i2 = 0; i2 < 4; ++i2) {
                    arrList[i2] = list_spi[i2];
                }
            } else if (type == 32) {
                int RESOLUTION_NUM = 8;
                arrList = new String[32];
                for (j = 0; j < 8; ++j) {
                    for (i = 0; i < 4; ++i) {
                        arrList[j * 4 + i] = list_spi[i] + ", " + (j + 14) + "bits";
                    }
                }
            } else if (type == 45) {
                String[] list_ssi = new String[]{"500kHz", "1MHz", "2MHz"};
                int RESOLUTION_NUM = 9;
                int SPEED_NUM_SSI = 3;
                arrList = new String[27];
                for (int j2 = 0; j2 < 9; ++j2) {
                    for (int i3 = 0; i3 < 3; ++i3) {
                        arrList[j2 * 3 + i3] = list_ssi[i3] + ", " + (j2 + 14) + "bits";
                    }
                }
            } else if (type == 43) {
                int RESOLUTION_NUM = 4;
                for (j = 0; j < BoardParams.ENC_TYPE_AKSIM2_TYPES.length; ++j) {
                    block6: for (int m = 0; m < 2; ++m) {
                        String str1 = BoardParams.ENC_TYPE_AKSIM2_TYPES[j] + ", ";
                        if (m == 1) {
                            str1 = str1 + "multiturn, ";
                        }
                        for (int k = 0; k < 4; ++k) {
                            String str2 = str1;
                            if (j == 1) {
                                str2 = str2 + (k + 17) + "bits, ";
                            }
                            for (int i4 = 0; i4 < 4; ++i4) {
                                int idx = (j << 5) + (m << 4) + (k << 2) + i4;
                                String name = str2 + list_spi[i4];
                                spravList.add(new Sprav(idx, name));
                            }
                            if (j != 1) continue block6;
                        }
                    }
                }
            } else if (type == 46) {
                int RESOLUTION_NUM = 3;
                for (int k = 0; k < 3; ++k) {
                    for (i = 0; i < 4; ++i) {
                        int idx = (k + 1 << 2) + i;
                        spravList.add(new Sprav(idx, list_spi[i] + ", " + (k + 18) + "bits"));
                    }
                }
            } else {
                arrList = list_spi;
            }
        } else if (!isCANDrv) {
            if (type == 2) {
                arrList = new String[]{"default address (0x40+axis)", "I2C address 0x40", "I2C address 0x41", "I2C address 0x42"};
            } else if (BoardParams.ENCODER_I2C_ADDRESS_RANGE.containsKey(type)) {
                Integer[] range = BoardParams.ENCODER_I2C_ADDRESS_RANGE.get(type);
                if (range.length > 1) {
                    arrList = new String[range.length + 2];
                    arrList[0] = "default address (0x" + (type == 47 ? "40" : Integer.toHexString(range[0]) + "+axis") + ")";
                    for (int i = 0; i < range.length; ++i) {
                        arrList[i + 1] = new String("I2C address 0x" + Integer.toHexString(range[i]));
                    }
                }
            } else if (type == 7) {
                arrList = new String[]{"default", "ADC1", "ADC2", "ADC3"};
            } else if (BoardParams.is_encoder_i2c_drv(type)) {
                ResourceMap r = SimpleBGC_GUIApp.getResourceMap();
                arrList = new String[BoardParams.ENC_SUB_TYPE_NAMES.length];
                arrList[0] = r.getString("option.disabled", new Object[0]);
                for (int sub_type = 1; sub_type < BoardParams.ENC_SUB_TYPE_NAMES.length; ++sub_type) {
                    arrList[sub_type] = BoardParams.ENC_SUB_TYPE_NAMES[sub_type];
                }
            } else if (type == 38) {
                arrList = new String[]{"I2C address 0x0C", "I2C address 0x0D", "I2C address 0x0E", "I2C address 0x0F"};
            }
        }
        if (arrList != null) {
            for (int i = 0; i < arrList.length; ++i) {
                spravList.add(new Sprav(i, (String)arrList[i]));
            }
        }
        return spravList;
    }

    public static ArrayList<Sprav> getOOAList(BoardInfo info) {
        ResourceMap r = SimpleBGC_GUIApp.getResourceMap();
        ArrayList<Sprav> list = new ArrayList<Sprav>();
        list.add(new Sprav(0, r.getString("ooa.pitch_roll_yaw", new Object[0])));
        list.add(new Sprav(1, r.getString("ooa.yaw_roll_pitch", new Object[0])));
        if (BoardInfo.hasBoardFeature(128L)) {
            list.add(new Sprav(2, r.getString("ooa.roll_yaw_pitch", new Object[0])));
        }
        list.add(new Sprav(3, r.getString("ooa.roll_pitch_yaw", new Object[0])));
        return list;
    }

    public static ArrayList<Sprav> getSerialPortList() {
        ResourceMap r = SimpleBGC_GUIApp.getResourceMap();
        ArrayList<Sprav> list = new ArrayList<Sprav>();
        list.add(new Sprav(0, r.getString("option.disabled", new Object[0])));
        list.addAll(BoardInfo.getSerialPortList());
        return list;
    }

    public static ArrayList<Sprav> getMavlinkSrcList() {
        return ParamsUIFactory.getSerialPortList();
    }

    public static ArrayList<Sprav> getMavlinkCfgList() {
        ArrayList<Sprav> list = new ArrayList<Sprav>();
        for (int i = 0; i < SerialPortService.SERIAL_BAUD_RATES.length; ++i) {
            for (int parity = 0; parity < 2; ++parity) {
                list.add(new Sprav(parity << 3 | i, SerialPortService.SERIAL_BAUD_RATES[i] + ", " + (parity == 0 ? "none" : "even") + " parity"));
            }
        }
        return list;
    }

    public static ArrayList<Sprav> getFrameIMUPosList() {
        ArrayList<Sprav> list = new ArrayList<Sprav>();
        list.add(new Sprav(2, "On the frame, above the outer motor"));
        list.add(new Sprav(1, "Below the outer motor"));
        if (BoardInfo.checkMinPartnerFirmwareVer(2660)) {
            list.add(new Sprav(8, "Below the middle motor"));
            list.add(new Sprav(9, "On the camera platform"));
        }
        return list;
    }

    public static ArrayList<Sprav> getDigitalOutputList() {
        ArrayList<Sprav> list = new ArrayList<Sprav>();
        list.add(new Sprav(0, "disabled"));
        for (int i = 0; i < 3; ++i) {
            list.add(new Sprav(BoardParams.AUX_PIN_ID[i], "AUX " + (i + 1)));
        }
        list.add(new Sprav(1, "RC_ROLL"));
        list.add(new Sprav(2, "RC_PITCH"));
        list.add(new Sprav(5, "RC_YAW"));
        list.add(new Sprav(3, "FC_ROLL"));
        list.add(new Sprav(4, "FC_PITCH"));
        return list;
    }

    public static ArrayList<Sprav> getExtraBtnPinList() {
        return ParamsUIFactory.getDigitalOutputList();
    }

    public static ArrayList<Sprav> getMavCtrlModeList() {
        ArrayList<Sprav> list = new ArrayList<Sprav>();
        list.add(new Sprav(0, "Disabled - use normal RC/Follow settings"));
        list.add(new Sprav(1, "Controls ROLL and PITCH axes only"));
        list.add(new Sprav(2, "Controls all axes"));
        return list;
    }

    public static ArrayList<Sprav> getMotor4OutputList(BoardInfo info) {
        int i;
        ArrayList<Sprav> list = new ArrayList<Sprav>();
        list.add(new Sprav(0, "SBGC32 Serial API"));
        for (i = 0; i < 4; ++i) {
            list.add(new Sprav(32 + i, "PWM Servo #" + (i + 1)));
        }
        for (i = 0; i < 7; ++i) {
            list.add(new Sprav(64 + i, "CAN_Drv #" + (i + 1)));
        }
        return list;
    }

    public static ArrayList<Sprav> getCANDrvList(BoardInfo info) {
        int i;
        ArrayList<Sprav> list = new ArrayList<Sprav>();
        list.add(new Sprav(0, "SBGC32 Serial API"));
        for (i = 0; i < 4; ++i) {
            list.add(new Sprav(32 + i, "PWM Servo #" + (i + 1)));
        }
        for (i = 0; i < 7; ++i) {
            list.add(new Sprav(64 + i, "CAN_Drv #" + (i + 1)));
        }
        return list;
    }

    public static String getExtIMUModelName(int model) {
        if (model >= 1 && model < EXT_IMU_MODEL_NAMES.length) {
            return EXT_IMU_MODEL_NAMES[model];
        }
        return "unknown model " + model;
    }

    public static ArrayList<Sprav> getExtIMUTypeList() {
        ResourceMap r = SimpleBGC_GUIApp.getResourceMap();
        ArrayList<Sprav> list = new ArrayList<Sprav>();
        list.add(new Sprav(0, r.getString("option.disabled", new Object[0])));
        list.add(new Sprav(1, EXT_IMU_MODEL_NAMES[1]));
        list.add(new Sprav(2, EXT_IMU_MODEL_NAMES[2]));
        if (BoardInfo.hasBoardFeature(32768L) || BoardInfo.isDebugMode()) {
            list.add(new Sprav(3, EXT_IMU_MODEL_NAMES[3]));
            if (BoardInfo.checkMinBaseFirmwareVer(2704)) {
                list.add(new Sprav(3, EXT_IMU_MODEL_NAMES[6]));
            }
            list.add(new Sprav(4, EXT_IMU_MODEL_NAMES[4]));
        }
        if (BoardInfo.checkMinPartnerFirmwareVer(2687)) {
            list.add(new Sprav(5, EXT_IMU_MODEL_NAMES[5]));
        }
        return list;
    }

    public static ArrayList<Sprav> getExtIMUPortList() {
        ArrayList<Sprav> list = ParamsUIFactory.getSerialPortList();
        list.add(new Sprav(10, "CAN"));
        return list;
    }

    public static ArrayList<Sprav> getExtSensTypeList() {
        ArrayList<Sprav> list = new ArrayList<Sprav>();
        list.add(new Sprav(0, "no"));
        if (BoardInfo.hasExtSensor()) {
            list.add(new Sprav(1, "KVH 1725"));
            list.add(new Sprav(2, "KVH 1750 (ACC 2G)"));
            list.add(new Sprav(3, "KVH 1750 (ACC 10G)"));
            list.add(new Sprav(4, "KVH 1750 (ACC 30G)"));
            list.add(new Sprav(5, "KVH 1775 (ACC 10G)"));
            list.add(new Sprav(6, "KVH 1775 (ACC 25G)"));
            list.add(new Sprav(7, "KVH 1760"));
            list.add(new Sprav(8, "ADXRS453"));
            list.add(new Sprav(9, "ADIS16460"));
            list.add(new Sprav(10, "STIM210"));
            list.add(new Sprav(11, "STIM300"));
            list.add(new Sprav(64, "Vectornav VN100/200 (UART)"));
            list.add(new Sprav(65, "Vectornav VN100/200 (SPI)"));
            list.add(new Sprav(12, "Murata SCHA63X"));
            list.add(new Sprav(13, "FG-50 (Z-axis)"));
            list.add(new Sprav(33, "EPSON_G354"));
            list.add(new Sprav(34, "EPSON_G364PDC0"));
            list.add(new Sprav(35, "EPSON_G364PDCA"));
            list.add(new Sprav(36, "EPSON_V340"));
            list.add(new Sprav(37, "EPSON_G365PDF0"));
            list.add(new Sprav(38, "EPSON_G365PDC0"));
            list.add(new Sprav(39, "EPSON_G365PDF1"));
            list.add(new Sprav(40, "EPSON_G365PDC1"));
            list.add(new Sprav(43, "EPSON_G366PDG0"));
            list.add(new Sprav(41, "EPSON_G370PDF0"));
            list.add(new Sprav(42, "EPSON_G370PDF1"));
            list.add(new Sprav(66, "KEBNI_AHRS (SPI)"));
        }
        return list;
    }

    public static int getExtSensCalibValNum(int id) {
        return id == 13 ? 1 : 0;
    }

    public static ArrayList<Sprav> geSerialLinkPortList(int function) {
        ArrayList<Sprav> list = new ArrayList<Sprav>();
        list.add(new Sprav(0, "disabled"));
        for (int device = 1; device < SerialLinkCfg.DEVICE_NAMES.length; ++device) {
            ListOption opt = SerialLinkCfg.DEVICE_NAMES[device];
            if (!opt.available()) continue;
            for (int j = 0; j < SerialLinkCfg.PORT_NAMES[device].length; ++j) {
                list.add(new Sprav(device << 2 | j & 3, opt.name + " " + SerialLinkCfg.PORT_NAMES[device][j]));
            }
        }
        return list;
    }

    public static ArrayList<Sprav> geSerialLinkFunctionList() {
        ArrayList<Sprav> list = new ArrayList<Sprav>();
        list.add(new Sprav(0, "disabled"));
        for (int i = 1; i < SerialLinkCfg.FUNCTION_NAMES.length; ++i) {
            list.add(new Sprav(i, SerialLinkCfg.FUNCTION_NAMES[i]));
        }
        return list;
    }

    public static ArrayList<Sprav> getIMUModelList(boolean isFrame) {
        ArrayList<Sprav> list = new ArrayList<Sprav>();
        list.add(new Sprav(0, "auto-detect"));
        list.add(new Sprav(1, "I2C_IMU (main 0x68)"));
        list.add(new Sprav(2, "I2C_IMU (frame 0x69)"));
        list.add(new Sprav(3, "CAN_IMU via CAN (main)"));
        list.add(new Sprav(4, "CAN_IMU via CAN (frame)"));
        list.add(new Sprav(5, "CAN_IMU via I2C (main)"));
        list.add(new Sprav(6, "CAN_IMU via I2C (frame)"));
        if (!isFrame) {
            list.add(new Sprav(7, "GPS_IMU via CAN"));
            list.add(new Sprav(16, "ADIS16460/16465 (SPI)"));
        }
        list.add(new Sprav(255, "On-board I2C sensor"));
        return list;
    }

    public static ArrayList<Sprav> getExtLicensesTypes() {
        ArrayList<Sprav> list = new ArrayList<Sprav>();
        for (int i = 1; i < BoardInfo.EXT_LIC_TYPE_LIST.length; ++i) {
            list.add(new Sprav(i, BoardInfo.getExtLicName(i)));
        }
        return list;
    }

    public static List<Sprav> getVibrationTestSensors() {
        List<Sprav> s_list = Arrays.asList(new Sprav(0, "Main IMU - gyroscope"), new Sprav(1, "Main IMU - accelerometer"), new Sprav(8, "Frame IMU - gyroscope"), new Sprav(9, "Frame IMU - accelerometer"));
        return s_list;
    }

    public static List<Sprav> getTransferTestSensors() {
        List<Sprav> s_list = Arrays.asList(new Sprav(16, "Gyroscope X"), new Sprav(17, "Gyroscope Y"), new Sprav(18, "Gyroscope Z"), new Sprav(19, "Gyroscope ROLL motor"), new Sprav(20, "Gyroscope PITCH motor"), new Sprav(21, "Gyroscope YAW motor"), new Sprav(22, "Accelerometer X"), new Sprav(23, "Accelerometer Y"), new Sprav(24, "Accelerometer Z"));
        return s_list;
    }

    public static List<Sprav> getEulerOrderList() {
        ArrayList<Sprav> list = new ArrayList<Sprav>(Arrays.asList(new Sprav(0, "Cam - PITCH - ROLL - YAW"), new Sprav(1, "Cam - ROLL - PITCH - YAW"), new Sprav(2, "Cam - PITCH(M) - ROLL - YAW(M)"), new Sprav(3, "Cam - ROLL - PITCH(M) - YAW(M)"), new Sprav(4, "Cam - YAW - ROLL - PITCH")));
        return list;
    }

    public static List<Sprav> getStabAxesList() {
        ArrayList<Sprav> list = new ArrayList<Sprav>(Arrays.asList(new Sprav(0, "In Euler axes (default)"), new Sprav(8, "Stabilize Euler axes, control in XYZ axes")));
        if (BoardInfo.checkMinBaseFirmwareVer(2740)) {
            list.add(new Sprav(24, "Stabilize & control in XYZ axes"));
        }
        return list;
    }

    static enum RCMapFieldType {
        COMMON,
        STEP_SIGNAL,
        SERVO_OUT;

    }
}

