/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import sbgc.object.Sprav;

public class SpravComboBoxModel
extends AbstractListModel
implements ComboBoxModel {
    private Object selectedItem = null;
    private final List<Sprav> elements;
    private Sprav current = null;

    public SpravComboBoxModel(List<Sprav> ops) {
        this.elements = ops;
    }

    public SpravComboBoxModel(List<Sprav> ops, ComboBoxModel prevModel) {
        this(ops);
        if (prevModel != null) {
            this.setSelectedItem(prevModel.getSelectedItem());
        }
    }

    public SpravComboBoxModel(List<Sprav> ops, int selectedId) {
        this(ops);
        this.setCurrentOrAdd(selectedId, "item");
    }

    public SpravComboBoxModel(List<Sprav> ops, int selectedId, String itemName) {
        this(ops);
        this.setCurrentOrAdd(selectedId, itemName);
    }

    public static List<Sprav> elementsFromArray(int[] arr) {
        ArrayList<Sprav> list = new ArrayList<Sprav>(arr.length);
        for (int i = 0; i < arr.length; ++i) {
            list.add(new Sprav(i, Integer.toString(arr[i])));
        }
        return list;
    }

    public static List<Sprav> elementsFromArray(String[] arr, int firstId) {
        ArrayList<Sprav> list = new ArrayList<Sprav>(arr.length);
        for (int i = 0; i < arr.length; ++i) {
            list.add(new Sprav(firstId + i, arr[i]));
        }
        return list;
    }

    public static List<Sprav> elemetntsFromHashMap(HashMap<Integer, String> map) {
        ArrayList<Sprav> list = new ArrayList<Sprav>(map.size());
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            list.add(new Sprav(entry.getKey(), entry.getValue()));
        }
        return list;
    }

    Sprav findElement(Integer id) {
        for (Sprav row : this.elements) {
            if (!row.getId().equals(id)) continue;
            return row;
        }
        return null;
    }

    Sprav findElement(String name) {
        for (Sprav row : this.elements) {
            if (!row.getName().equalsIgnoreCase(name)) continue;
            return row;
        }
        return null;
    }

    private void setSelectedItem(Sprav row) {
        if (row != null) {
            this.selectedItem = row.getName();
            this.current = row;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    @Override
    public Object getElementAt(int i) {
        Sprav row = this.elements.get(i);
        return row.getName();
    }

    @Override
    public int getSize() {
        return this.elements.size();
    }

    @Override
    public final void setSelectedItem(Object newValue) {
        if (newValue == null) {
            return;
        }
        this.setSelectedItem(this.findElement((String)newValue));
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    public Sprav getCurrent() {
        return this.current;
    }

    public Integer getCurrentId() {
        if (this.current != null) {
            return this.current.getId();
        }
        return new Integer(0);
    }

    public boolean setCurrent(Integer id) {
        Sprav row = this.findElement(id);
        if (row != null) {
            this.setSelectedItem(row);
            return true;
        }
        return false;
    }

    public void setCurrentOrAdd(Integer id) {
        this.setCurrentOrAdd(id, "option<" + id + ">");
    }

    public void setCurrentOrAdd(Integer id, String itemName) {
        Sprav row = this.findElement(id);
        if (row != null) {
            this.setSelectedItem(row);
        } else {
            row = new Sprav(id, itemName + "#" + id);
            this.elements.add(row);
            this.setSelectedItem(row);
        }
    }
}

