/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;
import sbgc.object.BoardInfo;
import sbgc.ui.GroupView;
import sbgc.ui.ITabbedPanel;
import sbgc.ui.ShowMorePanel;
import sbgc.ui.groups.IGroupPanel;
import sbgc.utils.Log;
import simplebgc_gui.SimpleBGC_GUIApp;
import simplebgc_gui.SimpleBGC_GUIView;

public abstract class TabbedPanelBase
extends JPanel
implements ITabbedPanel {
    protected final SimpleBGC_GUIView mainView;
    protected final ResourceMap resourceMap;
    protected final ResourceMap appResourceMap;
    protected final Log logger;
    private Component[] groups = null;
    protected JPanel contentPanel = null;
    Container parentContainer = null;

    protected static SpinnerNumberModel spinnerModel_50u() {
        return new SpinnerNumberModel(0, 0, 50, 1);
    }

    protected static SpinnerNumberModel spinnerModel_100u() {
        return new SpinnerNumberModel(0, 0, 100, 1);
    }

    protected static SpinnerNumberModel spinnerModel_100s() {
        return new SpinnerNumberModel(0, -100, 100, 1);
    }

    protected static SpinnerNumberModel spinnerModel_255u() {
        return new SpinnerNumberModel(0, 0, 255, 1);
    }

    protected static SpinnerNumberModel spinnerModel_500u() {
        return new SpinnerNumberModel(0, 0, 500, 2);
    }

    protected static SpinnerNumberModel spinnerModel_127s() {
        return new SpinnerNumberModel(0, -127, 127, 1);
    }

    protected static SpinnerNumberModel spinnerModel_50f() {
        return new SpinnerNumberModel(0.0, 0.0, 0.5, 0.01);
    }

    protected static SpinnerNumberModel spinnerModel_255f() {
        return new SpinnerNumberModel(0.0, 0.0, 2.55, 0.01);
    }

    protected static SpinnerNumberModel spinnerModel_25_5f() {
        return new SpinnerNumberModel(0.0, 0.0, 25.5, 0.1);
    }

    protected static SpinnerNumberModel spinnerModel_16u() {
        return new SpinnerNumberModel(0, 0, 16, 1);
    }

    protected static SpinnerNumberModel spinnerModel_5000f() {
        return new SpinnerNumberModel(0.0, 0.0, 50.0, 0.01);
    }

    protected static SpinnerNumberModel spinnerModel_word() {
        return new SpinnerNumberModel(0, Short.MIN_VALUE, Short.MAX_VALUE, 1);
    }

    protected static SpinnerNumberModel spinnerModel_1000u() {
        return new SpinnerNumberModel(0, 0, 1000, 1);
    }

    protected static void setSpinnerNumberModelAndEditor(JSpinner spinner, SpinnerNumberModel model) {
        Object val = spinner.getValue();
        if (val != null && val.getClass().isInstance(model.getValue())) {
            model.setValue(val);
        }
        spinner.setModel(model);
        spinner.setEditor(new JSpinner.NumberEditor(spinner));
    }

    protected TabbedPanelBase(SimpleBGC_GUIView mainView) {
        this.mainView = mainView;
        this.appResourceMap = SimpleBGC_GUIApp.getResourceMap();
        this.resourceMap = SimpleBGC_GUIApp.getResourceMap(this.getClass());
        this.logger = new Log(Logger.getLogger((String)this.getClass().getName()));
    }

    protected void addGroupPanels(IGroupPanel[] groupPanels) {
        for (IGroupPanel gp : groupPanels) {
            Component c = (Component)((Object)gp);
            this.add(c);
            c.setBounds(0, 0, c.getPreferredSize().width, c.getPreferredSize().height + 15);
        }
    }

    protected void prepareLayout() {
        for (Component c : this.groups = this.getComponents()) {
            c.setPreferredSize(c.getSize());
            c.setMinimumSize(c.getSize());
            this.remove(c);
        }
        this.contentPanel = new JPanel();
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setViewportView(this.contentPanel);
        scrollPane.getVerticalScrollBar().setUnitIncrement(15);
        this.setLayout(new BoxLayout(this, 2));
        this.add(scrollPane);
    }

    @Override
    public boolean showGroups() {
        this.contentPanel.removeAll();
        int targetWidth = 710;
        boolean hasGroups = false;
        if (this.groups != null) {
            GridBagLayout gridbag = new GridBagLayout();
            this.contentPanel.setLayout(gridbag);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.anchor = 18;
            c.weightx = 1.0;
            c.gridheight = 1;
            c.gridx = 0;
            c.gridy = 0;
            ArrayList<Component> list = new ArrayList<Component>(this.groups.length + 1);
            for (Component comp : this.groups) {
                if (!GroupView.canShowGroup(comp, this, true)) continue;
                list.add(comp);
                GroupView.processComponentChildsViewLevel(comp);
                hasGroups = true;
            }
            if (this.hasHiddenGroups() && SimpleBGC_GUIView.getMaxViewLevel().compareTo(GroupView.VIEW.BASIC) > 0) {
                ShowMorePanel comp = new ShowMorePanel();
                list.add(comp);
            }
            for (Component comp : list) {
                c.weighty = (double)comp.getMaximumSize().height / 32767.0;
                if (c.gridx < 2 && comp.getPreferredSize().width <= targetWidth / 2) {
                    c.gridwidth = 1;
                    gridbag.setConstraints(comp, c);
                    if (++c.gridx == 2) {
                        c.gridx = 0;
                        ++c.gridy;
                    }
                } else {
                    if (c.gridx > 0) {
                        c.gridx = 0;
                        ++c.gridy;
                    }
                    c.gridwidth = 2;
                    gridbag.setConstraints(comp, c);
                    ++c.gridy;
                }
                this.contentPanel.add(comp);
            }
        }
        this.contentPanel.validate();
        return hasGroups;
    }

    @Override
    public boolean hasVisibleGroups() {
        if (this.groups != null) {
            for (Component c : this.groups) {
                if (!GroupView.canShowGroup(c, this, true)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasHiddenGroups() {
        if (this.groups != null) {
            for (Component c : this.groups) {
                if (GroupView.canShowGroup(c, this, false)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getTitle() {
        return this.resourceMap.getString("panel.title", new Object[0]);
    }

    @Override
    public Component[] getGroups() {
        return this.groups;
    }

    public static void setComboBoxDefaultModel(JComboBox cb, ComboBoxModel model) {
        Object sel = cb.getSelectedItem();
        cb.setModel(model);
        if (sel != null) {
            cb.setSelectedItem(sel);
        }
    }

    @Override
    public Component getComponent() {
        return this;
    }

    public void setParentContainer(Container c) {
        this.parentContainer = c;
    }

    @Override
    public Container getParentContainer() {
        return this.parentContainer;
    }

    public boolean isPortConnected() {
        return this.mainView.isPortConnected();
    }

    public void setPortConnected(boolean b) {
    }

    public boolean isConnected() {
        return this.mainView.isConnected();
    }

    public void setConnected(boolean b) {
        this.mainView.setConnected(b);
    }

    public boolean isConnectedDebugMode() {
        return this.isConnected() && (SimpleBGC_GUIApp.debugMode || BoardInfo.isDebugMode());
    }

    public void setConnectedDebugMode(boolean b) {
    }

    public static void setEnabledTree(Component parent, boolean state) {
        parent.setEnabled(state && GroupView.isComponentEnabled(parent));
        TabbedPanelBase.setEnabledTreeExclusive(parent, state);
    }

    public static void setEnabledTreeExclusive(Component parent, boolean state) {
        if (parent instanceof Container) {
            for (Component child : ((Container)parent).getComponents()) {
                TabbedPanelBase.setEnabledTree(child, state);
            }
        }
    }

    @Override
    public boolean onBeforeClose() {
        return true;
    }

    @Override
    public void onConnected(boolean state) {
    }
}

