/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.xml.bind.DatatypeConverter;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import sbgc.object.BoardInfo;
import sbgc.object.BoardParams;
import sbgc.object.BoardProfile;
import sbgc.object.RealtimeData;
import sbgc.object.Sprav;
import sbgc.script_parser.utils.FileHelper;
import sbgc.service.CommandResponseListener;
import sbgc.service.RealtimeDataThread;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandProcessor;
import sbgc.service.SerialPortService;
import sbgc.ui.ITabbedPanel;
import sbgc.ui.SpravComboBoxModel;
import sbgc.ui.TabbedPanelBase;
import sbgc.utils.BGCJFileSaver;
import sbgc.utils.Log;
import sbgc.utils.Settings;
import sbgc.utils.apiTestUtils;
import simplebgc_gui.SimpleBGC_GUIApp;
import simplebgc_gui.SimpleBGC_GUIView;

public class TabbedPanelDebug
extends TabbedPanelBase
implements ITabbedPanel {
    private boolean isCmdDebugPaused = false;
    Thread testThread;
    int showCommandsLevel;
    boolean initDone = false;
    ArrayList<CmdSendingThread> cmdSendingThreads = new ArrayList();
    private JPanel groupDebug;
    private JButton jButtonDebugClear;
    private JButton jButtonDebugCmd;
    private JButton jButtonDebugConnect;
    private JButton jButtonDebugPortCfg;
    private JButton jButtonDebugRequestState;
    private JButton jButtonRepeatStop;
    private JButton jButtonSaveTxt;
    private JButton jButtonTest1;
    private JCheckBox jCheckBoxParity;
    private JCheckBox jCheckBoxRepeat;
    private JComboBox jComboBoxBaud;
    private JComboBox jComboBoxCmdData;
    private JComboBox jComboBoxProtocolVer;
    private JComboBox jComboBoxShowCommands;
    private JLabel jLabel1;
    private JLabel jLabel77;
    private JLabel jLabel78;
    private JLabel jLabelShowCommands;
    private JScrollPane jScrollPane2;
    private JSpinner jSpinnerRepeat;
    private JTextArea jTextAreaDebugCmd;
    private JTextField jTextFieldDebugCmd;
    private JToggleButton jToggleButtonSetDebugPort;

    public TabbedPanelDebug(SimpleBGC_GUIView mainView) {
        super(mainView);
        this.initComponents();
        this.prepareLayout();
        this.showCommandsLevel = Settings.getInt("debug.show_commands", SimpleBGC_GUIApp.debugMode ? 2 : 0);
        this.jComboBoxShowCommands.setSelectedIndex(this.showCommandsLevel);
        this.jComboBoxBaud.setModel(new SpravComboBoxModel(SpravComboBoxModel.elementsFromArray(SerialPortService.SERIAL_BAUD_RATES_EXTENDED)));
        ((SpravComboBoxModel)this.jComboBoxBaud.getModel()).setCurrent(Settings.getInt("latest.serial.baud", 0));
        this.initDone = true;
    }

    private void initComponents() {
        this.groupDebug = new JPanel();
        this.jLabel77 = new JLabel();
        this.jTextFieldDebugCmd = new JTextField();
        this.jButtonDebugCmd = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTextAreaDebugCmd = new JTextArea();
        this.jButtonDebugClear = new JButton();
        this.jLabel78 = new JLabel();
        this.jButtonDebugConnect = new JButton();
        this.jCheckBoxParity = new JCheckBox();
        this.jButtonDebugRequestState = new JButton();
        this.jToggleButtonSetDebugPort = new JToggleButton();
        this.jCheckBoxRepeat = new JCheckBox();
        this.jSpinnerRepeat = new JSpinner();
        this.jLabel1 = new JLabel();
        this.jButtonRepeatStop = new JButton();
        this.jButtonTest1 = new JButton();
        this.jButtonSaveTxt = new JButton();
        this.jButtonDebugPortCfg = new JButton();
        this.jComboBoxProtocolVer = new JComboBox();
        this.jComboBoxBaud = new JComboBox();
        this.jComboBoxCmdData = new JComboBox();
        this.jComboBoxShowCommands = new JComboBox();
        this.jLabelShowCommands = new JLabel();
        this.setName("Debug");
        this.setLayout(null);
        this.groupDebug.setName("groupDebug");
        this.groupDebug.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabel77.setText("Command ID:");
        this.jLabel77.setName("jLabel77");
        this.groupDebug.add((Component)this.jLabel77, new AbsoluteConstraints(20, 50, -1, -1));
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(TabbedPanelDebug.class);
        this.jTextFieldDebugCmd.setToolTipText(resourceMap.getString("jTextFieldDebugCmd.toolTipText", new Object[0]));
        this.jTextFieldDebugCmd.setName("jTextFieldDebugCmd");
        this.groupDebug.add((Component)this.jTextFieldDebugCmd, new AbsoluteConstraints(110, 50, 40, -1));
        this.jButtonDebugCmd.setText("SEND");
        this.jButtonDebugCmd.setName("jButtonDebugCmd");
        this.jButtonDebugCmd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TabbedPanelDebug.this.jButtonDebugCmdActionPerformed(evt);
            }
        });
        this.groupDebug.add((Component)this.jButtonDebugCmd, new AbsoluteConstraints(570, 50, -1, -1));
        this.jScrollPane2.setName("jScrollPane2");
        this.jTextAreaDebugCmd.setColumns(20);
        this.jTextAreaDebugCmd.setRows(5);
        this.jTextAreaDebugCmd.setTabSize(4);
        this.jTextAreaDebugCmd.setName("jTextAreaDebugCmd");
        this.jScrollPane2.setViewportView(this.jTextAreaDebugCmd);
        this.groupDebug.add((Component)this.jScrollPane2, new AbsoluteConstraints(20, 80, 690, 220));
        this.jButtonDebugClear.setText("CLEAR");
        this.jButtonDebugClear.setName("jButtonDebugClear");
        this.jButtonDebugClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TabbedPanelDebug.this.jButtonDebugClearActionPerformed(evt);
            }
        });
        this.groupDebug.add((Component)this.jButtonDebugClear, new AbsoluteConstraints(640, 50, -1, -1));
        this.jLabel78.setText("data (hex):");
        this.jLabel78.setName("jLabel78");
        this.groupDebug.add((Component)this.jLabel78, new AbsoluteConstraints(170, 50, -1, -1));
        ApplicationActionMap actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(TabbedPanelDebug.class, this);
        this.jButtonDebugConnect.setAction(actionMap.get("debugConnect"));
        this.jButtonDebugConnect.setText(resourceMap.getString("jButtonDebugConnect.text", new Object[0]));
        this.jButtonDebugConnect.setToolTipText(resourceMap.getString("jButtonDebugConnect.toolTipText", new Object[0]));
        this.jButtonDebugConnect.setName("jButtonDebugConnect");
        this.groupDebug.add((Component)this.jButtonDebugConnect, new AbsoluteConstraints(230, 10, 120, -1));
        this.jCheckBoxParity.setText(resourceMap.getString("jCheckBoxParity.text", new Object[0]));
        this.jCheckBoxParity.setToolTipText(resourceMap.getString("jCheckBoxParity.toolTipText", new Object[0]));
        this.jCheckBoxParity.setName("jCheckBoxParity");
        this.groupDebug.add((Component)this.jCheckBoxParity, new AbsoluteConstraints(160, 10, -1, -1));
        this.jButtonDebugRequestState.setAction(actionMap.get("buttonDebugRequestState"));
        this.jButtonDebugRequestState.setFont(this.jButtonDebugRequestState.getFont().deriveFont(this.jButtonDebugRequestState.getFont().getStyle() | 1));
        this.jButtonDebugRequestState.setIcon(resourceMap.getIcon("jButtonDebugRequestState.icon"));
        this.jButtonDebugRequestState.setText(resourceMap.getString("jButtonDebugRequestState.text", new Object[0]));
        this.jButtonDebugRequestState.setName("jButtonDebugRequestState");
        this.groupDebug.add((Component)this.jButtonDebugRequestState, new AbsoluteConstraints(550, 10, 160, -1));
        this.jToggleButtonSetDebugPort.setAction(actionMap.get("setDebugPort"));
        this.jToggleButtonSetDebugPort.setText(resourceMap.getString("jToggleButtonSetDebugPort.text", new Object[0]));
        this.jToggleButtonSetDebugPort.setToolTipText(resourceMap.getString("jToggleButtonSetDebugPort.toolTipText", new Object[0]));
        this.jToggleButtonSetDebugPort.setName("jToggleButtonSetDebugPort");
        this.groupDebug.add((Component)this.jToggleButtonSetDebugPort, new AbsoluteConstraints(370, 10, 140, 25));
        this.jCheckBoxRepeat.setText(resourceMap.getString("jCheckBoxRepeat.text", new Object[0]));
        this.jCheckBoxRepeat.setName("jCheckBoxRepeat");
        this.groupDebug.add((Component)this.jCheckBoxRepeat, new AbsoluteConstraints(290, 310, 90, -1));
        this.jSpinnerRepeat.setModel(new SpinnerNumberModel((Number)100, Integer.valueOf(10), null, (Number)10));
        this.jSpinnerRepeat.setName("jSpinnerRepeat");
        this.groupDebug.add((Component)this.jSpinnerRepeat, new AbsoluteConstraints(380, 310, 60, -1));
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.groupDebug.add((Component)this.jLabel1, new AbsoluteConstraints(450, 310, -1, -1));
        this.jButtonRepeatStop.setAction(actionMap.get("buttonReleatStop"));
        this.jButtonRepeatStop.setText(resourceMap.getString("jButtonRepeatStop.text", new Object[0]));
        this.jButtonRepeatStop.setName("jButtonRepeatStop");
        this.groupDebug.add((Component)this.jButtonRepeatStop, new AbsoluteConstraints(480, 310, 70, -1));
        this.jButtonTest1.setAction(actionMap.get("buttonTest1"));
        this.jButtonTest1.setText(resourceMap.getString("jButtonTest1.text", new Object[0]));
        this.jButtonTest1.setName("jButtonTest1");
        this.groupDebug.add((Component)this.jButtonTest1, new AbsoluteConstraints(550, 310, -1, -1));
        this.jButtonSaveTxt.setAction(actionMap.get("buttonSaveTxt"));
        this.jButtonSaveTxt.setText(resourceMap.getString("jButtonSaveTxt.text", new Object[0]));
        this.jButtonSaveTxt.setName("jButtonSaveTxt");
        this.groupDebug.add((Component)this.jButtonSaveTxt, new AbsoluteConstraints(610, 310, 100, -1));
        this.jButtonDebugPortCfg.setAction(actionMap.get("buttonDebugPortConfig"));
        this.jButtonDebugPortCfg.setIcon(resourceMap.getIcon("jButtonDebugPortCfg.icon"));
        this.jButtonDebugPortCfg.setText(resourceMap.getString("jButtonDebugPortCfg.text", new Object[0]));
        this.jButtonDebugPortCfg.setMargin(new Insets(5, 5, 5, 5));
        this.jButtonDebugPortCfg.setName("jButtonDebugPortCfg");
        this.groupDebug.add((Component)this.jButtonDebugPortCfg, new AbsoluteConstraints(510, 10, -1, -1));
        this.jComboBoxProtocolVer.setModel(new DefaultComboBoxModel<String>(new String[]{"V.1", "V.2"}));
        this.jComboBoxProtocolVer.setToolTipText(resourceMap.getString("jComboBoxProtocolVer.toolTipText", new Object[0]));
        this.jComboBoxProtocolVer.setName("jComboBoxProtocolVer");
        this.groupDebug.add((Component)this.jComboBoxProtocolVer, new AbsoluteConstraints(10, 10, 60, -1));
        this.jComboBoxBaud.setToolTipText(resourceMap.getString("jComboBoxBaud.toolTipText", new Object[0]));
        this.jComboBoxBaud.setName("jComboBoxBaud");
        this.groupDebug.add((Component)this.jComboBoxBaud, new AbsoluteConstraints(70, 10, 90, -1));
        this.jComboBoxCmdData.setEditable(true);
        this.jComboBoxCmdData.setToolTipText(resourceMap.getString("jComboBoxCmdData.toolTipText", new Object[0]));
        this.jComboBoxCmdData.setName("jComboBoxCmdData");
        this.groupDebug.add((Component)this.jComboBoxCmdData, new AbsoluteConstraints(240, 48, 320, -1));
        this.jComboBoxShowCommands.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "Low duty (compact)", "Low duty (full)", "All (compact)", "All (full)"}));
        this.jComboBoxShowCommands.setName("jComboBoxShowCommands");
        this.jComboBoxShowCommands.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TabbedPanelDebug.this.jComboBoxShowCommandsItemStateChanged(evt);
            }
        });
        this.groupDebug.add((Component)this.jComboBoxShowCommands, new AbsoluteConstraints(130, 310, 140, -1));
        this.jLabelShowCommands.setText(resourceMap.getString("jLabelShowCommands.text", new Object[0]));
        this.jLabelShowCommands.setName("jLabelShowCommands");
        this.groupDebug.add((Component)this.jLabelShowCommands, new AbsoluteConstraints(20, 310, 110, -1));
        this.add(this.groupDebug);
        this.groupDebug.setBounds(0, 0, 720, 340);
    }

    private void jButtonDebugCmdActionPerformed(ActionEvent evt) {
        String payload = (String)this.jComboBoxCmdData.getSelectedItem();
        if (payload == null) {
            payload = "";
        }
        this.addOption(this.jComboBoxCmdData, payload);
        try {
            byte[] data = DatatypeConverter.parseHexBinary((String)payload.replace(" ", ""));
            int id = this.jTextFieldDebugCmd.getText().charAt(0);
            if (id < 65) {
                id = Integer.parseInt(this.jTextFieldDebugCmd.getText());
            }
            SerialCommand cmd = new SerialCommand(id, data);
            if (this.jCheckBoxRepeat.isSelected()) {
                CmdSendingThread t = new CmdSendingThread(cmd, ((Number)this.jSpinnerRepeat.getValue()).intValue());
                t.start();
                this.cmdSendingThreads.add(t);
            } else {
                SerialCommandProcessor.sendCommand(cmd);
            }
        }
        catch (Exception e) {
            this.debugMessage("err: " + e.toString());
        }
    }

    private void jButtonDebugClearActionPerformed(ActionEvent evt) {
        this.jTextAreaDebugCmd.setText(null);
    }

    private void jComboBoxShowCommandsItemStateChanged(ItemEvent evt) {
        this.showCommandsLevel = this.jComboBoxShowCommands.getSelectedIndex();
        if (this.initDone) {
            Settings.set("debug.show_commands", this.showCommandsLevel);
            Settings.save();
        }
    }

    @Override
    public void updateBoardParams(BoardParams params) {
        BoardProfile p = params.profiles[params.curProfile];
    }

    @Override
    public void updateBoardVerUI() {
        boolean debugMode = BoardInfo.isDebugMode() || SimpleBGC_GUIApp.debugMode;
        this.jButtonTest1.setVisible(debugMode);
    }

    @Override
    public void applyBoardParams(BoardParams params) {
        BoardProfile p = params.profiles[params.curProfile];
    }

    public void debugMessage(String msg) {
        this.jTextAreaDebugCmd.append(msg + "\n");
    }

    public void setPortConnectedState(boolean state) {
        this.jButtonDebugConnect.setText(state ? this.resourceMap.getString("jButtonDebugConnect.disconnect.text", new Object[0]) : this.resourceMap.getString("jButtonDebugConnect.text", new Object[0]));
        this.jComboBoxProtocolVer.setEnabled(!state);
        this.jComboBoxBaud.setEnabled(!state);
        this.jCheckBoxParity.setEnabled(!state);
        if (!state) {
            this.stopCmdSendingThreads();
        }
    }

    public void stopCmdSendingThreads() {
        for (CmdSendingThread t : this.cmdSendingThreads) {
            t.stop();
        }
        this.cmdSendingThreads.clear();
    }

    @Action
    public void debugConnect() {
        if (!this.mainView.isPortConnected()) {
            String port = this.mainView.getSelectedPort(true);
            if (port != null) {
                this.mainView.connect(port, false);
                if (SerialPortService.isPortOpened()) {
                    int baudIndex = ((SpravComboBoxModel)this.jComboBoxBaud.getModel()).getCurrentId();
                    SerialPortService.setBaudIndex(baudIndex);
                    SerialPortService.setParity(this.jCheckBoxParity.isSelected() ? 2 : 0);
                }
                SerialCommandProcessor.setProtocolVer(this.jComboBoxProtocolVer.getSelectedIndex() == 0 ? SerialCommandProcessor.ProtocolVersion.V1 : SerialCommandProcessor.ProtocolVersion.V2);
            }
        } else {
            this.mainView.disconnect();
        }
    }

    @Action(enabledProperty="connected")
    public void buttonDebugRequestState() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                TabbedPanelDebug.this.isCmdDebugPaused = true;
                boolean rt_pause_state = RealtimeDataThread.pause(true);
                BoardInfo.showBoardInfo();
                if (BoardInfo.checkMinPartnerFirmwareVer(1)) {
                    String emgInfo;
                    BoardParams params;
                    SerialCommand resp;
                    try {
                        resp = CommandResponseListener.sendCommandAndWaitAnswer(new SerialCommand(52), 10000L);
                        if (resp == null || resp.getId() != 52) {
                            throw new Exception("No response on CMD_SYSTEM_STATE command");
                        }
                        BoardInfo.parseCmdSytemState(resp);
                    }
                    catch (Exception e) {
                        TabbedPanelDebug.this.mainView.debugMessageSynced("Failed to request system info: " + e.getMessage());
                    }
                    if (BoardInfo.hasConnectedModules()) {
                        try {
                            ArrayList<Sprav> list = SerialCommandProcessor.requestModuleList(null);
                            if (list != null) {
                                StringBuilder buf = new StringBuilder(500);
                                buf.append("All connected CAN modules:");
                                for (Sprav s : list) {
                                    buf.append("\n\t");
                                    buf.append(s.getName());
                                }
                                buf.append("\n");
                                TabbedPanelDebug.this.mainView.debugMessageSynced(buf.toString());
                            } else {
                                TabbedPanelDebug.this.mainView.debugMessageSynced("\tnot found");
                            }
                        }
                        catch (Exception e) {
                            TabbedPanelDebug.this.mainView.debugMessageSynced("Failed to request CAN modules state: " + e.getMessage());
                        }
                    }
                    if (BoardInfo.hasCANDrvParams()) {
                        try {
                            resp = CommandResponseListener.sendCommandAndWaitAnswer(new SerialCommand(98), 10000L);
                            if (resp == null || resp.getId() != 98) {
                                throw new Exception("No response on CMD_SYSTEM_STATE command");
                            }
                            BoardInfo.parseCmdCanDrvState(resp);
                        }
                        catch (Exception e) {
                            TabbedPanelDebug.this.mainView.debugMessageSynced("Failed to request CAN drivers state: " + e.getMessage());
                        }
                    }
                    if ((params = BoardParams.getCurParams()) != null) {
                        TabbedPanelDebug.this.mainView.debugMessageSynced("SBGC32 local serial ports:\n\t" + String.join((CharSequence)"\n\t", params.getLocalSerialPortInfo(TabbedPanelDebug.this.mainView.panelService.getSerial_link_cfg_tmp())) + "\n");
                    }
                    if ((emgInfo = SerialCommandProcessor.getEmergencyStopErrorInfo(null)) != null) {
                        TabbedPanelDebug.this.mainView.debugMessageSynced("Last emergency stop error: " + emgInfo + "\n");
                    }
                }
                TabbedPanelDebug.this.isCmdDebugPaused = false;
                RealtimeDataThread.pause(rt_pause_state);
            }
        }).start();
    }

    private void sendSetDebugPortCmd(boolean enable) {
        try {
            SerialCommand cmd = new SerialCommand(249);
            cmd.writeByte(enable ? 1 : 0);
            long cmd_filter = 0L;
            for (int i = 0; i < SerialCommand.DEBUG_PORT_CMD_FILTER.length; ++i) {
                if (!Settings.is("debug_port.filter." + SerialCommand.DEBUG_PORT_CMD_FILTER[i].getId())) continue;
                cmd_filter |= (long)(1 << i);
            }
            cmd.writeDWord(cmd_filter);
            cmd.writeEmptyArr(11);
            SerialCommandProcessor.sendCommand(cmd);
        }
        catch (Exception e) {
            this.logger.stackTrace(e);
        }
    }

    @Action(enabledProperty="portConnected")
    public void setDebugPort() {
        this.sendSetDebugPortCmd(this.jToggleButtonSetDebugPort.isSelected());
    }

    public void parseCmdSetDebugPort(SerialCommand cmd) throws Exception {
        final int time_ms = cmd.readWordUnsigned();
        int port_dir = cmd.readByte();
        final int portIdx = port_dir & 0x7F;
        final int dir = port_dir >> 7;
        int cmdId = cmd.readByte();
        byte[] data = cmd.readBytes(cmd.getBytesAvailable());
        final SerialCommand orig_cmd = new SerialCommand(cmdId, data);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TabbedPanelDebug.this.debugMessage(Log.formatTimeMs(time_ms) + " port" + portIdx + (dir == 0 ? ".in" : ".out") + ": " + orig_cmd.toString());
            }
        });
    }

    public void parseCmdDebugStr(SerialCommand cmd) throws Exception {
        int level = cmd.readByte();
        final int timestamp_ms = cmd.readWordUnsigned();
        final String str = cmd.readString();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TabbedPanelDebug.this.debugMessage(Log.formatTimeMs(timestamp_ms) + ": " + str);
            }
        });
    }

    public int showCommandLevel(SerialCommand cmd, boolean isHeavyDuty) {
        if (this.isCmdDebugPaused || this.showCommandsLevel == 0 || this.showCommandsLevel < 3 && isHeavyDuty) {
            return 0;
        }
        return 2 - this.showCommandsLevel % 2;
    }

    @Action
    public void buttonReleatStop() {
        this.stopCmdSendingThreads();
    }

    @Action
    public void buttonTest1() {
        if (this.testThread != null && !this.testThread.isAlive()) {
            this.testThread = null;
        }
        if (this.testThread == null) {
            this.testThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        apiTestUtils.runTest4();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Exception e) {
                        TabbedPanelDebug.this.logger.stackTrace(e);
                    }
                    TabbedPanelDebug.this.logger.info("Test finished.");
                }
            });
            this.testThread.start();
        } else if (this.mainView.showConfirmDialog("Test in progress, do you want to interrupt it?")) {
            this.testThread.interrupt();
            this.testThread = null;
        }
    }

    @Action
    public void buttonSaveTxt() {
        String filePath = new BGCJFileSaver(this.groupDebug, new String[]{"txt"}, SimpleBGC_GUIApp.getResourceMap().getString("file_type.txt", new Object[0]), "debug.last_used_dir").getFilePath("sbgc32_" + new SimpleDateFormat("yyyy-MM-dd HHmmss").format(new Date()) + ".txt", true);
        if (filePath == null) {
            return;
        }
        try {
            new FileHelper().writeString(filePath, this.jTextAreaDebugCmd.getText());
            this.mainView.updateStatus(this.resourceMap.getString("status.file_saved", filePath));
        }
        catch (IOException ex) {
            this.logger.error(ex.getCause().getMessage().toString());
        }
    }

    @Action(enabledProperty="portConnected")
    public void buttonDebugPortConfig() {
        JLabel label = new JLabel(this.resourceMap.getString("debugPortCfgDialog.filter.label", new Object[0]));
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        JPanel al = new JPanel();
        al.setLayout(new BoxLayout(al, 1));
        HashMap<Integer, JCheckBox> boxes = new HashMap<Integer, JCheckBox>();
        for (Sprav s : SerialCommand.DEBUG_PORT_CMD_FILTER) {
            JCheckBox box = new JCheckBox(s.getName() + " (#" + s.getId() + ")", Settings.is("debug_port.filter." + s.getId()));
            al.add(box);
            boxes.put(s.getId(), box);
        }
        JScrollPane scrollPane = new JScrollPane(al);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setPreferredSize(new Dimension(300, 200));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)label, "North");
        mainPanel.add((Component)scrollPane, "Center");
        if (JOptionPane.showConfirmDialog(null, mainPanel, this.resourceMap.getString("debugPortCfgDialog.title", new Object[0]), 2, 1) == 0) {
            for (Sprav s : SerialCommand.DEBUG_PORT_CMD_FILTER) {
                Settings.set("debug_port.filter." + s.getId(), ((JCheckBox)boxes.get(s.getId())).isSelected());
            }
            Settings.save();
            if (this.jToggleButtonSetDebugPort.isSelected()) {
                this.sendSetDebugPortCmd(false);
                this.sendSetDebugPortCmd(true);
            }
        }
    }

    void addOption(JComboBox cb, String str) {
        for (int i = 0; i < cb.getItemCount(); ++i) {
            if (!((String)cb.getItemAt(i)).equals(str)) continue;
            cb.removeItem(cb.getItemAt(i));
            break;
        }
        cb.insertItemAt(str, 0);
        cb.setSelectedIndex(0);
    }

    public void updateRealtimeData(RealtimeData d) {
        if (BoardInfo.checkMinBaseFirmwareVer(2734)) {
            this.jToggleButtonSetDebugPort.setSelected(d.isDebugPort);
        }
    }

    class CmdSendingThread
    implements Runnable {
        SerialCommand cmd;
        int interval_ms;

        public CmdSendingThread(SerialCommand cmd, int interval_ms) {
            this.cmd = cmd;
            this.interval_ms = interval_ms;
        }

        public void start() {
            TabbedPanelDebug.this.logger.debug("Starting CmdSendingThread(" + this.cmd.getId() + "," + this.interval_ms + ")..");
            new Thread(this).start();
        }

        public void stop() {
            if (this.cmd != null) {
                TabbedPanelDebug.this.logger.debug("Finishing CmdSendingThread(" + this.cmd.getId() + ")..");
                this.cmd = null;
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public void run() {
            while (this.cmd != null) {
                try {
                    SerialCommandProcessor.sendCommand(this.cmd);
                    Thread.currentThread();
                    Thread.sleep(this.interval_ms);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception e) {
                    TabbedPanelDebug.this.logger.stackTrace(e);
                }
            }
        }
    }
}

