/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.metal.MetalSliderUI;
import net.java.games.input.Component;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import sbgc.object.BoardInfo;
import sbgc.object.BoardParams;
import sbgc.object.Sprav;
import sbgc.service.ControlThread;
import sbgc.service.IJoystickUpdateEventListener;
import sbgc.service.Joystick;
import sbgc.service.QuatControl;
import sbgc.service.SerialCommandProcessor;
import sbgc.ui.ITabbedPanel;
import sbgc.ui.JoystickFldPanel;
import sbgc.ui.RCDataPanel;
import sbgc.ui.SpravComboBoxModel;
import sbgc.ui.TabbedPanelBase;
import sbgc.ui.Utils;
import sbgc.utils.MathUtils;
import sbgc.utils.Settings;
import simplebgc_gui.SimpleBGC_GUIApp;
import simplebgc_gui.SimpleBGC_GUIView;
import simplebgc_gui.TabWindow;

public class TabbedPanelJoystick
extends TabbedPanelBase
implements ITabbedPanel,
IJoystickUpdateEventListener {
    public Joystick gamepad = null;
    public final RCDataPanel[] gamepadAnalogPanels = new RCDataPanel[Joystick.ANALOG_AXES_IDENTIFIERS.length];
    public final RCDataPanel[] gamepadButtonPanels = new RCDataPanel[Joystick.BUTTON_IDENTIFIERS.length];
    long gamepadPrevCfgTime;
    static final int AXIS_ROLL_BIT = 1;
    static final int AXIS_PITCH_BIT = 2;
    static final int AXIS_YAW_BIT = 4;
    JoystickFldPanel screenJoyPanel;
    int screen_joy_interval;
    boolean screen_joy_constant_interval;
    ControlThread controlThread = new ControlThread();
    int[] screen_joy_values = new int[3];
    JRadioButton[] screenJoySendModeRBList;
    JCheckBox[] screenJoyCenterCBList;
    JCheckBox[] screenJoyModeRCAxes;
    JCheckBox[] mixFollowFlags;
    private ButtonGroup buttonGroupScreenJoystick;
    private JPanel groupGamepadConfig;
    private JPanel groupGamepadValues;
    private JPanel groupScreenJoystick;
    private JButton jButtonHome;
    private JButton jButtonNewWindow1;
    private JComboBox jCBControlQuatMode;
    private JComboBox jCBControllerList;
    private JCheckBox jCBGamepadVirtCh;
    private JCheckBox jCBMixFollowP;
    private JCheckBox jCBMixFollowR;
    private JCheckBox jCBMixFollowY;
    private JCheckBox jCBScreenJoyCenterOnReleaseR;
    private JCheckBox jCBScreenJoyCenterOnReleaseX;
    private JCheckBox jCBScreenJoyCenterOnReleaseY;
    private JCheckBox jCBScreenJoyIntervalEnabled;
    private JCheckBox jCBScreenJoyModeRC_P;
    private JCheckBox jCBScreenJoyModeRC_R;
    private JCheckBox jCBScreenJoyModeRC_Y;
    private JLabel jLabelCenterOnRelease;
    private JLabel jLabelForAxes;
    private JLabel jLabelGamepadChannelInfo;
    private JLabel jLabelGamepadController;
    private JLabel jLabelGamepadIntervalMs;
    private JLabel jLabelMixFollow;
    private JLabel jLabelScreenJoyDblPressHint;
    private JLabel jLabelScreenJoyInterval;
    private JLayeredPane jLayeredPane1;
    private JPanel jPanelScreenJoy;
    private JPanel jPanelScreenJoyCfg;
    private JPanel jPanelScreenJoyContainer;
    private JRadioButton jRBScreenJoyAPI;
    private JRadioButton jRBScreenJoyCmdControlAngle;
    private JRadioButton jRBScreenJoyCmdControlAngleShort;
    private JRadioButton jRBScreenJoyCmdControlRC;
    private JRadioButton jRBScreenJoyCmdQuat;
    private JSlider jSliderRoll;
    private JSpinner jSpinnerGamepadInterval;
    private JSpinner jSpinnerScreenJoyInterval;
    private JToggleButton jToggleButtonGamepadEnable;
    private JToggleButton jToggleButtonScreenJoyEnable;
    private final PropertyChangeListener screenJoyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("pos_reset")) {
                TabbedPanelJoystick.this.centerSlider();
            } else if (evt.getPropertyName().equals("pos_update")) {
                Point p = (Point)evt.getNewValue();
                TabbedPanelJoystick.this.screen_joy_values[0] = p.x;
                TabbedPanelJoystick.this.screen_joy_values[1] = p.y;
                TabbedPanelJoystick.this.controlThread.update(TabbedPanelJoystick.this.screen_joy_values);
            }
        }
    };

    public TabbedPanelJoystick(SimpleBGC_GUIView mainView) {
        super(mainView);
        int i;
        this.initComponents();
        this.prepareLayout();
        this.setControllerList();
        this.screenJoySendModeRBList = new JRadioButton[]{this.jRBScreenJoyAPI, this.jRBScreenJoyCmdControlRC, this.jRBScreenJoyCmdControlAngle, this.jRBScreenJoyCmdControlAngleShort, this.jRBScreenJoyCmdQuat};
        this.screenJoyCenterCBList = new JCheckBox[]{this.jCBScreenJoyCenterOnReleaseX, this.jCBScreenJoyCenterOnReleaseY, this.jCBScreenJoyCenterOnReleaseR};
        this.screenJoyModeRCAxes = new JCheckBox[]{this.jCBScreenJoyModeRC_R, this.jCBScreenJoyModeRC_P, this.jCBScreenJoyModeRC_Y};
        this.mixFollowFlags = new JCheckBox[]{this.jCBMixFollowR, this.jCBMixFollowP, this.jCBMixFollowY};
        this.screenJoyPanel = new JoystickFldPanel(16384);
        this.jLayeredPane1.add((Component)this.screenJoyPanel, 2);
        this.screenJoyPanel.addPropertyChangeListener(this.screenJoyChangeListener);
        this.jSliderRoll.setUI(new MetalSliderUI(){

            @Override
            protected Dimension getThumbSize() {
                return new Dimension(25, 25);
            }

            @Override
            public void paintThumb(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Rectangle knobBounds = this.thumbRect;
                g2.setColor(JoystickFldPanel.BORDER_COLOR);
                g2.fillOval(knobBounds.x, knobBounds.y, knobBounds.width, knobBounds.height);
                g2.setColor(JoystickFldPanel.THUMB_IDLE_COLOR);
                g2.fillOval(knobBounds.x + 2, knobBounds.y + 2, knobBounds.width - 4, knobBounds.height - 4);
            }
        });
        final ComponentAdapter joyPanelResizedAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                int size = Math.min(TabbedPanelJoystick.this.jLayeredPane1.getWidth(), TabbedPanelJoystick.this.jLayeredPane1.getHeight());
                TabbedPanelJoystick.this.screenJoyPanel.setBounds((TabbedPanelJoystick.this.jLayeredPane1.getWidth() - size) / 2, (TabbedPanelJoystick.this.jLayeredPane1.getHeight() - size) / 2, size, size);
            }
        };
        this.jLayeredPane1.addComponentListener(joyPanelResizedAdapter);
        this.jLayeredPane1.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorMoved(AncestorEvent evt) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent evt) {
            }

            @Override
            public void ancestorAdded(AncestorEvent evt) {
                joyPanelResizedAdapter.componentResized(null);
            }
        });
        for (i = 0; i < this.gamepadAnalogPanels.length; ++i) {
            float min = Joystick.ANALOG_AXES_IDENTIFIERS[i] == Component.Identifier.Axis.POV ? 0.0f : -1.0f;
            this.gamepadAnalogPanels[i] = new RCDataPanel(Joystick.ANALOG_AXES_IDENTIFIERS[i].getName(), "%.2f", min, 1.0f, false);
            this.gamepadAnalogPanels[i].setPreferredSize(new Dimension(215, 20));
            this.groupGamepadValues.add(this.gamepadAnalogPanels[i]);
        }
        for (i = 0; i < this.gamepadButtonPanels.length; ++i) {
            this.gamepadButtonPanels[i] = new RCDataPanel(Joystick.BUTTON_IDENTIFIERS[i].getName(), "", 0.5f, 1.0f, false);
            this.gamepadButtonPanels[i].setPreferredSize(new Dimension(30, 25));
            this.groupGamepadValues.add(this.gamepadButtonPanels[i]);
        }
        this.jSpinnerGamepadInterval.setValue(Settings.getInt("joystick.update_interval", 50));
        this.jCBGamepadVirtCh.setSelected(Settings.is("joystick.api_virt_ch_enabled", true));
        if (Settings.is("joystick.enabled", false) && this.jCBControllerList.getSelectedItem() != null) {
            this.jToggleButtonGamepadEnable.setSelected(true);
            this.buttonEnable();
        }
        this.jSpinnerScreenJoyInterval.setValue(Settings.getInt("screen_joy.interval", 10));
        this.jCBScreenJoyIntervalEnabled.setSelected(Settings.is("screen_joy.interval_enabled", false));
        SpravComboBoxModel m = new SpravComboBoxModel(SpravComboBoxModel.elemetntsFromHashMap(QuatControl.MODE_NAMES));
        m.setCurrent(Settings.getInt("screen_joy.quat_control_mode", 2));
        this.jCBControlQuatMode.setModel(m);
        ItemListener modeStateChangedListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!(e.getSource() instanceof JRadioButton) || e.getStateChange() == 1) {
                    TabbedPanelJoystick.this.screenJoyApplyModeCfg();
                }
            }
        };
        for (JToggleButton b : Utils.concatArrays(JToggleButton.class, this.screenJoySendModeRBList, this.screenJoyModeRCAxes, this.mixFollowFlags)) {
            b.addItemListener(modeStateChangedListener);
        }
        this.jCBControlQuatMode.addItemListener(modeStateChangedListener);
        Settings.selectToggleButton("screen_joy.send_mode", this.screenJoySendModeRBList, 1);
        Settings.selectToggleButton("screen_joy.auto_center", this.screenJoyCenterCBList, 7);
        Settings.selectToggleButton("screen_joy.mode_rc_axes", this.screenJoyModeRCAxes, 7);
        this.jToggleButtonScreenJoyEnable.setSelected(Settings.is("screen_joy.enabled", false));
    }

    private void initComponents() {
        this.buttonGroupScreenJoystick = new ButtonGroup();
        this.groupScreenJoystick = new JPanel();
        this.jPanelScreenJoyCfg = new JPanel();
        this.jRBScreenJoyAPI = new JRadioButton();
        this.jRBScreenJoyCmdControlRC = new JRadioButton();
        this.jRBScreenJoyCmdControlAngle = new JRadioButton();
        this.jRBScreenJoyCmdControlAngleShort = new JRadioButton();
        this.jRBScreenJoyCmdQuat = new JRadioButton();
        this.jCBControlQuatMode = new JComboBox();
        this.jLabelForAxes = new JLabel();
        this.jCBScreenJoyModeRC_R = new JCheckBox();
        this.jCBScreenJoyModeRC_Y = new JCheckBox();
        this.jCBScreenJoyModeRC_P = new JCheckBox();
        this.jLabelMixFollow = new JLabel();
        this.jCBMixFollowR = new JCheckBox();
        this.jCBMixFollowP = new JCheckBox();
        this.jCBMixFollowY = new JCheckBox();
        this.jLabelScreenJoyInterval = new JLabel();
        this.jSpinnerScreenJoyInterval = new JSpinner();
        this.jCBScreenJoyIntervalEnabled = new JCheckBox();
        this.jLabelCenterOnRelease = new JLabel();
        this.jCBScreenJoyCenterOnReleaseX = new JCheckBox();
        this.jCBScreenJoyCenterOnReleaseY = new JCheckBox();
        this.jCBScreenJoyCenterOnReleaseR = new JCheckBox();
        this.jToggleButtonScreenJoyEnable = new JToggleButton();
        this.jButtonNewWindow1 = new JButton();
        this.jPanelScreenJoyContainer = new JPanel();
        this.jPanelScreenJoy = new JPanel();
        this.jSliderRoll = new JSlider();
        this.jLabelScreenJoyDblPressHint = new JLabel();
        this.jLayeredPane1 = new JLayeredPane();
        this.jButtonHome = new JButton();
        this.groupGamepadValues = new JPanel();
        this.groupGamepadConfig = new JPanel();
        this.jToggleButtonGamepadEnable = new JToggleButton();
        this.jLabelGamepadController = new JLabel();
        this.jCBControllerList = new JComboBox();
        this.jCBGamepadVirtCh = new JCheckBox();
        this.jSpinnerGamepadInterval = new JSpinner();
        this.jLabelGamepadIntervalMs = new JLabel();
        this.jLabelGamepadChannelInfo = new JLabel();
        this.setName("Joystick");
        this.setLayout(null);
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(TabbedPanelJoystick.class);
        this.groupScreenJoystick.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("groupScreenJoystick.border.title", new Object[0])));
        this.groupScreenJoystick.setName("groupScreenJoystick");
        this.groupScreenJoystick.setPreferredSize(new Dimension(700, 300));
        this.groupScreenJoystick.setLayout((LayoutManager)new AbsoluteLayout());
        this.jPanelScreenJoyCfg.setName("jPanelScreenJoyCfg");
        this.jPanelScreenJoyCfg.setLayout((LayoutManager)new AbsoluteLayout());
        this.buttonGroupScreenJoystick.add(this.jRBScreenJoyAPI);
        this.jRBScreenJoyAPI.setText(resourceMap.getString("jRBScreenJoyAPI.text", new Object[0]));
        this.jRBScreenJoyAPI.setToolTipText(resourceMap.getString("jRBScreenJoyAPI.toolTipText", new Object[0]));
        this.jRBScreenJoyAPI.setActionCommand(resourceMap.getString("jRBScreenJoyAPI.actionCommand", new Object[0]));
        this.jRBScreenJoyAPI.setName("jRBScreenJoyAPI");
        this.jPanelScreenJoyCfg.add((Component)this.jRBScreenJoyAPI, new AbsoluteConstraints(20, 10, -1, -1));
        this.buttonGroupScreenJoystick.add(this.jRBScreenJoyCmdControlRC);
        this.jRBScreenJoyCmdControlRC.setText(resourceMap.getString("jRBScreenJoyCmdControlRC.text", new Object[0]));
        this.jRBScreenJoyCmdControlRC.setToolTipText(resourceMap.getString("jRBScreenJoyCmdControlRC.toolTipText", new Object[0]));
        this.jRBScreenJoyCmdControlRC.setName("jRBScreenJoyCmdControlRC");
        this.jPanelScreenJoyCfg.add((Component)this.jRBScreenJoyCmdControlRC, new AbsoluteConstraints(20, 30, -1, -1));
        this.buttonGroupScreenJoystick.add(this.jRBScreenJoyCmdControlAngle);
        this.jRBScreenJoyCmdControlAngle.setText(resourceMap.getString("jRBScreenJoyCmdControlAngle.text", new Object[0]));
        this.jRBScreenJoyCmdControlAngle.setToolTipText(resourceMap.getString("jRBScreenJoyCmdControlAngle.toolTipText", new Object[0]));
        this.jRBScreenJoyCmdControlAngle.setName("jRBScreenJoyCmdControlAngle");
        this.jPanelScreenJoyCfg.add((Component)this.jRBScreenJoyCmdControlAngle, new AbsoluteConstraints(20, 50, -1, -1));
        this.buttonGroupScreenJoystick.add(this.jRBScreenJoyCmdControlAngleShort);
        this.jRBScreenJoyCmdControlAngleShort.setText(resourceMap.getString("jRBScreenJoyCmdControlAngleShort.text", new Object[0]));
        this.jRBScreenJoyCmdControlAngleShort.setToolTipText(resourceMap.getString("jRBScreenJoyCmdControlAngleShort.toolTipText", new Object[0]));
        this.jRBScreenJoyCmdControlAngleShort.setName("jRBScreenJoyCmdControlAngleShort");
        this.jPanelScreenJoyCfg.add((Component)this.jRBScreenJoyCmdControlAngleShort, new AbsoluteConstraints(250, 50, -1, -1));
        this.buttonGroupScreenJoystick.add(this.jRBScreenJoyCmdQuat);
        this.jRBScreenJoyCmdQuat.setText(resourceMap.getString("jRBScreenJoyCmdQuat.text", new Object[0]));
        this.jRBScreenJoyCmdQuat.setToolTipText(resourceMap.getString("jRBScreenJoyCmdQuat.toolTipText", new Object[0]));
        this.jRBScreenJoyCmdQuat.setName("jRBScreenJoyCmdQuat");
        this.jPanelScreenJoyCfg.add((Component)this.jRBScreenJoyCmdQuat, new AbsoluteConstraints(20, 80, 230, -1));
        this.jCBControlQuatMode.setName("jCBControlQuatMode");
        this.jPanelScreenJoyCfg.add((Component)this.jCBControlQuatMode, new AbsoluteConstraints(250, 80, 150, -1));
        this.jLabelForAxes.setText(resourceMap.getString("jLabelForAxes.text", new Object[0]));
        this.jLabelForAxes.setName("jLabelForAxes");
        this.jPanelScreenJoyCfg.add((Component)this.jLabelForAxes, new AbsoluteConstraints(40, 110, -1, -1));
        this.jCBScreenJoyModeRC_R.setText(resourceMap.getString("jCBScreenJoyModeRC_R.text", new Object[0]));
        this.jCBScreenJoyModeRC_R.setName("jCBScreenJoyModeRC_R");
        this.jPanelScreenJoyCfg.add((Component)this.jCBScreenJoyModeRC_R, new AbsoluteConstraints(140, 110, -1, -1));
        this.jCBScreenJoyModeRC_Y.setText(resourceMap.getString("jCBScreenJoyModeRC_Y.text", new Object[0]));
        this.jCBScreenJoyModeRC_Y.setName("jCBScreenJoyModeRC_Y");
        this.jPanelScreenJoyCfg.add((Component)this.jCBScreenJoyModeRC_Y, new AbsoluteConstraints(300, 110, -1, -1));
        this.jCBScreenJoyModeRC_P.setText(resourceMap.getString("jCBScreenJoyModeRC_P.text", new Object[0]));
        this.jCBScreenJoyModeRC_P.setName("jCBScreenJoyModeRC_P");
        this.jPanelScreenJoyCfg.add((Component)this.jCBScreenJoyModeRC_P, new AbsoluteConstraints(220, 110, -1, -1));
        this.jLabelMixFollow.setText(resourceMap.getString("jLabelMixFollow.text", new Object[0]));
        this.jLabelMixFollow.setName("jLabelMixFollow");
        this.jPanelScreenJoyCfg.add((Component)this.jLabelMixFollow, new AbsoluteConstraints(40, 140, -1, -1));
        this.jCBMixFollowR.setText(resourceMap.getString("jCBMixFollowR.text", new Object[0]));
        this.jCBMixFollowR.setName("jCBMixFollowR");
        this.jPanelScreenJoyCfg.add((Component)this.jCBMixFollowR, new AbsoluteConstraints(140, 140, -1, -1));
        this.jCBMixFollowP.setText(resourceMap.getString("jCBMixFollowP.text", new Object[0]));
        this.jCBMixFollowP.setName("jCBMixFollowP");
        this.jPanelScreenJoyCfg.add((Component)this.jCBMixFollowP, new AbsoluteConstraints(220, 140, -1, -1));
        this.jCBMixFollowY.setText(resourceMap.getString("jCBMixFollowY.text", new Object[0]));
        this.jCBMixFollowY.setName("jCBMixFollowY");
        this.jPanelScreenJoyCfg.add((Component)this.jCBMixFollowY, new AbsoluteConstraints(300, 140, -1, -1));
        this.jLabelScreenJoyInterval.setText(resourceMap.getString("jLabelScreenJoyInterval.text", new Object[0]));
        this.jLabelScreenJoyInterval.setName("jLabelScreenJoyInterval");
        this.jPanelScreenJoyCfg.add((Component)this.jLabelScreenJoyInterval, new AbsoluteConstraints(20, 170, 190, -1));
        this.jSpinnerScreenJoyInterval.setModel(new SpinnerNumberModel(20, 8, 10000, 1));
        this.jSpinnerScreenJoyInterval.setToolTipText(resourceMap.getString("jSpinnerScreenJoyInterval.toolTipText", new Object[0]));
        this.jSpinnerScreenJoyInterval.setName("jSpinnerScreenJoyInterval");
        this.jSpinnerScreenJoyInterval.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TabbedPanelJoystick.this.jSpinnerScreenJoyIntervalStateChanged(evt);
            }
        });
        this.jPanelScreenJoyCfg.add((Component)this.jSpinnerScreenJoyInterval, new AbsoluteConstraints(220, 170, 60, -1));
        this.jCBScreenJoyIntervalEnabled.setText(resourceMap.getString("jCBScreenJoyIntervalEnabled.text", new Object[0]));
        this.jCBScreenJoyIntervalEnabled.setToolTipText(resourceMap.getString("jCBScreenJoyIntervalEnabled.toolTipText", new Object[0]));
        this.jCBScreenJoyIntervalEnabled.setName("jCBScreenJoyIntervalEnabled");
        this.jCBScreenJoyIntervalEnabled.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TabbedPanelJoystick.this.jCBScreenJoyIntervalEnabledStateChanged(evt);
            }
        });
        this.jPanelScreenJoyCfg.add((Component)this.jCBScreenJoyIntervalEnabled, new AbsoluteConstraints(290, 170, 120, -1));
        this.jLabelCenterOnRelease.setText(resourceMap.getString("jLabelCenterOnRelease.text", new Object[0]));
        this.jLabelCenterOnRelease.setName("jLabelCenterOnRelease");
        this.jPanelScreenJoyCfg.add((Component)this.jLabelCenterOnRelease, new AbsoluteConstraints(20, 200, 200, -1));
        this.jCBScreenJoyCenterOnReleaseX.setText(resourceMap.getString("jCBScreenJoyCenterOnReleaseX.text", new Object[0]));
        this.jCBScreenJoyCenterOnReleaseX.setName("jCBScreenJoyCenterOnReleaseX");
        this.jCBScreenJoyCenterOnReleaseX.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TabbedPanelJoystick.this.jCBScreenJoyCenterOnReleaseXItemStateChanged(evt);
            }
        });
        this.jPanelScreenJoyCfg.add((Component)this.jCBScreenJoyCenterOnReleaseX, new AbsoluteConstraints(220, 200, -1, -1));
        this.jCBScreenJoyCenterOnReleaseY.setText(resourceMap.getString("jCBScreenJoyCenterOnReleaseY.text", new Object[0]));
        this.jCBScreenJoyCenterOnReleaseY.setName("jCBScreenJoyCenterOnReleaseY");
        this.jCBScreenJoyCenterOnReleaseY.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TabbedPanelJoystick.this.jCBScreenJoyCenterOnReleaseYItemStateChanged(evt);
            }
        });
        this.jPanelScreenJoyCfg.add((Component)this.jCBScreenJoyCenterOnReleaseY, new AbsoluteConstraints(260, 200, -1, -1));
        this.jCBScreenJoyCenterOnReleaseR.setText(resourceMap.getString("jCBScreenJoyCenterOnReleaseR.text", new Object[0]));
        this.jCBScreenJoyCenterOnReleaseR.setName("jCBScreenJoyCenterOnReleaseR");
        this.jPanelScreenJoyCfg.add((Component)this.jCBScreenJoyCenterOnReleaseR, new AbsoluteConstraints(300, 200, -1, -1));
        ApplicationActionMap actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(TabbedPanelJoystick.class, this);
        this.jToggleButtonScreenJoyEnable.setAction(actionMap.get("buttonScreenJoyEnable"));
        this.jToggleButtonScreenJoyEnable.setText(resourceMap.getString("jToggleButtonScreenJoyEnable.text", new Object[0]));
        this.jToggleButtonScreenJoyEnable.setToolTipText(resourceMap.getString("jToggleButtonEnable.toolTipText", new Object[0]));
        this.jToggleButtonScreenJoyEnable.setName("jToggleButtonScreenJoyEnable");
        this.jPanelScreenJoyCfg.add((Component)this.jToggleButtonScreenJoyEnable, new AbsoluteConstraints(310, 230, 100, 30));
        this.groupScreenJoystick.add((Component)this.jPanelScreenJoyCfg, new AbsoluteConstraints(6, 20, 420, 260));
        this.jButtonNewWindow1.setAction(actionMap.get("buttonNewWindow"));
        this.jButtonNewWindow1.setToolTipText(resourceMap.getString("jButtonNewWindow1.toolTipText", new Object[0]));
        this.jButtonNewWindow1.setHorizontalTextPosition(0);
        this.jButtonNewWindow1.setIconTextGap(0);
        this.jButtonNewWindow1.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonNewWindow1.setName("jButtonNewWindow1");
        this.groupScreenJoystick.add((Component)this.jButtonNewWindow1, new AbsoluteConstraints(670, 20, 30, 30));
        this.jPanelScreenJoyContainer.setName("jPanelScreenJoyContainer");
        this.jPanelScreenJoyContainer.setLayout(new BoxLayout(this.jPanelScreenJoyContainer, 2));
        this.jPanelScreenJoy.setBorder(BorderFactory.createCompoundBorder(new LineBorder(new Color(0, 0, 0), 1, true), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.jPanelScreenJoy.setName("jPanelScreenJoy");
        this.jPanelScreenJoy.setLayout(new BorderLayout());
        this.jSliderRoll.setMajorTickSpacing(100);
        this.jSliderRoll.setMaximum(500);
        this.jSliderRoll.setMinimum(-500);
        this.jSliderRoll.setMinorTickSpacing(50);
        this.jSliderRoll.setValue(0);
        this.jSliderRoll.setName("jSliderRoll");
        this.jSliderRoll.setPreferredSize(new Dimension(200, 30));
        this.jSliderRoll.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                TabbedPanelJoystick.this.jSliderRollMouseReleased(evt);
            }
        });
        this.jSliderRoll.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TabbedPanelJoystick.this.jSliderRollStateChanged(evt);
            }
        });
        this.jPanelScreenJoy.add((Component)this.jSliderRoll, "North");
        this.jLabelScreenJoyDblPressHint.setHorizontalAlignment(0);
        this.jLabelScreenJoyDblPressHint.setText(resourceMap.getString("jLabelScreenJoyDblPressHint.text", new Object[0]));
        this.jLabelScreenJoyDblPressHint.setName("jLabelScreenJoyDblPressHint");
        this.jPanelScreenJoy.add((Component)this.jLabelScreenJoyDblPressHint, "South");
        this.jLayeredPane1.setName("jLayeredPane1");
        this.jButtonHome.setAction(actionMap.get("buttonHome"));
        this.jButtonHome.setText(resourceMap.getString("jButtonHome.text", new Object[0]));
        this.jButtonHome.setName("jButtonHome");
        this.jButtonHome.setBounds(10, 10, 30, 30);
        this.jLayeredPane1.add((Component)this.jButtonHome, new Integer(1));
        this.jPanelScreenJoy.add((Component)this.jLayeredPane1, "Center");
        this.jPanelScreenJoyContainer.add(this.jPanelScreenJoy);
        this.groupScreenJoystick.add((Component)this.jPanelScreenJoyContainer, new AbsoluteConstraints(434, 20, 230, 260));
        this.add(this.groupScreenJoystick);
        this.groupScreenJoystick.setBounds(0, 0, 700, 290);
        this.groupGamepadValues.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("groupGamepadValues.border.title", new Object[0])));
        this.groupGamepadValues.setName("groupGamepadValues");
        this.add(this.groupGamepadValues);
        this.groupGamepadValues.setBounds(0, 370, 700, 110);
        this.groupGamepadConfig.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("groupGamepadConfig.border.title", new Object[0])));
        this.groupGamepadConfig.setName("groupGamepadConfig");
        this.groupGamepadConfig.setLayout((LayoutManager)new AbsoluteLayout());
        this.jToggleButtonGamepadEnable.setAction(actionMap.get("buttonEnable"));
        this.jToggleButtonGamepadEnable.setText(resourceMap.getString("jToggleButtonGamepadEnable.text", new Object[0]));
        this.jToggleButtonGamepadEnable.setToolTipText(resourceMap.getString("jToggleButtonGamepadEnable.toolTipText", new Object[0]));
        this.jToggleButtonGamepadEnable.setName("jToggleButtonGamepadEnable");
        this.groupGamepadConfig.add((Component)this.jToggleButtonGamepadEnable, new AbsoluteConstraints(590, 30, 80, 30));
        this.jLabelGamepadController.setText(resourceMap.getString("jLabelGamepadController.text", new Object[0]));
        this.jLabelGamepadController.setName("jLabelGamepadController");
        this.groupGamepadConfig.add((Component)this.jLabelGamepadController, new AbsoluteConstraints(20, 30, 120, -1));
        this.jCBControllerList.setToolTipText(resourceMap.getString("jCBControllerList.toolTipText", new Object[0]));
        this.jCBControllerList.setName("jCBControllerList");
        this.jCBControllerList.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                TabbedPanelJoystick.this.jCBControllerListPopupMenuWillBecomeVisible(evt);
            }
        });
        this.groupGamepadConfig.add((Component)this.jCBControllerList, new AbsoluteConstraints(140, 30, 430, -1));
        this.jCBGamepadVirtCh.setText(resourceMap.getString("jCBGamepadVirtCh.text", new Object[0]));
        this.jCBGamepadVirtCh.setToolTipText(resourceMap.getString("jCBGamepadVirtCh.toolTipText", new Object[0]));
        this.jCBGamepadVirtCh.setName("jCBGamepadVirtCh");
        this.groupGamepadConfig.add((Component)this.jCBGamepadVirtCh, new AbsoluteConstraints(140, 90, -1, -1));
        this.jSpinnerGamepadInterval.setModel(new SpinnerNumberModel(20, 8, 10000, 1));
        this.jSpinnerGamepadInterval.setToolTipText(resourceMap.getString("jSpinnerGamepadInterval.toolTipText", new Object[0]));
        this.jSpinnerGamepadInterval.setName("jSpinnerGamepadInterval");
        this.groupGamepadConfig.add((Component)this.jSpinnerGamepadInterval, new AbsoluteConstraints(140, 60, 60, -1));
        this.jLabelGamepadIntervalMs.setText(resourceMap.getString("jLabelGamepadIntervalMs.text", new Object[0]));
        this.jLabelGamepadIntervalMs.setName("jLabelGamepadIntervalMs");
        this.groupGamepadConfig.add((Component)this.jLabelGamepadIntervalMs, new AbsoluteConstraints(20, 60, -1, -1));
        this.jLabelGamepadChannelInfo.setText(resourceMap.getString("jLabelGamepadChannelInfo.text", new Object[0]));
        this.jLabelGamepadChannelInfo.setName("jLabelGamepadChannelInfo");
        this.groupGamepadConfig.add((Component)this.jLabelGamepadChannelInfo, new AbsoluteConstraints(170, 110, 500, 50));
        this.add(this.groupGamepadConfig);
        this.groupGamepadConfig.setBounds(0, 480, 700, 170);
    }

    private void jCBControllerListPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        this.setControllerList();
    }

    private void jCBScreenJoyCenterOnReleaseXItemStateChanged(ItemEvent evt) {
        this.screenJoyPanel.setAutoCenter(0, this.jCBScreenJoyCenterOnReleaseX.isSelected());
    }

    private void jCBScreenJoyCenterOnReleaseYItemStateChanged(ItemEvent evt) {
        this.screenJoyPanel.setAutoCenter(1, this.jCBScreenJoyCenterOnReleaseY.isSelected());
    }

    private void jSliderRollMouseReleased(MouseEvent evt) {
        if (this.jCBScreenJoyCenterOnReleaseR.isSelected()) {
            this.centerSlider();
        }
    }

    private void jSliderRollStateChanged(ChangeEvent evt) {
        this.screen_joy_values[2] = this.jSliderRoll.getValue() * 16384 / 500;
        this.controlThread.update(this.screen_joy_values);
    }

    private void jCBScreenJoyIntervalEnabledStateChanged(ChangeEvent evt) {
        this.onScreenJoyIntervalChanges();
    }

    private void jSpinnerScreenJoyIntervalStateChanged(ChangeEvent evt) {
        this.onScreenJoyIntervalChanges();
    }

    void onScreenJoyIntervalChanges() {
        this.screen_joy_interval = ((Number)this.jSpinnerScreenJoyInterval.getValue()).intValue();
        this.screen_joy_constant_interval = this.jCBScreenJoyIntervalEnabled.isSelected();
        this.controlThread.setInterval(this.screen_joy_interval, this.screen_joy_constant_interval);
    }

    void centerSlider() {
        this.jSliderRoll.setValue((this.jSliderRoll.getMinimum() + this.jSliderRoll.getMaximum()) / 2);
    }

    private void setControllerList() {
        ArrayList<Sprav> controllerList = Joystick.getControllerList();
        SpravComboBoxModel model = new SpravComboBoxModel(controllerList, this.jCBControllerList.getModel());
        this.jCBControllerList.setModel(model);
        String controllerName = Settings.get("joystick.controller");
        Sprav lastUsedController = null;
        if (controllerName != null) {
            for (Sprav ctrl : controllerList) {
                if (!ctrl.getName().equals(controllerName)) continue;
                lastUsedController = ctrl;
                break;
            }
        }
        if (lastUsedController != null) {
            this.jCBControllerList.setSelectedItem(lastUsedController.getName());
        }
    }

    @Override
    public void updateBoardParams(BoardParams params) throws Exception {
    }

    @Override
    public void updateBoardVerUI() {
        boolean has_quat_control = BoardInfo.hasBoardFeature(0x800000000L);
        this.jRBScreenJoyCmdQuat.setEnabled(has_quat_control);
        this.jCBControlQuatMode.setEnabled(has_quat_control);
    }

    @Override
    public void applyBoardParams(BoardParams params) throws Exception {
    }

    @Override
    public boolean onBeforeClose() {
        Settings.setToggleButton("screen_joy.send_mode", this.screenJoySendModeRBList);
        Settings.setToggleButton("screen_joy.auto_center", this.screenJoyCenterCBList);
        Settings.setToggleButton("screen_joy.mode_rc_axes", this.screenJoyModeRCAxes);
        Settings.set("screen_joy.interval_enabled", this.screen_joy_constant_interval);
        Settings.set("screen_joy.interval", this.screen_joy_interval);
        Settings.set("screen_joy.enabled", this.jToggleButtonScreenJoyEnable.isSelected());
        Settings.set("screen_joy.quat_control_mode", ((SpravComboBoxModel)this.jCBControlQuatMode.getModel()).getCurrentId());
        return true;
    }

    @Action
    public void buttonEnable() {
        if (this.gamepad != null) {
            this.gamepadStop();
            this.gamepad = null;
        }
        try {
            String name = (String)this.jCBControllerList.getSelectedItem();
            int update_interval = ((Number)this.jSpinnerGamepadInterval.getValue()).intValue();
            if (this.jToggleButtonGamepadEnable.isSelected()) {
                this.jToggleButtonScreenJoyEnable.setSelected(false);
                this.gamepad = new Joystick(name, update_interval, this);
                this.gamepad.start();
                this.enableParams(false);
            }
            Settings.set("joystick.controller", name);
            Settings.set("joystick.enabled", this.jToggleButtonGamepadEnable.isSelected());
            Settings.set("joystick.api_virt_ch_enabled", this.jCBGamepadVirtCh.isSelected());
            Settings.set("joystick.update_interval", update_interval);
            Settings.save();
        }
        catch (Exception e) {
            this.mainView.showErrorMessage(e.getMessage());
            this.jToggleButtonGamepadEnable.setSelected(false);
        }
    }

    public void gamepadStop() {
        if (this.gamepad != null) {
            this.gamepad.stop();
        }
        this.enableParams(true);
        if (this.mainView != null && this.mainView.isSerialCommunicationActive()) {
            int[] values = new int[Joystick.ANALOG_AXES_IDENTIFIERS.length + Joystick.BUTTON_IDENTIFIERS.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = Short.MIN_VALUE;
            }
            SerialCommandProcessor.send_CMD_API_VIRT_CH_HIGH_RES(values);
        }
    }

    void enableParams(boolean state) {
        this.jSpinnerGamepadInterval.setEnabled(state);
        this.jCBGamepadVirtCh.setEnabled(state);
        this.jCBControllerList.setEnabled(state);
    }

    @Override
    public void onJoystickUpdateEvent(final Joystick joystick) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int i;
                for (i = 0; i < TabbedPanelJoystick.this.gamepadAnalogPanels.length; ++i) {
                    TabbedPanelJoystick.this.gamepadAnalogPanels[i].setData(Float.valueOf(joystick.analogValues[i]));
                }
                for (i = 0; i < TabbedPanelJoystick.this.gamepadButtonPanels.length; ++i) {
                    TabbedPanelJoystick.this.gamepadButtonPanels[i].setData(Float.valueOf(joystick.buttons[i] ? 1.0f : 0.0f));
                }
            }
        });
        if (this.mainView != null && this.mainView.isSerialCommunicationActiveAndNotPaused()) {
            try {
                if (this.jCBGamepadVirtCh.isSelected()) {
                    int i;
                    int[] values = new int[32];
                    for (i = 0; i < joystick.analogValues.length; ++i) {
                        float val = joystick.analogValues[i];
                        if (Joystick.ANALOG_AXES_IDENTIFIERS[i] == Component.Identifier.Axis.POV) {
                            val = val * 2.0f - 1.0f;
                        }
                        values[i] = MathUtils.constrain(Math.round(val * 16384.0f), -32767, Short.MAX_VALUE);
                    }
                    for (i = 0; i < joystick.buttons.length; ++i) {
                        values[i + joystick.analogValues.length] = joystick.buttons[i] ? 16384 : -16384;
                    }
                    SerialCommandProcessor.send_CMD_API_VIRT_CH_HIGH_RES(values);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Action
    public void buttonNewWindow() {
        try {
            new TabWindow(this.jPanelScreenJoy, this.getClass(), this.resourceMap.getString("window.title.screen_joy", new Object[0]), this.jPanelScreenJoyContainer, false, null).showDialog();
        }
        catch (Exception e) {
            this.logger.error(e.toString());
        }
    }

    @Action(enabledProperty="connected")
    public void buttonScreenJoyEnable() {
        if (this.jToggleButtonScreenJoyEnable.isSelected()) {
            this.jToggleButtonGamepadEnable.setSelected(false);
            if (SimpleBGC_GUIApp.mainView != null && SimpleBGC_GUIApp.mainView.isSerialCommunicationActive()) {
                this.screenJoyApplyModeCfg();
                this.controlThread.start();
            }
        } else {
            this.controlThread.stop();
        }
    }

    @Override
    public void onConnected(boolean state) {
        if (state) {
            this.buttonScreenJoyEnable();
        }
    }

    private void screenJoyApplyModeCfg() {
        this.logger.trace("Applying screen joystick parameters..");
        int mode = Utils.getRadioButtonSelectedIndex(this.screenJoySendModeRBList);
        this.controlThread.setControlMode(mode);
        this.screenJoyPanel.setAxisLock(false, false);
        this.jSliderRoll.setEnabled(true);
        switch (mode) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                int axesBits = Utils.getToggleButtonSelectedBits(this.screenJoyModeRCAxes);
                this.controlThread.setAxesBits(axesBits);
                int[] flags = new int[3];
                for (int axis = 0; axis < 3; ++axis) {
                    if (!this.mixFollowFlags[axis].isSelected()) continue;
                    int n = axis;
                    flags[n] = flags[n] | 0x10;
                }
                this.controlThread.setModeFlags(flags);
                this.screenJoyPanel.setAxisLock((axesBits & 4) == 0, (axesBits & 2) == 0);
                this.jSliderRoll.setEnabled((axesBits & 1) != 0);
                break;
            }
            case 4: {
                this.controlThread.setQuatControlMode(((SpravComboBoxModel)this.jCBControlQuatMode.getModel()).getCurrentId());
            }
        }
    }

    @Action
    public void buttonHome() {
        SerialCommandProcessor.sendCmdExecuteMenu(18);
    }

    public int[] getValues() {
        return this.screen_joy_values;
    }
}

